/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import com.facebook.common.logging.FLog;
import com.facebook.fbreact.specs.NativeExceptionsManagerSpec;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.common.JavascriptException;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.util.ExceptionDataHelper;
import com.facebook.react.util.JSStackTrace;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="ExceptionsManager")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/react/modules/core/ExceptionsManagerModule;", "Lcom/facebook/fbreact/specs/NativeExceptionsManagerSpec;", "devSupportManager", "Lcom/facebook/react/devsupport/interfaces/DevSupportManager;", "<init>", "(Lcom/facebook/react/devsupport/interfaces/DevSupportManager;)V", "reportFatalException", "", "message", "", "stack", "Lcom/facebook/react/bridge/ReadableArray;", "idDouble", "", "reportSoftException", "reportException", "data", "Lcom/facebook/react/bridge/ReadableMap;", "dismissRedbox", "Companion", "ReactAndroid_release"})
public class ExceptionsManagerModule
extends NativeExceptionsManagerSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DevSupportManager devSupportManager;
    @NotNull
    public static final String NAME = "ExceptionsManager";

    public ExceptionsManagerModule(@NotNull DevSupportManager devSupportManager) {
        Intrinsics.checkNotNullParameter((Object)devSupportManager, (String)"devSupportManager");
        super(null);
        this.devSupportManager = devSupportManager;
    }

    @Override
    public void reportFatalException(@Nullable String message, @Nullable ReadableArray stack, double idDouble) {
        int id2 = (int)idDouble;
        JavaOnlyMap data = new JavaOnlyMap();
        data.putString("message", message);
        data.putArray("stack", stack);
        data.putInt("id", id2);
        data.putBoolean("isFatal", true);
        this.reportException(data);
    }

    @Override
    public void reportSoftException(@Nullable String message, @Nullable ReadableArray stack, double idDouble) {
        int id2 = (int)idDouble;
        JavaOnlyMap data = new JavaOnlyMap();
        data.putString("message", message);
        data.putArray("stack", stack);
        data.putInt("id", id2);
        data.putBoolean("isFatal", false);
        this.reportException(data);
    }

    @Override
    public void reportException(@NotNull ReadableMap data) {
        ReadableArray readableArray;
        String message;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string2 = data.getString("message");
        if (string2 == null) {
            string2 = message = "";
        }
        if ((readableArray = data.getArray("stack")) == null) {
            WritableArray writableArray = Arguments.createArray();
            Intrinsics.checkNotNullExpressionValue((Object)writableArray, (String)"createArray(...)");
            readableArray = writableArray;
        }
        ReadableArray stack = readableArray;
        boolean isFatal = data.hasKey("isFatal") ? data.getBoolean("isFatal") : false;
        String extraDataAsJson = ExceptionDataHelper.getExtraDataAsJson(data);
        if (isFatal) {
            JavascriptException ex = new JavascriptException(JSStackTrace.format(message, stack));
            ex.setExtraDataAsJson(extraDataAsJson);
            throw ex;
        }
        FLog.e((String)"ReactNative", (String)JSStackTrace.format(message, stack));
        if (extraDataAsJson != null) {
            FLog.d((String)"ReactNative", (String)"extraData: %s", (Object)extraDataAsJson);
        }
    }

    @Override
    public void dismissRedbox() {
        if (this.devSupportManager.getDevSupportEnabled()) {
            this.devSupportManager.hideRedboxDialog();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/modules/core/ExceptionsManagerModule$Companion;", "", "<init>", "()V", "NAME", "", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

