/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.blob;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import com.facebook.react.ReactApplication;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.modules.blob.BlobModule;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016JK\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J/\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u0019J9\u0010\u001a\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/facebook/react/modules/blob/BlobProvider;", "Landroid/content/ContentProvider;", "<init>", "()V", "executor", "Ljava/util/concurrent/ExecutorService;", "onCreate", "", "query", "Landroid/database/Cursor;", "uri", "Landroid/net/Uri;", "projection", "", "", "selection", "selectionArgs", "sortOrder", "(Landroid/net/Uri;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)Landroid/database/Cursor;", "getType", "insert", "values", "Landroid/content/ContentValues;", "delete", "", "(Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)I", "update", "(Landroid/net/Uri;Landroid/content/ContentValues;Ljava/lang/String;[Ljava/lang/String;)I", "openFile", "Landroid/os/ParcelFileDescriptor;", "mode", "Companion", "ReactAndroid_release"})
public final class BlobProvider
extends ContentProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutorService executor;
    private static final int PIPE_CAPACITY = 65536;

    public BlobProvider() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        this.executor = executorService;
    }

    public boolean onCreate() {
        return true;
    }

    @Nullable
    public Cursor query(@NotNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return null;
    }

    @Nullable
    public String getType(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return null;
    }

    @Nullable
    public Uri insert(@NotNull Uri uri, @Nullable ContentValues values) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return null;
    }

    public int delete(@NotNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return 0;
    }

    public int update(@NotNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ParcelFileDescriptor openFile(@NotNull Uri uri, @NotNull String mode) throws FileNotFoundException {
        ParcelFileDescriptor readSide;
        block15: {
            Context context;
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            if (!Intrinsics.areEqual((Object)mode, (Object)"r")) {
                throw new FileNotFoundException("Cannot open " + uri + " in mode '" + mode + "'");
            }
            BlobModule blobModule = null;
            Context context2 = this.getContext();
            Object object = context = context2 != null ? context2.getApplicationContext() : null;
            if (context instanceof ReactApplication) {
                ReactNativeHost host = ((ReactApplication)context).getReactNativeHost();
                ReactContext reactContext = host.getReactInstanceManager().getCurrentReactContext();
                if (reactContext == null) {
                    throw new RuntimeException("No ReactContext associated with BlobProvider");
                }
                ReactContext reactContext2 = reactContext;
                blobModule = reactContext2.getNativeModule(BlobModule.class);
            }
            if (blobModule == null) {
                throw new RuntimeException("No blob module associated with BlobProvider");
            }
            byte[] byArray = blobModule.resolve(uri);
            if (byArray == null) {
                throw new FileNotFoundException("Cannot open " + uri + ", blob not found.");
            }
            byte[] data = byArray;
            ParcelFileDescriptor[] pipe = null;
            try {
                ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
                Intrinsics.checkNotNullExpressionValue((Object)parcelFileDescriptorArray, (String)"createPipe(...)");
                pipe = parcelFileDescriptorArray;
            }
            catch (IOException exception) {
                return null;
            }
            readSide = pipe[0];
            ParcelFileDescriptor writeSide = pipe[1];
            if (data.length <= 65536) {
                try {
                    Closeable closeable = (Closeable)new ParcelFileDescriptor.AutoCloseOutputStream(writeSide);
                    Throwable throwable = null;
                    try {
                        ParcelFileDescriptor.AutoCloseOutputStream outputStream = (ParcelFileDescriptor.AutoCloseOutputStream)closeable;
                        boolean bl = false;
                        outputStream.write(data);
                        Unit unit = Unit.INSTANCE;
                        break block15;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (IOException exception) {
                    return null;
                }
            }
            Runnable writer = () -> BlobProvider.openFile$lambda$2(writeSide, data);
            this.executor.submit(writer);
        }
        return readSide;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void openFile$lambda$2(ParcelFileDescriptor $writeSide, byte[] $data) {
        try {
            Closeable closeable = (Closeable)new ParcelFileDescriptor.AutoCloseOutputStream($writeSide);
            Throwable throwable = null;
            try {
                ParcelFileDescriptor.AutoCloseOutputStream outputStream = (ParcelFileDescriptor.AutoCloseOutputStream)closeable;
                boolean bl = false;
                outputStream.write($data);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/modules/blob/BlobProvider$Companion;", "", "<init>", "()V", "PIPE_CAPACITY", "", "ReactAndroid_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

