/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.blob;

import android.content.res.Resources;
import android.database.Cursor;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import com.facebook.fbreact.specs.NativeBlobModuleSpec;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapBuilder;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.blob.BlobCollector;
import com.facebook.react.modules.blob.BlobModule;
import com.facebook.react.modules.network.NetworkingModule;
import com.facebook.react.modules.websocket.WebSocketModule;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="BlobModule")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0004\u000b\u000e\u0011\u0014\b\u0007\u0018\u0000 <2\u00020\u0001:\u0001<B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u000e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\tJ\u0016\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\bJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\bH\u0007J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\bH\u0007J\u0010\u0010!\u001a\u0004\u0018\u00010\t2\u0006\u0010\"\u001a\u00020#J\"\u0010!\u001a\u0004\u0018\u00010\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%J\u0010\u0010!\u001a\u0004\u0018\u00010\t2\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020#H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\b2\u0006\u0010*\u001a\u00020#H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020#H\u0002J\u0010\u0010.\u001a\u00020\b2\u0006\u0010*\u001a\u00020#H\u0002J\b\u00103\u001a\u00020\u0017H\u0016J\u0010\u00104\u001a\u00020\u00172\u0006\u00105\u001a\u00020-H\u0016J\u0010\u00106\u001a\u00020\u00172\u0006\u00105\u001a\u00020-H\u0016J\u0018\u00107\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(2\u0006\u00105\u001a\u00020-H\u0016J\u0018\u00108\u001a\u00020\u00172\u0006\u00109\u001a\u00020:2\u0006\u0010\u001d\u001a\u00020\bH\u0016J\u0010\u0010;\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\bH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0016\u0010/\u001a\u0004\u0018\u0001008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006="}, d2={"Lcom/facebook/react/modules/blob/BlobModule;", "Lcom/facebook/fbreact/specs/NativeBlobModuleSpec;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "blobs", "Ljava/util/HashMap;", "", "", "webSocketContentHandler", "com/facebook/react/modules/blob/BlobModule$webSocketContentHandler$1", "Lcom/facebook/react/modules/blob/BlobModule$webSocketContentHandler$1;", "networkingUriHandler", "com/facebook/react/modules/blob/BlobModule$networkingUriHandler$1", "Lcom/facebook/react/modules/blob/BlobModule$networkingUriHandler$1;", "networkingRequestBodyHandler", "com/facebook/react/modules/blob/BlobModule$networkingRequestBodyHandler$1", "Lcom/facebook/react/modules/blob/BlobModule$networkingRequestBodyHandler$1;", "networkingResponseHandler", "com/facebook/react/modules/blob/BlobModule$networkingResponseHandler$1", "Lcom/facebook/react/modules/blob/BlobModule$networkingResponseHandler$1;", "initialize", "", "getTypedExportedConstants", "", "", "store", "data", "blobId", "getLengthOfBlob", "", "remove", "resolve", "uri", "Landroid/net/Uri;", "offset", "", "size", "blob", "Lcom/facebook/react/bridge/ReadableMap;", "getBytesFromUri", "contentUri", "getNameFromUri", "getLastModifiedFromUri", "", "getMimeTypeFromUri", "webSocketModule", "Lcom/facebook/react/modules/websocket/WebSocketModule;", "getWebSocketModule", "()Lcom/facebook/react/modules/websocket/WebSocketModule;", "addNetworkingHandler", "addWebSocketHandler", "idDouble", "removeWebSocketHandler", "sendOverSocket", "createFromParts", "parts", "Lcom/facebook/react/bridge/ReadableArray;", "release", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nBlobModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlobModule.kt\ncom/facebook/react/modules/blob/BlobModule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,339:1\n1#2:340\n*E\n"})
public final class BlobModule
extends NativeBlobModuleSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, byte[]> blobs;
    @NotNull
    private final webSocketContentHandler.1 webSocketContentHandler;
    @NotNull
    private final networkingUriHandler.1 networkingUriHandler;
    @NotNull
    private final networkingRequestBodyHandler.1 networkingRequestBodyHandler;
    @NotNull
    private final networkingResponseHandler.1 networkingResponseHandler;
    @NotNull
    public static final String NAME = "BlobModule";

    public BlobModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super(reactContext);
        this.blobs = new HashMap();
        this.webSocketContentHandler = new WebSocketModule.ContentHandler(this){
            final /* synthetic */ BlobModule this$0;
            {
                this.this$0 = $receiver;
            }

            public void onMessage(String text, WritableMap params) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                params.putString("data", text);
            }

            public void onMessage(ByteString byteString, WritableMap params) {
                ReadableMapBuilder readableMapBuilder;
                Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                byte[] data = byteString.toByteArray();
                BlobModule blobModule = this.this$0;
                boolean $i$f$buildReadableMap = false;
                WritableMap writableMap = Arguments.createMap();
                Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
                WritableMap map$iv = writableMap;
                ReadableMapBuilder $this$onMessage_u24lambda_u240 = readableMapBuilder = new ReadableMapBuilder(map$iv);
                boolean bl = false;
                $this$onMessage_u24lambda_u240.put("blobId", blobModule.store(data));
                $this$onMessage_u24lambda_u240.put("offset", 0);
                $this$onMessage_u24lambda_u240.put("size", data.length);
                ReadableMap blob = map$iv;
                params.putMap("data", blob);
                params.putString("type", "blob");
            }
        };
        this.networkingUriHandler = new NetworkingModule.UriHandler(this){
            final /* synthetic */ BlobModule this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean supports(Uri uri, String responseType) {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                Intrinsics.checkNotNullParameter((Object)responseType, (String)"responseType");
                String scheme = uri.getScheme();
                boolean isRemote = Intrinsics.areEqual((Object)scheme, (Object)"http") || Intrinsics.areEqual((Object)scheme, (Object)"https");
                return !isRemote && Intrinsics.areEqual((Object)responseType, (Object)"blob");
            }

            public WritableMap fetch(Uri uri) {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                byte[] data = BlobModule.access$getBytesFromUri(this.this$0, uri);
                WritableMap writableMap = Arguments.createMap();
                Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
                WritableMap blob = writableMap;
                blob.putString("blobId", this.this$0.store(data));
                blob.putInt("offset", 0);
                blob.putInt("size", data.length);
                blob.putString("type", BlobModule.access$getMimeTypeFromUri(this.this$0, uri));
                blob.putString("name", BlobModule.access$getNameFromUri(this.this$0, uri));
                blob.putDouble("lastModified", BlobModule.access$getLastModifiedFromUri(this.this$0, uri));
                return blob;
            }
        };
        this.networkingRequestBodyHandler = new NetworkingModule.RequestBodyHandler(this){
            final /* synthetic */ BlobModule this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean supports(ReadableMap map) {
                Intrinsics.checkNotNullParameter((Object)map, (String)"map");
                return map.hasKey("blob");
            }

            public RequestBody toRequestBody(ReadableMap map, String contentType) {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter((Object)map, (String)"map");
                String type = contentType;
                if (map.hasKey("type") && !((charSequence = (CharSequence)map.getString("type")) == null || charSequence.length() == 0)) {
                    type = map.getString("type");
                }
                if (type == null) {
                    type = "application/octet-stream";
                }
                ReadableMap readableMap = map.getMap("blob");
                if (readableMap == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalStateException(string2.toString());
                }
                ReadableMap blob = readableMap;
                byte[] byArray = this.this$0.resolve(blob.getString("blobId"), blob.getInt("offset"), blob.getInt("size"));
                if (byArray == null) {
                    String string3 = "Required value was null.";
                    throw new IllegalStateException(string3.toString());
                }
                byte[] bytes = byArray;
                return RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (MediaType)MediaType.Companion.-deprecated_parse(type), (byte[])bytes, (int)0, (int)0, (int)12, null);
            }
        };
        this.networkingResponseHandler = new NetworkingModule.ResponseHandler(this){
            final /* synthetic */ BlobModule this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean supports(String responseType) {
                Intrinsics.checkNotNullParameter((Object)responseType, (String)"responseType");
                return Intrinsics.areEqual((Object)responseType, (Object)"blob");
            }

            public WritableMap toResponseData(ResponseBody body) {
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                byte[] data = body.bytes();
                WritableMap writableMap = Arguments.createMap();
                Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
                WritableMap blob = writableMap;
                blob.putString("blobId", this.this$0.store(data));
                blob.putInt("offset", 0);
                blob.putInt("size", data.length);
                return blob;
            }
        };
    }

    @Override
    public void initialize() {
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)reactApplicationContext), (String)"getReactApplicationContext(...)");
        BlobCollector.install(reactApplicationContext, this);
    }

    @Override
    @NotNull
    public Map<String, Object> getTypedExportedConstants() {
        String packageName;
        Resources resources = this.getReactApplicationContext().getResources();
        int resourceId = resources.getIdentifier("blob_provider_authority", "string", packageName = this.getReactApplicationContext().getPackageName());
        if (resourceId == 0) {
            return MapsKt.emptyMap();
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"BLOB_URI_SCHEME", (Object)"content"), TuplesKt.to((Object)"BLOB_URI_HOST", (Object)resources.getString(resourceId))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final String store(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String blobId = string2;
        this.store(data, blobId);
        return blobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void store(@NotNull byte[] data, @NotNull String blobId) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)blobId, (String)"blobId");
        HashMap<String, byte[]> hashMap = this.blobs;
        synchronized (hashMap) {
            boolean bl = false;
            ((Map)this.blobs).put(blobId, data);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    public final long getLengthOfBlob(@NotNull String blobId) {
        Intrinsics.checkNotNullParameter((Object)blobId, (String)"blobId");
        HashMap<String, byte[]> hashMap = this.blobs;
        synchronized (hashMap) {
            boolean bl = false;
            byte[] data = this.blobs.get(blobId);
            long l = data != null ? (long)data.length : 0L;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    public final void remove(@NotNull String blobId) {
        Intrinsics.checkNotNullParameter((Object)blobId, (String)"blobId");
        HashMap<String, byte[]> hashMap = this.blobs;
        synchronized (hashMap) {
            boolean bl = false;
            byte[] byArray = this.blobs.remove(blobId);
        }
    }

    @Nullable
    public final byte[] resolve(@NotNull Uri uri) {
        String sizeParam;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String blobId = uri.getLastPathSegment();
        int offset = 0;
        int size = -1;
        String offsetParam = uri.getQueryParameter("offset");
        if (offsetParam != null) {
            offset = Integer.parseInt(offsetParam);
        }
        if ((sizeParam = uri.getQueryParameter("size")) != null) {
            size = Integer.parseInt(sizeParam);
        }
        return this.resolve(blobId, offset, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final byte[] resolve(@Nullable String blobId, int offset, int size) {
        HashMap<String, byte[]> hashMap = this.blobs;
        synchronized (hashMap) {
            byte[] data;
            block7: {
                block6: {
                    boolean bl = false;
                    data = (byte[])((Map)this.blobs).get(blobId);
                    if (data != null) break block6;
                    byte[] byArray = null;
                    return byArray;
                }
                int newSize = size;
                if (newSize == -1) {
                    newSize = data.length - offset;
                }
                if (offset <= 0 && newSize == data.length) break block7;
                byte[] byArray = Arrays.copyOfRange(data, offset, offset + newSize);
                return byArray;
            }
            byte[] byArray = data;
            return byArray;
        }
    }

    @Nullable
    public final byte[] resolve(@NotNull ReadableMap blob) {
        Intrinsics.checkNotNullParameter((Object)blob, (String)"blob");
        return this.resolve(blob.getString("blobId"), blob.getInt("offset"), blob.getInt("size"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] getBytesFromUri(Uri contentUri) throws IOException {
        InputStream inputStream = this.getReactApplicationContext().getContentResolver().openInputStream(contentUri);
        if (inputStream == null) {
            throw new FileNotFoundException("File not found for " + contentUri);
        }
        try (InputStream inputStream2 = inputStream;){
            byte[] buffer = new byte[Math.max(1024, inputStream2.available())];
            Ref.IntRef len = new Ref.IntRef();
            byte[] prevBuffer = new byte[1024];
            int prevLen = 0;
            ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
            while (true) {
                int n;
                int it = n = inputStream2.read(buffer);
                boolean bl = false;
                len.element = it;
                if (n == -1) break;
                byteBuffer.write(prevBuffer, 0, prevLen);
                byte[] temp = prevBuffer;
                prevBuffer = buffer;
                buffer = temp;
                prevLen = len.element;
            }
            if (byteBuffer.size() == 0 && prevBuffer.length == prevLen) {
                byte[] byArray = prevBuffer;
                return byArray;
            }
            byteBuffer.write(prevBuffer, 0, prevLen);
            byte[] byArray = byteBuffer.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getNameFromUri(Uri contentUri) {
        Cursor metaCursor;
        if (Intrinsics.areEqual((Object)contentUri.getScheme(), (Object)"file")) {
            return contentUri.getLastPathSegment();
        }
        String[] stringArray = new String[]{"_display_name"};
        String[] projection = stringArray;
        Cursor cursor = metaCursor = this.getReactApplicationContext().getContentResolver().query(contentUri, projection, null, null, null);
        if (cursor != null) {
            Closeable closeable = (Closeable)cursor;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl = false;
                if (it.moveToFirst()) {
                    String string2 = it.getString(0);
                    return string2;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return contentUri.getLastPathSegment();
    }

    private final double getLastModifiedFromUri(Uri contentUri) {
        return Intrinsics.areEqual((Object)contentUri.getScheme(), (Object)"file") ? (double)new File(contentUri.toString()).lastModified() : 0.0;
    }

    private final String getMimeTypeFromUri(Uri contentUri) {
        String string2;
        String ext;
        String type = this.getReactApplicationContext().getContentResolver().getType(contentUri);
        if (type == null && (ext = MimeTypeMap.getFileExtensionFromUrl((String)contentUri.getPath())) != null) {
            type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(ext);
        }
        if ((string2 = type) == null) {
            string2 = "";
        }
        return string2;
    }

    private final WebSocketModule getWebSocketModule() {
        return this.getReactApplicationContext().getNativeModule(WebSocketModule.class);
    }

    @Override
    public void addNetworkingHandler() {
        NetworkingModule networkingModule = this.getReactApplicationContext().getNativeModule(NetworkingModule.class);
        if (networkingModule == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        NetworkingModule networkingModule2 = networkingModule;
        networkingModule2.addUriHandler$ReactAndroid_release(this.networkingUriHandler);
        networkingModule2.addRequestBodyHandler$ReactAndroid_release(this.networkingRequestBodyHandler);
        networkingModule2.addResponseHandler$ReactAndroid_release(this.networkingResponseHandler);
    }

    @Override
    public void addWebSocketHandler(double idDouble) {
        block0: {
            int id2 = (int)idDouble;
            WebSocketModule webSocketModule = this.getWebSocketModule();
            if (webSocketModule == null) break block0;
            webSocketModule.setContentHandler(id2, this.webSocketContentHandler);
        }
    }

    @Override
    public void removeWebSocketHandler(double idDouble) {
        block0: {
            int id2 = (int)idDouble;
            WebSocketModule webSocketModule = this.getWebSocketModule();
            if (webSocketModule == null) break block0;
            webSocketModule.setContentHandler(id2, null);
        }
    }

    @Override
    public void sendOverSocket(@NotNull ReadableMap blob, double idDouble) {
        block1: {
            byte[] data;
            Intrinsics.checkNotNullParameter((Object)blob, (String)"blob");
            int id2 = (int)idDouble;
            WebSocketModule webSocketModule = this.getWebSocketModule();
            if (webSocketModule == null) break block1;
            WebSocketModule it = webSocketModule;
            boolean bl = false;
            if (data != null) {
                byte[] bytes = data = this.resolve(blob.getString("blobId"), blob.getInt("offset"), blob.getInt("size"));
                boolean bl2 = false;
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
                it.sendBinary(ByteString.Companion.-deprecated_of(byteBuffer), id2);
            }
        }
    }

    @Override
    public void createFromParts(@NotNull ReadableArray parts, @NotNull String blobId) {
        Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
        Intrinsics.checkNotNullParameter((Object)blobId, (String)"blobId");
        int totalBlobSize = 0;
        ArrayList<byte[]> partList = new ArrayList<byte[]>(parts.size());
        int n = parts.size();
        for (int i = 0; i < n; ++i) {
            String string2;
            String type;
            ReadableMap part;
            String string3;
            if (parts.getMap(i) == null) {
                string3 = "Required value was null.";
                throw new IllegalStateException(string3.toString());
            }
            if (part.getString("type") == null) {
                String string4 = "Required value was null.";
                throw new IllegalStateException(string4.toString());
            }
            string3 = type;
            if (Intrinsics.areEqual((Object)string3, (Object)"blob")) {
                ReadableMap blob;
                if (part.getMap("data") == null) {
                    string2 = "Required value was null.";
                    throw new IllegalStateException(string2.toString());
                }
                totalBlobSize += blob.getInt("size");
                byte[] byArray = this.resolve(blob);
                if (byArray == null) {
                    string2 = "Required value was null.";
                    throw new IllegalStateException(string2.toString());
                }
                partList.add(i, byArray);
                continue;
            }
            if (Intrinsics.areEqual((Object)string3, (Object)"string")) {
                byte[] bytes;
                String data;
                if (part.getString("data") == null) {
                    string2 = "Required value was null.";
                    throw new IllegalStateException(string2.toString());
                }
                string2 = data;
                Charset charset = Charset.forName("UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                Intrinsics.checkNotNullExpressionValue((Object)string2.getBytes(charset), (String)"getBytes(...)");
                totalBlobSize += bytes.length;
                partList.add(i, bytes);
                continue;
            }
            throw new IllegalArgumentException("Invalid type for blob: " + part.getString("type"));
        }
        ByteBuffer buffer = ByteBuffer.allocate(totalBlobSize);
        Iterator iterator2 = partList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            byte[] bytes = (byte[])e;
            buffer.put(bytes);
        }
        byte[] byArray = buffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        this.store(byArray, blobId);
    }

    @Override
    public void release(@NotNull String blobId) {
        Intrinsics.checkNotNullParameter((Object)blobId, (String)"blobId");
        this.remove(blobId);
    }

    public static final /* synthetic */ byte[] access$getBytesFromUri(BlobModule $this, Uri contentUri) {
        return $this.getBytesFromUri(contentUri);
    }

    public static final /* synthetic */ String access$getMimeTypeFromUri(BlobModule $this, Uri contentUri) {
        return $this.getMimeTypeFromUri(contentUri);
    }

    public static final /* synthetic */ String access$getNameFromUri(BlobModule $this, Uri contentUri) {
        return $this.getNameFromUri(contentUri);
    }

    public static final /* synthetic */ double access$getLastModifiedFromUri(BlobModule $this, Uri contentUri) {
        return $this.getLastModifiedFromUri(contentUri);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/modules/blob/BlobModule$Companion;", "", "<init>", "()V", "NAME", "", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

