/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.internal.turbomodule.core;

import androidx.annotation.GuardedBy;
import com.facebook.common.logging.FLog;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.CxxModuleWrapper;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.RuntimeExecutor;
import com.facebook.react.internal.turbomodule.core.TurboModuleInteropUtils;
import com.facebook.react.internal.turbomodule.core.TurboModuleManagerDelegate;
import com.facebook.react.internal.turbomodule.core.TurboModulePerfLogger;
import com.facebook.react.internal.turbomodule.core.interfaces.TurboModuleRegistry;
import com.facebook.react.turbomodule.core.CallInvokerHolderImpl;
import com.facebook.react.turbomodule.core.NativeMethodCallInvokerHolderImpl;
import com.facebook.react.turbomodule.core.interfaces.CallInvokerHolder;
import com.facebook.react.turbomodule.core.interfaces.NativeMethodCallInvokerHolder;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import com.facebook.soloader.SoLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 >2\u00020\u0001:\u0003<=>B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000eH\u0002J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000eH\u0002J\b\u0010\"\u001a\u00020\u0017H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010 \u001a\u00020\u000eH\u0003J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010 \u001a\u00020\u000eH\u0003J\u0012\u0010'\u001a\u0004\u0018\u00010&2\u0006\u0010 \u001a\u00020\u000eH\u0003J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010 \u001a\u00020\u000eH\u0003J\u0012\u0010*\u001a\u0004\u0018\u00010$2\u0006\u0010 \u001a\u00020\u000eH\u0016J\"\u0010+\u001a\u0004\u0018\u00010$2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u0017H\u0002J\u0010\u00102\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000eH\u0016J+\u00103\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u0002042\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u0005H\u0082 J\u0011\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0017H\u0082 J\b\u0010;\u001a\u000209H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u00178\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00198\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\u00020\u001c8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001d\u0010\u001eR\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020$0/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006?"}, d2={"Lcom/facebook/react/internal/turbomodule/core/TurboModuleManager;", "Lcom/facebook/react/internal/turbomodule/core/interfaces/TurboModuleRegistry;", "runtimeExecutor", "Lcom/facebook/react/bridge/RuntimeExecutor;", "delegate", "Lcom/facebook/react/internal/turbomodule/core/TurboModuleManagerDelegate;", "jsCallInvokerHolder", "Lcom/facebook/react/turbomodule/core/interfaces/CallInvokerHolder;", "nativeMethodCallInvokerHolder", "Lcom/facebook/react/turbomodule/core/interfaces/NativeMethodCallInvokerHolder;", "<init>", "(Lcom/facebook/react/bridge/RuntimeExecutor;Lcom/facebook/react/internal/turbomodule/core/TurboModuleManagerDelegate;Lcom/facebook/react/turbomodule/core/interfaces/CallInvokerHolder;Lcom/facebook/react/turbomodule/core/interfaces/NativeMethodCallInvokerHolder;)V", "eagerInitModuleNames", "", "", "getEagerInitModuleNames", "()Ljava/util/List;", "turboModuleProvider", "Lcom/facebook/react/internal/turbomodule/core/TurboModuleManager$ModuleProvider;", "legacyModuleProvider", "moduleCleanupLock", "Ljava/lang/Object;", "moduleCleanupStarted", "", "moduleHolders", "", "Lcom/facebook/react/internal/turbomodule/core/TurboModuleManager$ModuleHolder;", "mHybridData", "Lcom/facebook/jni/HybridData;", "getMHybridData$annotations", "()V", "isTurboModule", "moduleName", "isLegacyModule", "shouldEnableLegacyModuleInterop", "getLegacyJavaModule", "Lcom/facebook/react/bridge/NativeModule;", "getLegacyCxxModule", "Lcom/facebook/react/bridge/CxxModuleWrapper;", "getTurboLegacyCxxModule", "getTurboJavaModule", "Lcom/facebook/react/turbomodule/core/interfaces/TurboModule;", "getModule", "getOrCreateModule", "moduleHolder", "shouldPerfLog", "modules", "", "getModules", "()Ljava/util/Collection;", "hasModule", "initHybrid", "Lcom/facebook/react/turbomodule/core/CallInvokerHolderImpl;", "nativeMethodCallInvoker", "Lcom/facebook/react/turbomodule/core/NativeMethodCallInvokerHolderImpl;", "tmmDelegate", "installJSIBindings", "", "shouldCreateLegacyModules", "invalidate", "ModuleHolder", "ModuleProvider", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nTurboModuleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TurboModuleManager.kt\ncom/facebook/react/internal/turbomodule/core/TurboModuleManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,406:1\n1#2:407\n1#2:418\n1617#3,9:408\n1869#3:417\n1870#3:419\n1626#3:420\n*S KotlinDebug\n*F\n+ 1 TurboModuleManager.kt\ncom/facebook/react/internal/turbomodule/core/TurboModuleManager\n*L\n304#1:418\n304#1:408,9\n304#1:417\n304#1:419\n304#1:420\n*E\n"})
public final class TurboModuleManager
implements TurboModuleRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final TurboModuleManagerDelegate delegate;
    @NotNull
    private final List<String> eagerInitModuleNames;
    @NotNull
    private final ModuleProvider turboModuleProvider;
    @NotNull
    private final ModuleProvider legacyModuleProvider;
    @NotNull
    private final Object moduleCleanupLock;
    @GuardedBy(value="moduleCleanupLock")
    private boolean moduleCleanupStarted;
    @GuardedBy(value="moduleCleanupLock")
    @NotNull
    private final Map<String, ModuleHolder> moduleHolders;
    @DoNotStrip
    @NotNull
    private final HybridData mHybridData;
    @NotNull
    private static final String TAG = "TurboModuleManager";

    public TurboModuleManager(@NotNull RuntimeExecutor runtimeExecutor, @Nullable TurboModuleManagerDelegate delegate, @NotNull CallInvokerHolder jsCallInvokerHolder, @NotNull NativeMethodCallInvokerHolder nativeMethodCallInvokerHolder) {
        Intrinsics.checkNotNullParameter((Object)((Object)runtimeExecutor), (String)"runtimeExecutor");
        Intrinsics.checkNotNullParameter((Object)jsCallInvokerHolder, (String)"jsCallInvokerHolder");
        Intrinsics.checkNotNullParameter((Object)nativeMethodCallInvokerHolder, (String)"nativeMethodCallInvokerHolder");
        this.delegate = delegate;
        this.moduleCleanupLock = new Object();
        this.moduleHolders = new LinkedHashMap();
        this.mHybridData = this.initHybrid(runtimeExecutor, (CallInvokerHolderImpl)jsCallInvokerHolder, (NativeMethodCallInvokerHolderImpl)nativeMethodCallInvokerHolder, this.delegate);
        this.installJSIBindings(this.shouldEnableLegacyModuleInterop());
        Object object = this.delegate;
        if (object == null || (object = ((TurboModuleManagerDelegate)object).getEagerInitModuleNames()) == null) {
            object = CollectionsKt.emptyList();
        }
        this.eagerInitModuleNames = object;
        ModuleProvider nullProvider = TurboModuleManager::_init_$lambda$0;
        this.turboModuleProvider = this.delegate == null ? nullProvider : arg_0 -> TurboModuleManager._init_$lambda$1(this, arg_0);
        this.legacyModuleProvider = this.delegate == null || !this.shouldEnableLegacyModuleInterop() ? nullProvider : arg_0 -> TurboModuleManager._init_$lambda$3(this, arg_0);
    }

    @Override
    @NotNull
    public List<String> getEagerInitModuleNames() {
        return this.eagerInitModuleNames;
    }

    private static /* synthetic */ void getMHybridData$annotations() {
    }

    private final boolean isTurboModule(String moduleName) {
        TurboModuleManagerDelegate turboModuleManagerDelegate = this.delegate;
        return turboModuleManagerDelegate != null ? turboModuleManagerDelegate.unstable_isModuleRegistered(moduleName) : false;
    }

    private final boolean isLegacyModule(String moduleName) {
        TurboModuleManagerDelegate turboModuleManagerDelegate = this.delegate;
        return turboModuleManagerDelegate != null ? turboModuleManagerDelegate.unstable_isLegacyModuleRegistered(moduleName) : false;
    }

    private final boolean shouldEnableLegacyModuleInterop() {
        TurboModuleManagerDelegate turboModuleManagerDelegate = this.delegate;
        return turboModuleManagerDelegate != null ? turboModuleManagerDelegate.unstable_shouldEnableLegacyModuleInterop() : false;
    }

    @DoNotStrip
    private final NativeModule getLegacyJavaModule(String moduleName) {
        if (!this.isLegacyModule(moduleName)) {
            return null;
        }
        NativeModule module = this.getModule(moduleName);
        return !(module instanceof CxxModuleWrapper) && !(module instanceof TurboModule) ? module : null;
    }

    @DoNotStrip
    private final CxxModuleWrapper getLegacyCxxModule(String moduleName) {
        if (!this.isLegacyModule(moduleName)) {
            return null;
        }
        NativeModule module = this.getModule(moduleName);
        return module instanceof CxxModuleWrapper && !(module instanceof TurboModule) ? (CxxModuleWrapper)module : null;
    }

    @DoNotStrip
    private final CxxModuleWrapper getTurboLegacyCxxModule(String moduleName) {
        if (!this.isTurboModule(moduleName)) {
            return null;
        }
        NativeModule module = this.getModule(moduleName);
        return module instanceof CxxModuleWrapper && module instanceof TurboModule ? (CxxModuleWrapper)module : null;
    }

    @DoNotStrip
    private final TurboModule getTurboJavaModule(String moduleName) {
        if (!this.isTurboModule(moduleName)) {
            return null;
        }
        NativeModule module = this.getModule(moduleName);
        return !(module instanceof CxxModuleWrapper) && module instanceof TurboModule ? (TurboModule)((Object)module) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public NativeModule getModule(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        ModuleHolder moduleHolder = null;
        Object object = this.moduleCleanupLock;
        synchronized (object) {
            block8: {
                boolean bl = false;
                if (!this.moduleCleanupStarted) break block8;
                Object[] objectArray = new Object[]{moduleName, this.isLegacyModule(moduleName), this.isTurboModule(moduleName)};
                FLog.e((String)TAG, (String)"getModule(): Tried to get module \"%s\", but TurboModuleManager was tearing down (legacy: %b, turbo: %b)", (Object[])objectArray);
                NativeModule nativeModule = null;
                return nativeModule;
            }
            if (!this.moduleHolders.containsKey(moduleName)) {
                this.moduleHolders.put(moduleName, new ModuleHolder());
            }
            moduleHolder = this.moduleHolders.get(moduleName);
            Unit unit = Unit.INSTANCE;
        }
        if (moduleHolder == null) {
            Object[] objectArray = new Object[]{moduleName};
            FLog.e((String)TAG, (String)"getModule(): Tried to get module \"%s\", but moduleHolder was null", (Object[])objectArray);
            return null;
        }
        TurboModulePerfLogger.moduleCreateStart(moduleName, moduleHolder.getModuleId());
        NativeModule module = this.getOrCreateModule(moduleName, moduleHolder, true);
        if (module != null) {
            TurboModulePerfLogger.moduleCreateEnd(moduleName, moduleHolder.getModuleId());
        } else {
            TurboModulePerfLogger.moduleCreateFail(moduleName, moduleHolder.getModuleId());
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NativeModule getOrCreateModule(String moduleName, ModuleHolder moduleHolder, boolean shouldPerfLog) {
        Object object;
        boolean shouldCreateModule = false;
        ModuleHolder moduleHolder2 = moduleHolder;
        synchronized (moduleHolder2) {
            block23: {
                boolean bl = false;
                if (!moduleHolder.isDoneCreatingModule()) break block23;
                if (shouldPerfLog) {
                    TurboModulePerfLogger.moduleCreateCacheHit(moduleName, moduleHolder.getModuleId());
                }
                NativeModule nativeModule = moduleHolder.getModule();
                return nativeModule;
            }
            if (!moduleHolder.isCreatingModule()) {
                shouldCreateModule = true;
                moduleHolder.startCreatingModule();
            }
            object = Unit.INSTANCE;
        }
        if (shouldCreateModule) {
            TurboModulePerfLogger.moduleCreateConstructStart(moduleName, moduleHolder.getModuleId());
            NativeModule nativeModule = null;
            nativeModule = this.turboModuleProvider.getModule(moduleName);
            if (nativeModule == null) {
                nativeModule = this.legacyModuleProvider.getModule(moduleName);
            }
            TurboModulePerfLogger.moduleCreateConstructEnd(moduleName, moduleHolder.getModuleId());
            TurboModulePerfLogger.moduleCreateSetUpStart(moduleName, moduleHolder.getModuleId());
            if (nativeModule != null) {
                object = moduleHolder;
                synchronized (object) {
                    boolean $i$a$-synchronized-TurboModuleManager$getOrCreateModule$52 = false;
                    moduleHolder.setModule(nativeModule);
                    Unit $i$a$-synchronized-TurboModuleManager$getOrCreateModule$52 = Unit.INSTANCE;
                }
                nativeModule.initialize();
            } else {
                object = new Object[]{moduleName, this.isLegacyModule(moduleName), this.isTurboModule(moduleName)};
                FLog.e((String)TAG, (String)"getOrCreateModule(): Unable to create module \"%s\" (legacy: %b, turbo: %b)", (Object[])object);
            }
            TurboModulePerfLogger.moduleCreateSetUpEnd(moduleName, moduleHolder.getModuleId());
            object = moduleHolder;
            synchronized (object) {
                boolean $i$a$-synchronized-TurboModuleManager$getOrCreateModule$62 = false;
                moduleHolder.endCreatingModule();
                Intrinsics.checkNotNull((Object)moduleHolder, (String)"null cannot be cast to non-null type java.lang.Object");
                ((Object)moduleHolder).notifyAll();
                Unit $i$a$-synchronized-TurboModuleManager$getOrCreateModule$62 = Unit.INSTANCE;
            }
            return nativeModule;
        }
        moduleHolder2 = moduleHolder;
        synchronized (moduleHolder2) {
            boolean bl = false;
            boolean wasInterrupted = false;
            while (moduleHolder.isCreatingModule()) {
                try {
                    Intrinsics.checkNotNull((Object)moduleHolder, (String)"null cannot be cast to non-null type java.lang.Object");
                    ((Object)moduleHolder).wait();
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                }
            }
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
            NativeModule nativeModule = moduleHolder.getModule();
            return nativeModule;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<NativeModule> getModules() {
        void $this$mapNotNullTo$iv$iv;
        List $i$a$-synchronized-TurboModuleManager$modules$holders$22;
        Object object = this.moduleCleanupLock;
        synchronized (object) {
            boolean $i$a$-synchronized-TurboModuleManager$modules$holders$22 = false;
            $i$a$-synchronized-TurboModuleManager$modules$holders$22 = CollectionsKt.toList((Iterable)this.moduleHolders.values());
        }
        List holders = $i$a$-synchronized-TurboModuleManager$modules$holders$22;
        Iterable $this$mapNotNull$iv = holders;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            NativeModule it$iv$iv;
            NativeModule nativeModule;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ModuleHolder holder = (ModuleHolder)element$iv$iv;
            boolean bl2 = false;
            List list = holders;
            synchronized (list) {
                boolean bl3 = false;
                nativeModule = holder.getModule();
            }
            if (nativeModule == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List moduleList = (List)destination$iv$iv;
        return moduleList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasModule(@NotNull String moduleName) {
        boolean bl;
        ModuleHolder moduleHolder;
        ModuleHolder moduleHolder2;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Object object = this.moduleCleanupLock;
        synchronized (object) {
            ModuleHolder moduleHolder3;
            block7: {
                boolean bl2 = false;
                if (this.moduleHolders.get(moduleName) != null) break block7;
                boolean bl3 = false;
                return bl3;
            }
            moduleHolder2 = moduleHolder3;
        }
        ModuleHolder moduleHolder4 = moduleHolder = moduleHolder2;
        synchronized (moduleHolder4) {
            boolean bl4 = false;
            bl = moduleHolder.getModule() != null;
        }
        return bl;
    }

    private final native HybridData initHybrid(RuntimeExecutor var1, CallInvokerHolderImpl var2, NativeMethodCallInvokerHolderImpl var3, TurboModuleManagerDelegate var4);

    private final native void installJSIBindings(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        Map.Entry<String, ModuleHolder> entry2 = this.moduleCleanupLock;
        synchronized (entry2) {
            boolean $i$a$-synchronized-TurboModuleManager$invalidate$22 = false;
            this.moduleCleanupStarted = true;
            Unit $i$a$-synchronized-TurboModuleManager$invalidate$22 = Unit.INSTANCE;
        }
        for (Map.Entry<String, ModuleHolder> entry2 : this.moduleHolders.entrySet()) {
            NativeModule nativeModule;
            String moduleName = entry2.getKey();
            ModuleHolder moduleHolder = entry2.getValue();
            NativeModule nativeModule2 = nativeModule = this.getOrCreateModule(moduleName, moduleHolder, false);
            if (nativeModule2 == null) continue;
            nativeModule2.invalidate();
        }
        this.moduleHolders.clear();
        this.mHybridData.resetNative();
    }

    private static final NativeModule _init_$lambda$0(String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<unused var>");
        return null;
    }

    private static final NativeModule _init_$lambda$1(TurboModuleManager this$0, String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return (NativeModule)((Object)this$0.delegate.getModule(moduleName));
    }

    private static final NativeModule _init_$lambda$3(TurboModuleManager this$0, String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        NativeModule nativeModule = this$0.delegate.getLegacyModule(moduleName);
        if (nativeModule != null) {
            if (!(!(nativeModule instanceof TurboModule))) {
                boolean bl = false;
                String string2 = "NativeModule \"" + moduleName + "\" is a TurboModule";
                throw new IllegalArgumentException(string2.toString());
            }
            return nativeModule;
        }
        return null;
    }

    @JvmStatic
    @DoNotStrip
    private static final List<TurboModuleInteropUtils.MethodDescriptor> getMethodDescriptorsFromModule(NativeModule module) {
        return TurboModuleManager.Companion.getMethodDescriptorsFromModule(module);
    }

    static {
        SoLoader.loadLibrary((String)"turbomodulejsijni");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/react/internal/turbomodule/core/TurboModuleManager$Companion;", "", "<init>", "()V", "TAG", "", "getMethodDescriptorsFromModule", "", "Lcom/facebook/react/internal/turbomodule/core/TurboModuleInteropUtils$MethodDescriptor;", "module", "Lcom/facebook/react/bridge/NativeModule;", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @DoNotStrip
        private final List<TurboModuleInteropUtils.MethodDescriptor> getMethodDescriptorsFromModule(NativeModule module) {
            return TurboModuleInteropUtils.getMethodDescriptorsFromModule(module);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/facebook/react/internal/turbomodule/core/TurboModuleManager$ModuleHolder;", "", "<init>", "()V", "module", "Lcom/facebook/react/bridge/NativeModule;", "getModule", "()Lcom/facebook/react/bridge/NativeModule;", "setModule", "(Lcom/facebook/react/bridge/NativeModule;)V", "value", "", "isCreatingModule", "()Z", "isDoneCreatingModule", "", "moduleId", "getModuleId", "()I", "startCreatingModule", "", "endCreatingModule", "Companion", "ReactAndroid_release"})
    private static final class ModuleHolder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private volatile NativeModule module;
        private volatile boolean isCreatingModule;
        private volatile boolean isDoneCreatingModule;
        private volatile int moduleId = holderCount++;
        private static volatile int holderCount;

        @Nullable
        public final NativeModule getModule() {
            return this.module;
        }

        public final void setModule(@Nullable NativeModule nativeModule) {
            this.module = nativeModule;
        }

        public final boolean isCreatingModule() {
            return this.isCreatingModule;
        }

        public final boolean isDoneCreatingModule() {
            return this.isDoneCreatingModule;
        }

        public final int getModuleId() {
            return this.moduleId;
        }

        public final void startCreatingModule() {
            this.isCreatingModule = true;
        }

        public final void endCreatingModule() {
            this.isCreatingModule = false;
            this.isDoneCreatingModule = true;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/internal/turbomodule/core/TurboModuleManager$ModuleHolder$Companion;", "", "<init>", "()V", "holderCount", "", "ReactAndroid_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e2\u0080\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/internal/turbomodule/core/TurboModuleManager$ModuleProvider;", "", "getModule", "Lcom/facebook/react/bridge/NativeModule;", "name", "", "ReactAndroid_release"})
    private static interface ModuleProvider {
        @Nullable
        public NativeModule getModule(@NotNull String var1);
    }
}

