/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.internal.turbomodule.core;

import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001b\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\fJ;\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\n2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002\u00a2\u0006\u0002\u0010\u0014J$\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J$\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u0014\u0010\u0018\u001a\u00020\u000e2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J/\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\nH\u0002\u00a2\u0006\u0002\u0010\u001cJ;\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\n2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/facebook/react/internal/turbomodule/core/TurboModuleInteropUtils;", "", "<init>", "()V", "getMethodDescriptorsFromModule", "", "Lcom/facebook/react/internal/turbomodule/core/TurboModuleInteropUtils$MethodDescriptor;", "module", "Lcom/facebook/react/bridge/NativeModule;", "getMethodsFromModule", "", "Ljava/lang/reflect/Method;", "(Lcom/facebook/react/bridge/NativeModule;)[Ljava/lang/reflect/Method;", "createJniSignature", "", "moduleName", "methodName", "paramClasses", "Ljava/lang/Class;", "returnClass", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Class;Ljava/lang/Class;)Ljava/lang/String;", "convertParamClassToJniType", "paramClass", "convertReturnClassToJniType", "convertClassToJniType", "cls", "getJsArgCount", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Class;)I", "createJSIReturnKind", "MethodDescriptor", "ParsingException", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nTurboModuleInteropUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TurboModuleInteropUtils.kt\ncom/facebook/react/internal/turbomodule/core/TurboModuleInteropUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n1#2:295\n*E\n"})
public final class TurboModuleInteropUtils {
    @NotNull
    public static final TurboModuleInteropUtils INSTANCE = new TurboModuleInteropUtils();

    private TurboModuleInteropUtils() {
    }

    @JvmStatic
    @NotNull
    public static final List<MethodDescriptor> getMethodDescriptorsFromModule(@NotNull NativeModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Method[] methods = INSTANCE.getMethodsFromModule(module);
        List methodDescriptors = new ArrayList();
        Set methodNames = new HashSet();
        for (Method method : methods) {
            String moduleName;
            ReactMethod annotation = method.getAnnotation(ReactMethod.class);
            Intrinsics.checkNotNullExpressionValue((Object)module.getName(), (String)"getName(...)");
            String methodName = method.getName();
            if (annotation == null && !Intrinsics.areEqual((Object)"getConstants", (Object)methodName)) continue;
            if (methodNames.contains(methodName)) {
                throw new ParsingException(moduleName, "Module exports two methods to JavaScript with the same name: \"" + methodName);
            }
            Intrinsics.checkNotNull((Object)methodName);
            methodNames.add(methodName);
            Class<?>[] paramClasses = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            if (Intrinsics.areEqual((Object)"getConstants", (Object)methodName)) {
                if (!Intrinsics.areEqual(returnType, Map.class)) {
                    throw new ParsingException(moduleName, "getConstants must return a Map");
                }
            } else if (annotation != null && (annotation.isBlockingSynchronousMethod() && Intrinsics.areEqual(returnType, Void.TYPE) || !annotation.isBlockingSynchronousMethod() && !Intrinsics.areEqual(returnType, Void.TYPE))) {
                throw new ParsingException(moduleName, "TurboModule system assumes returnType == void iff the method is synchronous.");
            }
            Intrinsics.checkNotNull(paramClasses);
            Intrinsics.checkNotNull(returnType);
            methodDescriptors.add(new MethodDescriptor(methodName, INSTANCE.createJniSignature(moduleName, methodName, paramClasses, returnType), INSTANCE.createJSIReturnKind(moduleName, methodName, paramClasses, returnType), INSTANCE.getJsArgCount(moduleName, methodName, paramClasses)));
        }
        return methodDescriptors;
    }

    private final Method[] getMethodsFromModule(NativeModule module) {
        Class<?> superClass;
        Class<?> classForMethods = module.getClass();
        Class<?> clazz = classForMethods.getSuperclass();
        Class<Object> clazz2 = superClass = clazz instanceof Class ? clazz : null;
        if (superClass != null && TurboModule.class.isAssignableFrom(superClass)) {
            classForMethods = superClass;
        }
        Method[] methodArray = classForMethods.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
        return methodArray;
    }

    private final String createJniSignature(String moduleName, String methodName, Class<?>[] paramClasses, Class<?> returnClass) {
        StringBuilder jniSignature = new StringBuilder("(");
        for (Class<?> paramClass : paramClasses) {
            jniSignature.append(this.convertParamClassToJniType(moduleName, methodName, paramClass));
        }
        jniSignature.append(")");
        jniSignature.append(this.convertReturnClassToJniType(moduleName, methodName, returnClass));
        String string2 = jniSignature.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final String convertParamClassToJniType(String moduleName, String methodName, Class<?> paramClass) {
        if (Intrinsics.areEqual(paramClass, Boolean.TYPE)) {
            return "Z";
        }
        if (Intrinsics.areEqual(paramClass, Integer.TYPE)) {
            return "I";
        }
        if (Intrinsics.areEqual(paramClass, Double.TYPE)) {
            return "D";
        }
        if (Intrinsics.areEqual(paramClass, Float.TYPE)) {
            return "F";
        }
        if (Intrinsics.areEqual(paramClass, Boolean.class) || Intrinsics.areEqual(paramClass, Integer.class) || Intrinsics.areEqual(paramClass, Double.class) || Intrinsics.areEqual(paramClass, Float.class) || Intrinsics.areEqual(paramClass, String.class) || Intrinsics.areEqual(paramClass, Callback.class) || Intrinsics.areEqual(paramClass, Promise.class) || Intrinsics.areEqual(paramClass, ReadableMap.class) || Intrinsics.areEqual(paramClass, ReadableArray.class) || Intrinsics.areEqual(paramClass, Dynamic.class)) {
            return this.convertClassToJniType(paramClass);
        }
        throw new ParsingException(moduleName, methodName, "Unable to parse JNI signature. Detected unsupported parameter class: " + paramClass.getCanonicalName());
    }

    private final String convertReturnClassToJniType(String moduleName, String methodName, Class<?> returnClass) {
        if (Intrinsics.areEqual(returnClass, Boolean.TYPE)) {
            return "Z";
        }
        if (Intrinsics.areEqual(returnClass, Integer.TYPE)) {
            return "I";
        }
        if (Intrinsics.areEqual(returnClass, Double.TYPE)) {
            return "D";
        }
        if (Intrinsics.areEqual(returnClass, Float.TYPE)) {
            return "F";
        }
        if (Intrinsics.areEqual(returnClass, Void.TYPE)) {
            return "V";
        }
        if (Intrinsics.areEqual(returnClass, Boolean.class) || Intrinsics.areEqual(returnClass, Integer.class) || Intrinsics.areEqual(returnClass, Double.class) || Intrinsics.areEqual(returnClass, Float.class) || Intrinsics.areEqual(returnClass, String.class) || Intrinsics.areEqual(returnClass, WritableMap.class) || Intrinsics.areEqual(returnClass, WritableArray.class) || Intrinsics.areEqual(returnClass, Map.class)) {
            return this.convertClassToJniType(returnClass);
        }
        throw new ParsingException(moduleName, methodName, "Unable to parse JNI signature. Detected unsupported return class: " + returnClass.getCanonicalName());
    }

    private final String convertClassToJniType(Class<?> cls) {
        String canonicalName = cls.getCanonicalName();
        if (canonicalName == null) {
            boolean bl = false;
            String string2 = "Class must have a canonical name";
            throw new IllegalArgumentException(string2.toString());
        }
        return "L" + StringsKt.replace$default((String)canonicalName, (char)'.', (char)'/', (boolean)false, (int)4, null) + ";";
    }

    private final int getJsArgCount(String moduleName, String methodName, Class<?>[] paramClasses) {
        for (int i = 0; i < paramClasses.length; ++i) {
            if (!Intrinsics.areEqual(paramClasses[i], Promise.class)) continue;
            if (i != paramClasses.length - 1) {
                throw new ParsingException(moduleName, methodName, "Unable to parse JavaScript arg count. Promises must be used as last parameter only.");
            }
            return paramClasses.length - 1;
        }
        return paramClasses.length;
    }

    private final String createJSIReturnKind(String moduleName, String methodName, Class<?>[] paramClasses, Class<?> returnClass) {
        for (int i = 0; i < paramClasses.length; ++i) {
            if (!Intrinsics.areEqual(paramClasses[i], Promise.class)) continue;
            if (i != paramClasses.length - 1) {
                throw new ParsingException(moduleName, methodName, "Unable to parse JSI return kind. Promises must be used as last parameter only.");
            }
            return "PromiseKind";
        }
        if (Intrinsics.areEqual(returnClass, Boolean.TYPE) || Intrinsics.areEqual(returnClass, Boolean.class)) {
            return "BooleanKind";
        }
        if (Intrinsics.areEqual(returnClass, Double.TYPE) || Intrinsics.areEqual(returnClass, Double.class) || Intrinsics.areEqual(returnClass, Float.TYPE) || Intrinsics.areEqual(returnClass, Float.class) || Intrinsics.areEqual(returnClass, Integer.TYPE) || Intrinsics.areEqual(returnClass, Integer.class)) {
            return "NumberKind";
        }
        if (Intrinsics.areEqual(returnClass, String.class)) {
            return "StringKind";
        }
        if (Intrinsics.areEqual(returnClass, Void.TYPE)) {
            return "VoidKind";
        }
        if (Intrinsics.areEqual(returnClass, WritableMap.class) || Intrinsics.areEqual(returnClass, Map.class)) {
            return "ObjectKind";
        }
        if (Intrinsics.areEqual(returnClass, WritableArray.class)) {
            return "ArrayKind";
        }
        throw new ParsingException(moduleName, methodName, "Unable to parse JSI return kind. Detected unsupported return class: " + returnClass.getCanonicalName());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/react/internal/turbomodule/core/TurboModuleInteropUtils$MethodDescriptor;", "", "methodName", "", "jniSignature", "jsiReturnKind", "jsArgCount", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "ReactAndroid_release"})
    public static final class MethodDescriptor {
        @DoNotStrip
        @JvmField
        @NotNull
        public final String methodName;
        @DoNotStrip
        @JvmField
        @NotNull
        public final String jniSignature;
        @DoNotStrip
        @JvmField
        @NotNull
        public final String jsiReturnKind;
        @DoNotStrip
        @JvmField
        public final int jsArgCount;

        public MethodDescriptor(@NotNull String methodName, @NotNull String jniSignature, @NotNull String jsiReturnKind, int jsArgCount) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)jniSignature, (String)"jniSignature");
            Intrinsics.checkNotNullParameter((Object)jsiReturnKind, (String)"jsiReturnKind");
            this.methodName = methodName;
            this.jniSignature = jniSignature;
            this.jsiReturnKind = jsiReturnKind;
            this.jsArgCount = jsArgCount;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\t\u00a8\u0006\n"}, d2={"Lcom/facebook/react/internal/turbomodule/core/TurboModuleInteropUtils$ParsingException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "moduleName", "", "message", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "methodName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "ReactAndroid_release"})
    private static final class ParsingException
    extends RuntimeException {
        public ParsingException(@NotNull String moduleName, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super("Unable to parse @ReactMethod annotations from native module: " + moduleName + ". Details: " + message);
        }

        public ParsingException(@NotNull String moduleName, @NotNull String methodName, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super("Unable to parse @ReactMethod annotation from native module method: " + moduleName + "." + methodName + "(). Details: " + message);
        }
    }
}

