/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import android.annotation.SuppressLint;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.graphics.Point;
import android.os.SystemClock;
import android.view.View;
import androidx.annotation.AnyThread;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.core.util.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.proguard.annotations.DoNotStripAny;
import com.facebook.react.bridge.ColorPropConverter;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UIManagerListener;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.annotations.UnstableReactNativeAPI;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.common.mapbuffer.ReadableMapBuffer;
import com.facebook.react.fabric.DevToolsReactPerfLogger;
import com.facebook.react.fabric.FabricSoLoader;
import com.facebook.react.fabric.FabricUIManagerBinding;
import com.facebook.react.fabric.SurfaceHandlerBinding;
import com.facebook.react.fabric.SynchronousEvent;
import com.facebook.react.fabric.events.EventEmitterWrapper;
import com.facebook.react.fabric.events.FabricEventEmitter;
import com.facebook.react.fabric.internal.interop.InteropUIBlockListener;
import com.facebook.react.fabric.interop.UIBlock;
import com.facebook.react.fabric.interop.UIBlockViewResolver;
import com.facebook.react.fabric.mounting.LayoutMetricsConversions;
import com.facebook.react.fabric.mounting.MountItemDispatcher;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.SurfaceMountingManager;
import com.facebook.react.fabric.mounting.mountitems.BatchMountItem;
import com.facebook.react.fabric.mounting.mountitems.DispatchCommandMountItem;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.react.fabric.mounting.mountitems.MountItemFactory;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.internal.featureflags.ReactNativeNewArchitectureFeatureFlags;
import com.facebook.react.internal.interop.InteropEventEmitter;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import com.facebook.react.uimanager.GuardedFrameCallback;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactRoot;
import com.facebook.react.uimanager.ReactRootViewTagGenerator;
import com.facebook.react.uimanager.RootViewUtil;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerPropertyUpdater;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.events.BatchEventDispatchedListener;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.FabricEventDispatcher;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.SynchronousEventReceiver;
import com.facebook.react.views.text.PreparedLayout;
import com.facebook.react.views.text.ReactTextViewManagerCallback;
import com.facebook.react.views.text.TextLayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@SuppressLint(value={"MissingNativeLoadLibrary"})
@DoNotStripAny
public class FabricUIManager
implements UIManager,
LifecycleEventListener,
UIBlockViewResolver,
SynchronousEventReceiver {
    public static final String TAG = FabricUIManager.class.getSimpleName();
    public static final boolean IS_DEVELOPMENT_ENVIRONMENT = false;
    @Nullable
    public DevToolsReactPerfLogger mDevToolsReactPerfLogger;
    private static final DevToolsReactPerfLogger.DevToolsReactPerfLoggerListener FABRIC_PERF_LOGGER = commitPoint -> {
        long commitDuration = commitPoint.getCommitDuration();
        long layoutDuration = commitPoint.getLayoutDuration();
        long diffDuration = commitPoint.getDiffDuration();
        long transactionEndDuration = commitPoint.getTransactionEndDuration();
        long batchExecutionDuration = commitPoint.getBatchExecutionDuration();
        DevToolsReactPerfLogger.streamingCommitStats.add(commitDuration);
        DevToolsReactPerfLogger.streamingLayoutStats.add(layoutDuration);
        DevToolsReactPerfLogger.streamingDiffStats.add(diffDuration);
        DevToolsReactPerfLogger.streamingTransactionEndStats.add(transactionEndDuration);
        DevToolsReactPerfLogger.streamingBatchExecutionStats.add(batchExecutionDuration);
        FLog.i((String)TAG, (String)"Statistics of Fabric commit #%d:\n - Total commit time: %d ms. Avg: %.2f. Median: %.2f ms. Max: %d ms.\n - Layout time: %d ms. Avg: %.2f. Median: %.2f ms. Max: %d ms.\n - Diffing time: %d ms. Avg: %.2f. Median: %.2f ms. Max: %d ms.\n - FinishTransaction (Diffing + JNI serialization): %d ms. Avg: %.2f. Median: %.2f ms. Max: %d ms.\n - Mounting: %d ms. Avg: %.2f. Median: %.2f ms. Max: %d ms.\n", (Object[])new Object[]{commitPoint.getCommitNumber(), commitDuration, DevToolsReactPerfLogger.streamingCommitStats.getAverage(), DevToolsReactPerfLogger.streamingCommitStats.getMedian(), DevToolsReactPerfLogger.streamingCommitStats.getMax(), layoutDuration, DevToolsReactPerfLogger.streamingLayoutStats.getAverage(), DevToolsReactPerfLogger.streamingLayoutStats.getMedian(), DevToolsReactPerfLogger.streamingLayoutStats.getMax(), diffDuration, DevToolsReactPerfLogger.streamingDiffStats.getAverage(), DevToolsReactPerfLogger.streamingDiffStats.getMedian(), DevToolsReactPerfLogger.streamingDiffStats.getMax(), transactionEndDuration, DevToolsReactPerfLogger.streamingTransactionEndStats.getAverage(), DevToolsReactPerfLogger.streamingTransactionEndStats.getMedian(), DevToolsReactPerfLogger.streamingTransactionEndStats.getMax(), batchExecutionDuration, DevToolsReactPerfLogger.streamingBatchExecutionStats.getAverage(), DevToolsReactPerfLogger.streamingBatchExecutionStats.getMedian(), DevToolsReactPerfLogger.streamingBatchExecutionStats.getMax()});
    };
    @Nullable
    private FabricUIManagerBinding mBinding;
    private final ReactApplicationContext mReactApplicationContext;
    private final MountingManager mMountingManager;
    private final FabricEventDispatcher mEventDispatcher;
    private final MountItemDispatcher mMountItemDispatcher;
    private final ViewManagerRegistry mViewManagerRegistry;
    private final BatchEventDispatchedListener mBatchEventDispatchedListener;
    private final CopyOnWriteArrayList<UIManagerListener> mListeners = new CopyOnWriteArrayList();
    private boolean mMountNotificationScheduled = false;
    private List<Integer> mSurfaceIdsWithPendingMountNotification = new ArrayList<Integer>();
    @ThreadConfined(value="UI")
    private final DispatchUIFrameCallback mDispatchUIFrameCallback;
    @ThreadConfined(value="UI")
    private final Set<SynchronousEvent> mSynchronousEvents = new HashSet<SynchronousEvent>();
    private volatile boolean mDestroyed = false;
    private boolean mDriveCxxAnimations = false;
    private boolean mDriveCxxNativeAnimated = ReactNativeFeatureFlags.cxxNativeAnimatedEnabled();
    private long mDispatchViewUpdatesTime = 0L;
    private long mCommitStartTime = 0L;
    private long mLayoutTime = 0L;
    private long mFinishTransactionTime = 0L;
    private long mFinishTransactionCPPTime = 0L;
    private int mCurrentSynchronousCommitNumber = 10000;
    private final MountingManager.MountItemExecutor mMountItemExecutor = new MountingManager.MountItemExecutor(){

        @Override
        public void executeItems(Queue<MountItem> items) {
            FabricUIManager.this.mMountItemDispatcher.dispatchMountItems(items);
        }
    };
    @Nullable
    private InteropUIBlockListener mInteropUIBlockListener;

    public FabricUIManager(ReactApplicationContext reactContext, ViewManagerRegistry viewManagerRegistry2, BatchEventDispatchedListener batchEventDispatchedListener) {
        this.mDispatchUIFrameCallback = new DispatchUIFrameCallback(reactContext);
        this.mReactApplicationContext = reactContext;
        this.mMountingManager = new MountingManager(viewManagerRegistry2, this.mMountItemExecutor);
        this.mMountItemDispatcher = new MountItemDispatcher(this.mMountingManager, new MountItemDispatchListener());
        this.mEventDispatcher = new FabricEventDispatcher(reactContext, new FabricEventEmitter(this));
        this.mBatchEventDispatchedListener = batchEventDispatchedListener;
        this.mReactApplicationContext.addLifecycleEventListener(this);
        this.mViewManagerRegistry = viewManagerRegistry2;
        this.mReactApplicationContext.registerComponentCallbacks((ComponentCallbacks)viewManagerRegistry2);
    }

    @Override
    @Deprecated
    @UiThread
    @ThreadConfined(value="UI")
    public <T extends View> int addRootView(T rootView, @Nullable WritableMap initialProps) {
        ReactSoftExceptionLogger.logSoftException(TAG, new IllegalViewOperationException("Do not call addRootView in Fabric; it is unsupported. Call startSurface instead."));
        ReactRoot reactRootView = (ReactRoot)rootView;
        int rootTag = reactRootView.getRootViewTag();
        ThemedReactContext reactContext = new ThemedReactContext(this.mReactApplicationContext, rootView.getContext(), reactRootView.getSurfaceID(), rootTag);
        this.mMountingManager.startSurface(rootTag, reactContext, rootView);
        String moduleName = reactRootView.getJSModuleName();
        if (ReactNativeFeatureFlags.enableFabricLogs()) {
            FLog.d((String)TAG, (String)"Starting surface for module: %s and reactTag: %d", (Object)moduleName, (Object)rootTag);
        }
        Assertions.assertNotNull((Object)((Object)this.mBinding), (String)"Binding in FabricUIManager is null");
        this.mBinding.startSurface(rootTag, moduleName, (NativeMap)((Object)initialProps));
        return rootTag;
    }

    @Nullable
    public Integer findNextFocusableElement(int parentTag, int focusedTag, int direction) {
        int generalizedDirection;
        if (this.mBinding == null) {
            return null;
        }
        switch (direction) {
            case 130: {
                generalizedDirection = 0;
                break;
            }
            case 33: {
                generalizedDirection = 1;
                break;
            }
            case 66: {
                generalizedDirection = 2;
                break;
            }
            case 17: {
                generalizedDirection = 3;
                break;
            }
            case 2: {
                generalizedDirection = 4;
                break;
            }
            case 1: {
                generalizedDirection = 5;
                break;
            }
            default: {
                return null;
            }
        }
        int serializedNextFocusableNodeMetrics = this.mBinding.findNextFocusableElement(parentTag, focusedTag, generalizedDirection);
        if (serializedNextFocusableNodeMetrics == -1) {
            return null;
        }
        return serializedNextFocusableNodeMetrics;
    }

    @Nullable
    public int[] getRelativeAncestorList(int rootTag, int childTag) {
        return this.mBinding != null ? this.mBinding.getRelativeAncestorList(rootTag, childTag) : null;
    }

    @Override
    @AnyThread
    @ThreadConfined(value="ANY")
    public <T extends View> int startSurface(T rootView, String moduleName, @Nullable WritableMap initialProps, int widthMeasureSpec, int heightMeasureSpec) {
        int rootTag = ((ReactRoot)rootView).getRootViewTag();
        Context context = rootView.getContext();
        ThemedReactContext reactContext = new ThemedReactContext(this.mReactApplicationContext, context, moduleName, rootTag);
        if (ReactNativeFeatureFlags.enableFabricLogs()) {
            FLog.d((String)TAG, (String)"Starting surface for module: %s and reactTag: %d", (Object)moduleName, (Object)rootTag);
        }
        this.mMountingManager.startSurface(rootTag, reactContext, rootView);
        Point viewportOffset = UiThreadUtil.isOnUiThread() ? RootViewUtil.getViewportOffset(rootView) : new Point(0, 0);
        Assertions.assertNotNull((Object)((Object)this.mBinding), (String)"Binding in FabricUIManager is null");
        this.mBinding.startSurfaceWithConstraints(rootTag, moduleName, (NativeMap)((Object)initialProps), LayoutMetricsConversions.getMinSize(widthMeasureSpec), LayoutMetricsConversions.getMaxSize(widthMeasureSpec), LayoutMetricsConversions.getMinSize(heightMeasureSpec), LayoutMetricsConversions.getMaxSize(heightMeasureSpec), viewportOffset.x, viewportOffset.y, I18nUtil.getInstance().isRTL(context), I18nUtil.getInstance().doLeftAndRightSwapInRTL(context));
        return rootTag;
    }

    public void startSurface(SurfaceHandlerBinding surfaceHandler, Context context, @Nullable View rootView) {
        int rootTag = rootView instanceof ReactRoot ? ((ReactRoot)rootView).getRootViewTag() : ReactRootViewTagGenerator.getNextRootViewTag();
        ThemedReactContext reactContext = new ThemedReactContext(this.mReactApplicationContext, context, surfaceHandler.getModuleName(), rootTag);
        this.mMountingManager.startSurface(rootTag, reactContext, rootView);
        Assertions.assertNotNull((Object)((Object)this.mBinding), (String)"Binding in FabricUIManager is null");
        this.mBinding.startSurfaceWithSurfaceHandler(rootTag, surfaceHandler, rootView != null);
    }

    public void attachRootView(SurfaceHandlerBinding surfaceHandler, View rootView) {
        ThemedReactContext reactContext = new ThemedReactContext(this.mReactApplicationContext, rootView.getContext(), surfaceHandler.getModuleName(), surfaceHandler.getSurfaceId());
        this.mMountingManager.attachRootView(surfaceHandler.getSurfaceId(), rootView, reactContext);
        surfaceHandler.setMountable(true);
    }

    public void stopSurface(SurfaceHandlerBinding surfaceHandler) {
        if (!surfaceHandler.isRunning()) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Trying to stop surface that hasn't started yet"));
            return;
        }
        this.mMountingManager.stopSurface(surfaceHandler.getSurfaceId());
        Assertions.assertNotNull((Object)((Object)this.mBinding), (String)"Binding in FabricUIManager is null");
        this.mBinding.stopSurfaceWithSurfaceHandler(surfaceHandler);
    }

    public void onRequestEventBeat() {
        this.mEventDispatcher.dispatchAllEvents();
    }

    @Override
    @AnyThread
    @ThreadConfined(value="ANY")
    public void stopSurface(int surfaceID) {
        this.mMountingManager.stopSurface(surfaceID);
        Assertions.assertNotNull((Object)((Object)this.mBinding), (String)"Binding in FabricUIManager is null");
        this.mBinding.stopSurface(surfaceID);
    }

    @Override
    public void initialize() {
        this.mEventDispatcher.addBatchEventDispatchedListener(this.mBatchEventDispatchedListener);
        if (ReactNativeFeatureFlags.enableFabricLogs()) {
            this.mDevToolsReactPerfLogger = new DevToolsReactPerfLogger();
            this.mDevToolsReactPerfLogger.addDevToolsReactPerfLoggerListener(FABRIC_PERF_LOGGER);
            ReactMarker.addFabricListener(this.mDevToolsReactPerfLogger);
        }
        if (ReactNativeNewArchitectureFeatureFlags.useFabricInterop()) {
            InteropEventEmitter interopEventEmitter = new InteropEventEmitter(this.mReactApplicationContext);
            this.mReactApplicationContext.internal_registerInteropModule(RCTEventEmitter.class, interopEventEmitter);
        }
    }

    @Override
    @AnyThread
    @ThreadConfined(value="ANY")
    public void invalidate() {
        FLog.i((String)TAG, (String)"FabricUIManager.invalidate");
        if (this.mDevToolsReactPerfLogger != null) {
            this.mDevToolsReactPerfLogger.removeDevToolsReactPerfLoggerListener(FABRIC_PERF_LOGGER);
            ReactMarker.removeFabricListener(this.mDevToolsReactPerfLogger);
        }
        if (this.mDestroyed) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Cannot double-destroy FabricUIManager"));
            return;
        }
        this.mDestroyed = true;
        this.mEventDispatcher.removeBatchEventDispatchedListener(this.mBatchEventDispatchedListener);
        this.mEventDispatcher.invalidate();
        this.mReactApplicationContext.unregisterComponentCallbacks((ComponentCallbacks)this.mViewManagerRegistry);
        this.mViewManagerRegistry.invalidate();
        this.mReactApplicationContext.removeLifecycleEventListener(this);
        this.onHostPause();
        if (this.mBinding != null) {
            this.mBinding.unregister();
        }
        this.mBinding = null;
        ViewManagerPropertyUpdater.clear();
    }

    @Override
    public void markActiveTouchForTag(int surfaceId, int reactTag) {
        SurfaceMountingManager surfaceMountingManager = this.mMountingManager.getSurfaceManager(surfaceId);
        if (surfaceMountingManager != null) {
            surfaceMountingManager.markActiveTouchForTag(reactTag);
        }
    }

    @Override
    public void sweepActiveTouchForTag(int surfaceId, int reactTag) {
        SurfaceMountingManager surfaceMountingManager = this.mMountingManager.getSurfaceManager(surfaceId);
        if (surfaceMountingManager != null) {
            surfaceMountingManager.sweepActiveTouchForTag(reactTag);
        }
    }

    public void addUIBlock(UIBlock block) {
        if (ReactNativeNewArchitectureFeatureFlags.useFabricInterop()) {
            InteropUIBlockListener listener = this.getInteropUIBlockListener();
            listener.addUIBlock(block);
        }
    }

    public void prependUIBlock(UIBlock block) {
        if (ReactNativeNewArchitectureFeatureFlags.useFabricInterop()) {
            InteropUIBlockListener listener = this.getInteropUIBlockListener();
            listener.prependUIBlock(block);
        }
    }

    private InteropUIBlockListener getInteropUIBlockListener() {
        if (this.mInteropUIBlockListener == null) {
            this.mInteropUIBlockListener = new InteropUIBlockListener();
            this.addUIManagerEventListener(this.mInteropUIBlockListener);
        }
        return this.mInteropUIBlockListener;
    }

    private NativeArray measureLines(ReadableMapBuffer attributedString, ReadableMapBuffer paragraphAttributes, float width, float height) {
        ViewManager<?, ?> textViewManager = this.mViewManagerRegistry.get("RCTText");
        return (NativeArray)((Object)TextLayoutManager.measureLines((Context)this.mReactApplicationContext, attributedString, paragraphAttributes, PixelUtil.toPixelFromDIP(width), PixelUtil.toPixelFromDIP(height), textViewManager instanceof ReactTextViewManagerCallback ? (ReactTextViewManagerCallback)((Object)textViewManager) : null));
    }

    public int getColor(int surfaceId, String[] resourcePaths) {
        ThemedReactContext context = this.mMountingManager.getSurfaceManagerEnforced(surfaceId, "getColor").getContext();
        if (context == null) {
            return 0;
        }
        for (String resourcePath : resourcePaths) {
            Integer color = ColorPropConverter.resolveResourcePath((Context)context, resourcePath);
            if (color == null) continue;
            return color;
        }
        return 0;
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    public long measure(int surfaceId, String componentName, ReadableMap localData, ReadableMap props, ReadableMap state, float minWidth, float maxWidth, float minHeight, float maxHeight) {
        ReactContext context;
        if (surfaceId > 0) {
            SurfaceMountingManager surfaceMountingManager = this.mMountingManager.getSurfaceManagerEnforced(surfaceId, "measure");
            if (surfaceMountingManager.isStopped()) {
                return 0L;
            }
            context = surfaceMountingManager.getContext();
            Assertions.assertNotNull((Object)((Object)context), (String)("Context in SurfaceMountingManager is null. surfaceId: " + surfaceId));
        } else {
            context = this.mReactApplicationContext;
        }
        return this.mMountingManager.measure(context, componentName, localData, props, state, LayoutMetricsConversions.getYogaSize(minWidth, maxWidth), LayoutMetricsConversions.getYogaMeasureMode(minWidth, maxWidth), LayoutMetricsConversions.getYogaSize(minHeight, maxHeight), LayoutMetricsConversions.getYogaMeasureMode(minHeight, maxHeight), null);
    }

    @UnstableReactNativeAPI
    @AnyThread
    @ThreadConfined(value="ANY")
    public long measureText(int surfaceId, ReadableMapBuffer attributedString, ReadableMapBuffer paragraphAttributes, float minWidth, float maxWidth, float minHeight, float maxHeight, @Nullable float[] attachmentsPositions) {
        ReactContext context;
        if (surfaceId > 0) {
            SurfaceMountingManager surfaceMountingManager = this.mMountingManager.getSurfaceManagerEnforced(surfaceId, "measureText");
            if (surfaceMountingManager.isStopped()) {
                return 0L;
            }
            context = surfaceMountingManager.getContext();
            Assertions.assertNotNull((Object)((Object)context), (String)("Context in SurfaceMountingManager is null. surfaceId: " + surfaceId));
        } else {
            context = this.mReactApplicationContext;
        }
        ViewManager<?, ?> textViewManager = this.mViewManagerRegistry.get("RCTText");
        return TextLayoutManager.measureText((Context)context, attributedString, paragraphAttributes, LayoutMetricsConversions.getYogaSize(minWidth, maxWidth), LayoutMetricsConversions.getYogaMeasureMode(minWidth, maxWidth), LayoutMetricsConversions.getYogaSize(minHeight, maxHeight), LayoutMetricsConversions.getYogaMeasureMode(minHeight, maxHeight), textViewManager instanceof ReactTextViewManagerCallback ? (ReactTextViewManagerCallback)((Object)textViewManager) : null, attachmentsPositions);
    }

    @UnstableReactNativeAPI
    @AnyThread
    @ThreadConfined(value="ANY")
    public PreparedLayout prepareTextLayout(int surfaceId, ReadableMapBuffer attributedString, ReadableMapBuffer paragraphAttributes, float minWidth, float maxWidth, float minHeight, float maxHeight) {
        SurfaceMountingManager surfaceMountingManager = this.mMountingManager.getSurfaceManagerEnforced(surfaceId, "prepareTextLayout");
        ViewManager<?, ?> textViewManager = this.mViewManagerRegistry.get("RCTText");
        return TextLayoutManager.createPreparedLayout((Context)Preconditions.checkNotNull((Object)((Object)surfaceMountingManager.getContext())), attributedString, paragraphAttributes, LayoutMetricsConversions.getYogaSize(minWidth, maxWidth), LayoutMetricsConversions.getYogaMeasureMode(minWidth, maxWidth), LayoutMetricsConversions.getYogaSize(minHeight, maxHeight), LayoutMetricsConversions.getYogaMeasureMode(minHeight, maxHeight), textViewManager instanceof ReactTextViewManagerCallback ? (ReactTextViewManagerCallback)((Object)textViewManager) : null);
    }

    @UnstableReactNativeAPI
    @AnyThread
    @ThreadConfined(value="ANY")
    public float[] measurePreparedLayout(PreparedLayout preparedLayout, float minWidth, float maxWidth, float minHeight, float maxHeight) {
        return TextLayoutManager.measurePreparedLayout(preparedLayout, LayoutMetricsConversions.getYogaSize(minWidth, maxWidth), LayoutMetricsConversions.getYogaMeasureMode(minWidth, maxWidth), LayoutMetricsConversions.getYogaSize(minHeight, maxHeight), LayoutMetricsConversions.getYogaMeasureMode(minHeight, maxHeight));
    }

    public boolean getThemeData(int surfaceId, float[] defaultTextInputPadding) {
        ThemedReactContext context;
        SurfaceMountingManager surfaceMountingManager = this.mMountingManager.getSurfaceManager(surfaceId);
        ThemedReactContext themedReactContext = context = surfaceMountingManager != null ? surfaceMountingManager.getContext() : null;
        if (context == null) {
            FLog.w((String)TAG, (String)"Couldn't get context for surfaceId %d in getThemeData", (Object[])new Object[]{surfaceId});
            return false;
        }
        float[] defaultTextInputPaddingForTheme = UIManagerHelper.getDefaultTextInputPadding((Context)context);
        defaultTextInputPadding[0] = defaultTextInputPaddingForTheme[0];
        defaultTextInputPadding[1] = defaultTextInputPaddingForTheme[1];
        defaultTextInputPadding[2] = defaultTextInputPaddingForTheme[2];
        defaultTextInputPadding[3] = defaultTextInputPaddingForTheme[3];
        return true;
    }

    @Override
    public void addUIManagerEventListener(UIManagerListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void removeUIManagerEventListener(UIManagerListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    @UiThread
    @ThreadConfined(value="UI")
    public void synchronouslyUpdateViewOnUIThread(final int reactTag, final ReadableMap props) {
        UiThreadUtil.assertOnUiThread();
        int commitNumber = this.mCurrentSynchronousCommitNumber++;
        MountItem synchronousMountItem = new MountItem(){

            @Override
            public void execute(MountingManager mountingManager) {
                try {
                    mountingManager.updateProps(reactTag, props);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public int getSurfaceId() {
                return -1;
            }

            public String toString() {
                String propsString = IS_DEVELOPMENT_ENVIRONMENT ? props.toHashMap().toString() : "<hidden>";
                return String.format("SYNC UPDATE PROPS [%d]: %s", reactTag, propsString);
            }
        };
        if (!this.mMountingManager.getViewExists(reactTag)) {
            this.mMountItemDispatcher.addMountItem(synchronousMountItem);
            return;
        }
        ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_START, null, commitNumber);
        if (ReactNativeFeatureFlags.enableFabricLogs()) {
            FLog.d((String)TAG, (String)"SynchronouslyUpdateViewOnUIThread for tag %d: %s", (Object)reactTag, (Object)(IS_DEVELOPMENT_ENVIRONMENT ? props.toHashMap().toString() : "<hidden>"));
        }
        synchronousMountItem.execute(this.mMountingManager);
        ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_END, null, commitNumber);
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    private void preallocateView(int rootTag, int reactTag, String componentName, @Nullable Object props, @Nullable Object stateWrapper, boolean isLayoutable) {
        this.mMountItemDispatcher.addPreAllocateMountItem(MountItemFactory.createPreAllocateViewMountItem(rootTag, reactTag, componentName, (ReadableMap)props, (StateWrapper)stateWrapper, isLayoutable));
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    private void destroyUnmountedView(int surfaceId, int reactTag) {
        this.mMountItemDispatcher.addMountItem(MountItemFactory.createDestroyViewMountItem(surfaceId, reactTag));
    }

    @SuppressLint(value={"NotInvokedPrivateMethod"})
    @AnyThread
    @ThreadConfined(value="ANY")
    private boolean isOnMainThread() {
        return UiThreadUtil.isOnUiThread();
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    private MountItem createIntBufferBatchMountItem(int rootTag, @Nullable int[] intBuffer, @Nullable Object[] objBuffer, int commitNumber) {
        return MountItemFactory.createIntBufferBatchMountItem(rootTag, intBuffer == null ? new int[]{} : intBuffer, objBuffer == null ? new Object[]{} : objBuffer, commitNumber);
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    private void scheduleMountItem(@Nullable MountItem mountItem, int commitNumber, long commitStartTime, long diffStartTime, long diffEndTime, long layoutStartTime, long layoutEndTime, long finishTransactionStartTime, long finishTransactionEndTime, int affectedLayoutNodesCount) {
        long scheduleMountItemStartTime = SystemClock.uptimeMillis();
        boolean isBatchMountItem = mountItem instanceof BatchMountItem;
        boolean shouldSchedule = false;
        if (isBatchMountItem) {
            BatchMountItem batchMountItem = (BatchMountItem)mountItem;
            Assertions.assertNotNull((Object)batchMountItem, (String)"BatchMountItem is null");
            shouldSchedule = !batchMountItem.isBatchEmpty();
        } else {
            shouldSchedule = mountItem != null;
        }
        for (UIManagerListener listener : this.mListeners) {
            listener.didScheduleMountItems(this);
        }
        if (isBatchMountItem) {
            this.mCommitStartTime = commitStartTime;
            this.mLayoutTime = layoutEndTime - layoutStartTime;
            this.mFinishTransactionCPPTime = finishTransactionEndTime - finishTransactionStartTime;
            this.mFinishTransactionTime = scheduleMountItemStartTime - finishTransactionStartTime;
            this.mDispatchViewUpdatesTime = SystemClock.uptimeMillis();
        }
        if (shouldSchedule) {
            Assertions.assertNotNull((Object)mountItem, (String)"MountItem is null");
            this.mMountItemDispatcher.addMountItem(mountItem);
            GuardedRunnable runnable = new GuardedRunnable(this.mReactApplicationContext){

                @Override
                public void runGuarded() {
                    FabricUIManager.this.mMountItemDispatcher.tryDispatchMountItems();
                }
            };
            if (UiThreadUtil.isOnUiThread()) {
                runnable.run();
            }
        }
        if (isBatchMountItem) {
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_COMMIT_START, null, commitNumber, commitStartTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_START, null, commitNumber, finishTransactionStartTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_END, null, commitNumber, finishTransactionEndTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_DIFF_START, null, commitNumber, diffStartTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_DIFF_END, null, commitNumber, diffEndTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_LAYOUT_START, null, commitNumber, layoutStartTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_LAYOUT_END, null, commitNumber, layoutEndTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_LAYOUT_AFFECTED_NODES, null, commitNumber, layoutEndTime, affectedLayoutNodesCount);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_COMMIT_END, null, commitNumber);
        }
    }

    @UnstableReactNativeAPI
    public void experimental_prefetchResource(String componentName, int surfaceId, int reactTag, ReadableMapBuffer params) {
        this.mMountingManager.experimental_prefetchResource(this.mReactApplicationContext, componentName, surfaceId, reactTag, params);
    }

    void setBinding(FabricUIManagerBinding binding) {
        this.mBinding = binding;
    }

    @Override
    @UiThread
    @ThreadConfined(value="UI")
    public void updateRootLayoutSpecs(int surfaceId, int widthMeasureSpec, int heightMeasureSpec, int offsetX, int offsetY) {
        SurfaceMountingManager surfaceMountingManager;
        if (ReactNativeFeatureFlags.enableFabricLogs()) {
            FLog.d((String)TAG, (String)"Updating Root Layout Specs for [%d]", (Object)surfaceId);
        }
        if ((surfaceMountingManager = this.mMountingManager.getSurfaceManager(surfaceId)) == null) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalViewOperationException("Cannot updateRootLayoutSpecs on surfaceId that does not exist: " + surfaceId));
            return;
        }
        ThemedReactContext context = surfaceMountingManager.getContext();
        boolean isRTL = false;
        boolean doLeftAndRightSwapInRTL = false;
        if (context != null) {
            isRTL = I18nUtil.getInstance().isRTL((Context)context);
            doLeftAndRightSwapInRTL = I18nUtil.getInstance().doLeftAndRightSwapInRTL((Context)context);
        }
        Assertions.assertNotNull((Object)((Object)this.mBinding), (String)"Binding in FabricUIManager is null");
        this.mBinding.setConstraints(surfaceId, LayoutMetricsConversions.getMinSize(widthMeasureSpec), LayoutMetricsConversions.getMaxSize(widthMeasureSpec), LayoutMetricsConversions.getMinSize(heightMeasureSpec), LayoutMetricsConversions.getMaxSize(heightMeasureSpec), offsetX, offsetY, isRTL, doLeftAndRightSwapInRTL);
    }

    @Override
    @Nullable
    public View resolveView(int reactTag) {
        UiThreadUtil.assertOnUiThread();
        SurfaceMountingManager surfaceManager = this.mMountingManager.getSurfaceManagerForView(reactTag);
        return surfaceManager == null ? null : surfaceManager.getView(reactTag);
    }

    @Override
    public void receiveEvent(int reactTag, String eventName, @Nullable WritableMap params) {
        this.receiveEvent(-1, reactTag, eventName, false, params, 2);
    }

    @Override
    public void receiveEvent(int surfaceId, int reactTag, String eventName, @Nullable WritableMap params) {
        this.receiveEvent(surfaceId, reactTag, eventName, false, params, 2);
    }

    public void receiveEvent(int surfaceId, int reactTag, String eventName, boolean canCoalesceEvent, @Nullable WritableMap params, int eventCategory) {
        this.receiveEvent(surfaceId, reactTag, eventName, canCoalesceEvent, params, eventCategory, false);
    }

    @Override
    public void receiveEvent(int surfaceId, int reactTag, String eventName, boolean canCoalesceEvent, @Nullable WritableMap params, int eventCategory, boolean experimentalIsSynchronous) {
        if (ReactBuildConfig.DEBUG && surfaceId == -1) {
            FLog.d((String)TAG, (String)"Emitted event without surfaceId: [%d] %s", (Object)reactTag, (Object)eventName);
        }
        if (this.mDestroyed) {
            FLog.e((String)TAG, (String)"Attempted to receiveEvent after destruction");
            return;
        }
        EventEmitterWrapper eventEmitter = this.mMountingManager.getEventEmitter(surfaceId, reactTag);
        if (eventEmitter == null) {
            if (this.mMountingManager.getViewExists(reactTag)) {
                this.mMountingManager.enqueuePendingEvent(surfaceId, reactTag, eventName, canCoalesceEvent, params, eventCategory);
            } else {
                FLog.i((String)TAG, (String)("Unable to invoke event: " + eventName + " for reactTag: " + reactTag));
            }
            return;
        }
        if (experimentalIsSynchronous) {
            UiThreadUtil.assertOnUiThread();
            boolean firstEventForFrame = this.mSynchronousEvents.add(new SynchronousEvent(surfaceId, reactTag, eventName));
            if (firstEventForFrame) {
                eventEmitter.dispatchEventSynchronously(eventName, params);
            }
        } else if (canCoalesceEvent) {
            eventEmitter.dispatchUnique(eventName, params);
        } else {
            eventEmitter.dispatch(eventName, params, eventCategory);
        }
    }

    @Override
    public void onHostResume() {
        this.mDispatchUIFrameCallback.resume();
    }

    @Override
    public EventDispatcher getEventDispatcher() {
        return this.mEventDispatcher;
    }

    @Override
    public void onHostPause() {
        this.mDispatchUIFrameCallback.pause();
    }

    @Override
    public void onHostDestroy() {
    }

    @Override
    @Deprecated
    @AnyThread
    @ThreadConfined(value="ANY")
    public void dispatchCommand(int reactTag, int commandId, @Nullable ReadableArray commandArgs) {
        throw new UnsupportedOperationException("dispatchCommand called without surfaceId - Fabric dispatchCommand must be called through Fabric JSI API");
    }

    @Override
    @Deprecated
    @AnyThread
    @ThreadConfined(value="ANY")
    public void dispatchCommand(int reactTag, String commandId, @Nullable ReadableArray commandArgs) {
        throw new UnsupportedOperationException("dispatchCommand called without surfaceId - Fabric dispatchCommand must be called through Fabric JSI API");
    }

    @Deprecated
    @AnyThread
    @ThreadConfined(value="ANY")
    public void dispatchCommand(int surfaceId, int reactTag, int commandId, @Nullable ReadableArray commandArgs) {
        this.mMountItemDispatcher.addViewCommandMountItem(MountItemFactory.createDispatchCommandMountItem(surfaceId, reactTag, commandId, commandArgs));
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    public void dispatchCommand(int surfaceId, int reactTag, String commandId, @Nullable ReadableArray commandArgs) {
        if (ReactNativeNewArchitectureFeatureFlags.useFabricInterop()) {
            this.mMountItemDispatcher.addViewCommandMountItem(this.createDispatchCommandMountItemForInterop(surfaceId, reactTag, commandId, commandArgs));
        } else {
            this.mMountItemDispatcher.addViewCommandMountItem(MountItemFactory.createDispatchCommandMountItem(surfaceId, reactTag, commandId, commandArgs));
        }
    }

    @Override
    @AnyThread
    @ThreadConfined(value="ANY")
    public void sendAccessibilityEvent(int reactTag, int eventType) {
        this.mMountItemDispatcher.addMountItem(MountItemFactory.createSendAccessibilityEventMountItem(-1, reactTag, eventType));
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    public void sendAccessibilityEventFromJS(int surfaceId, int reactTag, String eventTypeJS) {
        int eventType;
        if ("focus".equals(eventTypeJS)) {
            eventType = 8;
        } else if ("windowStateChange".equals(eventTypeJS)) {
            eventType = 32;
        } else if ("click".equals(eventTypeJS)) {
            eventType = 1;
        } else if ("viewHoverEnter".equals(eventTypeJS)) {
            eventType = 128;
        } else {
            throw new IllegalArgumentException("sendAccessibilityEventFromJS: invalid eventType " + eventTypeJS);
        }
        this.mMountItemDispatcher.addMountItem(MountItemFactory.createSendAccessibilityEventMountItem(surfaceId, reactTag, eventType));
    }

    public void setJSResponder(final int surfaceId, final int reactTag, final int initialReactTag, final boolean blockNativeResponder) {
        this.mMountItemDispatcher.addMountItem(new MountItem(){

            @Override
            public void execute(MountingManager mountingManager) {
                SurfaceMountingManager surfaceMountingManager = mountingManager.getSurfaceManager(surfaceId);
                if (surfaceMountingManager != null) {
                    surfaceMountingManager.setJSResponder(reactTag, initialReactTag, blockNativeResponder);
                } else {
                    FLog.e((String)TAG, (String)("setJSResponder skipped, surface no longer available [" + surfaceId + "]"));
                }
            }

            @Override
            public int getSurfaceId() {
                return surfaceId;
            }

            @SuppressLint(value={"DefaultLocale"})
            public String toString() {
                return String.format("SET_JS_RESPONDER [%d] [surface:%d]", reactTag, surfaceId);
            }
        });
    }

    public void clearJSResponder() {
        this.mMountItemDispatcher.addMountItem(new MountItem(){

            @Override
            public void execute(MountingManager mountingManager) {
                mountingManager.clearJSResponder();
            }

            @Override
            public int getSurfaceId() {
                return -1;
            }

            public String toString() {
                return "CLEAR_JS_RESPONDER";
            }
        });
    }

    @Override
    public void profileNextBatch() {
    }

    @Override
    @Deprecated
    @Nullable
    public String resolveCustomDirectEventName(@Nullable String eventName) {
        if (eventName == null) {
            return null;
        }
        if (eventName.startsWith("top")) {
            return "on" + eventName.substring(3);
        }
        return eventName;
    }

    @AnyThread
    public void onAnimationStarted() {
        this.mDriveCxxAnimations = true;
    }

    @AnyThread
    public void onAllAnimationsComplete() {
        this.mDriveCxxAnimations = false;
    }

    @Override
    public Map<String, Long> getPerformanceCounters() {
        HashMap<String, Long> performanceCounters = new HashMap<String, Long>();
        performanceCounters.put("CommitStartTime", this.mCommitStartTime);
        performanceCounters.put("LayoutTime", this.mLayoutTime);
        performanceCounters.put("DispatchViewUpdatesTime", this.mDispatchViewUpdatesTime);
        performanceCounters.put("RunStartTime", this.mMountItemDispatcher.getRunStartTime());
        performanceCounters.put("BatchedExecutionTime", this.mMountItemDispatcher.getBatchedExecutionTime());
        performanceCounters.put("FinishFabricTransactionTime", this.mFinishTransactionTime);
        performanceCounters.put("FinishFabricTransactionCPPTime", this.mFinishTransactionCPPTime);
        return performanceCounters;
    }

    DispatchCommandMountItem createDispatchCommandMountItemForInterop(int surfaceId, int reactTag, String commandId, @Nullable ReadableArray commandArgs) {
        try {
            int commandIdInteger = Integer.parseInt(commandId);
            return MountItemFactory.createDispatchCommandMountItem(surfaceId, reactTag, commandIdInteger, commandArgs);
        }
        catch (NumberFormatException e) {
            return MountItemFactory.createDispatchCommandMountItem(surfaceId, reactTag, commandId, commandArgs);
        }
    }

    static {
        FabricSoLoader.staticInit();
    }

    private class DispatchUIFrameCallback
    extends GuardedFrameCallback {
        private volatile boolean mIsMountingEnabled;
        @ThreadConfined(value="UI")
        private boolean mShouldSchedule;
        @ThreadConfined(value="UI")
        private boolean mIsScheduled;

        private DispatchUIFrameCallback(ReactContext reactContext) {
            super(reactContext);
            this.mIsMountingEnabled = true;
            this.mShouldSchedule = false;
            this.mIsScheduled = false;
        }

        @UiThread
        @ThreadConfined(value="UI")
        private void schedule() {
            if (!this.mIsScheduled && this.mShouldSchedule) {
                this.mIsScheduled = true;
                ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this);
            }
        }

        @UiThread
        @ThreadConfined(value="UI")
        void resume() {
            this.mShouldSchedule = true;
            this.schedule();
        }

        @UiThread
        @ThreadConfined(value="UI")
        void pause() {
            ReactChoreographer.getInstance().removeFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this);
            this.mShouldSchedule = false;
            this.mIsScheduled = false;
        }

        @Override
        @UiThread
        @ThreadConfined(value="UI")
        public void doFrameGuarded(long frameTimeNanos) {
            this.mIsScheduled = false;
            if (!this.mIsMountingEnabled) {
                FLog.w((String)TAG, (String)"Not flushing pending UI operations: exception was previously thrown");
                return;
            }
            if (FabricUIManager.this.mDestroyed) {
                FLog.w((String)TAG, (String)"Not flushing pending UI operations: FabricUIManager is destroyed");
                return;
            }
            if ((FabricUIManager.this.mDriveCxxAnimations || FabricUIManager.this.mDriveCxxNativeAnimated) && FabricUIManager.this.mBinding != null) {
                FabricUIManager.this.mBinding.driveCxxAnimations();
            }
            if (FabricUIManager.this.mBinding != null) {
                FabricUIManager.this.mBinding.drainPreallocateViewsQueue();
            }
            try {
                FabricUIManager.this.mMountItemDispatcher.dispatchPreMountItems(frameTimeNanos);
                FabricUIManager.this.mMountItemDispatcher.tryDispatchMountItems();
            }
            catch (Exception ex) {
                FLog.e((String)TAG, (String)"Exception thrown when executing UIFrameGuarded", (Throwable)ex);
                this.mIsMountingEnabled = false;
                throw ex;
            }
            finally {
                this.schedule();
            }
            FabricUIManager.this.mSynchronousEvents.clear();
        }
    }

    private class MountItemDispatchListener
    implements MountItemDispatcher.ItemDispatchListener {
        private MountItemDispatchListener() {
        }

        @Override
        @UiThread
        @ThreadConfined(value="UI")
        public void willMountItems(@Nullable List<? extends MountItem> mountItems) {
            for (UIManagerListener listener : FabricUIManager.this.mListeners) {
                listener.willMountItems(FabricUIManager.this);
            }
        }

        @Override
        @UiThread
        @ThreadConfined(value="UI")
        public void didMountItems(@Nullable List<? extends MountItem> mountItems) {
            for (UIManagerListener uIManagerListener : FabricUIManager.this.mListeners) {
                uIManagerListener.didMountItems(FabricUIManager.this);
            }
            if (mountItems == null || mountItems.isEmpty()) {
                return;
            }
            for (MountItem mountItem : mountItems) {
                if (mountItem == null || FabricUIManager.this.mSurfaceIdsWithPendingMountNotification.contains(mountItem.getSurfaceId())) continue;
                FabricUIManager.this.mSurfaceIdsWithPendingMountNotification.add(mountItem.getSurfaceId());
            }
            if (!FabricUIManager.this.mMountNotificationScheduled && !FabricUIManager.this.mSurfaceIdsWithPendingMountNotification.isEmpty()) {
                FabricUIManager.this.mMountNotificationScheduled = true;
                UiThreadUtil.getUiThreadHandler().postAtFrontOfQueue(new Runnable(){

                    @Override
                    public void run() {
                        FabricUIManager.this.mMountNotificationScheduled = false;
                        List<Integer> surfaceIdsToReportMount = FabricUIManager.this.mSurfaceIdsWithPendingMountNotification;
                        FabricUIManager.this.mSurfaceIdsWithPendingMountNotification = new ArrayList<Integer>();
                        FabricUIManagerBinding binding = FabricUIManager.this.mBinding;
                        if (binding == null || FabricUIManager.this.mDestroyed) {
                            return;
                        }
                        for (int surfaceId : surfaceIdsToReportMount) {
                            binding.reportMount(surfaceId);
                        }
                    }
                });
            }
        }

        @Override
        public void didDispatchMountItems() {
            for (UIManagerListener listener : FabricUIManager.this.mListeners) {
                listener.didDispatchMountItems(FabricUIManager.this);
            }
        }
    }
}

