/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.fabric.LongStreamingStats;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\u0018\u0000 \u001d2\u00020\u0001:\u0004\u001a\u001b\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ*\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J2\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/facebook/react/fabric/DevToolsReactPerfLogger;", "Lcom/facebook/react/bridge/ReactMarker$FabricMarkerListener;", "<init>", "()V", "fabricCommitMarkers", "", "", "Lcom/facebook/react/fabric/DevToolsReactPerfLogger$FabricCommitPoint;", "devToolsReactPerfLoggerListeners", "", "Lcom/facebook/react/fabric/DevToolsReactPerfLogger$DevToolsReactPerfLoggerListener;", "addDevToolsReactPerfLoggerListener", "", "listener", "removeDevToolsReactPerfLoggerListener", "logFabricMarker", "name", "Lcom/facebook/react/bridge/ReactMarkerConstants;", "tag", "", "instanceKey", "timestamp", "", "counter", "onFabricCommitEnd", "commitPoint", "DevToolsReactPerfLoggerListener", "FabricCommitPointData", "FabricCommitPoint", "Companion", "ReactAndroid_release"})
public final class DevToolsReactPerfLogger
implements ReactMarker.FabricMarkerListener {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Integer, FabricCommitPoint> fabricCommitMarkers = new LinkedHashMap();
    @NotNull
    private final List<DevToolsReactPerfLoggerListener> devToolsReactPerfLoggerListeners = new ArrayList();
    @Deprecated
    @JvmField
    @NotNull
    public static final LongStreamingStats streamingCommitStats = new LongStreamingStats();
    @Deprecated
    @JvmField
    @NotNull
    public static final LongStreamingStats streamingLayoutStats = new LongStreamingStats();
    @Deprecated
    @JvmField
    @NotNull
    public static final LongStreamingStats streamingDiffStats = new LongStreamingStats();
    @Deprecated
    @JvmField
    @NotNull
    public static final LongStreamingStats streamingTransactionEndStats = new LongStreamingStats();
    @Deprecated
    @JvmField
    @NotNull
    public static final LongStreamingStats streamingBatchExecutionStats = new LongStreamingStats();

    public final void addDevToolsReactPerfLoggerListener(@NotNull DevToolsReactPerfLoggerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.devToolsReactPerfLoggerListeners.add(listener);
    }

    public final void removeDevToolsReactPerfLoggerListener(@NotNull DevToolsReactPerfLoggerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.devToolsReactPerfLoggerListeners.remove(listener);
    }

    @Override
    public void logFabricMarker(@NotNull ReactMarkerConstants name, @Nullable String tag, int instanceKey, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        this.logFabricMarker(name, tag, instanceKey, timestamp, 0);
    }

    @Override
    public void logFabricMarker(@NotNull ReactMarkerConstants name, @Nullable String tag, int instanceKey, long timestamp, int counter) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        if (DevToolsReactPerfLogger.Companion.isFabricCommitMarker(name)) {
            FabricCommitPoint commitPoint = this.fabricCommitMarkers.get(instanceKey);
            if (commitPoint == null) {
                commitPoint = new FabricCommitPoint(instanceKey);
                Integer n = instanceKey;
                this.fabricCommitMarkers.put(n, commitPoint);
            }
            commitPoint.addPoint$ReactAndroid_release(name, new FabricCommitPointData(timestamp, counter));
            if (name == ReactMarkerConstants.FABRIC_BATCH_EXECUTION_END && timestamp > 0L) {
                this.onFabricCommitEnd(commitPoint);
                this.fabricCommitMarkers.remove(instanceKey);
            }
        }
    }

    private final void onFabricCommitEnd(FabricCommitPoint commitPoint) {
        for (DevToolsReactPerfLoggerListener listener : this.devToolsReactPerfLoggerListeners) {
            listener.onFabricCommitEnd(commitPoint);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/fabric/DevToolsReactPerfLogger$Companion;", "", "<init>", "()V", "streamingCommitStats", "Lcom/facebook/react/fabric/LongStreamingStats;", "streamingLayoutStats", "streamingDiffStats", "streamingTransactionEndStats", "streamingBatchExecutionStats", "isFabricCommitMarker", "", "name", "Lcom/facebook/react/bridge/ReactMarkerConstants;", "ReactAndroid_release"})
    private static final class Companion {
        private Companion() {
        }

        private final boolean isFabricCommitMarker(ReactMarkerConstants name) {
            return name == ReactMarkerConstants.FABRIC_COMMIT_START || name == ReactMarkerConstants.FABRIC_COMMIT_END || name == ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_START || name == ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_END || name == ReactMarkerConstants.FABRIC_DIFF_START || name == ReactMarkerConstants.FABRIC_DIFF_END || name == ReactMarkerConstants.FABRIC_LAYOUT_START || name == ReactMarkerConstants.FABRIC_LAYOUT_END || name == ReactMarkerConstants.FABRIC_BATCH_EXECUTION_START || name == ReactMarkerConstants.FABRIC_BATCH_EXECUTION_END || name == ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_START || name == ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_END || name == ReactMarkerConstants.FABRIC_LAYOUT_AFFECTED_NODES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/fabric/DevToolsReactPerfLogger$DevToolsReactPerfLoggerListener;", "", "onFabricCommitEnd", "", "commitPoint", "Lcom/facebook/react/fabric/DevToolsReactPerfLogger$FabricCommitPoint;", "ReactAndroid_release"})
    public static interface DevToolsReactPerfLoggerListener {
        public void onFabricCommitEnd(@NotNull FabricCommitPoint var1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b.\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\b\u0010<\u001a\u00020=H\u0016R\u0011\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u0011\u0010\u0017\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\bR\u0011\u0010\u0019\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\bR\u0011\u0010\u001b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\bR\u0011\u0010\u001d\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\bR\u0011\u0010\u001f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b \u0010\bR\u0011\u0010!\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\bR\u0011\u0010#\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\bR\u0011\u0010%\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\bR\u0011\u0010*\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\bR\u0011\u0010,\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\bR\u0011\u0010.\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\bR\u0011\u00100\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\bR\u0011\u00102\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\bR\u0011\u00104\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\bR\u0011\u00106\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\bR\u0011\u00108\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\bR\u0011\u0010:\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\b\u00a8\u0006>"}, d2={"Lcom/facebook/react/fabric/DevToolsReactPerfLogger$FabricCommitPoint;", "", "commitNumber", "", "<init>", "(I)V", "", "getCommitNumber", "()J", "points", "", "Lcom/facebook/react/bridge/ReactMarkerConstants;", "Lcom/facebook/react/fabric/DevToolsReactPerfLogger$FabricCommitPointData;", "addPoint", "", "key", "data", "addPoint$ReactAndroid_release", "getTimestamp", "marker", "getCounter", "commitStart", "getCommitStart", "commitEnd", "getCommitEnd", "finishTransactionStart", "getFinishTransactionStart", "finishTransactionEnd", "getFinishTransactionEnd", "diffStart", "getDiffStart", "diffEnd", "getDiffEnd", "layoutStart", "getLayoutStart", "layoutEnd", "getLayoutEnd", "affectedLayoutNodesCount", "getAffectedLayoutNodesCount", "()I", "affectedLayoutNodesCountTime", "getAffectedLayoutNodesCountTime", "batchExecutionStart", "getBatchExecutionStart", "batchExecutionEnd", "getBatchExecutionEnd", "updateUIMainThreadStart", "getUpdateUIMainThreadStart", "updateUIMainThreadEnd", "getUpdateUIMainThreadEnd", "commitDuration", "getCommitDuration", "layoutDuration", "getLayoutDuration", "diffDuration", "getDiffDuration", "transactionEndDuration", "getTransactionEndDuration", "batchExecutionDuration", "getBatchExecutionDuration", "toString", "", "ReactAndroid_release"})
    public static final class FabricCommitPoint {
        private final long commitNumber;
        @NotNull
        private final Map<ReactMarkerConstants, FabricCommitPointData> points;

        public FabricCommitPoint(int commitNumber) {
            this.commitNumber = commitNumber;
            this.points = new LinkedHashMap();
        }

        public final long getCommitNumber() {
            return this.commitNumber;
        }

        public final void addPoint$ReactAndroid_release(@NotNull ReactMarkerConstants key, @NotNull FabricCommitPointData data) {
            Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.points.put(key, data);
        }

        private final long getTimestamp(ReactMarkerConstants marker) {
            FabricCommitPointData data;
            FabricCommitPointData fabricCommitPointData = data = this.points.get((Object)marker);
            return fabricCommitPointData != null ? fabricCommitPointData.getTimeStamp() : -1L;
        }

        private final int getCounter(ReactMarkerConstants marker) {
            FabricCommitPointData fabricCommitPointData = this.points.get((Object)marker);
            return fabricCommitPointData != null ? fabricCommitPointData.getCounter() : 0;
        }

        public final long getCommitStart() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_COMMIT_START);
        }

        public final long getCommitEnd() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_COMMIT_END);
        }

        public final long getFinishTransactionStart() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_START);
        }

        public final long getFinishTransactionEnd() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_END);
        }

        public final long getDiffStart() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_DIFF_START);
        }

        public final long getDiffEnd() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_DIFF_END);
        }

        public final long getLayoutStart() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_LAYOUT_START);
        }

        public final long getLayoutEnd() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_LAYOUT_END);
        }

        public final int getAffectedLayoutNodesCount() {
            return this.getCounter(ReactMarkerConstants.FABRIC_LAYOUT_AFFECTED_NODES);
        }

        public final long getAffectedLayoutNodesCountTime() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_LAYOUT_AFFECTED_NODES);
        }

        public final long getBatchExecutionStart() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_BATCH_EXECUTION_START);
        }

        public final long getBatchExecutionEnd() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_BATCH_EXECUTION_END);
        }

        public final long getUpdateUIMainThreadStart() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_START);
        }

        public final long getUpdateUIMainThreadEnd() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_END);
        }

        public final long getCommitDuration() {
            return this.getCommitEnd() - this.getCommitStart();
        }

        public final long getLayoutDuration() {
            return this.getLayoutEnd() - this.getLayoutStart();
        }

        public final long getDiffDuration() {
            return this.getDiffEnd() - this.getDiffStart();
        }

        public final long getTransactionEndDuration() {
            return this.getFinishTransactionEnd() - this.getFinishTransactionStart();
        }

        public final long getBatchExecutionDuration() {
            return this.getBatchExecutionEnd() - this.getBatchExecutionStart();
        }

        @NotNull
        public String toString() {
            return "FabricCommitPoint{mCommitNumber=" + this.commitNumber + ", mPoints=" + this.points + "}";
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/facebook/react/fabric/DevToolsReactPerfLogger$FabricCommitPointData;", "", "timeStamp", "", "counter", "", "<init>", "(JI)V", "getTimeStamp", "()J", "getCounter", "()I", "ReactAndroid_release"})
    public static final class FabricCommitPointData {
        private final long timeStamp;
        private final int counter;

        public FabricCommitPointData(long timeStamp, int counter) {
            this.timeStamp = timeStamp;
            this.counter = counter;
        }

        public final long getTimeStamp() {
            return this.timeStamp;
        }

        public final int getCounter() {
            return this.counter;
        }
    }
}

