/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import com.facebook.react.bridge.JavaOnlyArray;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.devsupport.interfaces.StackFrame;
import com.facebook.react.interfaces.exceptionmanager.ReactJsExceptionHandler;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001,B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007\u00a2\u0006\u0002\u0010\u001aJ\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u001dJ\u001b\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u001f\u001a\u00020 H\u0007\u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0017J%\u0010$\u001a\u00020\u00052\b\u0010%\u001a\u0004\u0018\u00010\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0007\u00a2\u0006\u0002\u0010&J\u0015\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0001\u00a2\u0006\u0002\b+R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/facebook/react/devsupport/StackTraceHelper;", "", "<init>", "()V", "COLUMN_KEY", "", "LINE_NUMBER_KEY", "FILE_KEY", "METHOD_NAME_KEY", "COLLAPSE_KEY", "MESSAGE_KEY", "ORIGINAL_MESSAGE_KEY", "NAME_KEY", "COMPONENT_STACK_KEY", "STACK_KEY", "ID_KEY", "IS_FATAL_KEY", "EXTRA_DATA_KEY", "STACK_FRAME_PATTERN1", "Ljava/util/regex/Pattern;", "STACK_FRAME_PATTERN2", "convertJsStackTrace", "", "Lcom/facebook/react/devsupport/interfaces/StackFrame;", "stack", "Lcom/facebook/react/bridge/ReadableArray;", "(Lcom/facebook/react/bridge/ReadableArray;)[Lcom/facebook/react/devsupport/interfaces/StackFrame;", "Lorg/json/JSONArray;", "(Lorg/json/JSONArray;)[Lcom/facebook/react/devsupport/interfaces/StackFrame;", "(Ljava/lang/String;)[Lcom/facebook/react/devsupport/interfaces/StackFrame;", "convertJavaStackTrace", "exception", "", "(Ljava/lang/Throwable;)[Lcom/facebook/react/devsupport/interfaces/StackFrame;", "formatFrameSource", "frame", "formatStackTrace", "title", "(Ljava/lang/String;[Lcom/facebook/react/devsupport/interfaces/StackFrame;)Ljava/lang/String;", "convertProcessedError", "Lcom/facebook/react/bridge/JavaOnlyMap;", "error", "Lcom/facebook/react/interfaces/exceptionmanager/ReactJsExceptionHandler$ProcessedError;", "convertProcessedError$ReactAndroid_release", "StackFrameImpl", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nStackTraceHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StackTraceHelper.kt\ncom/facebook/react/devsupport/StackTraceHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n739#2,9:253\n37#3:262\n36#3,3:263\n1#4:266\n*S KotlinDebug\n*F\n+ 1 StackTraceHelper.kt\ncom/facebook/react/devsupport/StackTraceHelper\n*L\n124#1:253,9\n124#1:262\n124#1:263,3\n*E\n"})
public final class StackTraceHelper {
    @NotNull
    public static final StackTraceHelper INSTANCE = new StackTraceHelper();
    @NotNull
    public static final String COLUMN_KEY = "column";
    @NotNull
    public static final String LINE_NUMBER_KEY = "lineNumber";
    @NotNull
    public static final String FILE_KEY = "file";
    @NotNull
    public static final String METHOD_NAME_KEY = "methodName";
    @NotNull
    public static final String COLLAPSE_KEY = "collapse";
    @NotNull
    public static final String MESSAGE_KEY = "message";
    @NotNull
    public static final String ORIGINAL_MESSAGE_KEY = "originalMessage";
    @NotNull
    public static final String NAME_KEY = "name";
    @NotNull
    public static final String COMPONENT_STACK_KEY = "componentStack";
    @NotNull
    public static final String STACK_KEY = "stack";
    @NotNull
    public static final String ID_KEY = "id";
    @NotNull
    public static final String IS_FATAL_KEY = "isFatal";
    @NotNull
    public static final String EXTRA_DATA_KEY = "extraData";
    @NotNull
    private static final Pattern STACK_FRAME_PATTERN1;
    @NotNull
    private static final Pattern STACK_FRAME_PATTERN2;

    private StackTraceHelper() {
    }

    @JvmStatic
    @NotNull
    public static final StackFrame[] convertJsStackTrace(@Nullable ReadableArray stack) {
        int size;
        ReadableArray readableArray = stack;
        int n = size = readableArray != null ? readableArray.size() : 0;
        if (stack == null) {
            return new StackFrame[0];
        }
        StackFrame[] stackFrameArray = new StackFrame[size];
        for (int i = 0; i < size; ++i) {
            StackFrameImpl stackFrameImpl;
            int n2 = i;
            ReadableType type = stack.getType(n2);
            if (type == ReadableType.Map) {
                String method;
                String file;
                ReadableMap frame;
                if (stack.getMap(n2) == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalArgumentException(string2.toString());
                }
                if (frame.getString(METHOD_NAME_KEY) == null) {
                    String string3 = "Required value was null.";
                    throw new IllegalArgumentException(string3.toString());
                }
                if (frame.getString(FILE_KEY) == null) {
                    String string4 = "Required value was null.";
                    throw new IllegalArgumentException(string4.toString());
                }
                boolean collapse = frame.hasKey(COLLAPSE_KEY) && !frame.isNull(COLLAPSE_KEY) && frame.getBoolean(COLLAPSE_KEY);
                int lineNumber = -1;
                if (frame.hasKey(LINE_NUMBER_KEY) && !frame.isNull(LINE_NUMBER_KEY)) {
                    lineNumber = frame.getInt(LINE_NUMBER_KEY);
                }
                int columnNumber = -1;
                if (frame.hasKey(COLUMN_KEY) && !frame.isNull(COLUMN_KEY)) {
                    columnNumber = frame.getInt(COLUMN_KEY);
                }
                stackFrameImpl = new StackFrameImpl(file, null, method, lineNumber, columnNumber, collapse, 2, null);
            } else if (type == ReadableType.String) {
                String string5 = stack.getString(n2);
                if (string5 == null) {
                    String string6 = "Required value was null.";
                    throw new IllegalStateException(string6.toString());
                }
                stackFrameImpl = new StackFrameImpl(null, null, string5, -1, -1, false, 34, null);
            } else {
                throw new IllegalStateException(("Cannot parse the stackframe for " + stack).toString());
            }
            stackFrameArray[n2] = stackFrameImpl;
        }
        return stackFrameArray;
    }

    @NotNull
    public final StackFrame[] convertJsStackTrace(@Nullable JSONArray stack) {
        if (stack == null) {
            return new StackFrame[0];
        }
        int size = stack.length();
        try {
            StackFrame[] stackFrameArray = new StackFrame[size];
            for (int i = 0; i < size; ++i) {
                int n = i;
                JSONObject frame = stack.getJSONObject(n);
                String method = frame.getString(METHOD_NAME_KEY);
                String file = frame.getString(FILE_KEY);
                int lineNumber = -1;
                if (frame.has(LINE_NUMBER_KEY) && !frame.isNull(LINE_NUMBER_KEY)) {
                    lineNumber = frame.getInt(LINE_NUMBER_KEY);
                }
                int columnNumber = -1;
                if (frame.has(COLUMN_KEY) && !frame.isNull(COLUMN_KEY)) {
                    columnNumber = frame.getInt(COLUMN_KEY);
                }
                boolean collapse = frame.has(COLLAPSE_KEY) && !frame.isNull(COLLAPSE_KEY) && frame.getBoolean(COLLAPSE_KEY);
                Intrinsics.checkNotNull((Object)method);
                stackFrameArray[n] = new StackFrameImpl(file, null, method, lineNumber, columnNumber, collapse, 2, null);
            }
            return stackFrameArray;
        }
        catch (JSONException exception) {
            throw new RuntimeException(exception);
        }
    }

    @NotNull
    public final StackFrame[] convertJsStackTrace(@NotNull String stack) {
        List list;
        Intrinsics.checkNotNullParameter((Object)stack, (String)STACK_KEY);
        CharSequence charSequence = stack;
        Regex regex = new Regex("\n");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stackTrace = thisCollection$iv.toArray(new String[0]);
        int n2 = stackTrace.length;
        StackFrame[] stackFrameArray = new StackFrame[n2];
        for (int i = 0; i < n2; ++i) {
            StackFrameImpl stackFrameImpl;
            Matcher matcher;
            int n3 = i;
            Matcher matcher1 = STACK_FRAME_PATTERN1.matcher(stackTrace[n3]);
            Matcher matcher2 = STACK_FRAME_PATTERN2.matcher(stackTrace[n3]);
            Matcher matcher3 = matcher2.find() ? matcher2 : (matcher = matcher1.find() ? matcher1 : null);
            if (matcher != null) {
                String file = matcher.group(2);
                String string2 = matcher.group(1);
                if (string2 == null) {
                    string2 = "(unknown)";
                }
                String method = string2;
                String lineString = matcher.group(3);
                String columnString = matcher.group(4);
                String string3 = lineString;
                if (string3 == null) {
                    String string4 = "Required value was null.";
                    throw new IllegalStateException(string4.toString());
                }
                String string5 = columnString;
                if (string5 == null) {
                    String string6 = "Required value was null.";
                    throw new IllegalStateException(string6.toString());
                }
                stackFrameImpl = new StackFrameImpl(file, null, method, Integer.parseInt(string3), Integer.parseInt(string5), false, 34, null);
            } else {
                stackFrameImpl = new StackFrameImpl(null, null, stackTrace[n3], -1, -1, false, 34, null);
            }
            stackFrameArray[n3] = stackFrameImpl;
        }
        return stackFrameArray;
    }

    @JvmStatic
    @NotNull
    public static final StackFrame[] convertJavaStackTrace(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        StackTraceElement[] stackTrace = exception.getStackTrace();
        int n = 0;
        int n2 = stackTrace.length;
        StackFrame[] stackFrameArray = new StackFrame[n2];
        while (n < n2) {
            int n3 = n++;
            String string2 = stackTrace[n3].getClassName();
            String string3 = stackTrace[n3].getFileName();
            String string4 = stackTrace[n3].getMethodName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getMethodName(...)");
            stackFrameArray[n3] = new StackFrameImpl(string2, string3, string4, stackTrace[n3].getLineNumber(), -1, false, 32, null);
        }
        return stackFrameArray;
    }

    @NotNull
    public final String formatFrameSource(@NotNull StackFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        StringBuilder lineInfo = new StringBuilder();
        lineInfo.append(frame.getFileName());
        int line = frame.getLine();
        if (line > 0) {
            lineInfo.append(":").append(line);
            int column = frame.getColumn();
            if (column > 0) {
                lineInfo.append(":").append(column);
            }
        }
        String string2 = lineInfo.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String formatStackTrace(@Nullable String title, @NotNull StackFrame[] stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)STACK_KEY);
        StringBuilder stackTrace = new StringBuilder();
        stackTrace.append(title).append("\n");
        for (StackFrame frame : stack) {
            stackTrace.append(frame.getMethod()).append("\n").append("    ").append(INSTANCE.formatFrameSource(frame)).append("\n");
        }
        String string2 = stackTrace.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final JavaOnlyMap convertProcessedError$ReactAndroid_release(@NotNull ReactJsExceptionHandler.ProcessedError error) {
        String it;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        JavaOnlyArray stack = new JavaOnlyArray();
        Object object = error.getStack().iterator();
        while (object.hasNext()) {
            void $this$convertProcessedError_u24lambda_u243;
            int it2;
            JavaOnlyMap javaOnlyMap;
            ReactJsExceptionHandler.ProcessedError.StackFrame frame = object.next();
            JavaOnlyMap javaOnlyMap2 = javaOnlyMap = new JavaOnlyMap();
            JavaOnlyArray javaOnlyArray = stack;
            boolean bl = false;
            Integer n = frame.getColumn();
            if (n != null) {
                it2 = ((Number)n).intValue();
                boolean bl2 = false;
                $this$convertProcessedError_u24lambda_u243.putDouble(COLUMN_KEY, it2);
            }
            Integer n2 = frame.getLineNumber();
            if (n2 != null) {
                it2 = ((Number)n2).intValue();
                boolean bl3 = false;
                $this$convertProcessedError_u24lambda_u243.putDouble(LINE_NUMBER_KEY, it2);
            }
            $this$convertProcessedError_u24lambda_u243.putString(FILE_KEY, frame.getFile());
            $this$convertProcessedError_u24lambda_u243.putString(METHOD_NAME_KEY, frame.getMethodName());
            javaOnlyArray.pushMap(javaOnlyMap);
        }
        Object $this$convertProcessedError_u24lambda_u247 = object = new JavaOnlyMap();
        boolean bl = false;
        ((JavaOnlyMap)$this$convertProcessedError_u24lambda_u247).putString(MESSAGE_KEY, error.getMessage());
        String string2 = error.getOriginalMessage();
        if (string2 != null) {
            it = string2;
            boolean bl4 = false;
            ((JavaOnlyMap)$this$convertProcessedError_u24lambda_u247).putString(ORIGINAL_MESSAGE_KEY, it);
        }
        String string3 = error.getName();
        if (string3 != null) {
            it = string3;
            boolean bl5 = false;
            ((JavaOnlyMap)$this$convertProcessedError_u24lambda_u247).putString(NAME_KEY, it);
        }
        String string4 = error.getComponentStack();
        if (string4 != null) {
            it = string4;
            boolean bl6 = false;
            ((JavaOnlyMap)$this$convertProcessedError_u24lambda_u247).putString(COMPONENT_STACK_KEY, it);
        }
        ((JavaOnlyMap)$this$convertProcessedError_u24lambda_u247).putArray(STACK_KEY, stack);
        ((JavaOnlyMap)$this$convertProcessedError_u24lambda_u247).putInt(ID_KEY, error.getId());
        ((JavaOnlyMap)$this$convertProcessedError_u24lambda_u247).putBoolean(IS_FATAL_KEY, error.isFatal());
        ((JavaOnlyMap)$this$convertProcessedError_u24lambda_u247).putMap(EXTRA_DATA_KEY, error.getExtraData());
        return object;
    }

    static {
        Pattern pattern = Pattern.compile("^(?:(.*?)@)?(.*?)\\:([0-9]+)\\:([0-9]+)$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        STACK_FRAME_PATTERN1 = pattern;
        Pattern pattern2 = Pattern.compile("\\s*(?:at)\\s*(.+?)\\s*[@(](.*):([0-9]+):([0-9]+)[)]$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        STACK_FRAME_PATTERN2 = pattern2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lcom/facebook/react/devsupport/StackTraceHelper$StackFrameImpl;", "Lcom/facebook/react/devsupport/interfaces/StackFrame;", "file", "", "fileName", "method", "line", "", "column", "isCollapsed", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IIZ)V", "getFile", "()Ljava/lang/String;", "getFileName", "getMethod", "getLine", "()I", "getColumn", "()Z", "toJSON", "Lorg/json/JSONObject;", "ReactAndroid_release"})
    @SourceDebugExtension(value={"SMAP\nStackTraceHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StackTraceHelper.kt\ncom/facebook/react/devsupport/StackTraceHelper$StackFrameImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n1#2:253\n*E\n"})
    public static final class StackFrameImpl
    implements StackFrame {
        @Nullable
        private final String file;
        @Nullable
        private final String fileName;
        @NotNull
        private final String method;
        private final int line;
        private final int column;
        private final boolean isCollapsed;

        public StackFrameImpl(@Nullable String file, @Nullable String fileName, @NotNull String method, int line, int column, boolean isCollapsed) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            this.file = file;
            this.fileName = fileName;
            this.method = method;
            this.line = line;
            this.column = column;
            this.isCollapsed = isCollapsed;
        }

        public /* synthetic */ StackFrameImpl(String string2, String string3, String string4, int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                String string5 = string2;
                if (string5 != null) {
                    String it = string5;
                    boolean bl2 = false;
                    v1 = new File(it).getName();
                } else {
                    v1 = string3 = null;
                }
            }
            if ((n3 & 0x20) != 0) {
                bl = false;
            }
            this(string2, string3, string4, n, n2, bl);
        }

        @Override
        @Nullable
        public String getFile() {
            return this.file;
        }

        @Override
        @Nullable
        public String getFileName() {
            return this.fileName;
        }

        @Override
        @NotNull
        public String getMethod() {
            return this.method;
        }

        @Override
        public int getLine() {
            return this.line;
        }

        @Override
        public int getColumn() {
            return this.column;
        }

        @Override
        public boolean isCollapsed() {
            return this.isCollapsed;
        }

        @Override
        @NotNull
        public JSONObject toJSON() {
            Pair[] pairArray = new Pair[5];
            String string2 = this.getFile();
            if (string2 == null) {
                string2 = "";
            }
            pairArray[0] = TuplesKt.to((Object)StackTraceHelper.FILE_KEY, (Object)string2);
            pairArray[1] = TuplesKt.to((Object)StackTraceHelper.METHOD_NAME_KEY, (Object)this.getMethod());
            pairArray[2] = TuplesKt.to((Object)StackTraceHelper.LINE_NUMBER_KEY, (Object)this.getLine());
            pairArray[3] = TuplesKt.to((Object)StackTraceHelper.COLUMN_KEY, (Object)this.getColumn());
            pairArray[4] = TuplesKt.to((Object)StackTraceHelper.COLLAPSE_KEY, (Object)this.isCollapsed());
            return new JSONObject(MapsKt.mapOf((Pair[])pairArray));
        }
    }
}

