/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.provider.Settings;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.devsupport.FpsView;
import com.facebook.react.devsupport.WindowOverlayCompat;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/react/devsupport/DebugOverlayController;", "", "reactContext", "Lcom/facebook/react/bridge/ReactContext;", "<init>", "(Lcom/facebook/react/bridge/ReactContext;)V", "windowManager", "Landroid/view/WindowManager;", "fpsDebugViewContainer", "Landroid/widget/FrameLayout;", "setFpsDebugViewVisible", "", "fpsDebugViewVisible", "", "Companion", "ReactAndroid_release"})
public final class DebugOverlayController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactContext reactContext;
    @NotNull
    private final WindowManager windowManager;
    @Nullable
    private FrameLayout fpsDebugViewContainer;

    public DebugOverlayController(@NotNull ReactContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        this.reactContext = reactContext;
        Object object = this.reactContext.getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        this.windowManager = (WindowManager)object;
    }

    public final void setFpsDebugViewVisible(boolean fpsDebugViewVisible) {
        UiThreadUtil.runOnUiThread(() -> DebugOverlayController.setFpsDebugViewVisible$lambda$0(fpsDebugViewVisible, this));
    }

    private static final void setFpsDebugViewVisible$lambda$0(boolean $fpsDebugViewVisible, DebugOverlayController this$0) {
        if ($fpsDebugViewVisible && this$0.fpsDebugViewContainer == null) {
            if (!DebugOverlayController.Companion.permissionCheck((Context)this$0.reactContext)) {
                FLog.d((String)"ReactNative", (String)"Wait for overlay permission to be set");
                return;
            }
            this$0.fpsDebugViewContainer = new FpsView(this$0.reactContext);
            WindowManager.LayoutParams params = new WindowManager.LayoutParams(-1, -1, WindowOverlayCompat.TYPE_SYSTEM_OVERLAY, 24, -3);
            this$0.windowManager.addView((View)this$0.fpsDebugViewContainer, (ViewGroup.LayoutParams)params);
        } else if (!$fpsDebugViewVisible && this$0.fpsDebugViewContainer != null) {
            FrameLayout frameLayout = this$0.fpsDebugViewContainer;
            if (frameLayout != null) {
                frameLayout.removeAllViews();
            }
            this$0.windowManager.removeView((View)this$0.fpsDebugViewContainer);
            this$0.fpsDebugViewContainer = null;
        }
    }

    @JvmStatic
    public static final void requestPermission(@NotNull Context context) {
        Companion.requestPermission(context);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/facebook/react/devsupport/DebugOverlayController$Companion;", "", "<init>", "()V", "requestPermission", "", "context", "Landroid/content/Context;", "permissionCheck", "", "canHandleIntent", "intent", "Landroid/content/Intent;", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void requestPermission(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!Settings.canDrawOverlays((Context)context)) {
                Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + context.getPackageName())));
                intent.setFlags(0x10000000);
                FLog.w((String)"ReactNative", (String)"Overlay permissions needs to be granted in order for react native apps to run in dev mode");
                if (this.canHandleIntent(context, intent)) {
                    context.startActivity(intent);
                }
            }
        }

        private final boolean permissionCheck(Context context) {
            return Settings.canDrawOverlays((Context)context);
        }

        private final boolean canHandleIntent(Context context, Intent intent) {
            PackageManager packageManager = context.getPackageManager();
            return packageManager != null && intent.resolveActivity(packageManager) != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

