/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.os.Handler;
import android.os.Looper;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.proguard.annotations.DoNotStripAny;
import com.facebook.react.devsupport.CxxInspectorPackagerConnection;
import com.facebook.react.devsupport.IInspectorPackagerConnection;
import com.facebook.soloader.SoLoader;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\n\u001a\u00020\u000bH\u0096 J\t\u0010\f\u001a\u00020\u000bH\u0096 J\u0013\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0096 R\u0010\u0010\b\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/facebook/react/devsupport/CxxInspectorPackagerConnection;", "Lcom/facebook/react/devsupport/IInspectorPackagerConnection;", "url", "", "deviceName", "packageName", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "mHybridData", "Lcom/facebook/jni/HybridData;", "connect", "", "closeQuietly", "sendEventToAllConnections", "event", "WebSocketDelegate", "IWebSocket", "DelegateImpl", "Companion", "ReactAndroid_release"})
public final class CxxInspectorPackagerConnection
implements IInspectorPackagerConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @DoNotStrip
    @NotNull
    private final HybridData mHybridData;

    public CxxInspectorPackagerConnection(@NotNull String url, @NotNull String deviceName, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        this.mHybridData = CxxInspectorPackagerConnection.Companion.initHybrid(url, deviceName, packageName, new DelegateImpl());
    }

    @Override
    public native void connect();

    @Override
    public native void closeQuietly();

    @Override
    public native void sendEventToAllConnections(@Nullable String var1);

    @JvmStatic
    private static final native HybridData initHybrid(String var0, String var1, String var2, DelegateImpl var3);

    static {
        SoLoader.loadLibrary((String)"react_devsupportjni");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0083 \u00a8\u0006\f"}, d2={"Lcom/facebook/react/devsupport/CxxInspectorPackagerConnection$Companion;", "", "<init>", "()V", "initHybrid", "Lcom/facebook/jni/HybridData;", "url", "", "deviceName", "packageName", "delegate", "Lcom/facebook/react/devsupport/CxxInspectorPackagerConnection$DelegateImpl;", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final HybridData initHybrid(String url, String deviceName, String packageName, DelegateImpl delegate) {
            return CxxInspectorPackagerConnection.initHybrid(url, deviceName, packageName, delegate);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/react/devsupport/CxxInspectorPackagerConnection$DelegateImpl;", "", "<init>", "()V", "httpClient", "Lokhttp3/OkHttpClient;", "mHandler", "Landroid/os/Handler;", "connectWebSocket", "Lcom/facebook/react/devsupport/CxxInspectorPackagerConnection$IWebSocket;", "urlParam", "", "delegate", "Lcom/facebook/react/devsupport/CxxInspectorPackagerConnection$WebSocketDelegate;", "scheduleCallback", "", "runnable", "Ljava/lang/Runnable;", "delayMs", "", "ReactAndroid_release"})
    private static final class DelegateImpl {
        @NotNull
        private final OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MINUTES).build();
        @NotNull
        private final Handler mHandler = new Handler(Looper.getMainLooper());

        @DoNotStrip
        @NotNull
        public final IWebSocket connectWebSocket(@Nullable String urlParam, @NotNull WebSocketDelegate delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            String string2 = urlParam;
            if (string2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
            String url = string2;
            Request request = new Request.Builder().url(url).build();
            WebSocket webSocket2 = this.httpClient.newWebSocket(request, new WebSocketListener(this, delegate){
                final /* synthetic */ DelegateImpl this$0;
                final /* synthetic */ WebSocketDelegate $delegate;
                {
                    this.this$0 = $receiver;
                    this.$delegate = $delegate;
                }

                public void onFailure(WebSocket webSocket2, Throwable t, Response response) {
                    Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    this.this$0.scheduleCallback(() -> connectWebSocket.webSocket.1.onFailure$lambda$0(t, this.$delegate), 0L);
                }

                public void onMessage(WebSocket webSocket2, String text) {
                    Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    this.this$0.scheduleCallback(() -> connectWebSocket.webSocket.1.onMessage$lambda$1(this.$delegate, text), 0L);
                }

                public void onOpen(WebSocket webSocket2, Response response) {
                    Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    this.this$0.scheduleCallback(() -> connectWebSocket.webSocket.1.onOpen$lambda$2(this.$delegate), 0L);
                }

                public void onClosed(WebSocket webSocket2, int code, String reason) {
                    Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
                    Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                    this.this$0.scheduleCallback(() -> connectWebSocket.webSocket.1.onClosed$lambda$3(this.$delegate), 0L);
                }

                private static final void onFailure$lambda$0(Throwable $t, WebSocketDelegate $delegate) {
                    String message = $t.getMessage();
                    String string2 = message;
                    if (string2 == null) {
                        string2 = "<Unknown error>";
                    }
                    $delegate.didFailWithError(null, string2);
                    $delegate.close();
                }

                private static final void onMessage$lambda$1(WebSocketDelegate $delegate, String $text) {
                    $delegate.didReceiveMessage($text);
                }

                private static final void onOpen$lambda$2(WebSocketDelegate $delegate) {
                    $delegate.didOpen();
                }

                private static final void onClosed$lambda$3(WebSocketDelegate $delegate) {
                    $delegate.didClose();
                    $delegate.close();
                }
            });
            return new IWebSocket(webSocket2){
                final /* synthetic */ WebSocket $webSocket;
                {
                    this.$webSocket = $webSocket;
                }

                public void send(String message) {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    this.$webSocket.send(message);
                }

                public void close() {
                    this.$webSocket.close(1000, "End of session");
                }
            };
        }

        @DoNotStrip
        public final void scheduleCallback(@NotNull Runnable runnable, long delayMs) {
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            this.mHandler.postDelayed(runnable, delayMs);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bc\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/devsupport/CxxInspectorPackagerConnection$IWebSocket;", "Ljava/io/Closeable;", "send", "", "message", "", "close", "ReactAndroid_release"})
    @DoNotStripAny
    private static interface IWebSocket
    extends Closeable {
        public void send(@NotNull String var1);

        @Override
        public void close();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0003\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0086 \u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0086 J\t\u0010\u000f\u001a\u00020\u0007H\u0086 J\t\u0010\u0010\u001a\u00020\u0007H\u0086 J\b\u0010\u0011\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/devsupport/CxxInspectorPackagerConnection$WebSocketDelegate;", "Ljava/io/Closeable;", "mHybridData", "Lcom/facebook/jni/HybridData;", "<init>", "(Lcom/facebook/jni/HybridData;)V", "didFailWithError", "", "posixCode", "", "error", "", "(Ljava/lang/Integer;Ljava/lang/String;)V", "didReceiveMessage", "message", "didOpen", "didClose", "close", "ReactAndroid_release"})
    @DoNotStrip
    private static final class WebSocketDelegate
    implements Closeable {
        @NotNull
        private final HybridData mHybridData;

        @DoNotStrip
        public WebSocketDelegate(@NotNull HybridData mHybridData) {
            Intrinsics.checkNotNullParameter((Object)mHybridData, (String)"mHybridData");
            this.mHybridData = mHybridData;
        }

        public final native void didFailWithError(@Nullable Integer var1, @Nullable String var2);

        public final native void didReceiveMessage(@Nullable String var1);

        public final native void didOpen();

        public final native void didClose();

        @Override
        public void close() {
            this.mHybridData.resetNative();
        }
    }
}

