/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.os.SystemClock;
import androidx.annotation.AnyThread;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactNativeJniCommonSoLoader;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\r\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0003&'(B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0007J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0007J\b\u0010\u0010\u001a\u00020\rH\u0007J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0007J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0007J\b\u0010\u0013\u001a\u00020\rH\u0007J2\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001aH\u0007J*\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\"\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0018H\u0007J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u001a\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J\"\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u001a\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001cH\u0007J\"\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J1\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cH\u0007\u00a2\u0006\u0002\u0010 J\u001f\u0010!\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cH\u0003\u00a2\u0006\u0002\u0010\"J\u0019\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u001cH\u0083 R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/facebook/react/bridge/ReactMarker;", "", "<init>", "()V", "nativeReactMarkerQueue", "Ljava/util/Queue;", "Lcom/facebook/react/bridge/ReactMarker$ReactMarkerRecord;", "listeners", "", "Lcom/facebook/react/bridge/ReactMarker$MarkerListener;", "fabricMarkerListeners", "Lcom/facebook/react/bridge/ReactMarker$FabricMarkerListener;", "addListener", "", "listener", "removeListener", "clearMarkerListeners", "addFabricListener", "removeFabricListener", "clearFabricMarkerListeners", "logFabricMarker", "name", "Lcom/facebook/react/bridge/ReactMarkerConstants;", "tag", "", "instanceKey", "", "timestamp", "", "counter", "logMarker", "time", "(Lcom/facebook/react/bridge/ReactMarkerConstants;Ljava/lang/String;ILjava/lang/Long;)V", "notifyNativeMarker", "(Lcom/facebook/react/bridge/ReactMarkerConstants;Ljava/lang/Long;)V", "nativeLogMarker", "markerName", "markerTime", "ReactMarkerRecord", "MarkerListener", "FabricMarkerListener", "ReactAndroid_release"})
@DoNotStrip
public final class ReactMarker {
    @NotNull
    public static final ReactMarker INSTANCE = new ReactMarker();
    @NotNull
    private static final Queue<ReactMarkerRecord> nativeReactMarkerQueue = new ConcurrentLinkedQueue();
    @NotNull
    private static final List<MarkerListener> listeners = new CopyOnWriteArrayList();
    @NotNull
    private static final List<FabricMarkerListener> fabricMarkerListeners = new CopyOnWriteArrayList();

    private ReactMarker() {
    }

    @JvmStatic
    @DoNotStrip
    public static final void addListener(@NotNull MarkerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    @JvmStatic
    @DoNotStrip
    public static final void removeListener(@NotNull MarkerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        listeners.remove(listener);
    }

    @JvmStatic
    @DoNotStrip
    public static final void clearMarkerListeners() {
        listeners.clear();
    }

    @JvmStatic
    @DoNotStrip
    public static final void addFabricListener(@NotNull FabricMarkerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (!fabricMarkerListeners.contains(listener)) {
            fabricMarkerListeners.add(listener);
        }
    }

    @JvmStatic
    @DoNotStrip
    public static final void removeFabricListener(@NotNull FabricMarkerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        fabricMarkerListeners.remove(listener);
    }

    @JvmStatic
    @DoNotStrip
    public static final void clearFabricMarkerListeners() {
        fabricMarkerListeners.clear();
    }

    @JvmStatic
    @DoNotStrip
    public static final void logFabricMarker(@NotNull ReactMarkerConstants name, @Nullable String tag, int instanceKey, long timestamp, int counter) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        for (FabricMarkerListener listener : fabricMarkerListeners) {
            listener.logFabricMarker(name, tag, instanceKey, timestamp, counter);
        }
    }

    @JvmStatic
    @DoNotStrip
    public static final void logFabricMarker(@NotNull ReactMarkerConstants name, @Nullable String tag, int instanceKey, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        for (FabricMarkerListener listener : fabricMarkerListeners) {
            listener.logFabricMarker(name, tag, instanceKey, timestamp, 0);
        }
    }

    @JvmStatic
    @DoNotStrip
    public static final void logFabricMarker(@NotNull ReactMarkerConstants name, @Nullable String tag, int instanceKey) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        ReactMarker.logFabricMarker(name, tag, instanceKey, SystemClock.uptimeMillis(), 0);
    }

    @JvmStatic
    @DoNotStrip
    public static final void logMarker(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ReactMarker.logMarker(name, null);
    }

    @JvmStatic
    @DoNotStrip
    public static final void logMarker(@NotNull String name, int instanceKey) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ReactMarker.logMarker(name, null, instanceKey);
    }

    @JvmStatic
    @DoNotStrip
    public static final void logMarker(@NotNull String name, @Nullable String tag) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ReactMarker.logMarker(name, tag, 0);
    }

    @JvmStatic
    @DoNotStrip
    public static final void logMarker(@NotNull String name, @Nullable String tag, int instanceKey) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ReactMarker.logMarker(ReactMarkerConstants.valueOf(name), tag, instanceKey);
    }

    @JvmStatic
    @DoNotStrip
    public static final void logMarker(@NotNull ReactMarkerConstants name) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        ReactMarker.logMarker(name, null, 0);
    }

    @JvmStatic
    @DoNotStrip
    public static final void logMarker(@NotNull ReactMarkerConstants name, int instanceKey) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        ReactMarker.logMarker(name, null, instanceKey);
    }

    @JvmStatic
    @DoNotStrip
    public static final void logMarker(@NotNull ReactMarkerConstants name, @Nullable String tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        ReactMarker.logMarker(name, tag, 0);
    }

    @JvmStatic
    @DoNotStrip
    public static final void logMarker(@NotNull ReactMarkerConstants name, long time) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        ReactMarker.logMarker(name, null, 0, time);
    }

    @JvmStatic
    @DoNotStrip
    @AnyThread
    public static final void logMarker(@NotNull ReactMarkerConstants name, @Nullable String tag, int instanceKey) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        ReactMarker.logMarker(name, tag, instanceKey, null);
    }

    @JvmStatic
    @DoNotStrip
    @AnyThread
    public static final void logMarker(@NotNull ReactMarkerConstants name, @Nullable String tag, int instanceKey, @Nullable Long time) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        ReactMarker.logFabricMarker(name, tag, instanceKey);
        for (MarkerListener listener : listeners) {
            listener.logMarker(name, tag, instanceKey);
        }
        ReactMarker.notifyNativeMarker(name, time);
    }

    @JvmStatic
    @DoNotStrip
    private static final void notifyNativeMarker(ReactMarkerConstants name, Long time) {
        long now;
        if (!name.hasMatchingNameMarker()) {
            return;
        }
        Long l = time;
        long l2 = now = l != null ? l : SystemClock.uptimeMillis();
        if (ReactNativeJniCommonSoLoader.isInitialized()) {
            ReactMarker.nativeLogMarker(name.name(), now);
            while (nativeReactMarkerQueue.poll() != null) {
                ReactMarkerRecord record;
                ReactMarker.nativeLogMarker(record.getMarkerName(), record.getMarkerTime());
            }
        } else {
            nativeReactMarkerQueue.add(new ReactMarkerRecord(name.name(), now));
        }
    }

    @JvmStatic
    @DoNotStrip
    private static final native void nativeLogMarker(String var0, long var1);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J*\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J2\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/bridge/ReactMarker$FabricMarkerListener;", "", "logFabricMarker", "", "name", "Lcom/facebook/react/bridge/ReactMarkerConstants;", "tag", "", "instanceKey", "", "timestamp", "", "counter", "ReactAndroid_release"})
    public static interface FabricMarkerListener {
        public void logFabricMarker(@NotNull ReactMarkerConstants var1, @Nullable String var2, int var3, long var4);

        default public void logFabricMarker(@NotNull ReactMarkerConstants name, @Nullable String tag, int instanceKey, long timestamp, int counter) {
            Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
            this.logFabricMarker(name, tag, instanceKey, timestamp);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/bridge/ReactMarker$MarkerListener;", "", "logMarker", "", "name", "Lcom/facebook/react/bridge/ReactMarkerConstants;", "tag", "", "instanceKey", "", "ReactAndroid_release"})
    public static interface MarkerListener {
        public void logMarker(@NotNull ReactMarkerConstants var1, @Nullable String var2, int var3);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/facebook/react/bridge/ReactMarker$ReactMarkerRecord;", "", "markerName", "", "markerTime", "", "<init>", "(Ljava/lang/String;J)V", "getMarkerName", "()Ljava/lang/String;", "getMarkerTime", "()J", "ReactAndroid_release"})
    private static final class ReactMarkerRecord {
        @NotNull
        private final String markerName;
        private final long markerTime;

        public ReactMarkerRecord(@NotNull String markerName, long markerTime) {
            Intrinsics.checkNotNullParameter((Object)markerName, (String)"markerName");
            this.markerName = markerName;
            this.markerTime = markerTime;
        }

        @NotNull
        public final String getMarkerName() {
            return this.markerName;
        }

        public final long getMarkerTime() {
            return this.markerTime;
        }
    }
}

