/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.ActivityEventListener;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.JSExceptionHandler;
import com.facebook.react.bridge.JavaScriptContextHolder;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WindowFocusChangeListener;
import com.facebook.react.bridge.interop.InteropModuleRegistry;
import com.facebook.react.bridge.queue.MessageQueueThread;
import com.facebook.react.bridge.queue.ReactQueueConfiguration;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.turbomodule.core.interfaces.CallInvokerHolder;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class ReactContext
extends ContextWrapper {
    private static final String TAG = "ReactContext";
    private final CopyOnWriteArraySet<LifecycleEventListener> mLifecycleEventListeners = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<ActivityEventListener> mActivityEventListeners = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<WindowFocusChangeListener> mWindowFocusEventListeners = new CopyOnWriteArraySet();
    private LifecycleState mLifecycleState = LifecycleState.BEFORE_CREATE;
    @Nullable
    private LayoutInflater mInflater;
    @Nullable
    private ReactQueueConfiguration mQueueConfig;
    @Nullable
    private MessageQueueThread mUiMessageQueueThread;
    @Nullable
    private MessageQueueThread mNativeModulesMessageQueueThread;
    @Nullable
    private MessageQueueThread mJSMessageQueueThread;
    @Nullable
    private JSExceptionHandler mJSExceptionHandler;
    @Nullable
    private JSExceptionHandler mExceptionHandlerWrapper;
    @Nullable
    private WeakReference<Activity> mCurrentActivity;
    @Nullable
    protected InteropModuleRegistry mInteropModuleRegistry;
    private boolean mIsInitialized = false;

    public ReactContext(Context base) {
        super(base);
    }

    protected void initializeFromOther(ReactContext other) {
        if (other.hasReactInstance()) {
            this.initializeMessageQueueThreads(other.mQueueConfig);
        }
        this.mInteropModuleRegistry = other.mInteropModuleRegistry;
    }

    public synchronized void initializeMessageQueueThreads(ReactQueueConfiguration queueConfig) {
        FLog.d((String)TAG, (String)"initializeMessageQueueThreads() is called.");
        if (this.mUiMessageQueueThread != null || this.mNativeModulesMessageQueueThread != null || this.mJSMessageQueueThread != null) {
            throw new IllegalStateException("Message queue threads already initialized");
        }
        this.mQueueConfig = queueConfig;
        this.mUiMessageQueueThread = queueConfig.getUIQueueThread();
        this.mNativeModulesMessageQueueThread = queueConfig.getNativeModulesQueueThread();
        this.mJSMessageQueueThread = queueConfig.getJSQueueThread();
        if (this.mUiMessageQueueThread == null) {
            throw new IllegalStateException("UI thread is null");
        }
        if (this.mNativeModulesMessageQueueThread == null) {
            throw new IllegalStateException("NativeModules thread is null");
        }
        if (this.mJSMessageQueueThread == null) {
            throw new IllegalStateException("JavaScript thread is null");
        }
        this.mIsInitialized = true;
    }

    protected void initializeInteropModules() {
        this.mInteropModuleRegistry = new InteropModuleRegistry();
    }

    public void resetPerfStats() {
        if (this.mNativeModulesMessageQueueThread != null) {
            this.mNativeModulesMessageQueueThread.resetPerfStats();
        }
        if (this.mJSMessageQueueThread != null) {
            this.mJSMessageQueueThread.resetPerfStats();
        }
    }

    public void setJSExceptionHandler(@Nullable JSExceptionHandler jSExceptionHandler) {
        this.mJSExceptionHandler = jSExceptionHandler;
    }

    public Object getSystemService(String name) {
        if ("layout_inflater".equals(name)) {
            if (this.mInflater == null) {
                this.mInflater = LayoutInflater.from((Context)this.getBaseContext()).cloneInContext((Context)this);
            }
            return this.mInflater;
        }
        return this.getBaseContext().getSystemService(name);
    }

    public abstract <T extends JavaScriptModule> T getJSModule(Class<T> var1);

    public abstract <T extends NativeModule> boolean hasNativeModule(Class<T> var1);

    public abstract Collection<NativeModule> getNativeModules();

    @Nullable
    public abstract <T extends NativeModule> T getNativeModule(Class<T> var1);

    @Nullable
    public abstract NativeModule getNativeModule(String var1);

    public void emitDeviceEvent(String eventName, @Nullable Object args) {
        RCTDeviceEventEmitter eventEmitter = this.getJSModule(RCTDeviceEventEmitter.class);
        if (eventEmitter != null) {
            eventEmitter.emit(eventName, args);
        }
    }

    public void emitDeviceEvent(String eventName) {
        this.emitDeviceEvent(eventName, null);
    }

    public abstract CatalystInstance getCatalystInstance();

    @Deprecated
    public abstract boolean hasActiveCatalystInstance();

    public abstract boolean hasActiveReactInstance();

    @Deprecated
    public abstract boolean hasCatalystInstance();

    public abstract boolean hasReactInstance();

    public LifecycleState getLifecycleState() {
        return this.mLifecycleState;
    }

    public void addLifecycleEventListener(final LifecycleEventListener listener) {
        this.mLifecycleEventListeners.add(listener);
        if (this.hasActiveReactInstance() || this.isBridgeless()) {
            switch (this.mLifecycleState) {
                case BEFORE_CREATE: 
                case BEFORE_RESUME: {
                    break;
                }
                case RESUMED: {
                    this.runOnUiQueueThread(new Runnable(){

                        @Override
                        public void run() {
                            if (!ReactContext.this.mLifecycleEventListeners.contains(listener)) {
                                return;
                            }
                            try {
                                listener.onHostResume();
                            }
                            catch (RuntimeException e) {
                                ReactContext.this.handleException(e);
                            }
                        }
                    });
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled lifecycle state.");
                }
            }
        }
    }

    public void removeLifecycleEventListener(LifecycleEventListener listener) {
        this.mLifecycleEventListeners.remove(listener);
    }

    public void addActivityEventListener(ActivityEventListener listener) {
        this.mActivityEventListeners.add(listener);
    }

    public void removeActivityEventListener(ActivityEventListener listener) {
        this.mActivityEventListeners.remove(listener);
    }

    public void addWindowFocusChangeListener(WindowFocusChangeListener listener) {
        this.mWindowFocusEventListeners.add(listener);
    }

    public void removeWindowFocusChangeListener(WindowFocusChangeListener listener) {
        this.mWindowFocusEventListeners.remove(listener);
    }

    @ThreadConfined(value="UI")
    public void onHostResume(@Nullable Activity activity) {
        this.mLifecycleState = LifecycleState.RESUMED;
        this.mCurrentActivity = new WeakReference<Activity>(activity);
        ReactMarker.logMarker(ReactMarkerConstants.ON_HOST_RESUME_START);
        for (LifecycleEventListener listener : this.mLifecycleEventListeners) {
            try {
                listener.onHostResume();
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
        ReactMarker.logMarker(ReactMarkerConstants.ON_HOST_RESUME_END);
    }

    @ThreadConfined(value="UI")
    public void onUserLeaveHint(@Nullable Activity activity) {
        ReactMarker.logMarker(ReactMarkerConstants.ON_USER_LEAVE_HINT_START);
        for (ActivityEventListener listener : this.mActivityEventListeners) {
            try {
                listener.onUserLeaveHint(activity);
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
        ReactMarker.logMarker(ReactMarkerConstants.ON_USER_LEAVE_HINT_END);
    }

    @ThreadConfined(value="UI")
    public void onNewIntent(@Nullable Activity activity, Intent intent) {
        UiThreadUtil.assertOnUiThread();
        this.mCurrentActivity = new WeakReference<Activity>(activity);
        for (ActivityEventListener listener : this.mActivityEventListeners) {
            try {
                listener.onNewIntent(intent);
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
    }

    @ThreadConfined(value="UI")
    public void onHostPause() {
        this.mLifecycleState = LifecycleState.BEFORE_RESUME;
        ReactMarker.logMarker(ReactMarkerConstants.ON_HOST_PAUSE_START);
        for (LifecycleEventListener listener : this.mLifecycleEventListeners) {
            try {
                listener.onHostPause();
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
        ReactMarker.logMarker(ReactMarkerConstants.ON_HOST_PAUSE_END);
    }

    @ThreadConfined(value="UI")
    public void onHostDestroy() {
        this.onHostDestroyImpl();
        this.mCurrentActivity = null;
    }

    @ThreadConfined(value="UI")
    public void onHostDestroy(boolean keepActivity) {
        if (!keepActivity) {
            this.onHostDestroy();
        } else {
            this.onHostDestroyImpl();
        }
    }

    @ThreadConfined(value="UI")
    private void onHostDestroyImpl() {
        UiThreadUtil.assertOnUiThread();
        this.mLifecycleState = LifecycleState.BEFORE_CREATE;
        for (LifecycleEventListener listener : this.mLifecycleEventListeners) {
            try {
                listener.onHostDestroy();
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
    }

    @ThreadConfined(value="UI")
    public abstract void destroy();

    public void onActivityResult(Activity activity, int requestCode, int resultCode, @Nullable Intent data) {
        for (ActivityEventListener listener : this.mActivityEventListeners) {
            try {
                listener.onActivityResult(activity, requestCode, resultCode, data);
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
    }

    @ThreadConfined(value="UI")
    public void onWindowFocusChange(boolean hasFocus) {
        UiThreadUtil.assertOnUiThread();
        for (WindowFocusChangeListener listener : this.mWindowFocusEventListeners) {
            try {
                listener.onWindowFocusChange(hasFocus);
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
    }

    public void assertOnUiQueueThread() {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mUiMessageQueueThread)).assertIsOnThread();
    }

    public boolean isOnUiQueueThread() {
        return ((MessageQueueThread)Assertions.assertNotNull((Object)this.mUiMessageQueueThread)).isOnThread();
    }

    public void runOnUiQueueThread(Runnable runnable) {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mUiMessageQueueThread)).runOnQueue(runnable);
    }

    public void assertOnNativeModulesQueueThread() {
        if (!this.mIsInitialized) {
            throw new IllegalStateException("Tried to call assertOnNativeModulesQueueThread() on an uninitialized ReactContext");
        }
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mNativeModulesMessageQueueThread)).assertIsOnThread();
    }

    public void assertOnNativeModulesQueueThread(String message) {
        if (!this.mIsInitialized) {
            throw new IllegalStateException("Tried to call assertOnNativeModulesQueueThread(message) on an uninitialized ReactContext");
        }
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mNativeModulesMessageQueueThread)).assertIsOnThread(message);
    }

    public boolean isOnNativeModulesQueueThread() {
        return ((MessageQueueThread)Assertions.assertNotNull((Object)this.mNativeModulesMessageQueueThread)).isOnThread();
    }

    public void runOnNativeModulesQueueThread(Runnable runnable) {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mNativeModulesMessageQueueThread)).runOnQueue(runnable);
    }

    public void assertOnJSQueueThread() {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mJSMessageQueueThread)).assertIsOnThread();
    }

    public boolean isOnJSQueueThread() {
        return ((MessageQueueThread)Assertions.assertNotNull((Object)this.mJSMessageQueueThread)).isOnThread();
    }

    public boolean runOnJSQueueThread(Runnable runnable) {
        return ((MessageQueueThread)Assertions.assertNotNull((Object)this.mJSMessageQueueThread)).runOnQueue(runnable);
    }

    @Nullable
    public MessageQueueThread getJSMessageQueueThread() {
        return this.mJSMessageQueueThread;
    }

    @Nullable
    public MessageQueueThread getNativeModulesMessageQueueThread() {
        return this.mNativeModulesMessageQueueThread;
    }

    @Nullable
    public MessageQueueThread getUiMessageQueueThread() {
        return this.mUiMessageQueueThread;
    }

    public abstract void handleException(Exception var1);

    public JSExceptionHandler getExceptionHandler() {
        if (this.mExceptionHandlerWrapper == null) {
            this.mExceptionHandlerWrapper = new ExceptionHandlerWrapper();
        }
        return this.mExceptionHandlerWrapper;
    }

    public JSExceptionHandler getJSExceptionHandler() {
        return this.mJSExceptionHandler;
    }

    public boolean hasCurrentActivity() {
        return this.mCurrentActivity != null && this.mCurrentActivity.get() != null;
    }

    public boolean startActivityForResult(Intent intent, int code, Bundle bundle) {
        Activity activity = this.getCurrentActivity();
        if (activity != null) {
            activity.startActivityForResult(intent, code, bundle);
            return true;
        }
        return false;
    }

    @Nullable
    public Activity getCurrentActivity() {
        if (this.mCurrentActivity == null) {
            return null;
        }
        return (Activity)this.mCurrentActivity.get();
    }

    @Deprecated
    public abstract boolean isBridgeless();

    @Nullable
    public abstract JavaScriptContextHolder getJavaScriptContextHolder();

    @Nullable
    public abstract CallInvokerHolder getJSCallInvokerHolder();

    @Deprecated(since="This method is deprecated, please use UIManagerHelper.getUIManager() instead.")
    @Nullable
    public abstract UIManager getFabricUIManager();

    @Nullable
    public abstract String getSourceURL();

    public abstract void registerSegment(int var1, String var2, Callback var3);

    public <T extends JavaScriptModule> void internal_registerInteropModule(Class<T> interopModuleInterface, Object interopModule) {
        if (this.mInteropModuleRegistry != null) {
            this.mInteropModuleRegistry.registerInteropModule(interopModuleInterface, interopModule);
        }
    }

    @DoNotStrip
    public static interface RCTDeviceEventEmitter
    extends JavaScriptModule {
        public void emit(@NonNull String var1, @Nullable Object var2);
    }

    public class ExceptionHandlerWrapper
    implements JSExceptionHandler {
        @Override
        public void handleException(Exception e) {
            ReactContext.this.handleException(e);
        }
    }
}

