/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.content.Context;
import android.content.res.AssetManager;
import com.facebook.react.bridge.JSBundleLoaderDelegate;
import com.facebook.react.common.DebugServerException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\t"}, d2={"Lcom/facebook/react/bridge/JSBundleLoader;", "", "<init>", "()V", "loadScript", "", "delegate", "Lcom/facebook/react/bridge/JSBundleLoaderDelegate;", "Companion", "ReactAndroid_release"})
public abstract class JSBundleLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract String loadScript(@NotNull JSBundleLoaderDelegate var1);

    @JvmStatic
    @NotNull
    public static final JSBundleLoader createAssetLoader(@NotNull Context context, @NotNull String assetUrl, boolean loadSynchronously) {
        return Companion.createAssetLoader(context, assetUrl, loadSynchronously);
    }

    @JvmStatic
    @NotNull
    public static final JSBundleLoader createFileLoader(@NotNull String fileName) {
        return Companion.createFileLoader(fileName);
    }

    @JvmStatic
    @NotNull
    public static final JSBundleLoader createFileLoader(@NotNull String fileName, @NotNull String assetUrl, boolean loadSynchronously) {
        return Companion.createFileLoader(fileName, assetUrl, loadSynchronously);
    }

    @JvmStatic
    @NotNull
    public static final JSBundleLoader createCachedBundleFromNetworkLoader(@NotNull String sourceURL, @NotNull String cachedFileLocation) {
        return Companion.createCachedBundleFromNetworkLoader(sourceURL, cachedFileLocation);
    }

    @JvmStatic
    @NotNull
    public static final JSBundleLoader createCachedSplitBundleFromNetworkLoader(@NotNull String sourceURL, @NotNull String cachedFileLocation) {
        return Companion.createCachedSplitBundleFromNetworkLoader(sourceURL, cachedFileLocation);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\tH\u0007J \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0007J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0007\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/bridge/JSBundleLoader$Companion;", "", "<init>", "()V", "createAssetLoader", "Lcom/facebook/react/bridge/JSBundleLoader;", "context", "Landroid/content/Context;", "assetUrl", "", "loadSynchronously", "", "createFileLoader", "fileName", "createCachedBundleFromNetworkLoader", "sourceURL", "cachedFileLocation", "createCachedSplitBundleFromNetworkLoader", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JSBundleLoader createAssetLoader(@NotNull Context context, @NotNull String assetUrl, boolean loadSynchronously) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)assetUrl, (String)"assetUrl");
            return new JSBundleLoader(context, assetUrl, loadSynchronously){
                final /* synthetic */ Context $context;
                final /* synthetic */ String $assetUrl;
                final /* synthetic */ boolean $loadSynchronously;
                {
                    this.$context = $context;
                    this.$assetUrl = $assetUrl;
                    this.$loadSynchronously = $loadSynchronously;
                }

                public String loadScript(JSBundleLoaderDelegate delegate) {
                    Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
                    AssetManager assetManager = this.$context.getAssets();
                    Intrinsics.checkNotNullExpressionValue((Object)assetManager, (String)"getAssets(...)");
                    delegate.loadScriptFromAssets(assetManager, this.$assetUrl, this.$loadSynchronously);
                    return this.$assetUrl;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final JSBundleLoader createFileLoader(@NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return this.createFileLoader(fileName, fileName, false);
        }

        @JvmStatic
        @NotNull
        public final JSBundleLoader createFileLoader(@NotNull String fileName, @NotNull String assetUrl, boolean loadSynchronously) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)assetUrl, (String)"assetUrl");
            return new JSBundleLoader(fileName, assetUrl, loadSynchronously){
                final /* synthetic */ String $fileName;
                final /* synthetic */ String $assetUrl;
                final /* synthetic */ boolean $loadSynchronously;
                {
                    this.$fileName = $fileName;
                    this.$assetUrl = $assetUrl;
                    this.$loadSynchronously = $loadSynchronously;
                }

                public String loadScript(JSBundleLoaderDelegate delegate) {
                    Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
                    delegate.loadScriptFromFile(this.$fileName, this.$assetUrl, this.$loadSynchronously);
                    return this.$fileName;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final JSBundleLoader createCachedBundleFromNetworkLoader(@NotNull String sourceURL, @NotNull String cachedFileLocation) {
            Intrinsics.checkNotNullParameter((Object)sourceURL, (String)"sourceURL");
            Intrinsics.checkNotNullParameter((Object)cachedFileLocation, (String)"cachedFileLocation");
            return new JSBundleLoader(cachedFileLocation, sourceURL){
                final /* synthetic */ String $cachedFileLocation;
                final /* synthetic */ String $sourceURL;
                {
                    this.$cachedFileLocation = $cachedFileLocation;
                    this.$sourceURL = $sourceURL;
                }

                public String loadScript(JSBundleLoaderDelegate delegate) {
                    String string2;
                    Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
                    try {
                        delegate.loadScriptFromFile(this.$cachedFileLocation, this.$sourceURL, false);
                        string2 = this.$sourceURL;
                    }
                    catch (Exception e) {
                        String string3 = e.getMessage();
                        if (string3 == null) {
                            string3 = "";
                        }
                        throw DebugServerException.Companion.makeGeneric(this.$sourceURL, string3, e);
                    }
                    return string2;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final JSBundleLoader createCachedSplitBundleFromNetworkLoader(@NotNull String sourceURL, @NotNull String cachedFileLocation) {
            Intrinsics.checkNotNullParameter((Object)sourceURL, (String)"sourceURL");
            Intrinsics.checkNotNullParameter((Object)cachedFileLocation, (String)"cachedFileLocation");
            return new JSBundleLoader(cachedFileLocation, sourceURL){
                final /* synthetic */ String $cachedFileLocation;
                final /* synthetic */ String $sourceURL;
                {
                    this.$cachedFileLocation = $cachedFileLocation;
                    this.$sourceURL = $sourceURL;
                }

                public String loadScript(JSBundleLoaderDelegate delegate) {
                    String string2;
                    Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
                    try {
                        delegate.loadSplitBundleFromFile(this.$cachedFileLocation, this.$sourceURL);
                        string2 = this.$sourceURL;
                    }
                    catch (Exception e) {
                        String string3 = e.getMessage();
                        if (string3 == null) {
                            string3 = "";
                        }
                        throw DebugServerException.Companion.makeGeneric(this.$sourceURL, string3, e);
                    }
                    return string2;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

