/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/facebook/react/bridge/DynamicFromObject;", "Lcom/facebook/react/bridge/Dynamic;", "value", "", "<init>", "(Ljava/lang/Object;)V", "recycle", "", "isNull", "", "()Z", "asBoolean", "asDouble", "", "asInt", "", "asString", "", "asArray", "Lcom/facebook/react/bridge/ReadableArray;", "asMap", "Lcom/facebook/react/bridge/ReadableMap;", "type", "Lcom/facebook/react/bridge/ReadableType;", "getType", "()Lcom/facebook/react/bridge/ReadableType;", "ReactAndroid_release"})
public final class DynamicFromObject
implements Dynamic {
    @Nullable
    private final Object value;

    public DynamicFromObject(@Nullable Object value) {
        this.value = value;
    }

    @Override
    public void recycle() {
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean asBoolean() {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        throw new ClassCastException("Dynamic value from Object is not a boolean");
    }

    @Override
    public double asDouble() {
        if (this.value instanceof Number) {
            Object object = this.value;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            return (Double)object;
        }
        throw new ClassCastException("Dynamic value from Object is not a number");
    }

    @Override
    public int asInt() {
        if (this.value instanceof Number) {
            Object object = this.value;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            return (int)((Double)object).doubleValue();
        }
        throw new ClassCastException("Dynamic value from Object is not a number");
    }

    @Override
    @NotNull
    public String asString() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        throw new ClassCastException("Dynamic value from Object is not a string");
    }

    @Override
    @NotNull
    public ReadableArray asArray() {
        if (this.value instanceof ReadableArray) {
            return (ReadableArray)this.value;
        }
        throw new ClassCastException("Dynamic value from Object is not a ReadableArray");
    }

    @Override
    @NotNull
    public ReadableMap asMap() {
        if (this.value instanceof ReadableMap) {
            return (ReadableMap)this.value;
        }
        throw new ClassCastException("Dynamic value from Object is not a ReadableMap");
    }

    @Override
    @NotNull
    public ReadableType getType() {
        ReadableType readableType;
        Object object = this.value;
        if (object == null) {
            readableType = ReadableType.Null;
        } else if (object instanceof Boolean) {
            readableType = ReadableType.Boolean;
        } else if (object instanceof Number) {
            readableType = ReadableType.Number;
        } else if (object instanceof String) {
            readableType = ReadableType.String;
        } else if (object instanceof ReadableMap) {
            readableType = ReadableType.Map;
        } else if (object instanceof ReadableArray) {
            readableType = ReadableType.Array;
        } else {
            FLog.e((String)"ReactNative", (String)("Unmapped object type " + this.value.getClass().getName()));
            readableType = ReadableType.Null;
        }
        return readableType;
    }
}

