/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import androidx.annotation.AnyThread;
import androidx.annotation.UiThread;
import com.facebook.fbreact.specs.NativeAnimatedModuleSpec;
import com.facebook.react.animated.AnimatedNodeValueListener;
import com.facebook.react.animated.NativeAnimatedModule;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableArrayBuilder;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapBuilder;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UIManagerListener;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.uimanager.GuardedFrameCallback;
import com.facebook.react.uimanager.NativeViewHierarchyManager;
import com.facebook.react.uimanager.UIBlock;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.common.ViewUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="NativeAnimatedModule")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008d\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\b\n\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005*\u00017\b\u0007\u0018\u0000 o2\u00020\u00012\u00020\u00022\u00020\u0003:\u0004lmnoB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0018J\b\u0010 \u001a\u00020\u001eH\u0016J\b\u0010!\u001a\u00020\u001eH\u0016J\u0014\u0010\"\u001a\u00020\u001e2\n\u0010#\u001a\u00060$R\u00020\u0000H\u0002J\u0014\u0010%\u001a\u00020\u001e2\n\u0010#\u001a\u00060$R\u00020\u0000H\u0002J\u0014\u0010&\u001a\u00020\u001e2\n\u0010#\u001a\u00060$R\u00020\u0000H\u0002J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)H\u0017J\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)H\u0017J\b\u0010.\u001a\u00020\u001eH\u0016J\b\u0010/\u001a\u00020\u001eH\u0016J\b\u00109\u001a\u00020\u001eH\u0002J\b\u0010:\u001a\u00020\u001eH\u0002J\u0010\u0010;\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0018H\u0002J\u0010\u0010<\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0018H\u0002J\b\u0010=\u001a\u00020\u001eH\u0016J\b\u0010>\u001a\u00020\u001eH\u0016J\u0018\u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0016J\u0018\u0010D\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010E\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010F\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010G\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020AH\u0016J\u0018\u0010H\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020A2\u0006\u0010I\u001a\u00020AH\u0016J\u0018\u0010J\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020A2\u0006\u0010I\u001a\u00020AH\u0016J\u0010\u0010K\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010L\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020AH\u0016J(\u0010M\u001a\u00020\u001e2\u0006\u0010N\u001a\u00020A2\u0006\u0010O\u001a\u00020A2\u0006\u0010P\u001a\u00020C2\u0006\u0010Q\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020\u001e2\u0006\u0010N\u001a\u00020AH\u0016J\u0018\u0010T\u001a\u00020\u001e2\u0006\u0010U\u001a\u00020A2\u0006\u0010V\u001a\u00020AH\u0016J\u0018\u0010W\u001a\u00020\u001e2\u0006\u0010U\u001a\u00020A2\u0006\u0010V\u001a\u00020AH\u0016J\u0018\u0010X\u001a\u00020\u001e2\u0006\u0010O\u001a\u00020A2\u0006\u0010Y\u001a\u00020AH\u0016J\u0018\u0010Z\u001a\u00020\u001e2\u0006\u0010O\u001a\u00020A2\u0006\u0010Y\u001a\u00020AH\u0016J\u0010\u0010[\u001a\u00020\u001e2\u0006\u0010O\u001a\u00020AH\u0016J \u0010\\\u001a\u00020\u001e2\u0006\u0010Y\u001a\u00020A2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020CH\u0016J \u0010`\u001a\u00020\u001e2\u0006\u0010Y\u001a\u00020A2\u0006\u0010]\u001a\u00020^2\u0006\u0010a\u001a\u00020AH\u0016J\u0010\u0010b\u001a\u00020\u001e2\u0006\u0010]\u001a\u00020^H\u0016J\u0010\u0010c\u001a\u00020\u001e2\u0006\u0010d\u001a\u00020AH\u0016J\u0018\u0010e\u001a\u00020\u001e2\u0006\u0010f\u001a\u00020A2\u0006\u0010g\u001a\u00020RH\u0016J\b\u0010h\u001a\u00020\u001eH\u0016J\u0010\u0010i\u001a\u00020\u001e2\u0006\u0010j\u001a\u00020kH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u00100\u001a\u0004\u0018\u00010\u000f2\b\u00100\u001a\u0004\u0018\u00010\u000f8F@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u000e\u00105\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00108\u00a8\u0006p"}, d2={"Lcom/facebook/react/animated/NativeAnimatedModule;", "Lcom/facebook/fbreact/specs/NativeAnimatedModuleSpec;", "Lcom/facebook/react/bridge/LifecycleEventListener;", "Lcom/facebook/react/bridge/UIManagerListener;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "reactChoreographer", "Lcom/facebook/react/modules/core/ReactChoreographer;", "operations", "Lcom/facebook/react/animated/NativeAnimatedModule$ConcurrentOperationQueue;", "preOperations", "nodesManagerRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/facebook/react/animated/NativeAnimatedNodesManager;", "batchingControlledByJS", "", "currentFrameNumber", "", "currentBatchNumber", "initializedForFabric", "initializedForNonFabric", "uiManagerType", "", "getUiManagerType$annotations", "()V", "numFabricAnimations", "numNonFabricAnimations", "userDrivenScrollEnded", "", "viewTag", "initialize", "onHostResume", "addOperation", "operation", "Lcom/facebook/react/animated/NativeAnimatedModule$UIThreadOperation;", "addUnbatchedOperation", "addPreOperation", "didScheduleMountItems", "uiManager", "Lcom/facebook/react/bridge/UIManager;", "willMountItems", "didMountItems", "didDispatchMountItems", "willDispatchViewUpdates", "onHostPause", "onHostDestroy", "nodesManager", "getNodesManager", "()Lcom/facebook/react/animated/NativeAnimatedNodesManager;", "setNodesManager", "(Lcom/facebook/react/animated/NativeAnimatedNodesManager;)V", "enqueuedAnimationOnFrame", "animatedFrameCallback", "com/facebook/react/animated/NativeAnimatedModule$animatedFrameCallback$1", "Lcom/facebook/react/animated/NativeAnimatedModule$animatedFrameCallback$1;", "clearFrameCallback", "enqueueFrameCallback", "initializeLifecycleEventListenersForViewTag", "decrementInFlightAnimationsForViewTag", "startOperationBatch", "finishOperationBatch", "createAnimatedNode", "tagDouble", "", "config", "Lcom/facebook/react/bridge/ReadableMap;", "updateAnimatedNodeConfig", "startListeningToAnimatedNodeValue", "stopListeningToAnimatedNodeValue", "dropAnimatedNode", "setAnimatedNodeValue", "value", "setAnimatedNodeOffset", "flattenAnimatedNodeOffset", "extractAnimatedNodeOffset", "startAnimatingNode", "animationIdDouble", "animatedNodeTagDouble", "animationConfig", "endCallback", "Lcom/facebook/react/bridge/Callback;", "stopAnimation", "connectAnimatedNodes", "parentNodeTagDouble", "childNodeTagDouble", "disconnectAnimatedNodes", "connectAnimatedNodeToView", "viewTagDouble", "disconnectAnimatedNodeFromView", "restoreDefaultValues", "addAnimatedEventToView", "eventName", "", "eventMapping", "removeAnimatedEventFromView", "animatedValueTagDouble", "addListener", "removeListeners", "count", "getValue", "animatedValueNodeTagDouble", "callback", "invalidate", "queueAndExecuteBatchedOperations", "opsAndArgs", "Lcom/facebook/react/bridge/ReadableArray;", "BatchExecutionOpCodes", "UIThreadOperation", "ConcurrentOperationQueue", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nNativeAnimatedModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeAnimatedModule.kt\ncom/facebook/react/animated/NativeAnimatedModule\n+ 2 ReadableMapBuilder.kt\ncom/facebook/react/bridge/ReadableMapBuilderKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1055:1\n30#2,3:1056\n30#2,3:1061\n1869#3,2:1059\n*S KotlinDebug\n*F\n+ 1 NativeAnimatedModule.kt\ncom/facebook/react/animated/NativeAnimatedModule\n*L\n233#1:1056,3\n526#1:1061,3\n233#1:1059,2\n*E\n"})
public final class NativeAnimatedModule
extends NativeAnimatedModuleSpec
implements LifecycleEventListener,
UIManagerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactChoreographer reactChoreographer;
    @NotNull
    private final ConcurrentOperationQueue operations;
    @NotNull
    private final ConcurrentOperationQueue preOperations;
    @NotNull
    private final AtomicReference<NativeAnimatedNodesManager> nodesManagerRef;
    private boolean batchingControlledByJS;
    private volatile long currentFrameNumber;
    private volatile long currentBatchNumber;
    private boolean initializedForFabric;
    private boolean initializedForNonFabric;
    private int uiManagerType;
    private int numFabricAnimations;
    private int numNonFabricAnimations;
    private boolean enqueuedAnimationOnFrame;
    @NotNull
    private final animatedFrameCallback.1 animatedFrameCallback;
    @NotNull
    public static final String NAME = "NativeAnimatedModule";
    public static final boolean ANIMATED_MODULE_DEBUG = false;

    public NativeAnimatedModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super(reactContext);
        this.reactChoreographer = ReactChoreographer.Companion.getInstance();
        this.operations = new ConcurrentOperationQueue();
        this.preOperations = new ConcurrentOperationQueue();
        this.nodesManagerRef = new AtomicReference();
        this.uiManagerType = 1;
        this.animatedFrameCallback = new GuardedFrameCallback(reactContext, this){
            final /* synthetic */ NativeAnimatedModule this$0;
            {
                this.this$0 = $receiver;
                super($reactContext);
            }

            protected void doFrameGuarded(long frameTimeNanos) {
                try {
                    NativeAnimatedModule.access$setEnqueuedAnimationOnFrame$p(this.this$0, false);
                    NativeAnimatedNodesManager nativeAnimatedNodesManager = this.this$0.getNodesManager();
                    if (nativeAnimatedNodesManager == null) {
                        return;
                    }
                    NativeAnimatedNodesManager nodesManager = nativeAnimatedNodesManager;
                    if (nodesManager.hasActiveAnimations()) {
                        nodesManager.runUpdates(frameTimeNanos);
                    }
                    NativeAnimatedModule.access$enqueueFrameCallback(this.this$0);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    private static /* synthetic */ void getUiManagerType$annotations() {
    }

    public final void userDrivenScrollEnded(int viewTag) {
        block2: {
            ReactApplicationContext reactApplicationContext;
            ReadableMapBuilder readableMapBuilder;
            NativeAnimatedNodesManager nativeAnimatedNodesManager = this.nodesManagerRef.get();
            if (nativeAnimatedNodesManager == null) {
                return;
            }
            NativeAnimatedNodesManager nodeManager = nativeAnimatedNodesManager;
            Set<Integer> tags = nodeManager.getTagsOfConnectedNodes$ReactAndroid_release(viewTag, "topScrollEnded");
            if (tags.isEmpty()) {
                return;
            }
            boolean $i$f$buildReadableMap = false;
            WritableMap writableMap = Arguments.createMap();
            Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
            WritableMap map$iv = writableMap;
            ReadableMapBuilder $this$userDrivenScrollEnded_u24lambda_u242 = readableMapBuilder = new ReadableMapBuilder(map$iv);
            boolean bl = false;
            $this$userDrivenScrollEnded_u24lambda_u242.putArray("tags", (Function1<? super ReadableArrayBuilder, Unit>)((Function1)arg_0 -> NativeAnimatedModule.userDrivenScrollEnded$lambda$2$lambda$1(tags, arg_0)));
            ReadableMap onAnimationEndedData = map$iv;
            ReactApplicationContext reactApplicationContext2 = reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext2 == null) break block2;
            reactApplicationContext2.emitDeviceEvent("onUserDrivenAnimationEnded", onAnimationEndedData);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getReactApplicationContext().addLifecycleEventListener(this);
    }

    @Override
    public void onHostResume() {
        this.enqueueFrameCallback();
    }

    private final void addOperation(UIThreadOperation operation) {
        operation.setBatchNumber(this.currentBatchNumber);
        this.operations.add(operation);
    }

    private final void addUnbatchedOperation(UIThreadOperation operation) {
        operation.setBatchNumber(-1L);
        this.operations.add(operation);
    }

    private final void addPreOperation(UIThreadOperation operation) {
        operation.setBatchNumber(this.currentBatchNumber);
        this.preOperations.add(operation);
    }

    @Override
    public void didScheduleMountItems(@NotNull UIManager uiManager) {
        Intrinsics.checkNotNullParameter((Object)uiManager, (String)"uiManager");
        long l = this.currentFrameNumber;
        this.currentFrameNumber = l + 1L;
    }

    @Override
    public void willMountItems(@NotNull UIManager uiManager) {
        Intrinsics.checkNotNullParameter((Object)uiManager, (String)"uiManager");
    }

    @Override
    public void didMountItems(@NotNull UIManager uiManager) {
        Intrinsics.checkNotNullParameter((Object)uiManager, (String)"uiManager");
    }

    @Override
    @UiThread
    public void didDispatchMountItems(@NotNull UIManager uiManager) {
        Intrinsics.checkNotNullParameter((Object)uiManager, (String)"uiManager");
        if (this.uiManagerType != 2) {
            return;
        }
        long batchNumber = this.currentBatchNumber - 1L;
        if (!this.batchingControlledByJS) {
            long l = this.currentFrameNumber;
            this.currentFrameNumber = l + 1L;
            if (this.currentFrameNumber - this.currentBatchNumber > 2L) {
                batchNumber = this.currentBatchNumber = this.currentFrameNumber;
            }
        }
        this.preOperations.executeBatch(batchNumber, this.getNodesManager());
        this.operations.executeBatch(batchNumber, this.getNodesManager());
    }

    @Override
    @UiThread
    public void willDispatchViewUpdates(@NotNull UIManager uiManager) {
        Intrinsics.checkNotNullParameter((Object)uiManager, (String)"uiManager");
        if (this.operations.isEmpty() && this.preOperations.isEmpty()) {
            return;
        }
        if (this.uiManagerType == 2 || ReactBuildConfig.UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE) {
            return;
        }
        long l = this.currentBatchNumber;
        this.currentBatchNumber = l + 1L;
        long frameNo = l;
        UIBlock preOperationsUIBlock = arg_0 -> NativeAnimatedModule.willDispatchViewUpdates$lambda$3(this, frameNo, arg_0);
        UIBlock operationsUIBlock = arg_0 -> NativeAnimatedModule.willDispatchViewUpdates$lambda$4(this, frameNo, arg_0);
        boolean bl = uiManager instanceof UIManagerModule;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        UIManagerModule uiManagerModule = (UIManagerModule)uiManager;
        uiManagerModule.prependUIBlock(preOperationsUIBlock);
        uiManagerModule.addUIBlock(operationsUIBlock);
    }

    @Override
    public void onHostPause() {
        this.clearFrameCallback();
    }

    @Override
    public void onHostDestroy() {
        this.clearFrameCallback();
    }

    @Nullable
    public final NativeAnimatedNodesManager getNodesManager() {
        ReactApplicationContext reactApplicationContext;
        if (this.nodesManagerRef.get() == null && (reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn()) != null) {
            this.nodesManagerRef.compareAndSet(null, new NativeAnimatedNodesManager(reactApplicationContext));
        }
        return this.nodesManagerRef.get();
    }

    @VisibleForTesting
    public final void setNodesManager(@Nullable NativeAnimatedNodesManager nodesManager) {
        this.nodesManagerRef.set(nodesManager);
    }

    private final void clearFrameCallback() {
        this.reactChoreographer.removeFrameCallback(ReactChoreographer.CallbackType.NATIVE_ANIMATED_MODULE, this.animatedFrameCallback);
        this.enqueuedAnimationOnFrame = false;
    }

    private final void enqueueFrameCallback() {
        if (!this.enqueuedAnimationOnFrame) {
            this.reactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.NATIVE_ANIMATED_MODULE, this.animatedFrameCallback);
            this.enqueuedAnimationOnFrame = true;
        }
    }

    private final void initializeLifecycleEventListenersForViewTag(int viewTag) {
        UIManager uiManager;
        boolean initialized;
        this.uiManagerType = ViewUtil.getUIManagerType(viewTag);
        if (this.uiManagerType == 2) {
            var2_2 = this.numFabricAnimations;
            this.numFabricAnimations = var2_2 + 1;
        } else {
            var2_2 = this.numNonFabricAnimations;
            this.numNonFabricAnimations = var2_2 + 1;
        }
        NativeAnimatedNodesManager nodesManager = this.getNodesManager();
        if (nodesManager != null) {
            nodesManager.initializeEventListenerForUIManagerType(this.uiManagerType);
        } else {
            ReactSoftExceptionLogger.logSoftException(NAME, new RuntimeException("initializeLifecycleEventListenersForViewTag could not get NativeAnimatedNodesManager"));
        }
        boolean bl = initialized = this.uiManagerType == 2 ? this.initializedForFabric : this.initializedForNonFabric;
        if (initialized) {
            return;
        }
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
        if (reactApplicationContext != null && (uiManager = UIManagerHelper.getUIManager(reactApplicationContext, this.uiManagerType)) != null) {
            uiManager.addUIManagerEventListener(this);
            if (this.uiManagerType == 2) {
                this.initializedForFabric = true;
            } else {
                this.initializedForNonFabric = true;
            }
        }
    }

    private final void decrementInFlightAnimationsForViewTag(int viewTag) {
        int animationManagerType = ViewUtil.getUIManagerType(viewTag);
        if (animationManagerType == 2) {
            int n = this.numFabricAnimations;
            this.numFabricAnimations = n + -1;
        } else {
            int n = this.numNonFabricAnimations;
            this.numNonFabricAnimations = n + -1;
        }
        if (this.numNonFabricAnimations == 0 && this.numFabricAnimations > 0 && this.uiManagerType != 2) {
            this.uiManagerType = 2;
        } else if (this.numFabricAnimations == 0 && this.numNonFabricAnimations > 0 && this.uiManagerType != 1) {
            this.uiManagerType = 1;
        }
    }

    @Override
    public void startOperationBatch() {
        this.batchingControlledByJS = true;
        long l = this.currentBatchNumber;
        this.currentBatchNumber = l + 1L;
    }

    @Override
    public void finishOperationBatch() {
        this.batchingControlledByJS = false;
        long l = this.currentBatchNumber;
        this.currentBatchNumber = l + 1L;
    }

    @Override
    public void createAnimatedNode(double tagDouble, @NotNull ReadableMap config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        int tag = (int)tagDouble;
        this.addOperation(new UIThreadOperation(this, tag, config){
            final /* synthetic */ int $tag;
            final /* synthetic */ ReadableMap $config;
            {
                this.$tag = $tag;
                this.$config = $config;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.createAnimatedNode(this.$tag, this.$config);
            }
        });
    }

    @Override
    public void updateAnimatedNodeConfig(double tagDouble, @NotNull ReadableMap config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        int tag = (int)tagDouble;
        this.addOperation(new UIThreadOperation(this, tag, config){
            final /* synthetic */ int $tag;
            final /* synthetic */ ReadableMap $config;
            {
                this.$tag = $tag;
                this.$config = $config;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.updateAnimatedNodeConfig(this.$tag, this.$config);
            }
        });
    }

    @Override
    public void startListeningToAnimatedNodeValue(double tagDouble) {
        int tag = (int)tagDouble;
        AnimatedNodeValueListener listener = (arg_0, arg_1) -> NativeAnimatedModule.startListeningToAnimatedNodeValue$lambda$6(this, tag, arg_0, arg_1);
        this.addOperation(new UIThreadOperation(this, tag, listener){
            final /* synthetic */ int $tag;
            final /* synthetic */ AnimatedNodeValueListener $listener;
            {
                this.$tag = $tag;
                this.$listener = $listener;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.startListeningToAnimatedNodeValue(this.$tag, this.$listener);
            }
        });
    }

    @Override
    public void stopListeningToAnimatedNodeValue(double tagDouble) {
        int tag = (int)tagDouble;
        this.addOperation(new UIThreadOperation(this, tag){
            final /* synthetic */ int $tag;
            {
                this.$tag = $tag;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.stopListeningToAnimatedNodeValue(this.$tag);
            }
        });
    }

    @Override
    public void dropAnimatedNode(double tagDouble) {
        int tag = (int)tagDouble;
        this.addOperation(new UIThreadOperation(this, tag){
            final /* synthetic */ int $tag;
            {
                this.$tag = $tag;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.dropAnimatedNode(this.$tag);
            }
        });
    }

    @Override
    public void setAnimatedNodeValue(double tagDouble, double value) {
        int tag = (int)tagDouble;
        this.addOperation(new UIThreadOperation(this, tag, value){
            final /* synthetic */ int $tag;
            final /* synthetic */ double $value;
            {
                this.$tag = $tag;
                this.$value = $value;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.setAnimatedNodeValue(this.$tag, this.$value);
            }
        });
    }

    @Override
    public void setAnimatedNodeOffset(double tagDouble, double value) {
        int tag = (int)tagDouble;
        this.addOperation(new UIThreadOperation(this, tag, value){
            final /* synthetic */ int $tag;
            final /* synthetic */ double $value;
            {
                this.$tag = $tag;
                this.$value = $value;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.setAnimatedNodeOffset(this.$tag, this.$value);
            }
        });
    }

    @Override
    public void flattenAnimatedNodeOffset(double tagDouble) {
        int tag = (int)tagDouble;
        this.addOperation(new UIThreadOperation(this, tag){
            final /* synthetic */ int $tag;
            {
                this.$tag = $tag;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.flattenAnimatedNodeOffset(this.$tag);
            }
        });
    }

    @Override
    public void extractAnimatedNodeOffset(double tagDouble) {
        int tag = (int)tagDouble;
        this.addOperation(new UIThreadOperation(this, tag){
            final /* synthetic */ int $tag;
            {
                this.$tag = $tag;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.extractAnimatedNodeOffset(this.$tag);
            }
        });
    }

    @Override
    public void startAnimatingNode(double animationIdDouble, double animatedNodeTagDouble, @NotNull ReadableMap animationConfig, @NotNull Callback endCallback) {
        Intrinsics.checkNotNullParameter((Object)animationConfig, (String)"animationConfig");
        Intrinsics.checkNotNullParameter((Object)endCallback, (String)"endCallback");
        int animationId = (int)animationIdDouble;
        int animatedNodeTag = (int)animatedNodeTagDouble;
        this.addUnbatchedOperation(new UIThreadOperation(this, animationId, animatedNodeTag, animationConfig, endCallback){
            final /* synthetic */ int $animationId;
            final /* synthetic */ int $animatedNodeTag;
            final /* synthetic */ ReadableMap $animationConfig;
            final /* synthetic */ Callback $endCallback;
            {
                this.$animationId = $animationId;
                this.$animatedNodeTag = $animatedNodeTag;
                this.$animationConfig = $animationConfig;
                this.$endCallback = $endCallback;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.startAnimatingNode(this.$animationId, this.$animatedNodeTag, this.$animationConfig, this.$endCallback);
            }
        });
    }

    @Override
    public void stopAnimation(double animationIdDouble) {
        int animationId = (int)animationIdDouble;
        this.addOperation(new UIThreadOperation(this, animationId){
            final /* synthetic */ int $animationId;
            {
                this.$animationId = $animationId;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.stopAnimation(this.$animationId);
            }
        });
    }

    @Override
    public void connectAnimatedNodes(double parentNodeTagDouble, double childNodeTagDouble) {
        int parentNodeTag = (int)parentNodeTagDouble;
        int childNodeTag = (int)childNodeTagDouble;
        this.addOperation(new UIThreadOperation(this, parentNodeTag, childNodeTag){
            final /* synthetic */ int $parentNodeTag;
            final /* synthetic */ int $childNodeTag;
            {
                this.$parentNodeTag = $parentNodeTag;
                this.$childNodeTag = $childNodeTag;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.connectAnimatedNodes(this.$parentNodeTag, this.$childNodeTag);
            }
        });
    }

    @Override
    public void disconnectAnimatedNodes(double parentNodeTagDouble, double childNodeTagDouble) {
        int parentNodeTag = (int)parentNodeTagDouble;
        int childNodeTag = (int)childNodeTagDouble;
        this.addOperation(new UIThreadOperation(this, parentNodeTag, childNodeTag){
            final /* synthetic */ int $parentNodeTag;
            final /* synthetic */ int $childNodeTag;
            {
                this.$parentNodeTag = $parentNodeTag;
                this.$childNodeTag = $childNodeTag;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.disconnectAnimatedNodes(this.$parentNodeTag, this.$childNodeTag);
            }
        });
    }

    @Override
    public void connectAnimatedNodeToView(double animatedNodeTagDouble, double viewTagDouble) {
        int animatedNodeTag = (int)animatedNodeTagDouble;
        int viewTag = (int)viewTagDouble;
        this.initializeLifecycleEventListenersForViewTag(viewTag);
        this.addOperation(new UIThreadOperation(this, animatedNodeTag, viewTag){
            final /* synthetic */ int $animatedNodeTag;
            final /* synthetic */ int $viewTag;
            {
                this.$animatedNodeTag = $animatedNodeTag;
                this.$viewTag = $viewTag;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.connectAnimatedNodeToView(this.$animatedNodeTag, this.$viewTag);
            }
        });
    }

    @Override
    public void disconnectAnimatedNodeFromView(double animatedNodeTagDouble, double viewTagDouble) {
        int animatedNodeTag = (int)animatedNodeTagDouble;
        int viewTag = (int)viewTagDouble;
        this.decrementInFlightAnimationsForViewTag(viewTag);
        this.addOperation(new UIThreadOperation(this, animatedNodeTag, viewTag){
            final /* synthetic */ int $animatedNodeTag;
            final /* synthetic */ int $viewTag;
            {
                this.$animatedNodeTag = $animatedNodeTag;
                this.$viewTag = $viewTag;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.disconnectAnimatedNodeFromView(this.$animatedNodeTag, this.$viewTag);
            }
        });
    }

    @Override
    public void restoreDefaultValues(double animatedNodeTagDouble) {
        int animatedNodeTag = (int)animatedNodeTagDouble;
        this.addPreOperation(new UIThreadOperation(this, animatedNodeTag){
            final /* synthetic */ int $animatedNodeTag;
            {
                this.$animatedNodeTag = $animatedNodeTag;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.restoreDefaultValues(this.$animatedNodeTag);
            }
        });
    }

    @Override
    public void addAnimatedEventToView(double viewTagDouble, @NotNull String eventName, @NotNull ReadableMap eventMapping) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter((Object)eventMapping, (String)"eventMapping");
        int viewTag = (int)viewTagDouble;
        this.initializeLifecycleEventListenersForViewTag(viewTag);
        this.addOperation(new UIThreadOperation(this, viewTag, eventName, eventMapping){
            final /* synthetic */ int $viewTag;
            final /* synthetic */ String $eventName;
            final /* synthetic */ ReadableMap $eventMapping;
            {
                this.$viewTag = $viewTag;
                this.$eventName = $eventName;
                this.$eventMapping = $eventMapping;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.addAnimatedEventToView(this.$viewTag, this.$eventName, this.$eventMapping);
            }
        });
    }

    @Override
    public void removeAnimatedEventFromView(double viewTagDouble, @NotNull String eventName, double animatedValueTagDouble) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        int viewTag = (int)viewTagDouble;
        int animatedValueTag = (int)animatedValueTagDouble;
        this.decrementInFlightAnimationsForViewTag(viewTag);
        this.addOperation(new UIThreadOperation(this, viewTag, eventName, animatedValueTag){
            final /* synthetic */ int $viewTag;
            final /* synthetic */ String $eventName;
            final /* synthetic */ int $animatedValueTag;
            {
                this.$viewTag = $viewTag;
                this.$eventName = $eventName;
                this.$animatedValueTag = $animatedValueTag;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.removeAnimatedEventFromView(this.$viewTag, this.$eventName, this.$animatedValueTag);
            }
        });
    }

    @Override
    public void addListener(@NotNull String eventName) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
    }

    @Override
    public void removeListeners(double count) {
    }

    @Override
    public void getValue(double animatedValueNodeTagDouble, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        int animatedValueNodeTag = (int)animatedValueNodeTagDouble;
        this.addOperation(new UIThreadOperation(this, animatedValueNodeTag, callback){
            final /* synthetic */ int $animatedValueNodeTag;
            final /* synthetic */ Callback $callback;
            {
                this.$animatedValueNodeTag = $animatedValueNodeTag;
                this.$callback = $callback;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                animatedNodesManager.getValue(this.$animatedValueNodeTag, this.$callback);
            }
        });
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.getReactApplicationContext().removeLifecycleEventListener(this);
    }

    @Override
    public void queueAndExecuteBatchedOperations(@NotNull ReadableArray opsAndArgs) {
        Intrinsics.checkNotNullParameter((Object)opsAndArgs, (String)"opsAndArgs");
        int opBufferSize = opsAndArgs.size();
        int i = 0;
        block7: while (i < opBufferSize) {
            BatchExecutionOpCodes command = BatchExecutionOpCodes.Companion.fromId(opsAndArgs.getInt(i++));
            switch (WhenMappings.$EnumSwitchMapping$0[command.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    ++i;
                    continue block7;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    i += 2;
                    continue block7;
                }
                case 18: 
                case 19: {
                    i += 3;
                    continue block7;
                }
                case 20: {
                    int n = ++i;
                    ++i;
                    this.initializeLifecycleEventListenersForViewTag(opsAndArgs.getInt(n));
                    continue block7;
                }
                case 21: {
                    this.initializeLifecycleEventListenersForViewTag(opsAndArgs.getInt(i++));
                    ++i;
                    ++i;
                    continue block7;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        this.startOperationBatch();
        this.addUnbatchedOperation(new UIThreadOperation(this, opBufferSize, opsAndArgs){
            final /* synthetic */ NativeAnimatedModule this$0;
            final /* synthetic */ int $opBufferSize;
            final /* synthetic */ ReadableArray $opsAndArgs;
            {
                this.this$0 = $receiver;
                this.$opBufferSize = $opBufferSize;
                this.$opsAndArgs = $opsAndArgs;
            }

            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                Intrinsics.checkNotNullParameter((Object)animatedNodesManager, (String)"animatedNodesManager");
                ReactApplicationContext reactApplicationContext = NativeAnimatedModule.access$getReactApplicationContextIfActiveOrWarn(this.this$0);
                int viewTag = -1;
                int i = 0;
                block22: while (i < this.$opBufferSize) {
                    BatchExecutionOpCodes command = BatchExecutionOpCodes.Companion.fromId(this.$opsAndArgs.getInt(i++));
                    switch (queueAndExecuteBatchedOperations.WhenMappings.$EnumSwitchMapping$0[command.ordinal()]) {
                        case 1: {
                            String string2;
                            int n = i++;
                            ReadableMap readableMap = this.$opsAndArgs.getMap(i++);
                            if (readableMap == null) {
                                string2 = "Required value was null.";
                                throw new IllegalStateException(string2.toString());
                            }
                            animatedNodesManager.createAnimatedNode(this.$opsAndArgs.getInt(n), readableMap);
                            continue block22;
                        }
                        case 2: {
                            String string2;
                            int n = i++;
                            ReadableMap readableMap = this.$opsAndArgs.getMap(i++);
                            if (readableMap == null) {
                                string2 = "Required value was null.";
                                throw new IllegalStateException(string2.toString());
                            }
                            animatedNodesManager.updateAnimatedNodeConfig(this.$opsAndArgs.getInt(n), readableMap);
                            continue block22;
                        }
                        case 3: {
                            animatedNodesManager.getValue(this.$opsAndArgs.getInt(i++), null);
                            continue block22;
                        }
                        case 4: {
                            int tag = this.$opsAndArgs.getInt(i++);
                            AnimatedNodeValueListener listener = (arg_0, arg_1) -> queueAndExecuteBatchedOperations.1.execute$lambda$1(this.this$0, tag, arg_0, arg_1);
                            animatedNodesManager.startListeningToAnimatedNodeValue(tag, listener);
                            continue block22;
                        }
                        case 5: {
                            animatedNodesManager.stopListeningToAnimatedNodeValue(this.$opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case 6: {
                            animatedNodesManager.connectAnimatedNodes(this.$opsAndArgs.getInt(i++), this.$opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case 7: {
                            animatedNodesManager.disconnectAnimatedNodes(this.$opsAndArgs.getInt(i++), this.$opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case 8: {
                            String string2;
                            int n = i++;
                            int n2 = i++;
                            ReadableMap readableMap = this.$opsAndArgs.getMap(i++);
                            if (readableMap == null) {
                                string2 = "Required value was null.";
                                throw new IllegalStateException(string2.toString());
                            }
                            animatedNodesManager.startAnimatingNode(this.$opsAndArgs.getInt(n), this.$opsAndArgs.getInt(n2), readableMap, null);
                            continue block22;
                        }
                        case 9: {
                            animatedNodesManager.stopAnimation(this.$opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case 10: {
                            animatedNodesManager.setAnimatedNodeValue(this.$opsAndArgs.getInt(i++), this.$opsAndArgs.getDouble(i++));
                            continue block22;
                        }
                        case 11: {
                            animatedNodesManager.setAnimatedNodeOffset(this.$opsAndArgs.getInt(i++), this.$opsAndArgs.getDouble(i++));
                            continue block22;
                        }
                        case 12: {
                            animatedNodesManager.flattenAnimatedNodeOffset(this.$opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case 13: {
                            animatedNodesManager.extractAnimatedNodeOffset(this.$opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case 14: {
                            animatedNodesManager.connectAnimatedNodeToView(this.$opsAndArgs.getInt(i++), this.$opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case 15: {
                            int animatedNodeTag = this.$opsAndArgs.getInt(i++);
                            viewTag = this.$opsAndArgs.getInt(i++);
                            NativeAnimatedModule.access$decrementInFlightAnimationsForViewTag(this.this$0, viewTag);
                            animatedNodesManager.disconnectAnimatedNodeFromView(animatedNodeTag, viewTag);
                            continue block22;
                        }
                        case 16: {
                            animatedNodesManager.restoreDefaultValues(this.$opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case 17: {
                            animatedNodesManager.dropAnimatedNode(this.$opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case 18: {
                            String string2;
                            int n = i++;
                            String string3 = this.$opsAndArgs.getString(i++);
                            if (string3 == null) {
                                string2 = "Required value was null.";
                                throw new IllegalStateException(string2.toString());
                            }
                            ReadableMap readableMap = this.$opsAndArgs.getMap(i++);
                            if (readableMap == null) {
                                string2 = "Required value was null.";
                                throw new IllegalStateException(string2.toString());
                            }
                            animatedNodesManager.addAnimatedEventToView(this.$opsAndArgs.getInt(n), string3, readableMap);
                            continue block22;
                        }
                        case 19: {
                            String string2;
                            viewTag = this.$opsAndArgs.getInt(i++);
                            NativeAnimatedModule.access$decrementInFlightAnimationsForViewTag(this.this$0, viewTag);
                            String string4 = this.$opsAndArgs.getString(i++);
                            if (string4 == null) {
                                string2 = "Required value was null.";
                                throw new IllegalStateException(string2.toString());
                            }
                            animatedNodesManager.removeAnimatedEventFromView(viewTag, string4, this.$opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case 20: 
                        case 21: {
                            ++i;
                            continue block22;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
            }

            private static final void execute$lambda$1(NativeAnimatedModule this$0, int $tag, double value, double offset) {
                block0: {
                    ReactApplicationContext reactApplicationContext;
                    ReadableMapBuilder readableMapBuilder;
                    boolean $i$f$buildReadableMap = false;
                    WritableMap writableMap = Arguments.createMap();
                    Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
                    WritableMap map$iv = writableMap;
                    ReadableMapBuilder $this$execute_u24lambda_u241_u24lambda_u240 = readableMapBuilder = new ReadableMapBuilder(map$iv);
                    boolean bl = false;
                    $this$execute_u24lambda_u241_u24lambda_u240.put("tag", $tag);
                    $this$execute_u24lambda_u241_u24lambda_u240.put("value", value);
                    $this$execute_u24lambda_u241_u24lambda_u240.put("offset", offset);
                    ReadableMap onAnimatedValueData = map$iv;
                    ReactApplicationContext reactApplicationContext2 = reactApplicationContext = NativeAnimatedModule.access$getReactApplicationContextIfActiveOrWarn(this$0);
                    if (reactApplicationContext2 == null) break block0;
                    reactApplicationContext2.emitDeviceEvent("onAnimatedValueUpdate", onAnimatedValueData);
                }
            }
        });
        this.finishOperationBatch();
    }

    private static final Unit userDrivenScrollEnded$lambda$2$lambda$1(Set $tags, ReadableArrayBuilder $this$putArray) {
        Intrinsics.checkNotNullParameter((Object)$this$putArray, (String)"$this$putArray");
        Iterable $this$forEach$iv = $tags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            $this$putArray.add(it);
        }
        return Unit.INSTANCE;
    }

    private static final void willDispatchViewUpdates$lambda$3(NativeAnimatedModule this$0, long $frameNo, NativeViewHierarchyManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.preOperations.executeBatch($frameNo, this$0.getNodesManager());
    }

    private static final void willDispatchViewUpdates$lambda$4(NativeAnimatedModule this$0, long $frameNo, NativeViewHierarchyManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.operations.executeBatch($frameNo, this$0.getNodesManager());
    }

    private static final void startListeningToAnimatedNodeValue$lambda$6(NativeAnimatedModule this$0, int $tag, double value, double offset) {
        block0: {
            ReactApplicationContext reactApplicationContext;
            ReadableMapBuilder readableMapBuilder;
            boolean $i$f$buildReadableMap = false;
            WritableMap writableMap = Arguments.createMap();
            Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
            WritableMap map$iv = writableMap;
            ReadableMapBuilder $this$startListeningToAnimatedNodeValue_u24lambda_u246_u24lambda_u245 = readableMapBuilder = new ReadableMapBuilder(map$iv);
            boolean bl = false;
            $this$startListeningToAnimatedNodeValue_u24lambda_u246_u24lambda_u245.put("tag", $tag);
            $this$startListeningToAnimatedNodeValue_u24lambda_u246_u24lambda_u245.put("value", value);
            $this$startListeningToAnimatedNodeValue_u24lambda_u246_u24lambda_u245.put("offset", offset);
            ReadableMap onAnimatedValueData = map$iv;
            ReactApplicationContext reactApplicationContext2 = reactApplicationContext = this$0.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext2 == null) break block0;
            reactApplicationContext2.emitDeviceEvent("onAnimatedValueUpdate", onAnimatedValueData);
        }
    }

    public static final /* synthetic */ ReactApplicationContext access$getReactApplicationContextIfActiveOrWarn(NativeAnimatedModule $this) {
        return $this.getReactApplicationContextIfActiveOrWarn();
    }

    public static final /* synthetic */ void access$decrementInFlightAnimationsForViewTag(NativeAnimatedModule $this, int viewTag) {
        $this.decrementInFlightAnimationsForViewTag(viewTag);
    }

    public static final /* synthetic */ void access$setEnqueuedAnimationOnFrame$p(NativeAnimatedModule $this, boolean bl) {
        $this.enqueuedAnimationOnFrame = bl;
    }

    public static final /* synthetic */ void access$enqueueFrameCallback(NativeAnimatedModule $this) {
        $this.enqueueFrameCallback();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0019\b\u0082\u0081\u0002\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001bB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001a\u00a8\u0006\u001c"}, d2={"Lcom/facebook/react/animated/NativeAnimatedModule$BatchExecutionOpCodes;", "", "value", "", "<init>", "(Ljava/lang/String;II)V", "OP_CODE_CREATE_ANIMATED_NODE", "OP_CODE_UPDATE_ANIMATED_NODE_CONFIG", "OP_CODE_GET_VALUE", "OP_START_LISTENING_TO_ANIMATED_NODE_VALUE", "OP_STOP_LISTENING_TO_ANIMATED_NODE_VALUE", "OP_CODE_CONNECT_ANIMATED_NODES", "OP_CODE_DISCONNECT_ANIMATED_NODES", "OP_CODE_START_ANIMATING_NODE", "OP_CODE_STOP_ANIMATION", "OP_CODE_SET_ANIMATED_NODE_VALUE", "OP_CODE_SET_ANIMATED_NODE_OFFSET", "OP_CODE_FLATTEN_ANIMATED_NODE_OFFSET", "OP_CODE_EXTRACT_ANIMATED_NODE_OFFSET", "OP_CODE_CONNECT_ANIMATED_NODE_TO_VIEW", "OP_CODE_DISCONNECT_ANIMATED_NODE_FROM_VIEW", "OP_CODE_RESTORE_DEFAULT_VALUES", "OP_CODE_DROP_ANIMATED_NODE", "OP_CODE_ADD_ANIMATED_EVENT_TO_VIEW", "OP_CODE_REMOVE_ANIMATED_EVENT_FROM_VIEW", "OP_CODE_ADD_LISTENER", "OP_CODE_REMOVE_LISTENERS", "Companion", "ReactAndroid_release"})
    private static final class BatchExecutionOpCodes
    extends Enum<BatchExecutionOpCodes> {
        @NotNull
        public static final Companion Companion;
        @Nullable
        private static BatchExecutionOpCodes[] valueMap;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_CREATE_ANIMATED_NODE;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_UPDATE_ANIMATED_NODE_CONFIG;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_GET_VALUE;
        public static final /* enum */ BatchExecutionOpCodes OP_START_LISTENING_TO_ANIMATED_NODE_VALUE;
        public static final /* enum */ BatchExecutionOpCodes OP_STOP_LISTENING_TO_ANIMATED_NODE_VALUE;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_CONNECT_ANIMATED_NODES;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_DISCONNECT_ANIMATED_NODES;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_START_ANIMATING_NODE;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_STOP_ANIMATION;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_SET_ANIMATED_NODE_VALUE;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_SET_ANIMATED_NODE_OFFSET;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_FLATTEN_ANIMATED_NODE_OFFSET;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_EXTRACT_ANIMATED_NODE_OFFSET;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_CONNECT_ANIMATED_NODE_TO_VIEW;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_DISCONNECT_ANIMATED_NODE_FROM_VIEW;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_RESTORE_DEFAULT_VALUES;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_DROP_ANIMATED_NODE;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_ADD_ANIMATED_EVENT_TO_VIEW;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_REMOVE_ANIMATED_EVENT_FROM_VIEW;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_ADD_LISTENER;
        public static final /* enum */ BatchExecutionOpCodes OP_CODE_REMOVE_LISTENERS;
        private static final /* synthetic */ BatchExecutionOpCodes[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private BatchExecutionOpCodes(int value) {
        }

        public static BatchExecutionOpCodes[] values() {
            return (BatchExecutionOpCodes[])$VALUES.clone();
        }

        public static BatchExecutionOpCodes valueOf(String value) {
            return Enum.valueOf(BatchExecutionOpCodes.class, value);
        }

        @NotNull
        public static EnumEntries<BatchExecutionOpCodes> getEntries() {
            return $ENTRIES;
        }

        @JvmStatic
        @NotNull
        public static final BatchExecutionOpCodes fromId(int id2) {
            return Companion.fromId(id2);
        }

        static {
            OP_CODE_CREATE_ANIMATED_NODE = new BatchExecutionOpCodes(1);
            OP_CODE_UPDATE_ANIMATED_NODE_CONFIG = new BatchExecutionOpCodes(2);
            OP_CODE_GET_VALUE = new BatchExecutionOpCodes(3);
            OP_START_LISTENING_TO_ANIMATED_NODE_VALUE = new BatchExecutionOpCodes(4);
            OP_STOP_LISTENING_TO_ANIMATED_NODE_VALUE = new BatchExecutionOpCodes(5);
            OP_CODE_CONNECT_ANIMATED_NODES = new BatchExecutionOpCodes(6);
            OP_CODE_DISCONNECT_ANIMATED_NODES = new BatchExecutionOpCodes(7);
            OP_CODE_START_ANIMATING_NODE = new BatchExecutionOpCodes(8);
            OP_CODE_STOP_ANIMATION = new BatchExecutionOpCodes(9);
            OP_CODE_SET_ANIMATED_NODE_VALUE = new BatchExecutionOpCodes(10);
            OP_CODE_SET_ANIMATED_NODE_OFFSET = new BatchExecutionOpCodes(11);
            OP_CODE_FLATTEN_ANIMATED_NODE_OFFSET = new BatchExecutionOpCodes(12);
            OP_CODE_EXTRACT_ANIMATED_NODE_OFFSET = new BatchExecutionOpCodes(13);
            OP_CODE_CONNECT_ANIMATED_NODE_TO_VIEW = new BatchExecutionOpCodes(14);
            OP_CODE_DISCONNECT_ANIMATED_NODE_FROM_VIEW = new BatchExecutionOpCodes(15);
            OP_CODE_RESTORE_DEFAULT_VALUES = new BatchExecutionOpCodes(16);
            OP_CODE_DROP_ANIMATED_NODE = new BatchExecutionOpCodes(17);
            OP_CODE_ADD_ANIMATED_EVENT_TO_VIEW = new BatchExecutionOpCodes(18);
            OP_CODE_REMOVE_ANIMATED_EVENT_FROM_VIEW = new BatchExecutionOpCodes(19);
            OP_CODE_ADD_LISTENER = new BatchExecutionOpCodes(20);
            OP_CODE_REMOVE_LISTENERS = new BatchExecutionOpCodes(21);
            $VALUES = batchExecutionOpCodesArray = new BatchExecutionOpCodes[]{BatchExecutionOpCodes.OP_CODE_CREATE_ANIMATED_NODE, BatchExecutionOpCodes.OP_CODE_UPDATE_ANIMATED_NODE_CONFIG, BatchExecutionOpCodes.OP_CODE_GET_VALUE, BatchExecutionOpCodes.OP_START_LISTENING_TO_ANIMATED_NODE_VALUE, BatchExecutionOpCodes.OP_STOP_LISTENING_TO_ANIMATED_NODE_VALUE, BatchExecutionOpCodes.OP_CODE_CONNECT_ANIMATED_NODES, BatchExecutionOpCodes.OP_CODE_DISCONNECT_ANIMATED_NODES, BatchExecutionOpCodes.OP_CODE_START_ANIMATING_NODE, BatchExecutionOpCodes.OP_CODE_STOP_ANIMATION, BatchExecutionOpCodes.OP_CODE_SET_ANIMATED_NODE_VALUE, BatchExecutionOpCodes.OP_CODE_SET_ANIMATED_NODE_OFFSET, BatchExecutionOpCodes.OP_CODE_FLATTEN_ANIMATED_NODE_OFFSET, BatchExecutionOpCodes.OP_CODE_EXTRACT_ANIMATED_NODE_OFFSET, BatchExecutionOpCodes.OP_CODE_CONNECT_ANIMATED_NODE_TO_VIEW, BatchExecutionOpCodes.OP_CODE_DISCONNECT_ANIMATED_NODE_FROM_VIEW, BatchExecutionOpCodes.OP_CODE_RESTORE_DEFAULT_VALUES, BatchExecutionOpCodes.OP_CODE_DROP_ANIMATED_NODE, BatchExecutionOpCodes.OP_CODE_ADD_ANIMATED_EVENT_TO_VIEW, BatchExecutionOpCodes.OP_CODE_REMOVE_ANIMATED_EVENT_FROM_VIEW, BatchExecutionOpCodes.OP_CODE_ADD_LISTENER, BatchExecutionOpCodes.OP_CODE_REMOVE_LISTENERS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007R\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/facebook/react/animated/NativeAnimatedModule$BatchExecutionOpCodes$Companion;", "", "<init>", "()V", "valueMap", "", "Lcom/facebook/react/animated/NativeAnimatedModule$BatchExecutionOpCodes;", "[Lcom/facebook/react/animated/NativeAnimatedModule$BatchExecutionOpCodes;", "fromId", "id", "", "ReactAndroid_release"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final BatchExecutionOpCodes fromId(int id2) {
                BatchExecutionOpCodes[] valueMapNonnull;
                BatchExecutionOpCodes[] batchExecutionOpCodesArray = valueMap;
                if (batchExecutionOpCodesArray == null) {
                    batchExecutionOpCodesArray = valueMapNonnull = BatchExecutionOpCodes.values();
                }
                if (valueMap == null) {
                    valueMap = valueMapNonnull;
                }
                return valueMapNonnull[id2 - 1];
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/react/animated/NativeAnimatedModule$Companion;", "", "<init>", "()V", "NAME", "", "ANIMATED_MODULE_DEBUG", "", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u0006R\u00020\u0007H\u0007J\u001a\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\u001c\u0010\u0014\u001a\u000e\u0012\b\u0012\u00060\u0006R\u00020\u0007\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006R\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0018\u00010\u0006R\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/animated/NativeAnimatedModule$ConcurrentOperationQueue;", "", "<init>", "(Lcom/facebook/react/animated/NativeAnimatedModule;)V", "queue", "Ljava/util/Queue;", "Lcom/facebook/react/animated/NativeAnimatedModule$UIThreadOperation;", "Lcom/facebook/react/animated/NativeAnimatedModule;", "peekedOperation", "isEmpty", "", "()Z", "add", "", "operation", "executeBatch", "maxBatchNumber", "", "nodesManager", "Lcom/facebook/react/animated/NativeAnimatedNodesManager;", "drainQueueIntoList", "", "ReactAndroid_release"})
    private final class ConcurrentOperationQueue {
        @NotNull
        private final Queue<UIThreadOperation> queue = new ConcurrentLinkedQueue();
        @Nullable
        private UIThreadOperation peekedOperation;

        @AnyThread
        public final boolean isEmpty() {
            return this.queue.isEmpty() && this.peekedOperation == null;
        }

        @AnyThread
        public final void add(@NotNull UIThreadOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            this.queue.add(operation);
        }

        @UiThread
        public final void executeBatch(long maxBatchNumber, @Nullable NativeAnimatedNodesManager nodesManager) {
            List<UIThreadOperation> operations = this.drainQueueIntoList(maxBatchNumber);
            if (operations != null) {
                for (UIThreadOperation operation : operations) {
                    NativeAnimatedNodesManager nativeAnimatedNodesManager = nodesManager;
                    if (nativeAnimatedNodesManager == null) {
                        String string2 = "Required value was null.";
                        throw new IllegalStateException(string2.toString());
                    }
                    operation.execute(nativeAnimatedNodesManager);
                }
            }
        }

        @UiThread
        @Nullable
        public final List<UIThreadOperation> drainQueueIntoList(long maxBatchNumber) {
            if (this.isEmpty()) {
                return null;
            }
            List operations = new ArrayList();
            while (true) {
                UIThreadOperation polledOperation;
                UIThreadOperation peekedOperation;
                if ((peekedOperation = this.peekedOperation) != null) {
                    if (peekedOperation.getBatchNumber() > maxBatchNumber) break;
                    operations.add(peekedOperation);
                    this.peekedOperation = null;
                }
                if (this.queue.poll() == null) break;
                if (polledOperation.getBatchNumber() > maxBatchNumber) {
                    this.peekedOperation = polledOperation;
                    break;
                }
                operations.add(polledOperation);
            }
            return operations;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/animated/NativeAnimatedModule$UIThreadOperation;", "", "<init>", "(Lcom/facebook/react/animated/NativeAnimatedModule;)V", "execute", "", "animatedNodesManager", "Lcom/facebook/react/animated/NativeAnimatedNodesManager;", "batchNumber", "", "getBatchNumber", "()J", "setBatchNumber", "(J)V", "ReactAndroid_release"})
    private abstract class UIThreadOperation {
        private long batchNumber = -1L;

        public abstract void execute(@NotNull NativeAnimatedNodesManager var1);

        public final long getBatchNumber() {
            return this.batchNumber;
        }

        public final void setBatchNumber(long l) {
            this.batchNumber = l;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BatchExecutionOpCodes.values().length];
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_GET_VALUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_START_LISTENING_TO_ANIMATED_NODE_VALUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_STOP_LISTENING_TO_ANIMATED_NODE_VALUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_STOP_ANIMATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_FLATTEN_ANIMATED_NODE_OFFSET.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_EXTRACT_ANIMATED_NODE_OFFSET.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_RESTORE_DEFAULT_VALUES.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_DROP_ANIMATED_NODE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_ADD_LISTENER.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_REMOVE_LISTENERS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_CREATE_ANIMATED_NODE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_UPDATE_ANIMATED_NODE_CONFIG.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_CONNECT_ANIMATED_NODES.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_DISCONNECT_ANIMATED_NODES.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_SET_ANIMATED_NODE_VALUE.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_SET_ANIMATED_NODE_OFFSET.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_DISCONNECT_ANIMATED_NODE_FROM_VIEW.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_START_ANIMATING_NODE.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_REMOVE_ANIMATED_EVENT_FROM_VIEW.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_CONNECT_ANIMATED_NODE_TO_VIEW.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BatchExecutionOpCodes.OP_CODE_ADD_ANIMATED_EVENT_TO_VIEW.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

