/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JSApplicationCausedNativeException;
import com.facebook.react.bridge.ReadableMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\f\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u000eJ\r\u0010\u000f\u001a\u00020\u0010H\u0010\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/animated/ModulusAnimatedNode;", "Lcom/facebook/react/animated/ValueAnimatedNode;", "config", "Lcom/facebook/react/bridge/ReadableMap;", "nativeAnimatedNodesManager", "Lcom/facebook/react/animated/NativeAnimatedNodesManager;", "<init>", "(Lcom/facebook/react/bridge/ReadableMap;Lcom/facebook/react/animated/NativeAnimatedNodesManager;)V", "inputNode", "", "modulus", "", "update", "", "update$ReactAndroid_release", "prettyPrint", "", "prettyPrint$ReactAndroid_release", "ReactAndroid_release"})
public final class ModulusAnimatedNode
extends ValueAnimatedNode {
    @NotNull
    private final NativeAnimatedNodesManager nativeAnimatedNodesManager;
    private final int inputNode;
    private final double modulus;

    public ModulusAnimatedNode(@NotNull ReadableMap config, @NotNull NativeAnimatedNodesManager nativeAnimatedNodesManager) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)nativeAnimatedNodesManager, (String)"nativeAnimatedNodesManager");
        super(null, 1, null);
        this.nativeAnimatedNodesManager = nativeAnimatedNodesManager;
        this.inputNode = config.getInt("input");
        this.modulus = config.getDouble("modulus");
    }

    @Override
    public void update$ReactAndroid_release() {
        AnimatedNode animatedNode = this.nativeAnimatedNodesManager.getNodeById(this.inputNode);
        if (!(animatedNode instanceof ValueAnimatedNode)) {
            throw new JSApplicationCausedNativeException("Illegal node ID set as an input for Animated.modulus node");
        }
        double animatedNodeValue = ((ValueAnimatedNode)animatedNode).getValue();
        this.nodeValue = (animatedNodeValue % this.modulus + this.modulus) % this.modulus;
    }

    @Override
    @NotNull
    public String prettyPrint$ReactAndroid_release() {
        return "NativeAnimatedNodesManager[" + this.tag + "] inputNode: " + this.inputNode + " modulus: " + this.modulus + " super: " + super.prettyPrint$ReactAndroid_release();
    }
}

