/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewStructure;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Animation;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.touch.OnInterceptTouchEventListener;
import com.facebook.react.touch.ReactHitSlopView;
import com.facebook.react.touch.ReactInterceptingViewGroup;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.BlendModeHelper;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.MeasureSpecAssertions;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ReactAxOrderHelper;
import com.facebook.react.uimanager.ReactClippingProhibitedView;
import com.facebook.react.uimanager.ReactClippingViewGroup;
import com.facebook.react.uimanager.ReactClippingViewGroupHelper;
import com.facebook.react.uimanager.ReactOverflowViewWithInset;
import com.facebook.react.uimanager.ReactPointerEventsView;
import com.facebook.react.uimanager.ReactZIndexedViewGroup;
import com.facebook.react.uimanager.ViewGroupDrawingOrderHelper;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.BorderStyle;
import com.facebook.react.uimanager.style.LogicalEdge;
import com.facebook.react.uimanager.style.Overflow;
import com.facebook.react.views.view.CanvasUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\"\n\u0002\b-\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00bf\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u00062\u00020\u0007:\u0004\u00be\u0001\u00bf\u0001B\u0011\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010;\u001a\u00020<H\u0002J\r\u0010=\u001a\u00020<H\u0010\u00a2\u0006\u0002\b>J\u0018\u0010D\u001a\u00020<2\u0006\u0010E\u001a\u00020\u00112\u0006\u0010F\u001a\u00020\u0011H\u0014J0\u0010G\u001a\u00020<2\u0006\u0010H\u001a\u00020\u00132\u0006\u0010I\u001a\u00020\u00112\u0006\u0010J\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u00112\u0006\u0010L\u001a\u00020\u0011H\u0014J\b\u0010M\u001a\u00020<H\u0017J\u0010\u0010N\u001a\u00020<2\u0006\u0010O\u001a\u00020PH\u0017J\u0010\u0010Q\u001a\u00020<2\u0006\u0010R\u001a\u00020\u0011H\u0016J\u0012\u0010S\u001a\u00020<2\b\u0010T\u001a\u0004\u0018\u00010UH\u0007J\u0010\u0010V\u001a\u00020<2\u0006\u0010W\u001a\u000202H\u0016J\u0010\u0010X\u001a\u00020\u00132\u0006\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020\u00132\u0006\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010\\\u001a\u00020\u00132\u0006\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010]\u001a\u00020\u00132\u0006\u0010^\u001a\u00020ZH\u0016J\b\u0010_\u001a\u00020\u0013H\u0016J\u000e\u0010`\u001a\u00020<2\u0006\u00103\u001a\u00020\u0013J\u0016\u0010a\u001a\u00020<2\u0006\u0010b\u001a\u00020\u00112\u0006\u0010c\u001a\u000205J\u001d\u0010d\u001a\u00020<2\u0006\u0010b\u001a\u00020\u00112\b\u0010R\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010eJ\u0010\u0010f\u001a\u00020<2\u0006\u0010g\u001a\u000205H\u0007J\u0018\u0010f\u001a\u00020<2\u0006\u0010g\u001a\u0002052\u0006\u0010b\u001a\u00020\u0011H\u0007J\u0018\u0010f\u001a\u00020<2\u0006\u0010h\u001a\u00020i2\b\u0010g\u001a\u0004\u0018\u00010jJ\u0010\u0010k\u001a\u00020<2\b\u0010l\u001a\u0004\u0018\u00010*J\u0010\u0010s\u001a\u00020<2\u0006\u0010t\u001a\u00020\rH\u0016J\b\u0010u\u001a\u00020<H\u0016J\u0018\u0010u\u001a\u00020<2\u000e\u0010v\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010wH\u0016J\u0010\u0010x\u001a\u00020<2\u0006\u0010y\u001a\u00020\u0017H\u0016J\u0010\u0010z\u001a\u00020<2\u0006\u0010{\u001a\u00020\u0011H\u0002J\u0010\u0010|\u001a\u00020\u00132\u0006\u0010}\u001a\u00020\u0017H\u0002J\"\u0010~\u001a\u00020<2\u0006\u0010\u001d\u001a\u00020\r2\u0010\b\u0002\u0010\u007f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010wH\u0002J5\u0010\u0080\u0001\u001a\u00020<2\u0006\u0010\u001d\u001a\u00020\r2\u0007\u0010\u0081\u0001\u001a\u00020\u00112\u0007\u0010\u0082\u0001\u001a\u00020\u00112\u0010\b\u0002\u0010\u007f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010wH\u0002J\u0012\u0010\u0080\u0001\u001a\u00020<2\u0007\u0010\u0083\u0001\u001a\u00020\u0017H\u0002J-\u0010\u0084\u0001\u001a\u00020<2\u0007\u0010\u0085\u0001\u001a\u00020\u00112\u0007\u0010\u0086\u0001\u001a\u00020\u00112\u0007\u0010\u0087\u0001\u001a\u00020\u00112\u0007\u0010\u0088\u0001\u001a\u00020\u0011H\u0014J\t\u0010\u0089\u0001\u001a\u00020<H\u0014J\t\u0010\u008a\u0001\u001a\u00020\u0013H\u0002J\u0011\u0010\u008b\u0001\u001a\u00020<2\u0006\u0010}\u001a\u00020\u0017H\u0016J\u0011\u0010\u008c\u0001\u001a\u00020<2\u0006\u0010}\u001a\u00020\u0017H\u0016J\u001a\u0010\u008d\u0001\u001a\u00020<2\u0006\u0010}\u001a\u00020\u00172\u0007\u0010\u008e\u0001\u001a\u00020\u0013H\u0002J\u001b\u0010\u008f\u0001\u001a\u00020\u00112\u0007\u0010\u0090\u0001\u001a\u00020\u00112\u0007\u0010\u0091\u0001\u001a\u00020\u0011H\u0014J\u0012\u0010\u0092\u0001\u001a\u00020\u00112\u0007\u0010\u0091\u0001\u001a\u00020\u0011H\u0016J\t\u0010\u0093\u0001\u001a\u00020<H\u0016J\u0012\u0010\u0094\u0001\u001a\u00020<2\u0007\u0010\u0095\u0001\u001a\u00020\u0013H\u0014J\t\u0010\u0096\u0001\u001a\u00020<H\u0002J\u001a\u0010\u0097\u0001\u001a\u0004\u0018\u00010\u00172\u0007\u0010\u0091\u0001\u001a\u00020\u0011H\u0000\u00a2\u0006\u0003\b\u0098\u0001J \u0010\u0099\u0001\u001a\u00020<2\u0006\u0010}\u001a\u00020\u00172\u0007\u0010\u0091\u0001\u001a\u00020\u0011H\u0000\u00a2\u0006\u0003\b\u009a\u0001J\u0017\u0010\u009b\u0001\u001a\u00020<2\u0006\u0010y\u001a\u00020\u0017H\u0000\u00a2\u0006\u0003\b\u009c\u0001J\u000f\u0010\u009d\u0001\u001a\u00020<H\u0000\u00a2\u0006\u0003\b\u009e\u0001J$\u0010\u009f\u0001\u001a\u00020\u00132\b\u0010y\u001a\u0004\u0018\u00010\u00172\t\u0010\u0091\u0001\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0003\u0010\u00a0\u0001J\u0011\u0010\u00a1\u0001\u001a\u00020\u00112\u0006\u0010}\u001a\u00020\u0017H\u0002J\u001a\u0010\u00a2\u0001\u001a\u00020<2\u0006\u0010}\u001a\u00020\u00172\u0007\u0010\u0091\u0001\u001a\u00020\u0011H\u0002J\u0012\u0010\u00a3\u0001\u001a\u00020<2\u0007\u0010\u0091\u0001\u001a\u00020\u0011H\u0002J)\u0010\u00ab\u0001\u001a\u00020<2\u0006\u0010I\u001a\u00020\u00112\u0006\u0010J\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u00112\u0006\u0010L\u001a\u00020\u0011H\u0016J\u0014\u0010\u00ac\u0001\u001a\u00020<2\t\u0010\u00ad\u0001\u001a\u0004\u0018\u00010UH\u0002J\u0013\u0010\u00ae\u0001\u001a\u00020<2\b\u0010\u00af\u0001\u001a\u00030\u00b0\u0001H\u0016J\u0013\u0010\u00b1\u0001\u001a\u00020<2\b\u0010\u00af\u0001\u001a\u00030\u00b0\u0001H\u0014J%\u0010\u00b2\u0001\u001a\u00020\u00132\b\u0010\u00af\u0001\u001a\u00030\u00b0\u00012\u0006\u0010}\u001a\u00020\u00172\b\u0010\u00b3\u0001\u001a\u00030\u00b4\u0001H\u0014J\u0010\u0010\u00b5\u0001\u001a\u00020<2\u0007\u0010\u00b6\u0001\u001a\u000205J\u0010\u0010\u00b7\u0001\u001a\u00020<2\u0007\u0010\u00b8\u0001\u001a\u00020*J\u0007\u0010\u00b9\u0001\u001a\u00020<J\u0019\u0010\u00ba\u0001\u001a\u00020<2\u000e\u0010\u00bb\u0001\u001a\t\u0012\u0004\u0012\u00020\u00170\u00bc\u0001H\u0016J\u0007\u0010\u00bd\u0001\u001a\u00020<R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u001e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0011@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\"\u0010(\u001a\n\u0012\u0004\u0012\u00020*\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00107\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u0004\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010A\u001a\u00020@8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR$\u0010n\u001a\u00020\u00132\u0006\u0010m\u001a\u00020\u00138V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bo\u0010p\"\u0004\bq\u0010rR\u0012\u0010\u00a4\u0001\u001a\u0005\u0018\u00010\u00a5\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\u00a6\u0001\u001a\u0004\u0018\u00010*2\t\u0010\u00a6\u0001\u001a\u0004\u0018\u00010*8V@VX\u0096\u000e\u00a2\u0006\u0010\u001a\u0006\b\u00a7\u0001\u0010\u00a8\u0001\"\u0006\b\u00a9\u0001\u0010\u00aa\u0001\u00a8\u0006\u00c0\u0001"}, d2={"Lcom/facebook/react/views/view/ReactViewGroup;", "Landroid/view/ViewGroup;", "Lcom/facebook/react/touch/ReactInterceptingViewGroup;", "Lcom/facebook/react/uimanager/ReactClippingViewGroup;", "Lcom/facebook/react/uimanager/ReactPointerEventsView;", "Lcom/facebook/react/touch/ReactHitSlopView;", "Lcom/facebook/react/uimanager/ReactZIndexedViewGroup;", "Lcom/facebook/react/uimanager/ReactOverflowViewWithInset;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "overflowInset", "Landroid/graphics/Rect;", "getOverflowInset", "()Landroid/graphics/Rect;", "recycleCount", "", "_removeClippedSubviews", "", "inSubviewClippingLoop", "allChildren", "", "Landroid/view/View;", "[Landroid/view/View;", "value", "allChildrenCount", "getAllChildrenCount$ReactAndroid_debug", "()I", "clippingRect", "hitSlopRect", "getHitSlopRect", "setHitSlopRect", "(Landroid/graphics/Rect;)V", "pointerEvents", "Lcom/facebook/react/uimanager/PointerEvents;", "getPointerEvents", "()Lcom/facebook/react/uimanager/PointerEvents;", "setPointerEvents", "(Lcom/facebook/react/uimanager/PointerEvents;)V", "axOrderList", "", "", "getAxOrderList", "()Ljava/util/List;", "setAxOrderList", "(Ljava/util/List;)V", "childrenLayoutChangeListener", "Lcom/facebook/react/views/view/ReactViewGroup$ChildrenLayoutChangeListener;", "onInterceptTouchEventListener", "Lcom/facebook/react/touch/OnInterceptTouchEventListener;", "needsOffscreenAlphaCompositing", "backfaceOpacity", "", "backfaceVisible", "childrenRemovedWhileTransitioning", "", "accessibilityStateChangeListener", "Landroid/view/accessibility/AccessibilityManager$AccessibilityStateChangeListener;", "initView", "", "recycleView", "recycleView$ReactAndroid_debug", "_drawingOrderHelper", "Lcom/facebook/react/uimanager/ViewGroupDrawingOrderHelper;", "drawingOrderHelper", "getDrawingOrderHelper", "()Lcom/facebook/react/uimanager/ViewGroupDrawingOrderHelper;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onLayout", "changed", "left", "top", "right", "bottom", "requestLayout", "dispatchProvideStructure", "structure", "Landroid/view/ViewStructure;", "setBackgroundColor", "color", "setTranslucentBackgroundDrawable", "background", "Landroid/graphics/drawable/Drawable;", "setOnInterceptTouchEventListener", "listener", "onInterceptTouchEvent", "event", "Landroid/view/MotionEvent;", "onTouchEvent", "onHoverEvent", "dispatchGenericMotionEvent", "ev", "hasOverlappingRendering", "setNeedsOffscreenAlphaCompositing", "setBorderWidth", "position", "width", "setBorderColor", "(ILjava/lang/Integer;)V", "setBorderRadius", "borderRadius", "property", "Lcom/facebook/react/uimanager/style/BorderRadiusProp;", "Lcom/facebook/react/uimanager/LengthPercentage;", "setBorderStyle", "style", "newValue", "removeClippedSubviews", "getRemoveClippedSubviews", "()Z", "setRemoveClippedSubviews", "(Z)V", "getClippingRect", "outClippingRect", "updateClippingRect", "excludedViews", "", "endViewTransition", "view", "trackChildViewTransition", "childId", "isChildRemovedWhileTransitioning", "child", "updateClippingToRect", "excludedViewsSet", "updateSubviewClipStatus", "idx", "clippedSoFar", "subview", "onSizeChanged", "w", "h", "oldw", "oldh", "onAttachedToWindow", "customDrawOrderDisabled", "onViewAdded", "onViewRemoved", "checkViewClippingTag", "expectedTag", "getChildDrawingOrder", "childCount", "index", "getZIndexMappedChildIndex", "updateDrawingOrder", "dispatchSetPressed", "pressed", "resetPointerEvents", "getChildAtWithSubviewClippingEnabled", "getChildAtWithSubviewClippingEnabled$ReactAndroid_debug", "addViewWithSubviewClippingEnabled", "addViewWithSubviewClippingEnabled$ReactAndroid_debug", "removeViewWithSubviewClippingEnabled", "removeViewWithSubviewClippingEnabled$ReactAndroid_debug", "removeAllViewsWithSubviewClippingEnabled", "removeAllViewsWithSubviewClippingEnabled$ReactAndroid_debug", "isViewClipped", "(Landroid/view/View;Ljava/lang/Integer;)Z", "indexOfChildInAllChildren", "addInArray", "removeFromArray", "_overflow", "Lcom/facebook/react/uimanager/style/Overflow;", "overflow", "getOverflow", "()Ljava/lang/String;", "setOverflow", "(Ljava/lang/String;)V", "setOverflowInset", "updateBackgroundDrawable", "drawable", "draw", "canvas", "Landroid/graphics/Canvas;", "dispatchDraw", "drawChild", "drawingTime", "", "setOpacityIfPossible", "opacity", "setBackfaceVisibility", "backfaceVisibility", "setBackfaceVisibilityDependantOpacity", "addChildrenForAccessibility", "outChildren", "Ljava/util/ArrayList;", "cleanUpAxOrderListener", "ChildrenLayoutChangeListener", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nReactViewGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactViewGroup.kt\ncom/facebook/react/views/view/ReactViewGroup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1015:1\n1#2:1016\n*E\n"})
public class ReactViewGroup
extends ViewGroup
implements ReactInterceptingViewGroup,
ReactClippingViewGroup,
ReactPointerEventsView,
ReactHitSlopView,
ReactZIndexedViewGroup,
ReactOverflowViewWithInset {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Rect overflowInset = new Rect();
    private int recycleCount;
    private boolean _removeClippedSubviews;
    private volatile boolean inSubviewClippingLoop;
    @Nullable
    private View[] allChildren;
    private int allChildrenCount;
    @Nullable
    private Rect clippingRect;
    @Nullable
    private Rect hitSlopRect;
    @NotNull
    private PointerEvents pointerEvents = PointerEvents.AUTO;
    @Nullable
    private List<String> axOrderList;
    @Nullable
    private ChildrenLayoutChangeListener childrenLayoutChangeListener;
    @Nullable
    private OnInterceptTouchEventListener onInterceptTouchEventListener;
    private boolean needsOffscreenAlphaCompositing;
    private float backfaceOpacity;
    private boolean backfaceVisible;
    @Nullable
    private Set<Integer> childrenRemovedWhileTransitioning;
    @Nullable
    private AccessibilityManager.AccessibilityStateChangeListener accessibilityStateChangeListener;
    @Nullable
    private ViewGroupDrawingOrderHelper _drawingOrderHelper;
    @Nullable
    private Overflow _overflow;
    private static final int ARRAY_CAPACITY_INCREMENT = 12;
    @NotNull
    private static final ViewGroup.LayoutParams defaultLayoutParam = new ViewGroup.LayoutParams(0, 0);

    public ReactViewGroup(@Nullable Context context) {
        super(context);
        this.initView();
    }

    @Override
    @NotNull
    public Rect getOverflowInset() {
        return this.overflowInset;
    }

    public final int getAllChildrenCount$ReactAndroid_debug() {
        return this.allChildrenCount;
    }

    @Override
    @Nullable
    public Rect getHitSlopRect() {
        return this.hitSlopRect;
    }

    public void setHitSlopRect(@Nullable Rect rect) {
        this.hitSlopRect = rect;
    }

    @Override
    @NotNull
    public PointerEvents getPointerEvents() {
        return this.pointerEvents;
    }

    public void setPointerEvents(@NotNull PointerEvents pointerEvents) {
        Intrinsics.checkNotNullParameter((Object)((Object)pointerEvents), (String)"<set-?>");
        this.pointerEvents = pointerEvents;
    }

    @Nullable
    public final List<String> getAxOrderList() {
        return this.axOrderList;
    }

    public final void setAxOrderList(@Nullable List<String> list) {
        this.axOrderList = list;
    }

    private final void initView() {
        this.setClipChildren(false);
        this._removeClippedSubviews = false;
        this.inSubviewClippingLoop = false;
        this.allChildren = null;
        this.allChildrenCount = 0;
        this.clippingRect = null;
        this.setHitSlopRect(null);
        this._overflow = Overflow.VISIBLE;
        this.setPointerEvents(PointerEvents.AUTO);
        this.childrenLayoutChangeListener = null;
        this.onInterceptTouchEventListener = null;
        this.needsOffscreenAlphaCompositing = false;
        this._drawingOrderHelper = null;
        this.backfaceOpacity = 1.0f;
        this.backfaceVisible = true;
        this.childrenRemovedWhileTransitioning = null;
    }

    public void recycleView$ReactAndroid_debug() {
        int n = this.recycleCount;
        this.recycleCount = n + 1;
        View[] allChildren = this.allChildren;
        if (allChildren != null && this.childrenLayoutChangeListener != null) {
            ChildrenLayoutChangeListener childrenLayoutChangeListener = this.childrenLayoutChangeListener;
            if (childrenLayoutChangeListener != null) {
                childrenLayoutChangeListener.shutdown();
            }
            int n2 = this.allChildrenCount;
            for (int i = 0; i < n2; ++i) {
                View view = allChildren[i];
                if (view == null) continue;
                view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this.childrenLayoutChangeListener);
            }
        }
        this.initView();
        this.getOverflowInset().setEmpty();
        this.removeAllViews();
        if (this.getParent() != null) {
            ViewParent viewParent = this.getParent();
            Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.ViewGroup");
            ((ViewGroup)viewParent).removeView((View)this);
        }
        this.updateBackgroundDrawable(null);
        this.resetPointerEvents();
    }

    private final ViewGroupDrawingOrderHelper getDrawingOrderHelper() {
        if (this._drawingOrderHelper == null) {
            this._drawingOrderHelper = new ViewGroupDrawingOrderHelper(this);
        }
        ViewGroupDrawingOrderHelper viewGroupDrawingOrderHelper = this._drawingOrderHelper;
        if (viewGroupDrawingOrderHelper == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        return viewGroupDrawingOrderHelper;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MeasureSpecAssertions.assertExplicitMeasureSpec(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void requestLayout() {
    }

    @TargetApi(value=23)
    public void dispatchProvideStructure(@NotNull ViewStructure structure) {
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        try {
            super.dispatchProvideStructure(structure);
        }
        catch (NullPointerException e) {
            FLog.e((String)"ReactNative", (String)"NullPointerException when executing dispatchProvideStructure", (Throwable)e);
        }
    }

    public void setBackgroundColor(int color) {
        BackgroundStyleApplicator.setBackgroundColor((View)this, color);
    }

    @Deprecated(message="setTranslucentBackgroundDrawable is deprecated since React Native 0.76.0 and will be removed in a future version")
    public final void setTranslucentBackgroundDrawable(@Nullable Drawable background) {
        BackgroundStyleApplicator.setFeedbackUnderlay((View)this, background);
    }

    @Override
    public void setOnInterceptTouchEventListener(@NotNull OnInterceptTouchEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.onInterceptTouchEventListener = listener;
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        OnInterceptTouchEventListener onInterceptTouchEventListener = this.onInterceptTouchEventListener;
        boolean bl = onInterceptTouchEventListener != null ? onInterceptTouchEventListener.onInterceptTouchEvent(this, event) : false;
        if (bl) {
            return true;
        }
        if (!PointerEvents.Companion.canChildrenBeTouchTarget(this.getPointerEvents())) {
            return true;
        }
        return super.onInterceptTouchEvent(event);
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return PointerEvents.Companion.canBeTouchTarget(this.getPointerEvents());
    }

    public boolean onHoverEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (ReactFeatureFlags.dispatchPointerEvents) {
            return PointerEvents.Companion.canBeTouchTarget(this.getPointerEvents());
        }
        return super.onHoverEvent(event);
    }

    public boolean dispatchGenericMotionEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        if (!PointerEvents.Companion.canChildrenBeTouchTarget(this.getPointerEvents())) {
            return false;
        }
        return super.dispatchGenericMotionEvent(ev);
    }

    public boolean hasOverlappingRendering() {
        return this.needsOffscreenAlphaCompositing;
    }

    public final void setNeedsOffscreenAlphaCompositing(boolean needsOffscreenAlphaCompositing) {
        this.needsOffscreenAlphaCompositing = needsOffscreenAlphaCompositing;
    }

    public final void setBorderWidth(int position, float width) {
        BackgroundStyleApplicator.setBorderWidth((View)this, (LogicalEdge)((Object)LogicalEdge.getEntries().get(position)), Float.valueOf(PixelUtil.toDIPFromPixel(width)));
    }

    public final void setBorderColor(int position, @Nullable Integer color) {
        BackgroundStyleApplicator.setBorderColor((View)this, (LogicalEdge)((Object)LogicalEdge.getEntries().get(position)), color);
    }

    @Deprecated(message="setBorderRadius(Float) is deprecated and will be removed in the future.", replaceWith=@ReplaceWith(expression="setBorderRadius(Float,LengthPercentage)", imports={}))
    public final void setBorderRadius(float borderRadius) {
        LengthPercentage radius = Float.isNaN(borderRadius) ? null : new LengthPercentage(borderRadius, LengthPercentageType.POINT);
        BackgroundStyleApplicator.setBorderRadius((View)this, BorderRadiusProp.BORDER_RADIUS, radius);
    }

    @Deprecated(message="setBorderRadius(Float) is deprecated and will be removed in the future.", replaceWith=@ReplaceWith(expression="setBorderRadius(Float,LengthPercentage)", imports={}))
    public final void setBorderRadius(float borderRadius, int position) {
        LengthPercentage radius = Float.isNaN(borderRadius) ? null : new LengthPercentage(borderRadius, LengthPercentageType.POINT);
        BackgroundStyleApplicator.setBorderRadius((View)this, (BorderRadiusProp)((Object)BorderRadiusProp.getEntries().get(position)), radius);
    }

    public final void setBorderRadius(@NotNull BorderRadiusProp property, @Nullable LengthPercentage borderRadius) {
        Intrinsics.checkNotNullParameter((Object)((Object)property), (String)"property");
        BackgroundStyleApplicator.setBorderRadius((View)this, property, borderRadius);
    }

    /*
     * WARNING - void declaration
     */
    public final void setBorderStyle(@Nullable String style2) {
        BorderStyle borderStyle;
        View view = (View)this;
        String string2 = style2;
        if (string2 != null) {
            void it;
            String string3 = string2;
            View view2 = view;
            boolean bl = false;
            borderStyle = BorderStyle.Companion.fromString((String)it);
            view = view2;
        } else {
            borderStyle = null;
        }
        BackgroundStyleApplicator.setBorderStyle(view, borderStyle);
    }

    @Override
    public boolean getRemoveClippedSubviews() {
        return this._removeClippedSubviews;
    }

    @Override
    public void setRemoveClippedSubviews(boolean newValue) {
        if (newValue == this._removeClippedSubviews) {
            return;
        }
        this._removeClippedSubviews = newValue;
        this.childrenRemovedWhileTransitioning = null;
        if (newValue) {
            Rect clippingRect = new Rect();
            ReactClippingViewGroupHelper.calculateClippingRect((View)this, clippingRect);
            this.clippingRect = clippingRect;
            this.allChildrenCount = this.getChildCount();
            View[] allChildren = new View[Math.max(12, this.allChildrenCount)];
            this.childrenLayoutChangeListener = new ChildrenLayoutChangeListener(this);
            int n = this.allChildrenCount;
            for (int i = 0; i < n; ++i) {
                View child;
                allChildren[i] = child = this.getChildAt(i);
                child.addOnLayoutChangeListener((View.OnLayoutChangeListener)this.childrenLayoutChangeListener);
                Intrinsics.checkNotNull((Object)child);
                ReactViewGroup.Companion.setViewClipped(child, false);
            }
            this.allChildren = allChildren;
            this.updateClippingRect();
        } else {
            if (this.allChildren == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            View[] childArray = this.allChildren;
            if (this.childrenLayoutChangeListener == null) {
                String string3 = "Required value was null.";
                throw new IllegalStateException(string3.toString());
            }
            int n = this.allChildrenCount;
            for (int i = 0; i < n; ++i) {
                View view = childArray[i];
                if (view == null) continue;
                view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this.childrenLayoutChangeListener);
            }
            Rect rect = this.clippingRect;
            if (rect == null) {
                String string4 = "Required value was null.";
                throw new IllegalStateException(string4.toString());
            }
            Rect clippingRect = rect;
            this.getDrawingRect(clippingRect);
            ReactViewGroup.updateClippingToRect$default(this, clippingRect, null, 2, null);
            this.allChildren = null;
            this.clippingRect = null;
            this.allChildrenCount = 0;
            this.childrenLayoutChangeListener = null;
        }
    }

    @Override
    public void getClippingRect(@NotNull Rect outClippingRect) {
        Intrinsics.checkNotNullParameter((Object)outClippingRect, (String)"outClippingRect");
        Rect rect = this.clippingRect;
        if (rect == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        outClippingRect.set(rect);
    }

    @Override
    public void updateClippingRect() {
        this.updateClippingRect(null);
    }

    @Override
    public void updateClippingRect(@Nullable Set<Integer> excludedViews) {
        if (!this._removeClippedSubviews) {
            return;
        }
        Rect rect = this.clippingRect;
        if (rect == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        Rect clippingRect = rect;
        ReactClippingViewGroupHelper.calculateClippingRect((View)this, clippingRect);
        this.updateClippingToRect(clippingRect, excludedViews);
    }

    public void endViewTransition(@NotNull View view) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            super.endViewTransition(view);
            Set<Integer> set = this.childrenRemovedWhileTransitioning;
            if (set == null) break block0;
            set.remove(view.getId());
        }
    }

    private final void trackChildViewTransition(int childId) {
        block1: {
            if (this.childrenRemovedWhileTransitioning == null) {
                this.childrenRemovedWhileTransitioning = new LinkedHashSet();
            }
            Set<Integer> set = this.childrenRemovedWhileTransitioning;
            if (set == null) break block1;
            set.add(childId);
        }
    }

    private final boolean isChildRemovedWhileTransitioning(View child) {
        Set<Integer> set = this.childrenRemovedWhileTransitioning;
        return set != null ? set.contains(child.getId()) : false;
    }

    private final void updateClippingToRect(Rect clippingRect, Set<Integer> excludedViewsSet) {
        if (this.allChildren == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        View[] childArray = this.allChildren;
        this.inSubviewClippingLoop = true;
        int clippedSoFar = 0;
        int n = this.allChildrenCount;
        for (int i = 0; i < n; ++i) {
            try {
                this.updateSubviewClipStatus(clippingRect, i, clippedSoFar, excludedViewsSet);
            }
            catch (IndexOutOfBoundsException ex) {
                int realClippedSoFar = 0;
                Set uniqueViews = new HashSet();
                for (int j = 0; j < i; ++j) {
                    realClippedSoFar += this.isViewClipped(childArray[j], j) ? 1 : 0;
                    uniqueViews.add(childArray[j]);
                }
                Set<Integer> set = excludedViewsSet;
                throw new IllegalStateException("Invalid clipping state. i=" + i + " clippedSoFar=" + clippedSoFar + " count=" + this.getChildCount() + " allChildrenCount=" + this.allChildrenCount + " recycleCount=" + this.recycleCount + " realClippedSoFar=" + realClippedSoFar + " uniqueViewsCount=" + uniqueViews.size() + " excludedViews=" + (set != null ? set.size() : 0), ex);
            }
            if (this.isViewClipped(childArray[i], i)) {
                ++clippedSoFar;
            }
            if (i - clippedSoFar <= this.getChildCount()) continue;
            Set<Integer> set = excludedViewsSet;
            throw new IllegalStateException("Invalid clipping state. i=" + i + " clippedSoFar=" + clippedSoFar + " count=" + this.getChildCount() + " allChildrenCount=" + this.allChildrenCount + " recycleCount=" + this.recycleCount + "  excludedViews=" + (set != null ? set.size() : 0));
        }
        this.inSubviewClippingLoop = false;
    }

    static /* synthetic */ void updateClippingToRect$default(ReactViewGroup reactViewGroup, Rect rect, Set set, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateClippingToRect");
        }
        if ((n & 2) != 0) {
            set = null;
        }
        reactViewGroup.updateClippingToRect(rect, set);
    }

    private final void updateSubviewClipStatus(Rect clippingRect, int idx, int clippedSoFar, Set<Integer> excludedViewsSet) {
        boolean shouldSkipView;
        UiThreadUtil.assertOnUiThread();
        Object object = this.allChildren != null ? this.allChildren[idx] : null;
        if (object == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        View child = object;
        boolean intersects = clippingRect.intersects(child.getLeft(), child.getTop(), child.getRight(), child.getBottom());
        boolean needUpdateClippingRecursive = false;
        Animation animation = child.getAnimation();
        boolean isAnimating = animation != null ? !animation.hasEnded() : false;
        Set<Integer> set = excludedViewsSet;
        boolean bl = set != null ? set.contains(child.getId()) : (shouldSkipView = false);
        if (excludedViewsSet != null) {
            needUpdateClippingRecursive = true;
        }
        if (!(intersects || this.isViewClipped(child, idx) || isAnimating || child == this.getFocusedChild() || shouldSkipView)) {
            ReactViewGroup.Companion.setViewClipped(child, true);
            this.removeViewInLayout(child);
            needUpdateClippingRecursive = true;
        } else if ((shouldSkipView || intersects) && this.isViewClipped(child, idx)) {
            int adjustedIdx = idx - clippedSoFar;
            if (!(adjustedIdx >= 0)) {
                throw new IllegalStateException("Check failed.");
            }
            ReactViewGroup.Companion.setViewClipped(child, false);
            this.addViewInLayout(child, adjustedIdx, defaultLayoutParam, true);
            this.invalidate();
            needUpdateClippingRecursive = true;
        } else if (intersects) {
            needUpdateClippingRecursive = true;
        }
        if (needUpdateClippingRecursive) {
            ReactClippingViewGroup reactClippingViewGroup = child instanceof ReactClippingViewGroup ? (ReactClippingViewGroup)child : null;
            boolean bl2 = reactClippingViewGroup != null ? reactClippingViewGroup.getRemoveClippedSubviews() : false;
            if (bl2) {
                ((ReactClippingViewGroup)child).updateClippingRect(excludedViewsSet);
            }
        }
    }

    static /* synthetic */ void updateSubviewClipStatus$default(ReactViewGroup reactViewGroup, Rect rect, int n, int n2, Set set, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateSubviewClipStatus");
        }
        if ((n3 & 8) != 0) {
            set = null;
        }
        reactViewGroup.updateSubviewClipStatus(rect, n, n2, set);
    }

    private final void updateSubviewClipStatus(View subview) {
        boolean oldIntersects;
        if (!this._removeClippedSubviews || this.getParent() == null) {
            return;
        }
        Rect rect = this.clippingRect;
        if (rect == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        Rect clippingRect = rect;
        if (this.allChildren == null) {
            String string3 = "Required value was null.";
            throw new IllegalStateException(string3.toString());
        }
        View[] allChildren = this.allChildren;
        boolean intersects = clippingRect.intersects(subview.getLeft(), subview.getTop(), subview.getRight(), subview.getBottom());
        boolean bl = oldIntersects = !this.isViewClipped(subview, null);
        if (intersects != oldIntersects) {
            this.inSubviewClippingLoop = true;
            int clippedSoFar = 0;
            int n = this.allChildrenCount;
            for (int i = 0; i < n; ++i) {
                if (allChildren[i] == subview) {
                    ReactViewGroup.updateSubviewClipStatus$default(this, clippingRect, i, clippedSoFar, null, 8, null);
                    break;
                }
                if (!this.isViewClipped(allChildren[i], i)) continue;
                ++clippedSoFar;
            }
            this.inSubviewClippingLoop = false;
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this._removeClippedSubviews) {
            this.updateClippingRect();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this._removeClippedSubviews) {
            this.updateClippingRect();
        }
    }

    private final boolean customDrawOrderDisabled() {
        if (this.getId() == -1) {
            return false;
        }
        return ViewUtil.getUIManagerType(this.getId()) == 2;
    }

    public void onViewAdded(@NotNull View child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        UiThreadUtil.assertOnUiThread();
        this.checkViewClippingTag(child, false);
        if (!this.customDrawOrderDisabled()) {
            this.getDrawingOrderHelper().handleAddView(child);
            this.setChildrenDrawingOrderEnabled(this.getDrawingOrderHelper().shouldEnableCustomDrawingOrder());
        } else {
            this.setChildrenDrawingOrderEnabled(false);
        }
        super.onViewAdded(child);
    }

    public void onViewRemoved(@NotNull View child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        UiThreadUtil.assertOnUiThread();
        this.checkViewClippingTag(child, true);
        if (!this.customDrawOrderDisabled()) {
            this.getDrawingOrderHelper().handleRemoveView(child);
            this.setChildrenDrawingOrderEnabled(this.getDrawingOrderHelper().shouldEnableCustomDrawingOrder());
        } else {
            this.setChildrenDrawingOrderEnabled(false);
        }
        if (child.getParent() != null) {
            this.trackChildViewTransition(child.getId());
        }
        super.onViewRemoved(child);
    }

    private final void checkViewClippingTag(View child, boolean expectedTag) {
        if (this.inSubviewClippingLoop) {
            Object tag = child.getTag(R.id.view_clipped);
            if (!Intrinsics.areEqual((Object)expectedTag, (Object)tag)) {
                ReactSoftExceptionLogger.logSoftException("ReactViewGroup.onViewRemoved", new ReactNoCrashSoftException("View clipping tag mismatch: tag=" + tag + " expected=" + expectedTag));
            }
        }
        if (this._removeClippedSubviews) {
            child.setTag(R.id.view_clipped, (Object)expectedTag);
        } else {
            child.setTag(R.id.view_clipped, null);
        }
    }

    protected int getChildDrawingOrder(int childCount, int index) {
        UiThreadUtil.assertOnUiThread();
        return !this.customDrawOrderDisabled() ? this.getDrawingOrderHelper().getChildDrawingOrder(childCount, index) : index;
    }

    @Override
    public int getZIndexMappedChildIndex(int index) {
        UiThreadUtil.assertOnUiThread();
        if (!this.customDrawOrderDisabled() && this.getDrawingOrderHelper().shouldEnableCustomDrawingOrder()) {
            return this.getDrawingOrderHelper().getChildDrawingOrder(this.getChildCount(), index);
        }
        return index;
    }

    @Override
    public void updateDrawingOrder() {
        if (this.customDrawOrderDisabled()) {
            return;
        }
        this.getDrawingOrderHelper().update();
        this.setChildrenDrawingOrderEnabled(this.getDrawingOrderHelper().shouldEnableCustomDrawingOrder());
        this.invalidate();
    }

    protected void dispatchSetPressed(boolean pressed) {
    }

    private final void resetPointerEvents() {
        this.setPointerEvents(PointerEvents.AUTO);
    }

    @Nullable
    public final View getChildAtWithSubviewClippingEnabled$ReactAndroid_debug(int index) {
        View view;
        boolean bl = 0 <= index ? index < this.allChildrenCount : false;
        if (bl) {
            if (this.allChildren == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            view = this.allChildren[index];
        } else {
            view = null;
        }
        return view;
    }

    public final void addViewWithSubviewClippingEnabled$ReactAndroid_debug(@NotNull View child, int index) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        if (!this._removeClippedSubviews) {
            throw new IllegalStateException("Check failed.");
        }
        ReactViewGroup.Companion.setViewClipped(child, true);
        this.addInArray(child, index);
        Rect rect = this.clippingRect;
        if (rect == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        Rect clippingRect = rect;
        if (this.allChildren == null) {
            String string3 = "Required value was null.";
            throw new IllegalStateException(string3.toString());
        }
        View[] allChildren = this.allChildren;
        this.inSubviewClippingLoop = true;
        int clippedSoFar = 0;
        for (int i = 0; i < index; ++i) {
            if (!this.isViewClipped(allChildren[i], i)) continue;
            ++clippedSoFar;
        }
        ReactViewGroup.updateSubviewClipStatus$default(this, clippingRect, index, clippedSoFar, null, 8, null);
        this.inSubviewClippingLoop = false;
        child.addOnLayoutChangeListener((View.OnLayoutChangeListener)this.childrenLayoutChangeListener);
        if (child instanceof ReactClippingProhibitedView) {
            UiThreadUtil.runOnUiThread(new Runnable(child, this){
                final /* synthetic */ View $child;
                final /* synthetic */ ReactViewGroup this$0;
                {
                    this.$child = $child;
                    this.this$0 = $receiver;
                }

                public void run() {
                    if (!this.$child.isShown()) {
                        ReactSoftExceptionLogger.logSoftException("ReactClippingProhibitedView", new ReactNoCrashSoftException("Child view has been added to Parent view in which it is clipped and not visible. This is not legal for this particular child view. Child: [" + this.$child.getId() + "] " + this.$child + " Parent: [" + this.this$0.getId() + "] " + this));
                    }
                }
            });
        }
    }

    public final void removeViewWithSubviewClippingEnabled$ReactAndroid_debug(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        UiThreadUtil.assertOnUiThread();
        if (!this._removeClippedSubviews) {
            throw new IllegalStateException("Check failed.");
        }
        if (this.allChildren == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        View[] allChildren = this.allChildren;
        view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this.childrenLayoutChangeListener);
        int index = this.indexOfChildInAllChildren(view);
        if (!this.isViewClipped(allChildren[index], index)) {
            int clippedSoFar = 0;
            for (int i = 0; i < index; ++i) {
                if (!this.isViewClipped(allChildren[i], i)) continue;
                ++clippedSoFar;
            }
            this.removeViewsInLayout(index - clippedSoFar, 1);
            this.invalidate();
        }
        this.removeFromArray(index);
    }

    public final void removeAllViewsWithSubviewClippingEnabled$ReactAndroid_debug() {
        if (!this._removeClippedSubviews) {
            throw new IllegalStateException("Check failed.");
        }
        if (this.allChildren == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        View[] allChildren = this.allChildren;
        int n = this.allChildrenCount;
        for (int i = 0; i < n; ++i) {
            View view = allChildren[i];
            if (view == null) continue;
            view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this.childrenLayoutChangeListener);
        }
        this.removeAllViewsInLayout();
        this.allChildrenCount = 0;
    }

    private final boolean isViewClipped(View view, Integer index) {
        View view2 = view;
        if (view2 == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        View view3 = view2;
        Object tag = view3.getTag(R.id.view_clipped);
        if (tag != null) {
            return (Boolean)tag;
        }
        ViewParent parent = view3.getParent();
        boolean transitioning = this.isChildRemovedWhileTransitioning(view3);
        if (index != null) {
            ReactSoftExceptionLogger.logSoftException("ReactViewGroup.isViewClipped", new ReactNoCrashSoftException("View missing clipping tag: index=" + index + " parentNull=" + (parent == null) + " parentThis=" + (parent == this) + " transitioning=" + transitioning));
        }
        if (parent == null || transitioning) {
            return true;
        }
        if (!(parent == this)) {
            throw new IllegalStateException("Check failed.");
        }
        return false;
    }

    private final int indexOfChildInAllChildren(View child) {
        int count = this.allChildrenCount;
        if (this.allChildren == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        View[] childArray = this.allChildren;
        for (int i = 0; i < count; ++i) {
            if (childArray[i] != child) continue;
            return i;
        }
        return -1;
    }

    private final void addInArray(View child, int index) {
        if (this.allChildren == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        View[] childArray = this.allChildren;
        int count = this.allChildrenCount;
        int size = childArray.length;
        if (index == count) {
            if (size == count) {
                View[] allChildren = new View[size + 12];
                System.arraycopy(childArray, 0, allChildren, 0, size);
                this.allChildren = childArray = allChildren;
            }
            int allChildren = this.allChildrenCount;
            this.allChildrenCount = allChildren + 1;
            childArray[allChildren] = child;
        } else if (index < count) {
            if (size == count) {
                View[] allChildren = new View[size + 12];
                System.arraycopy(childArray, 0, allChildren, 0, index);
                System.arraycopy(childArray, index, allChildren, index + 1, count - index);
                this.allChildren = childArray = allChildren;
            } else {
                System.arraycopy(childArray, index, childArray, index + 1, count - index);
            }
            childArray[index] = child;
            int n = this.allChildrenCount;
            this.allChildrenCount = n + 1;
        } else {
            throw new IndexOutOfBoundsException("index=" + index + " count=" + count);
        }
    }

    private final void removeFromArray(int index) {
        if (this.allChildren == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        View[] childArray = this.allChildren;
        int n = index;
        int count = this.allChildrenCount;
        if (n == count - 1) {
            this.allChildrenCount += -1;
            childArray[this.allChildrenCount] = null;
        } else {
            boolean bl = 0 <= n ? n < count : false;
            if (bl) {
                System.arraycopy(childArray, index + 1, childArray, index, count - index - 1);
                this.allChildrenCount += -1;
                childArray[this.allChildrenCount] = null;
            } else {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    @Override
    @Nullable
    public String getOverflow() {
        Overflow overflow = this._overflow;
        return switch (overflow == null ? -1 : WhenMappings.$EnumSwitchMapping$0[overflow.ordinal()]) {
            case 1 -> "hidden";
            case 2 -> "scroll";
            case 3 -> "visible";
            default -> null;
        };
    }

    public void setOverflow(@Nullable String overflow) {
        this._overflow = overflow == null ? Overflow.VISIBLE : Overflow.Companion.fromString(overflow);
        this.invalidate();
    }

    @Override
    public void setOverflowInset(int left, int top, int right, int bottom) {
        if (BlendModeHelper.needsIsolatedLayer(this) && (this.getOverflowInset().left != left || this.getOverflowInset().top != top || this.getOverflowInset().right != right || this.getOverflowInset().bottom != bottom)) {
            this.invalidate();
        }
        this.getOverflowInset().set(left, top, right, bottom);
    }

    private final void updateBackgroundDrawable(Drawable drawable2) {
        super.setBackground(drawable2);
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (Build.VERSION.SDK_INT >= 29 && ViewUtil.getUIManagerType((View)this) == 2 && BlendModeHelper.needsIsolatedLayer(this)) {
            Rect overflowInset = this.getOverflowInset();
            canvas.saveLayer((float)overflowInset.left, (float)overflowInset.top, (float)(this.getWidth() + -overflowInset.right), (float)(this.getHeight() + -overflowInset.bottom), null);
            super.draw(canvas);
            canvas.restore();
        } else {
            super.draw(canvas);
        }
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this._overflow != Overflow.VISIBLE || this.getTag(R.id.filter) != null) {
            BackgroundStyleApplicator.clipToPaddingBox((View)this, canvas);
        }
        super.dispatchDraw(canvas);
    }

    protected boolean drawChild(@NotNull Canvas canvas, @NotNull View child, long drawingTime) {
        boolean drawWithZ;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        boolean bl = drawWithZ = child.getElevation() > 0.0f;
        if (drawWithZ) {
            CanvasUtil.enableZ(canvas, true);
        }
        BlendMode mixBlendMode = null;
        if (Build.VERSION.SDK_INT >= 29 && ViewUtil.getUIManagerType((View)this) == 2 && BlendModeHelper.needsIsolatedLayer(this)) {
            Object object = child.getTag(R.id.mix_blend_mode);
            BlendMode blendMode = mixBlendMode = object instanceof BlendMode ? (BlendMode)object : null;
            if (mixBlendMode != null) {
                Paint p = new Paint();
                p.setBlendMode(mixBlendMode);
                Rect overflowInset = this.getOverflowInset();
                canvas.saveLayer((float)overflowInset.left, (float)overflowInset.top, (float)(this.getWidth() + -overflowInset.right), (float)(this.getHeight() + -overflowInset.bottom), p);
            }
        }
        boolean result = super.drawChild(canvas, child, drawingTime);
        if (mixBlendMode != null) {
            canvas.restore();
        }
        if (drawWithZ) {
            CanvasUtil.enableZ(canvas, false);
        }
        return result;
    }

    public final void setOpacityIfPossible(float opacity) {
        this.backfaceOpacity = opacity;
        this.setBackfaceVisibilityDependantOpacity();
    }

    public final void setBackfaceVisibility(@NotNull String backfaceVisibility) {
        Intrinsics.checkNotNullParameter((Object)backfaceVisibility, (String)"backfaceVisibility");
        this.backfaceVisible = Intrinsics.areEqual((Object)"visible", (Object)backfaceVisibility);
        this.setBackfaceVisibilityDependantOpacity();
    }

    public final void setBackfaceVisibilityDependantOpacity() {
        boolean isFrontfaceVisible;
        if (this.backfaceVisible) {
            this.setAlpha(this.backfaceOpacity);
            return;
        }
        float rotationX = this.getRotationX();
        float rotationY = this.getRotationY();
        boolean bl = isFrontfaceVisible = rotationX >= -90.0f && rotationX < 90.0f && rotationY >= -90.0f && rotationY < 90.0f;
        if (isFrontfaceVisible) {
            this.setAlpha(this.backfaceOpacity);
            return;
        }
        this.setAlpha(0.0f);
    }

    public void addChildrenForAccessibility(@NotNull ArrayList<View> outChildren) {
        Intrinsics.checkNotNullParameter(outChildren, (String)"outChildren");
        ReactViewGroup reactViewGroup = (ReactViewGroup)this.getTag(R.id.accessibility_order_parent);
        List<String> axOrderParentOrderList = reactViewGroup != null ? reactViewGroup.axOrderList : null;
        List<String> axOrder = this.axOrderList;
        if (axOrder != null) {
            AccessibilityManager am = (AccessibilityManager)this.getContext().getSystemService("accessibility");
            if (this.accessibilityStateChangeListener == null && am != null) {
                AccessibilityManager.AccessibilityStateChangeListener newAccessibilityStateChangeListener = arg_0 -> ReactViewGroup.addChildrenForAccessibility$lambda$1(this, arg_0);
                am.addAccessibilityStateChangeListener(newAccessibilityStateChangeListener);
                this.accessibilityStateChangeListener = newAccessibilityStateChangeListener;
            }
            View[] result = new View[axOrder.size()];
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view = this.getChildAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getChildAt(...)");
                ReactAxOrderHelper.INSTANCE.buildAxOrderList(view, axOrder, result);
            }
            for (View view : result) {
                if (view == null) continue;
                if (view.isFocusable()) {
                    outChildren.add(view);
                    continue;
                }
                view.addChildrenForAccessibility(outChildren);
            }
        } else if (axOrderParentOrderList != null) {
            if (!this.isFocusable()) {
                super.addChildrenForAccessibility(outChildren);
                return;
            }
            if (this.isFocusable() && (this.getContentDescription() == null || Intrinsics.areEqual((Object)this.getContentDescription(), (Object)""))) {
                super.addChildrenForAccessibility(outChildren);
                ReactAxOrderHelper.INSTANCE.disableFocusForSubtree(this, axOrderParentOrderList);
            } else if (this.isFocusable() && this.getContentDescription() != null && !Intrinsics.areEqual((Object)this.getContentDescription(), (Object)"")) {
                return;
            }
        } else {
            super.addChildrenForAccessibility(outChildren);
        }
    }

    public final void cleanUpAxOrderListener() {
        AccessibilityManager am;
        Object object = this.getContext().getSystemService("accessibility");
        AccessibilityManager accessibilityManager = am = object instanceof AccessibilityManager ? (AccessibilityManager)object : null;
        if (am != null) {
            AccessibilityManager.AccessibilityStateChangeListener accessibilityStateChangeListener = this.accessibilityStateChangeListener;
            if (accessibilityStateChangeListener != null) {
                AccessibilityManager.AccessibilityStateChangeListener it = accessibilityStateChangeListener;
                boolean bl = false;
                am.removeAccessibilityStateChangeListener(it);
            }
        }
        this.accessibilityStateChangeListener = null;
    }

    private static final void addChildrenForAccessibility$lambda$1(ReactViewGroup this$0, boolean enabled) {
        if (!enabled) {
            ReactAxOrderHelper.restoreFocusability(this$0);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JP\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0006\u0010\u0013\u001a\u00020\u0007R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/react/views/view/ReactViewGroup$ChildrenLayoutChangeListener;", "Landroid/view/View$OnLayoutChangeListener;", "parent", "Lcom/facebook/react/views/view/ReactViewGroup;", "<init>", "(Lcom/facebook/react/views/view/ReactViewGroup;)V", "onLayoutChange", "", "v", "Landroid/view/View;", "left", "", "top", "right", "bottom", "oldLeft", "oldTop", "oldRight", "oldBottom", "shutdown", "ReactAndroid_debug"})
    private static final class ChildrenLayoutChangeListener
    implements View.OnLayoutChangeListener {
        @Nullable
        private ReactViewGroup parent;

        public ChildrenLayoutChangeListener(@Nullable ReactViewGroup parent) {
            this.parent = parent;
        }

        public void onLayoutChange(@NotNull View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                ReactViewGroup reactViewGroup = this.parent;
                boolean bl = reactViewGroup != null ? reactViewGroup.getRemoveClippedSubviews() : false;
                if (!bl) break block1;
                ReactViewGroup reactViewGroup2 = this.parent;
                if (reactViewGroup2 != null) {
                    reactViewGroup2.updateSubviewClipStatus(v);
                }
            }
        }

        public final void shutdown() {
            this.parent = null;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/views/view/ReactViewGroup$Companion;", "", "<init>", "()V", "ARRAY_CAPACITY_INCREMENT", "", "defaultLayoutParam", "Landroid/view/ViewGroup$LayoutParams;", "setViewClipped", "", "view", "Landroid/view/View;", "clipped", "", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        private final void setViewClipped(View view, boolean clipped) {
            view.setTag(R.id.view_clipped, (Object)clipped);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Overflow.values().length];
            try {
                nArray[Overflow.HIDDEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Overflow.SCROLL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Overflow.VISIBLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

