/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.view.View;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.scroll.ScrollEvent;
import com.facebook.react.views.scroll.ScrollEventType;
import com.facebook.react.views.textinput.ReactEditText;
import com.facebook.react.views.textinput.ScrollWatcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/views/textinput/ReactTextScrollWatcher;", "Lcom/facebook/react/views/textinput/ScrollWatcher;", "editText", "Lcom/facebook/react/views/textinput/ReactEditText;", "<init>", "(Lcom/facebook/react/views/textinput/ReactEditText;)V", "eventDispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "surfaceId", "", "previousHorizontal", "previousVert", "onScrollChanged", "", "horiz", "vert", "oldHoriz", "oldVert", "ReactAndroid_debug"})
public final class ReactTextScrollWatcher
implements ScrollWatcher {
    @NotNull
    private final ReactEditText editText;
    @Nullable
    private final EventDispatcher eventDispatcher;
    private final int surfaceId;
    private int previousHorizontal;
    private int previousVert;

    public ReactTextScrollWatcher(@NotNull ReactEditText editText) {
        Intrinsics.checkNotNullParameter((Object)((Object)editText), (String)"editText");
        this.editText = editText;
        ReactContext reactContext = UIManagerHelper.getReactContext((View)this.editText);
        this.eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag(reactContext, this.editText.getId());
        this.surfaceId = UIManagerHelper.getSurfaceId((Context)reactContext);
    }

    @Override
    public void onScrollChanged(int horiz, int vert, int oldHoriz, int oldVert) {
        if (this.previousHorizontal != horiz || this.previousVert != vert) {
            ScrollEvent event = ScrollEvent.Companion.obtain(this.surfaceId, this.editText.getId(), ScrollEventType.SCROLL, horiz, vert, 0.0f, 0.0f, 0, 0, this.editText.getWidth(), this.editText.getHeight());
            EventDispatcher eventDispatcher = this.eventDispatcher;
            if (eventDispatcher != null) {
                eventDispatcher.dispatchEvent(event);
            }
            this.previousHorizontal = horiz;
            this.previousVert = vert;
        }
    }
}

