/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.common.mapbuffer.MapBuffer;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.react.uimanager.events.BlurEvent;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.FocusEvent;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.BorderStyle;
import com.facebook.react.uimanager.style.LogicalEdge;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import com.facebook.react.views.scroll.ScrollEventType;
import com.facebook.react.views.text.DefaultStyleValuesUtil;
import com.facebook.react.views.text.ReactBaseTextShadowNode;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.ReactTextViewManagerCallback;
import com.facebook.react.views.text.ReactTypefaceUtils;
import com.facebook.react.views.text.TextAttributeProps;
import com.facebook.react.views.text.TextLayoutManager;
import com.facebook.react.views.text.internal.span.TextInlineImageSpan;
import com.facebook.react.views.textinput.ReactEditText;
import com.facebook.react.views.textinput.ReactTextContentSizeWatcher;
import com.facebook.react.views.textinput.ReactTextInputEndEditingEvent;
import com.facebook.react.views.textinput.ReactTextInputShadowNode;
import com.facebook.react.views.textinput.ReactTextInputSubmitEditingEvent;
import com.facebook.react.views.textinput.ReactTextInputTextWatcher;
import com.facebook.react.views.textinput.ReactTextScrollWatcher;
import com.facebook.react.views.textinput.ReactTextSelectionWatcher;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="AndroidTextInput")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b9\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00a5\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u00a5\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0014H\u0016J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001a0\u0016H\u0016J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0017J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\r2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u001a\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\r2\u0006\u0010$\u001a\u00020\u001aH\u0002J\u0018\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u0017H\u0016J\u0018\u0010(\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u001aH\u0007J\u0018\u0010*\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,H\u0007J\u001a\u0010-\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010.\u001a\u0004\u0018\u00010\rH\u0007J\u0018\u0010/\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u00100\u001a\u00020,H\u0007J\u001a\u00101\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u00102\u001a\u0004\u0018\u00010\rH\u0007J\u001a\u00103\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u00104\u001a\u0004\u0018\u00010\rH\u0007J\u001a\u00105\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u00106\u001a\u0004\u0018\u00010 H\u0007J\u0018\u00107\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u00108\u001a\u000209H\u0007J\u001a\u0010:\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010;\u001a\u0004\u0018\u00010\rH\u0007J\u0018\u0010:\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010<\u001a\u00020\u001aH\u0002J)\u0010=\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0012\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0?\"\u00020\rH\u0002\u00a2\u0006\u0002\u0010@J\u0018\u0010A\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010B\u001a\u000209H\u0007J\u001a\u0010C\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010D\u001a\u0004\u0018\u00010\rH\u0007J\u0018\u0010E\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010F\u001a\u000209H\u0007J\u0018\u0010G\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010H\u001a\u000209H\u0007J\u0018\u0010I\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010J\u001a\u000209H\u0007J\u0018\u0010K\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010L\u001a\u00020,H\u0007J\u0018\u0010M\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010N\u001a\u000209H\u0007J\u001a\u0010O\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010P\u001a\u0004\u0018\u00010\rH\u0007J\u001f\u0010Q\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010R\u001a\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0002\u0010SJ\u001f\u0010T\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010R\u001a\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0002\u0010SJ\u001f\u0010U\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010R\u001a\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0002\u0010SJ\u001f\u0010V\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010R\u001a\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0002\u0010SJ\u0018\u0010W\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010X\u001a\u000209H\u0007J\u0018\u0010Y\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010Z\u001a\u000209H\u0007J\u0018\u0010[\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010\\\u001a\u000209H\u0007J\u001f\u0010]\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010R\u001a\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0002\u0010SJ\u001f\u0010^\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010_\u001a\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0002\u0010SJ\u001a\u0010`\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010a\u001a\u0004\u0018\u00010\rH\u0007J\u001a\u0010b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010c\u001a\u0004\u0018\u00010\rH\u0007J\u001a\u0010d\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010e\u001a\u0004\u0018\u00010\rH\u0007J\u0018\u0010f\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010g\u001a\u00020\u001aH\u0007J\u0018\u0010h\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010i\u001a\u000209H\u0007J\u0018\u0010j\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010k\u001a\u00020\u001aH\u0007J\u001f\u0010l\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010m\u001a\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0002\u0010SJ\u001a\u0010n\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010o\u001a\u0004\u0018\u00010\rH\u0007J\u001f\u0010p\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010q\u001a\u0004\u0018\u000109H\u0007\u00a2\u0006\u0002\u0010rJ\u0018\u0010s\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010t\u001a\u000209H\u0007J\u0018\u0010u\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010v\u001a\u000209H\u0007J\u0018\u0010w\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010x\u001a\u00020yH\u0007J\u001a\u0010z\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010{\u001a\u0004\u0018\u00010\rH\u0007J\u001a\u0010|\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010}\u001a\u0004\u0018\u00010\rH\u0007J\u001a\u0010~\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\b\u0010\u007f\u001a\u0004\u0018\u00010 H\u0007J\u001a\u0010\u0080\u0001\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0007\u0010\u0081\u0001\u001a\u000209H\u0007J\u001c\u0010\u0082\u0001\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010\rH\u0007J#\u0010\u0084\u0001\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0007\u0010\u0085\u0001\u001a\u00020\u001a2\u0007\u0010\u0086\u0001\u001a\u00020,H\u0007J\u001c\u0010\u0087\u0001\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\t\u0010\u0088\u0001\u001a\u0004\u0018\u00010\rH\u0007J\u001a\u0010\u0089\u0001\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0007\u0010\u0089\u0001\u001a\u000209H\u0007J\u001a\u0010\u008a\u0001\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0007\u0010\u008b\u0001\u001a\u000209H\u0007J\u001c\u0010\u008c\u0001\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\t\u0010\u008d\u0001\u001a\u0004\u0018\u00010\rH\u0007J#\u0010\u008e\u0001\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0007\u0010\u0085\u0001\u001a\u00020\u001a2\u0007\u0010\u008f\u0001\u001a\u00020,H\u0007J*\u0010\u0090\u0001\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0007\u0010\u0085\u0001\u001a\u00020\u001a2\b\u0010R\u001a\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0003\u0010\u0091\u0001J\u001c\u0010\u0092\u0001\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\t\u0010\u0093\u0001\u001a\u0004\u0018\u00010\rH\u0007J\u0011\u0010\u0094\u0001\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u0002H\u0014J\u001b\u0010\u0095\u0001\u001a\u00020\u001c2\u0007\u0010\u0096\u0001\u001a\u00020\u00102\u0007\u0010\u0097\u0001\u001a\u00020\u0002H\u0014J\u0015\u0010\u0098\u0001\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J5\u0010\u0099\u0001\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00022\u0007\u0010\u009a\u0001\u001a\u00020\u001a2\u0007\u0010\u009b\u0001\u001a\u00020\u001a2\u0007\u0010\u009c\u0001\u001a\u00020\u001a2\u0007\u0010\u009d\u0001\u001a\u00020\u001aH\u0016J'\u0010\u009e\u0001\u001a\u0004\u0018\u00010\u00172\u0006\u0010&\u001a\u00020\u00022\b\u0010\u009f\u0001\u001a\u00030\u00a0\u00012\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001H\u0016J$\u0010!\u001a\u0004\u0018\u00010\u00172\u0006\u0010&\u001a\u00020\u00022\b\u0010\u009f\u0001\u001a\u00030\u00a0\u00012\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u0001R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u00a6\u0001"}, d2={"Lcom/facebook/react/views/textinput/ReactTextInputManager;", "Lcom/facebook/react/uimanager/BaseViewManager;", "Lcom/facebook/react/views/textinput/ReactEditText;", "Lcom/facebook/react/uimanager/LayoutShadowNode;", "<init>", "()V", "reactTextViewManagerCallback", "Lcom/facebook/react/views/text/ReactTextViewManagerCallback;", "getReactTextViewManagerCallback", "()Lcom/facebook/react/views/text/ReactTextViewManagerCallback;", "setReactTextViewManagerCallback", "(Lcom/facebook/react/views/text/ReactTextViewManagerCallback;)V", "getName", "", "createViewInstance", "context", "Lcom/facebook/react/uimanager/ThemedReactContext;", "createShadowNodeInstance", "Lcom/facebook/react/views/text/ReactBaseTextShadowNode;", "getShadowNodeClass", "Ljava/lang/Class;", "getExportedCustomBubblingEventTypeConstants", "", "", "getExportedCustomDirectEventTypeConstants", "getCommandsMap", "", "receiveCommand", "", "reactEditText", "commandId", "args", "Lcom/facebook/react/bridge/ReadableArray;", "getReactTextUpdate", "Lcom/facebook/react/views/text/ReactTextUpdate;", "text", "mostRecentEventCount", "updateExtraData", "view", "extraData", "setLineHeight", "lineHeight", "setFontSize", "fontSize", "", "setFontFamily", "fontFamily", "setMaxFontSizeMultiplier", "maxFontSizeMultiplier", "setFontWeight", "fontWeight", "setFontStyle", "fontStyle", "setFontVariant", "fontVariant", "setIncludeFontPadding", "includepad", "", "setImportantForAutofill", "value", "mode", "setAutofillHints", "hints", "", "(Lcom/facebook/react/views/textinput/ReactEditText;[Ljava/lang/String;)V", "setOnSelectionChange", "onSelectionChange", "setSubmitBehavior", "submitBehavior", "setOnContentSizeChange", "onContentSizeChange", "setOnScroll", "onScroll", "setOnKeyPress", "onKeyPress", "setLetterSpacing", "letterSpacing", "setAllowFontScaling", "allowFontScaling", "setPlaceholder", "placeholder", "setPlaceholderTextColor", "color", "(Lcom/facebook/react/views/textinput/ReactEditText;Ljava/lang/Integer;)V", "setSelectionColor", "setSelectionHandleColor", "setCursorColor", "setCaretHidden", "caretHidden", "setContextMenuHidden", "contextMenuHidden", "setSelectTextOnFocus", "selectTextOnFocus", "setColor", "setUnderlineColor", "underlineColor", "setTextAlign", "textAlign", "setTextAlignVertical", "textAlignVertical", "setInlineImageLeft", "resource", "setInlineImagePadding", "padding", "setEditable", "editable", "setNumLines", "numLines", "setMaxLength", "maxLength", "setTextContentType", "autoComplete", "setAutoCorrect", "autoCorrect", "(Lcom/facebook/react/views/textinput/ReactEditText;Ljava/lang/Boolean;)V", "setMultiline", "multiline", "setSecureTextEntry", "password", "setAutoCapitalize", "autoCapitalize", "Lcom/facebook/react/bridge/Dynamic;", "setKeyboardType", "keyboardType", "setReturnKeyType", "returnKeyType", "setAcceptDragAndDropTypes", "acceptDragAndDropTypes", "setDisableFullscreenUI", "disableFullscreenUI", "setReturnKeyLabel", "returnKeyLabel", "setBorderRadius", "index", "borderRadius", "setBorderStyle", "borderStyle", "showKeyboardOnFocus", "setAutoFocus", "autoFocus", "setTextDecorationLine", "textDecorationLineString", "setBorderWidth", "width", "setBorderColor", "(Lcom/facebook/react/views/textinput/ReactEditText;ILjava/lang/Integer;)V", "setOverflow", "overflow", "onAfterUpdateTransaction", "addEventEmitters", "reactContext", "editText", "getExportedViewConstants", "setPadding", "left", "top", "right", "bottom", "updateState", "props", "Lcom/facebook/react/uimanager/ReactStylesDiffMap;", "stateWrapper", "Lcom/facebook/react/uimanager/StateWrapper;", "state", "Lcom/facebook/react/common/mapbuffer/MapBuffer;", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nReactTextInputManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactTextInputManager.kt\ncom/facebook/react/views/textinput/ReactTextInputManager\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1133:1\n37#2:1134\n36#2,3:1135\n37#2:1148\n36#2,3:1149\n1#3:1138\n739#4,9:1139\n*S KotlinDebug\n*F\n+ 1 ReactTextInputManager.kt\ncom/facebook/react/views/textinput/ReactTextInputManager\n*L\n626#1:1134\n626#1:1135,3\n838#1:1148\n838#1:1149,3\n837#1:1139,9\n*E\n"})
public class ReactTextInputManager
extends BaseViewManager<ReactEditText, LayoutShadowNode> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ReactTextViewManagerCallback reactTextViewManagerCallback;
    @NotNull
    private static final String TAG;
    @NotNull
    public static final String REACT_CLASS = "AndroidTextInput";
    private static final short TX_STATE_KEY_ATTRIBUTED_STRING = 0;
    private static final short TX_STATE_KEY_PARAGRAPH_ATTRIBUTES = 1;
    private static final short TX_STATE_KEY_MOST_RECENT_EVENT_COUNT = 3;
    @NotNull
    private static final Map<String, String> REACT_PROPS_AUTOFILL_HINTS_MAP;
    private static final int FOCUS_TEXT_INPUT = 1;
    private static final int BLUR_TEXT_INPUT = 2;
    private static final int SET_MOST_RECENT_EVENT_COUNT = 3;
    private static final int SET_TEXT_AND_SELECTION = 4;
    private static final int INPUT_TYPE_KEYBOARD_NUMBER_PAD = 2;
    private static final int INPUT_TYPE_KEYBOARD_DECIMAL_PAD = 8194;
    private static final int INPUT_TYPE_KEYBOARD_NUMBERED = 12290;
    private static final int AUTOCAPITALIZE_FLAGS = 28672;
    @NotNull
    private static final String KEYBOARD_TYPE_EMAIL_ADDRESS = "email-address";
    @NotNull
    private static final String KEYBOARD_TYPE_NUMERIC = "numeric";
    @NotNull
    private static final String KEYBOARD_TYPE_DECIMAL_PAD = "decimal-pad";
    @NotNull
    private static final String KEYBOARD_TYPE_NUMBER_PAD = "number-pad";
    @NotNull
    private static final String KEYBOARD_TYPE_PHONE_PAD = "phone-pad";
    @NotNull
    private static final String KEYBOARD_TYPE_VISIBLE_PASSWORD = "visible-password";
    @NotNull
    private static final String KEYBOARD_TYPE_URI = "url";
    @NotNull
    private static final InputFilter[] EMPTY_FILTERS;
    private static final int UNSET = -1;
    @NotNull
    private static final String[] DRAWABLE_HANDLE_RESOURCES;
    @NotNull
    private static final String[] DRAWABLE_HANDLE_FIELDS;
    private static final int IME_ACTION_ID = 1648;

    @Nullable
    protected final ReactTextViewManagerCallback getReactTextViewManagerCallback() {
        return this.reactTextViewManagerCallback;
    }

    protected final void setReactTextViewManagerCallback(@Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        this.reactTextViewManagerCallback = reactTextViewManagerCallback;
    }

    @Override
    @NotNull
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    @NotNull
    public ReactEditText createViewInstance(@NotNull ThemedReactContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        ReactEditText editText = new ReactEditText((Context)context);
        int inputType = editText.getInputType();
        editText.setInputType(inputType & 0xFFFDFFFF);
        editText.setReturnKeyType("done");
        editText.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        return editText;
    }

    @Override
    @NotNull
    public ReactBaseTextShadowNode createShadowNodeInstance() {
        return new ReactTextInputShadowNode(null, 1, null);
    }

    @NotNull
    public final ReactBaseTextShadowNode createShadowNodeInstance(@Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        return new ReactTextInputShadowNode(reactTextViewManagerCallback);
    }

    @Override
    @NotNull
    public Class<? extends LayoutShadowNode> getShadowNodeClass() {
        return ReactTextInputShadowNode.class;
    }

    @Override
    @NotNull
    public Map<String, Object> getExportedCustomBubblingEventTypeConstants() {
        Map baseEventTypeConstants = super.getExportedCustomBubblingEventTypeConstants();
        Map map = baseEventTypeConstants;
        if (map == null) {
            map = new LinkedHashMap();
        }
        Map eventTypeConstants = map;
        Pair[] pairArray = new Pair[3];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"bubbled", (Object)"onSubmitEditing"), TuplesKt.to((Object)"captured", (Object)"onSubmitEditingCapture")};
        pairArray[0] = TuplesKt.to((Object)"topSubmitEditing", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"phasedRegistrationNames", (Object)MapsKt.mapOf((Pair[])pairArray2))));
        pairArray2 = new Pair[]{TuplesKt.to((Object)"bubbled", (Object)"onEndEditing"), TuplesKt.to((Object)"captured", (Object)"onEndEditingCapture")};
        pairArray[1] = TuplesKt.to((Object)"topEndEditing", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"phasedRegistrationNames", (Object)MapsKt.mapOf((Pair[])pairArray2))));
        pairArray2 = new Pair[]{TuplesKt.to((Object)"bubbled", (Object)"onKeyPress"), TuplesKt.to((Object)"captured", (Object)"onKeyPressCapture")};
        pairArray[2] = TuplesKt.to((Object)"topKeyPress", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"phasedRegistrationNames", (Object)MapsKt.mapOf((Pair[])pairArray2))));
        eventTypeConstants.putAll(MapsKt.mapOf((Pair[])pairArray));
        return eventTypeConstants;
    }

    @Override
    @NotNull
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        Map baseEventTypeConstants = super.getExportedCustomDirectEventTypeConstants();
        Map map = baseEventTypeConstants;
        if (map == null) {
            map = new LinkedHashMap();
        }
        Map eventTypeConstants = map;
        eventTypeConstants.putAll(MapsKt.mapOf((Pair)TuplesKt.to((Object)ScrollEventType.Companion.getJSEventName(ScrollEventType.SCROLL), (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"registrationName", (Object)"onScroll")))));
        return eventTypeConstants;
    }

    @Override
    @NotNull
    public Map<String, Integer> getCommandsMap() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"focusTextInput", (Object)1), TuplesKt.to((Object)"blurTextInput", (Object)2)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @Deprecated(message="Deprecated in Java")
    public void receiveCommand(@NotNull ReactEditText reactEditText, int commandId, @Nullable ReadableArray args) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactEditText), (String)"reactEditText");
        switch (commandId) {
            case 1: {
                this.receiveCommand(reactEditText, "focus", args);
                break;
            }
            case 2: {
                this.receiveCommand(reactEditText, "blur", args);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.receiveCommand(reactEditText, "setTextAndSelection", args);
            }
        }
    }

    @Override
    public void receiveCommand(@NotNull ReactEditText reactEditText, @NotNull String commandId, @Nullable ReadableArray args) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactEditText), (String)"reactEditText");
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        switch (commandId) {
            case "focusTextInput": 
            case "focus": {
                reactEditText.requestFocusFromJS();
                break;
            }
            case "blurTextInput": 
            case "blur": {
                reactEditText.clearFocusFromJS$ReactAndroid_debug();
                break;
            }
            case "setTextAndSelection": {
                ReadableArray readableArray = args;
                if (readableArray == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalStateException(string2.toString());
                }
                int mostRecentEventCount = readableArray.getInt(0);
                if (mostRecentEventCount == -1) {
                    return;
                }
                int start = args.getInt(2);
                int end = args.getInt(3);
                if (end == -1) {
                    end = start;
                }
                if (!args.isNull(1)) {
                    String text = args.getString(1);
                    reactEditText.maybeSetTextFromJS(this.getReactTextUpdate(text, mostRecentEventCount));
                }
                reactEditText.maybeSetSelection(mostRecentEventCount, start, end);
            }
        }
    }

    private final ReactTextUpdate getReactTextUpdate(String text, int mostRecentEventCount) {
        SpannableStringBuilder sb = new SpannableStringBuilder();
        sb.append((CharSequence)text);
        return new ReactTextUpdate((Spannable)sb, mostRecentEventCount, false, 0.0f, 0.0f, 0.0f, 0.0f, 0, 0, 0);
    }

    @Override
    public void updateExtraData(@NotNull ReactEditText view, @NotNull Object extraData) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Intrinsics.checkNotNullParameter((Object)extraData, (String)"extraData");
        if (extraData instanceof ReactTextUpdate) {
            int paddingLeft = (int)((ReactTextUpdate)extraData).getPaddingLeft();
            int paddingTop = (int)((ReactTextUpdate)extraData).getPaddingTop();
            int paddingRight = (int)((ReactTextUpdate)extraData).getPaddingRight();
            int paddingBottom = (int)((ReactTextUpdate)extraData).getPaddingBottom();
            if (paddingLeft != -1 || paddingTop != -1 || paddingRight != -1 || paddingBottom != -1) {
                view.setPadding(paddingLeft != -1 ? paddingLeft : view.getPaddingLeft(), paddingTop != -1 ? paddingTop : view.getPaddingTop(), paddingRight != -1 ? paddingRight : view.getPaddingRight(), paddingBottom != -1 ? paddingBottom : view.getPaddingBottom());
            }
            if (((ReactTextUpdate)extraData).containsImages()) {
                Spannable spannable = ((ReactTextUpdate)extraData).getText();
                TextInlineImageSpan.Companion.possiblyUpdateInlineImageSpans(spannable, (TextView)view);
            }
            boolean isCurrentSelectionEmpty = view.getSelectionStart() == view.getSelectionEnd();
            int selectionStart = -1;
            int selectionEnd = -1;
            if (isCurrentSelectionEmpty) {
                Editable editable = view.getText();
                int textLength = editable != null ? editable.length() : 0;
                int selectionOffset = textLength - view.getSelectionStart();
                selectionEnd = selectionStart = ((ReactTextUpdate)extraData).getText().length() - selectionOffset;
            }
            view.maybeSetTextFromState((ReactTextUpdate)extraData);
            view.maybeSetSelection(((ReactTextUpdate)extraData).getJsEventCounter(), selectionStart, selectionEnd);
        }
    }

    @ReactProp(name="lineHeight", defaultFloat=0.0f)
    public final void setLineHeight(@NotNull ReactEditText view, int lineHeight) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setLineHeight(lineHeight);
    }

    @ReactProp(name="fontSize", defaultFloat=14.0f)
    public final void setFontSize(@NotNull ReactEditText view, float fontSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setFontSize(fontSize);
    }

    @ReactProp(name="fontFamily")
    public final void setFontFamily(@NotNull ReactEditText view, @Nullable String fontFamily) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setFontFamily(fontFamily);
    }

    @ReactProp(name="maxFontSizeMultiplier", defaultFloat=NaNf)
    public final void setMaxFontSizeMultiplier(@NotNull ReactEditText view, float maxFontSizeMultiplier) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setMaxFontSizeMultiplier(maxFontSizeMultiplier);
    }

    @ReactProp(name="fontWeight")
    public final void setFontWeight(@NotNull ReactEditText view, @Nullable String fontWeight) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setFontWeight(fontWeight);
    }

    @ReactProp(name="fontStyle")
    public final void setFontStyle(@NotNull ReactEditText view, @Nullable String fontStyle) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setFontStyle(fontStyle);
    }

    @ReactProp(name="fontVariant")
    public final void setFontVariant(@NotNull ReactEditText view, @Nullable ReadableArray fontVariant) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setFontFeatureSettings(ReactTypefaceUtils.parseFontVariant(fontVariant));
    }

    @ReactProp(name="includeFontPadding", defaultBoolean=true)
    public final void setIncludeFontPadding(@NotNull ReactEditText view, boolean includepad) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setIncludeFontPadding(includepad);
    }

    @ReactProp(name="importantForAutofill")
    public final void setImportantForAutofill(@NotNull ReactEditText view, @Nullable String value) {
        int mode;
        block16: {
            Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
            mode = 0;
            String string2 = value;
            if (string2 == null) break block16;
            int n = -1;
            switch (string2.hashCode()) {
                case 3521: {
                    if (string2.equals("no")) {
                        n = 1;
                    }
                    break;
                }
                case 1723649149: {
                    if (string2.equals("noExcludeDescendants")) {
                        n = 2;
                    }
                    break;
                }
                case 1828836387: {
                    if (string2.equals("yesExcludeDescendants")) {
                        n = 3;
                    }
                    break;
                }
                case 119527: {
                    if (string2.equals("yes")) {
                        n = 4;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    mode = 2;
                    break;
                }
                case 2: {
                    mode = 8;
                    break;
                }
                case 4: {
                    mode = 1;
                    break;
                }
                case 3: {
                    mode = 4;
                }
            }
        }
        this.setImportantForAutofill(view, mode);
    }

    private final void setImportantForAutofill(ReactEditText view, int mode) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        view.setImportantForAutofill(mode);
    }

    private final void setAutofillHints(ReactEditText view, String ... hints) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        view.setAutofillHints(Arrays.copyOf(hints, hints.length));
    }

    @ReactProp(name="onSelectionChange", defaultBoolean=false)
    public final void setOnSelectionChange(@NotNull ReactEditText view, boolean onSelectionChange) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (onSelectionChange) {
            view.setSelectionWatcher$ReactAndroid_debug(new ReactTextSelectionWatcher(view));
        } else {
            view.setSelectionWatcher$ReactAndroid_debug(null);
        }
    }

    @ReactProp(name="submitBehavior")
    public final void setSubmitBehavior(@NotNull ReactEditText view, @Nullable String submitBehavior) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setSubmitBehavior(submitBehavior);
    }

    @ReactProp(name="onContentSizeChange", defaultBoolean=false)
    public final void setOnContentSizeChange(@NotNull ReactEditText view, boolean onContentSizeChange) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (onContentSizeChange) {
            view.setContentSizeWatcher(new ReactTextContentSizeWatcher(view));
        } else {
            view.setContentSizeWatcher(null);
        }
    }

    @ReactProp(name="onScroll", defaultBoolean=false)
    public final void setOnScroll(@NotNull ReactEditText view, boolean onScroll) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (onScroll) {
            view.setScrollWatcher(new ReactTextScrollWatcher(view));
        } else {
            view.setScrollWatcher(null);
        }
    }

    @ReactProp(name="onKeyPress", defaultBoolean=false)
    public final void setOnKeyPress(@NotNull ReactEditText view, boolean onKeyPress) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setOnKeyPress(onKeyPress);
    }

    @ReactProp(name="letterSpacing", defaultFloat=0.0f)
    public final void setLetterSpacing(@NotNull ReactEditText view, float letterSpacing) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setLetterSpacingPt(letterSpacing);
    }

    @ReactProp(name="allowFontScaling", defaultBoolean=true)
    public final void setAllowFontScaling(@NotNull ReactEditText view, boolean allowFontScaling) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setAllowFontScaling(allowFontScaling);
    }

    @ReactProp(name="placeholder")
    public final void setPlaceholder(@NotNull ReactEditText view, @Nullable String placeholder) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setPlaceholder(placeholder);
    }

    @ReactProp(name="placeholderTextColor", customType="Color")
    public final void setPlaceholderTextColor(@NotNull ReactEditText view, @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (color == null) {
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            view.setHintTextColor(DefaultStyleValuesUtil.getDefaultTextColorHint(context));
        } else {
            view.setHintTextColor(color);
        }
    }

    @ReactProp(name="selectionColor", customType="Color")
    public final void setSelectionColor(@NotNull ReactEditText view, @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (color == null) {
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            view.setHighlightColor(DefaultStyleValuesUtil.getDefaultTextColorHighlight(context));
        } else {
            view.setHighlightColor(color);
        }
    }

    @ReactProp(name="selectionHandleColor", customType="Color")
    public final void setSelectionHandleColor(@NotNull ReactEditText view, @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (Build.VERSION.SDK_INT >= 29) {
            Drawable drawable2 = view.getTextSelectHandle();
            Object object = drawable2 != null ? drawable2.mutate() : null;
            if (object == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Drawable drawableCenter = object;
            Drawable drawable3 = view.getTextSelectHandleLeft();
            Object object2 = drawable3 != null ? drawable3.mutate() : null;
            if (object2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalStateException(string3.toString());
            }
            Drawable drawableLeft = object2;
            Drawable drawable4 = view.getTextSelectHandleRight();
            Object object3 = drawable4 != null ? drawable4.mutate() : null;
            if (object3 == null) {
                String string4 = "Required value was null.";
                throw new IllegalStateException(string4.toString());
            }
            Drawable drawableRight = object3;
            if (color != null) {
                BlendModeColorFilter filter = new BlendModeColorFilter(color.intValue(), BlendMode.SRC_IN);
                drawableCenter.setColorFilter((ColorFilter)filter);
                drawableLeft.setColorFilter((ColorFilter)filter);
                drawableRight.setColorFilter((ColorFilter)filter);
            } else {
                drawableCenter.clearColorFilter();
                drawableLeft.clearColorFilter();
                drawableRight.clearColorFilter();
            }
            view.setTextSelectHandle(drawableCenter);
            view.setTextSelectHandleLeft(drawableLeft);
            view.setTextSelectHandleRight(drawableRight);
            return;
        }
        if (Build.VERSION.SDK_INT == 28) {
            return;
        }
        int n = DRAWABLE_HANDLE_RESOURCES.length;
        for (int i = 0; i < n; ++i) {
            try {
                Object editor;
                Drawable drawable5;
                Field drawableResourceField = ((Object)((Object)view)).getClass().getDeclaredField(DRAWABLE_HANDLE_RESOURCES[i]);
                drawableResourceField.setAccessible(true);
                int resourceId = drawableResourceField.getInt((Object)view);
                if (resourceId == 0) {
                    return;
                }
                Drawable drawable6 = ContextCompat.getDrawable((Context)view.getContext(), (int)resourceId);
                if ((drawable6 != null ? drawable6.mutate() : null) == null) {
                    String string5 = "Required value was null.";
                    throw new IllegalStateException(string5.toString());
                }
                drawable5 = drawable5;
                if (color != null) {
                    drawable5.setColorFilter(color.intValue(), PorterDuff.Mode.SRC_IN);
                } else {
                    drawable5.clearColorFilter();
                }
                Field editorField = TextView.class.getDeclaredField("mEditor");
                editorField.setAccessible(true);
                if (editorField.get((Object)view) == null) {
                    String string6 = "Required value was null.";
                    throw new IllegalStateException(string6.toString());
                }
                Field cursorDrawableField = editor.getClass().getDeclaredField(DRAWABLE_HANDLE_FIELDS[i]);
                cursorDrawableField.setAccessible(true);
                cursorDrawableField.set(editor, drawable5);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    @ReactProp(name="cursorColor", customType="Color")
    public final void setCursorColor(@NotNull ReactEditText view, @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (Build.VERSION.SDK_INT >= 29) {
            Drawable cursorDrawable = view.getTextCursorDrawable();
            if (cursorDrawable != null) {
                if (color != null) {
                    cursorDrawable.setColorFilter((ColorFilter)new BlendModeColorFilter(color.intValue(), BlendMode.SRC_IN));
                } else {
                    cursorDrawable.clearColorFilter();
                }
                view.setTextCursorDrawable(cursorDrawable);
            }
            return;
        }
        if (Build.VERSION.SDK_INT == 28) {
            return;
        }
        try {
            Field drawableCursorField = ((Object)((Object)view)).getClass().getDeclaredField("mCursorDrawableRes");
            drawableCursorField.setAccessible(true);
            int resourceId = drawableCursorField.getInt((Object)view);
            if (resourceId == 0) {
                return;
            }
            Drawable drawable2 = ContextCompat.getDrawable((Context)view.getContext(), (int)resourceId);
            Object object = drawable2 != null ? drawable2.mutate() : null;
            if (object == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Drawable drawable3 = object;
            if (color != null) {
                drawable3.setColorFilter(color.intValue(), PorterDuff.Mode.SRC_IN);
            } else {
                drawable3.clearColorFilter();
            }
            Field editorField = TextView.class.getDeclaredField("mEditor");
            editorField.setAccessible(true);
            Object object2 = editorField.get((Object)view);
            if (object2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalStateException(string3.toString());
            }
            Object editor = object2;
            Field cursorDrawableField = editor.getClass().getDeclaredField("mCursorDrawable");
            cursorDrawableField.setAccessible(true);
            Drawable[] drawableArray = new Drawable[]{drawable3, drawable3};
            Drawable[] drawables = drawableArray;
            cursorDrawableField.set(editor, drawables);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @ReactProp(name="caretHidden", defaultBoolean=false)
    public final void setCaretHidden(@NotNull ReactEditText view, boolean caretHidden) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (view.getStagedInputType() == 32 && ReactTextInputManager.Companion.shouldHideCursorForEmailTextInput()) {
            return;
        }
        view.setCursorVisible(!caretHidden);
    }

    @ReactProp(name="contextMenuHidden", defaultBoolean=false)
    public final void setContextMenuHidden(@NotNull ReactEditText view, boolean contextMenuHidden) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setContextMenuHidden(contextMenuHidden);
    }

    @ReactProp(name="selectTextOnFocus", defaultBoolean=false)
    public final void setSelectTextOnFocus(@NotNull ReactEditText view, boolean selectTextOnFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setSelectTextOnFocus(selectTextOnFocus);
    }

    @ReactProp(name="color", customType="Color")
    public final void setColor(@NotNull ReactEditText view, @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (color == null) {
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            ColorStateList defaultContextTextColor = DefaultStyleValuesUtil.getDefaultTextColor(context);
            if (defaultContextTextColor != null) {
                view.setTextColor(defaultContextTextColor);
            } else {
                Context c;
                Context context2 = c = view.getContext();
                ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Could not get default text color from View Context: " + (context2 != null ? context2.getClass().getCanonicalName() : "null")));
            }
        } else {
            view.setTextColor(color);
        }
    }

    @ReactProp(name="underlineColorAndroid", customType="Color")
    public final void setUnderlineColor(@NotNull ReactEditText view, @Nullable Integer underlineColor) {
        Drawable background;
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Drawable drawableToMutate = background = view.getBackground();
        if (background == null) {
            return;
        }
        if (background.getConstantState() != null) {
            try {
                Drawable drawable2 = background.mutate();
                if (drawable2 == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalStateException(string2.toString());
                }
                drawableToMutate = drawable2;
            }
            catch (NullPointerException e) {
                FLog.e((String)TAG, (String)"NullPointerException when setting underlineColorAndroid for TextInput", (Throwable)e);
            }
        }
        if (underlineColor == null) {
            drawableToMutate.clearColorFilter();
        } else {
            drawableToMutate.setColorFilter(underlineColor.intValue(), PorterDuff.Mode.SRC_IN);
        }
    }

    /*
     * Unable to fully structure code
     */
    @ReactProp(name="textAlign")
    @SuppressLint(value={"WrongConstant"})
    public final void setTextAlign(@NotNull ReactEditText view, @Nullable String textAlign) {
        block19: {
            block18: {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                if (!Intrinsics.areEqual((Object)"justify", (Object)textAlign)) break block18;
                if (Build.VERSION.SDK_INT >= 26) {
                    view.setJustificationMode(1);
                }
                view.setGravityHorizontal$ReactAndroid_debug(3);
                break block19;
            }
            if (Build.VERSION.SDK_INT >= 26) {
                view.setJustificationMode(0);
            }
            if ((var3_3 = textAlign) == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var3_3.hashCode()) {
                case 3005871: {
                    if (var3_3.equals("auto")) {
                        tmp = 1;
                    }
                    break;
                }
                case 3317767: {
                    if (var3_3.equals("left")) {
                        tmp = 2;
                    }
                    break;
                }
                case -1364013995: {
                    if (var3_3.equals("center")) {
                        tmp = 3;
                    }
                    break;
                }
                case 108511772: {
                    if (var3_3.equals("right")) {
                        tmp = 4;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: lbl-1000:
                // 2 sources

                {
                    view.setGravityHorizontal$ReactAndroid_debug(0);
                    break;
                }
                case 2: {
                    view.setGravityHorizontal$ReactAndroid_debug(3);
                    break;
                }
                case 4: {
                    view.setGravityHorizontal$ReactAndroid_debug(5);
                    break;
                }
                case 3: {
                    view.setGravityHorizontal$ReactAndroid_debug(1);
                    break;
                }
                default: {
                    FLog.w((String)"ReactNative", (String)("Invalid textAlign: " + textAlign));
                    view.setGravityHorizontal$ReactAndroid_debug(0);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @ReactProp(name="textAlignVertical")
    public final void setTextAlignVertical(@NotNull ReactEditText view, @Nullable String textAlignVertical) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        var3_3 = textAlignVertical;
        if (var3_3 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var3_3.hashCode()) {
            case 3005871: {
                if (var3_3.equals("auto")) {
                    tmp = 1;
                }
                break;
            }
            case 115029: {
                if (var3_3.equals("top")) {
                    tmp = 2;
                }
                break;
            }
            case -1383228885: {
                if (var3_3.equals("bottom")) {
                    tmp = 3;
                }
                break;
            }
            case -1364013995: {
                if (var3_3.equals("center")) {
                    tmp = 4;
                }
                break;
            }
        }
        switch (tmp) {
            case 1: lbl-1000:
            // 2 sources

            {
                view.setGravityVertical$ReactAndroid_debug(0);
                break;
            }
            case 2: {
                view.setGravityVertical$ReactAndroid_debug(48);
                break;
            }
            case 3: {
                view.setGravityVertical$ReactAndroid_debug(80);
                break;
            }
            case 4: {
                view.setGravityVertical$ReactAndroid_debug(16);
                break;
            }
            default: {
                FLog.w((String)"ReactNative", (String)("Invalid textAlignVertical: " + textAlignVertical));
                view.setGravityVertical$ReactAndroid_debug(0);
            }
        }
    }

    @ReactProp(name="inlineImageLeft")
    public final void setInlineImageLeft(@NotNull ReactEditText view, @Nullable String resource) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        int id2 = ResourceDrawableIdHelper.getResourceDrawableId(context, resource);
        view.setCompoundDrawablesWithIntrinsicBounds(id2, 0, 0, 0);
    }

    @ReactProp(name="inlineImagePadding")
    public final void setInlineImagePadding(@NotNull ReactEditText view, int padding) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setCompoundDrawablePadding(padding);
    }

    @ReactProp(name="editable", defaultBoolean=true)
    public final void setEditable(@NotNull ReactEditText view, boolean editable) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setEnabled(editable);
    }

    @ReactProp(name="numberOfLines", defaultInt=1)
    public final void setNumLines(@NotNull ReactEditText view, int numLines) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setLines(numLines);
    }

    @ReactProp(name="maxLength")
    public final void setMaxLength(@NotNull ReactEditText view, @Nullable Integer maxLength) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Object[] currentFilters = view.getFilters();
        InputFilter[] newFilters = EMPTY_FILTERS;
        if (maxLength == null) {
            Intrinsics.checkNotNull((Object)currentFilters);
            if (!(currentFilters.length == 0)) {
                LinkedList<InputFilter> list = new LinkedList<InputFilter>();
                Iterator iterator2 = ArrayIteratorKt.iterator((Object[])currentFilters);
                while (iterator2.hasNext()) {
                    InputFilter currentFilter = (InputFilter)iterator2.next();
                    if (currentFilter instanceof InputFilter.LengthFilter) continue;
                    list.add(currentFilter);
                }
                if (!list.isEmpty()) {
                    Collection $this$toTypedArray$iv = list;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    newFilters = thisCollection$iv.toArray(new InputFilter[0]);
                }
            }
        } else {
            Intrinsics.checkNotNull((Object)currentFilters);
            if (!(currentFilters.length == 0)) {
                newFilters = currentFilters;
                boolean replaced = false;
                int n = currentFilters.length;
                for (int i = 0; i < n; ++i) {
                    if (!(currentFilters[i] instanceof InputFilter.LengthFilter)) continue;
                    currentFilters[i] = new InputFilter.LengthFilter(maxLength.intValue());
                    replaced = true;
                }
                if (!replaced) {
                    newFilters = new InputFilter[currentFilters.length + 1];
                    System.arraycopy(currentFilters, 0, newFilters, 0, currentFilters.length);
                    currentFilters[currentFilters.length] = new InputFilter.LengthFilter(maxLength.intValue());
                }
            } else {
                newFilters = new InputFilter[]{new InputFilter.LengthFilter(maxLength.intValue())};
            }
        }
        view.setFilters(newFilters);
    }

    @ReactProp(name="autoComplete")
    public final void setTextContentType(@NotNull ReactEditText view, @Nullable String autoComplete) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (autoComplete == null) {
            this.setImportantForAutofill(view, 2);
        } else if (Intrinsics.areEqual((Object)"off", (Object)autoComplete)) {
            this.setImportantForAutofill(view, 2);
        } else if (REACT_PROPS_AUTOFILL_HINTS_MAP.containsKey(autoComplete)) {
            String[] stringArray = new String[1];
            if (REACT_PROPS_AUTOFILL_HINTS_MAP.get(autoComplete) == null) {
                String cfr_ignored_0 = stringArray[0];
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            this.setAutofillHints(view, stringArray);
        } else {
            FLog.w((String)"ReactNative", (String)("Invalid autoComplete: " + autoComplete));
            this.setImportantForAutofill(view, 2);
        }
    }

    @ReactProp(name="autoCorrect")
    public final void setAutoCorrect(@NotNull ReactEditText view, @Nullable Boolean autoCorrect) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Boolean bl = autoCorrect;
        ReactTextInputManager.Companion.updateStagedInputTypeFlag(view, 557056, Intrinsics.areEqual((Object)bl, (Object)true) ? 32768 : (Intrinsics.areEqual((Object)bl, (Object)false) ? 524288 : 0));
    }

    @ReactProp(name="multiline", defaultBoolean=false)
    public final void setMultiline(@NotNull ReactEditText view, boolean multiline) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        ReactTextInputManager.Companion.updateStagedInputTypeFlag(view, multiline ? 0 : 131072, multiline ? 131072 : 0);
    }

    @ReactProp(name="secureTextEntry", defaultBoolean=false)
    public final void setSecureTextEntry(@NotNull ReactEditText view, boolean password) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        ReactTextInputManager.Companion.updateStagedInputTypeFlag(view, password ? 144 : 144, password ? 128 : 0);
        ReactTextInputManager.Companion.checkPasswordType(view);
    }

    /*
     * Unable to fully structure code
     */
    @ReactProp(name="autoCapitalize")
    public final void setAutoCapitalize(@NotNull ReactEditText view, @NotNull Dynamic autoCapitalize) {
        block9: {
            block10: {
                block11: {
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                        Intrinsics.checkNotNullParameter((Object)autoCapitalize, (String)"autoCapitalize");
                        autoCapitalizeValue = 16384;
                        if (autoCapitalize.getType() != ReadableType.Number) break block8;
                        autoCapitalizeValue = autoCapitalize.asInt();
                        break block9;
                    }
                    if (autoCapitalize.getType() != ReadableType.String || (var5_5 = (autoCapitalizeStr = autoCapitalize.asString())) == null) break block9;
                    switch (var5_5.hashCode()) {
                        case 1245424234: {
                            if (var5_5.equals("characters")) break;
                            ** break;
                        }
                        case 490141296: {
                            if (!var5_5.equals("sentences")) {
                                ** break;
                            }
                            break block10;
                        }
                        case 113318569: {
                            if (!var5_5.equals("words")) {
                                ** break;
                            }
                            break block11;
                        }
                        case 3387192: {
                            if (!var5_5.equals("none")) ** break;
                            autoCapitalizeValue = 0;
                            ** break;
                        }
                    }
                    autoCapitalizeValue = 4096;
                    ** break;
                }
                autoCapitalizeValue = 8192;
                ** break;
            }
            autoCapitalizeValue = 16384;
        }
        com.facebook.react.views.textinput.ReactTextInputManager$Companion.access$updateStagedInputTypeFlag(ReactTextInputManager.Companion, view, 28672, autoCapitalizeValue);
    }

    @ReactProp(name="keyboardType")
    public final void setKeyboardType(@NotNull ReactEditText view, @Nullable String keyboardType) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        int flagsToSet = 1;
        if (StringsKt.equals((String)KEYBOARD_TYPE_NUMERIC, (String)keyboardType, (boolean)true)) {
            flagsToSet = 12290;
        } else if (StringsKt.equals((String)KEYBOARD_TYPE_NUMBER_PAD, (String)keyboardType, (boolean)true)) {
            flagsToSet = 2;
        } else if (StringsKt.equals((String)KEYBOARD_TYPE_DECIMAL_PAD, (String)keyboardType, (boolean)true)) {
            flagsToSet = 8194;
        } else if (StringsKt.equals((String)KEYBOARD_TYPE_EMAIL_ADDRESS, (String)keyboardType, (boolean)true)) {
            flagsToSet = 33;
            if (ReactTextInputManager.Companion.shouldHideCursorForEmailTextInput()) {
                view.setCursorVisible(false);
            }
        } else if (StringsKt.equals((String)KEYBOARD_TYPE_PHONE_PAD, (String)keyboardType, (boolean)true)) {
            flagsToSet = 3;
        } else if (StringsKt.equals((String)KEYBOARD_TYPE_VISIBLE_PASSWORD, (String)keyboardType, (boolean)true)) {
            flagsToSet = 144;
        } else if (StringsKt.equals((String)KEYBOARD_TYPE_URI, (String)keyboardType, (boolean)true)) {
            flagsToSet = 16;
        }
        ReactTextInputManager.Companion.updateStagedInputTypeFlag(view, 15, flagsToSet);
        ReactTextInputManager.Companion.checkPasswordType(view);
    }

    @ReactProp(name="returnKeyType")
    public final void setReturnKeyType(@NotNull ReactEditText view, @Nullable String returnKeyType) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setReturnKeyType(returnKeyType);
    }

    @ReactProp(name="acceptDragAndDropTypes")
    public final void setAcceptDragAndDropTypes(@NotNull ReactEditText view, @Nullable ReadableArray acceptDragAndDropTypes) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (acceptDragAndDropTypes == null) {
            view.setDragAndDropFilter(null);
        } else {
            List acceptedTypes = new ArrayList();
            int n = acceptDragAndDropTypes.size();
            for (int i = 0; i < n; ++i) {
                String string2;
                if (acceptDragAndDropTypes.getString(i) == null) continue;
                String p0 = string2;
                boolean bl = false;
                acceptedTypes.add(p0);
            }
            view.setDragAndDropFilter(acceptedTypes);
        }
    }

    @ReactProp(name="disableFullscreenUI", defaultBoolean=false)
    public final void setDisableFullscreenUI(@NotNull ReactEditText view, boolean disableFullscreenUI) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setDisableFullscreenUI(disableFullscreenUI);
    }

    @ReactProp(name="returnKeyLabel")
    public final void setReturnKeyLabel(@NotNull ReactEditText view, @Nullable String returnKeyLabel) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setImeActionLabel(returnKeyLabel, 1648);
    }

    @ReactPropGroup(names={"borderRadius", "borderTopLeftRadius", "borderTopRightRadius", "borderBottomRightRadius", "borderBottomLeftRadius"}, defaultFloat=NaNf)
    public final void setBorderRadius(@NotNull ReactEditText view, int index, float borderRadius) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        LengthPercentage radius = Float.isNaN(borderRadius) ? null : new LengthPercentage(borderRadius, LengthPercentageType.POINT);
        BackgroundStyleApplicator.setBorderRadius((View)view, (BorderRadiusProp)((Object)BorderRadiusProp.getEntries().get(index)), radius);
    }

    @ReactProp(name="borderStyle")
    public final void setBorderStyle(@NotNull ReactEditText view, @Nullable String borderStyle) {
        BorderStyle borderStyle2;
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        String string2 = borderStyle;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            borderStyle2 = BorderStyle.Companion.fromString(it);
        } else {
            borderStyle2 = null;
        }
        BorderStyle parsedBorderStyle = borderStyle2;
        BackgroundStyleApplicator.setBorderStyle((View)view, parsedBorderStyle);
    }

    @ReactProp(name="showSoftInputOnFocus", defaultBoolean=true)
    public final void showKeyboardOnFocus(@NotNull ReactEditText view, boolean showKeyboardOnFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setShowSoftInputOnFocus(showKeyboardOnFocus);
    }

    @ReactProp(name="autoFocus", defaultBoolean=false)
    public final void setAutoFocus(@NotNull ReactEditText view, boolean autoFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setAutoFocus(autoFocus);
    }

    /*
     * WARNING - void declaration
     */
    @ReactProp(name="textDecorationLine")
    public final void setTextDecorationLine(@NotNull ReactEditText view, @Nullable String textDecorationLineString) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setPaintFlags(view.getPaintFlags() & 0xFFFFFFE7);
        if (textDecorationLineString == null) {
            return;
        }
        Object object = textDecorationLineString;
        Regex regex = new Regex(" ");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        for (String token : thisCollection$iv.toArray(new String[0])) {
            if (Intrinsics.areEqual((Object)token, (Object)"underline")) {
                view.setPaintFlags(view.getPaintFlags() | 8);
                continue;
            }
            if (!Intrinsics.areEqual((Object)token, (Object)"line-through")) continue;
            view.setPaintFlags(view.getPaintFlags() | 0x10);
        }
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth"}, defaultFloat=NaNf)
    public final void setBorderWidth(@NotNull ReactEditText view, int index, float width) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        BackgroundStyleApplicator.setBorderWidth((View)view, (LogicalEdge)((Object)LogicalEdge.getEntries().get(index)), Float.valueOf(width));
    }

    @ReactPropGroup(names={"borderColor", "borderLeftColor", "borderRightColor", "borderTopColor", "borderBottomColor"}, customType="Color")
    public final void setBorderColor(@NotNull ReactEditText view, int index, @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        BackgroundStyleApplicator.setBorderColor((View)view, LogicalEdge.ALL, color);
    }

    @ReactProp(name="overflow")
    public final void setOverflow(@NotNull ReactEditText view, @Nullable String overflow) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setOverflow(overflow);
    }

    @Override
    protected void onAfterUpdateTransaction(@NotNull ReactEditText view) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        super.onAfterUpdateTransaction((View)view);
        view.maybeUpdateTypeface();
        view.commitStagedInputType$ReactAndroid_debug();
    }

    @Override
    protected void addEventEmitters(@NotNull ThemedReactContext reactContext, @NotNull ReactEditText editText) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        Intrinsics.checkNotNullParameter((Object)((Object)editText), (String)"editText");
        editText.setEventDispatcher(ReactTextInputManager.Companion.getEventDispatcher(reactContext, editText));
        editText.addTextChangedListener(new ReactTextInputTextWatcher(reactContext, editText));
        editText.setOnFocusChangeListener((arg_0, arg_1) -> ReactTextInputManager.addEventEmitters$lambda$2(reactContext, editText, arg_0, arg_1));
        editText.setOnEditorActionListener((arg_0, arg_1, arg_2) -> ReactTextInputManager.addEventEmitters$lambda$3(editText, reactContext, arg_0, arg_1, arg_2));
    }

    @Override
    @NotNull
    public Map<String, Object> getExportedViewConstants() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"none", (Object)0), TuplesKt.to((Object)"characters", (Object)4096), TuplesKt.to((Object)"words", (Object)8192), TuplesKt.to((Object)"sentences", (Object)16384)};
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"AutoCapitalizationType", (Object)MapsKt.mapOf((Pair[])pairArray)));
    }

    @Override
    public void setPadding(@NotNull ReactEditText view, int left, int top, int right, int bottom) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setPadding(left, top, right, bottom);
    }

    @Override
    @Nullable
    public Object updateState(@NotNull ReactEditText view, @NotNull ReactStylesDiffMap props, @NotNull StateWrapper stateWrapper) {
        StateWrapper stateManager;
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Intrinsics.checkNotNullParameter((Object)stateWrapper, (String)"stateWrapper");
        if (ReactEditText.Companion.getDEBUG_MODE()) {
            FLog.e((String)TAG, (String)("updateState: [" + view.getId() + "]"));
        }
        if ((stateManager = view.getStateWrapper()) == null) {
            view.setPadding(0, 0, 0, 0);
        }
        view.setStateWrapper(stateWrapper);
        MapBuffer stateMapBuffer = stateWrapper.getStateDataMapBuffer();
        if (stateMapBuffer != null) {
            return this.getReactTextUpdate(view, props, stateMapBuffer);
        }
        return null;
    }

    @Nullable
    public final Object getReactTextUpdate(@NotNull ReactEditText view, @NotNull ReactStylesDiffMap props, @NotNull MapBuffer state) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state.getCount() == 0) {
            return null;
        }
        MapBuffer attributedString = state.getMapBuffer(0);
        MapBuffer paragraphAttributes = state.getMapBuffer(1);
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Spannable spanned = TextLayoutManager.INSTANCE.getOrCreateSpannableForText(context, attributedString, this.reactTextViewManagerCallback);
        int textBreakStrategy = TextAttributeProps.getTextBreakStrategy(paragraphAttributes.getString(2));
        int currentJustificationMode = Build.VERSION.SDK_INT < 26 ? 0 : view.getJustificationMode();
        return ReactTextUpdate.Companion.buildReactTextUpdateFromState(spanned, state.getInt(3), TextAttributeProps.getTextAlignment(props, TextLayoutManager.INSTANCE.isRTL(attributedString), view.getGravityHorizontal$ReactAndroid_debug()), textBreakStrategy, TextAttributeProps.getJustificationMode(props, currentJustificationMode));
    }

    private static final void addEventEmitters$lambda$2(ThemedReactContext $reactContext, ReactEditText $editText, View view, boolean hasFocus) {
        block2: {
            EventDispatcher eventDispatcher;
            int surfaceId;
            block1: {
                surfaceId = $reactContext.getSurfaceId();
                eventDispatcher = ReactTextInputManager.Companion.getEventDispatcher($reactContext, $editText);
                if (!hasFocus) break block1;
                EventDispatcher eventDispatcher2 = eventDispatcher;
                if (eventDispatcher2 == null) break block2;
                eventDispatcher2.dispatchEvent(new FocusEvent(surfaceId, $editText.getId()));
                break block2;
            }
            EventDispatcher eventDispatcher3 = eventDispatcher;
            if (eventDispatcher3 != null) {
                eventDispatcher3.dispatchEvent(new BlurEvent(surfaceId, $editText.getId()));
            }
            EventDispatcher eventDispatcher4 = eventDispatcher;
            if (eventDispatcher4 == null) break block2;
            eventDispatcher4.dispatchEvent(new ReactTextInputEndEditingEvent(surfaceId, $editText.getId(), String.valueOf($editText.getText())));
        }
    }

    private static final boolean addEventEmitters$lambda$3(ReactEditText $editText, ThemedReactContext $reactContext, TextView textView, int actionId, KeyEvent keyEvent) {
        if ((actionId & 0xFF) != 0 || actionId == 0) {
            boolean isMultiline = $editText.isMultiline$ReactAndroid_debug();
            boolean shouldSubmit = $editText.shouldSubmitOnReturn();
            boolean shouldBlur = $editText.shouldBlurOnReturn();
            if (shouldSubmit) {
                EventDispatcher eventDispatcher;
                EventDispatcher eventDispatcher2 = eventDispatcher = ReactTextInputManager.Companion.getEventDispatcher($reactContext, $editText);
                if (eventDispatcher2 != null) {
                    eventDispatcher2.dispatchEvent(new ReactTextInputSubmitEditingEvent($reactContext.getSurfaceId(), $editText.getId(), String.valueOf($editText.getText())));
                }
            }
            if (shouldBlur) {
                $editText.clearFocusAndMaybeRefocus$ReactAndroid_debug();
            }
            if (shouldBlur || shouldSubmit || !isMultiline) {
                return true;
            }
            return actionId == 5 || actionId == 7;
        }
        return true;
    }

    static {
        String string2 = ReactTextInputManager.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
        TAG = string2;
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"birthdate-day", (Object)"birthDateDay"), TuplesKt.to((Object)"birthdate-full", (Object)"birthDateFull"), TuplesKt.to((Object)"birthdate-month", (Object)"birthDateMonth"), TuplesKt.to((Object)"birthdate-year", (Object)"birthDateYear"), TuplesKt.to((Object)"cc-csc", (Object)"creditCardSecurityCode"), TuplesKt.to((Object)"cc-exp", (Object)"creditCardExpirationDate"), TuplesKt.to((Object)"cc-exp-day", (Object)"creditCardExpirationDay"), TuplesKt.to((Object)"cc-exp-month", (Object)"creditCardExpirationMonth"), TuplesKt.to((Object)"cc-exp-year", (Object)"creditCardExpirationYear"), TuplesKt.to((Object)"cc-number", (Object)"creditCardNumber"), TuplesKt.to((Object)"email", (Object)"emailAddress"), TuplesKt.to((Object)"gender", (Object)"gender"), TuplesKt.to((Object)"name", (Object)"personName"), TuplesKt.to((Object)"name-family", (Object)"personFamilyName"), TuplesKt.to((Object)"name-given", (Object)"personGivenName"), TuplesKt.to((Object)"name-middle", (Object)"personMiddleName"), TuplesKt.to((Object)"name-middle-initial", (Object)"personMiddleInitial"), TuplesKt.to((Object)"name-prefix", (Object)"personNamePrefix"), TuplesKt.to((Object)"name-suffix", (Object)"personNameSuffix"), TuplesKt.to((Object)"password", (Object)"password"), TuplesKt.to((Object)"password-new", (Object)"newPassword"), TuplesKt.to((Object)"postal-address", (Object)"postalAddress"), TuplesKt.to((Object)"postal-address-country", (Object)"addressCountry"), TuplesKt.to((Object)"postal-address-extended", (Object)"extendedAddress"), TuplesKt.to((Object)"postal-address-extended-postal-code", (Object)"extendedPostalCode"), TuplesKt.to((Object)"postal-address-locality", (Object)"addressLocality"), TuplesKt.to((Object)"postal-address-region", (Object)"addressRegion"), TuplesKt.to((Object)"postal-code", (Object)"postalCode"), TuplesKt.to((Object)"street-address", (Object)"streetAddress"), TuplesKt.to((Object)"sms-otp", (Object)"smsOTPCode"), TuplesKt.to((Object)"tel", (Object)"phoneNumber"), TuplesKt.to((Object)"tel-country-code", (Object)"phoneCountryCode"), TuplesKt.to((Object)"tel-national", (Object)"phoneNational"), TuplesKt.to((Object)"tel-device", (Object)"phoneNumberDevice"), TuplesKt.to((Object)"username", (Object)"username"), TuplesKt.to((Object)"username-new", (Object)"newUsername")};
        REACT_PROPS_AUTOFILL_HINTS_MAP = MapsKt.mapOf((Pair[])objectArray);
        EMPTY_FILTERS = new InputFilter[0];
        objectArray = new String[]{"mTextSelectHandleLeftRes", "mTextSelectHandleRightRes", "mTextSelectHandleRes"};
        DRAWABLE_HANDLE_RESOURCES = objectArray;
        objectArray = new String[]{"mSelectHandleLeft", "mSelectHandleRight", "mSelectHandleCenter"};
        DRAWABLE_HANDLE_FIELDS = objectArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J \u0010.\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u0010H\u0002J\u001a\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020-H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\"R\u000e\u0010#\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010%R\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010%R\u000e\u0010)\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/facebook/react/views/textinput/ReactTextInputManager$Companion;", "", "<init>", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "REACT_CLASS", "TX_STATE_KEY_ATTRIBUTED_STRING", "", "TX_STATE_KEY_PARAGRAPH_ATTRIBUTES", "TX_STATE_KEY_MOST_RECENT_EVENT_COUNT", "REACT_PROPS_AUTOFILL_HINTS_MAP", "", "FOCUS_TEXT_INPUT", "", "BLUR_TEXT_INPUT", "SET_MOST_RECENT_EVENT_COUNT", "SET_TEXT_AND_SELECTION", "INPUT_TYPE_KEYBOARD_NUMBER_PAD", "INPUT_TYPE_KEYBOARD_DECIMAL_PAD", "INPUT_TYPE_KEYBOARD_NUMBERED", "AUTOCAPITALIZE_FLAGS", "KEYBOARD_TYPE_EMAIL_ADDRESS", "KEYBOARD_TYPE_NUMERIC", "KEYBOARD_TYPE_DECIMAL_PAD", "KEYBOARD_TYPE_NUMBER_PAD", "KEYBOARD_TYPE_PHONE_PAD", "KEYBOARD_TYPE_VISIBLE_PASSWORD", "KEYBOARD_TYPE_URI", "EMPTY_FILTERS", "", "Landroid/text/InputFilter;", "[Landroid/text/InputFilter;", "UNSET", "DRAWABLE_HANDLE_RESOURCES", "[Ljava/lang/String;", "DRAWABLE_HANDLE_FIELDS", "shouldHideCursorForEmailTextInput", "", "IME_ACTION_ID", "checkPasswordType", "", "view", "Lcom/facebook/react/views/textinput/ReactEditText;", "updateStagedInputTypeFlag", "flagsToUnset", "flagsToSet", "getEventDispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "reactContext", "Lcom/facebook/react/bridge/ReactContext;", "editText", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        private final boolean shouldHideCursorForEmailTextInput() {
            String string2 = Build.MANUFACTURER;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MANUFACTURER");
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String manufacturer = string3;
            return Build.VERSION.SDK_INT == 29 && StringsKt.contains$default((CharSequence)manufacturer, (CharSequence)"xiaomi", (boolean)false, (int)2, null);
        }

        private final void checkPasswordType(ReactEditText view) {
            if ((view.getStagedInputType() & 0x3002) != 0 && (view.getStagedInputType() & 0x80) != 0) {
                this.updateStagedInputTypeFlag(view, 128, 16);
            }
        }

        private final void updateStagedInputTypeFlag(ReactEditText view, int flagsToUnset, int flagsToSet) {
            view.setStagedInputType(view.getStagedInputType() & ~flagsToUnset | flagsToSet);
        }

        private final EventDispatcher getEventDispatcher(ReactContext reactContext, ReactEditText editText) {
            return UIManagerHelper.getEventDispatcherForReactTag(reactContext, editText.getId());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

