/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.view.View;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.textinput.ContentSizeWatcher;
import com.facebook.react.views.textinput.ReactContentSizeChangedEvent;
import com.facebook.react.views.textinput.ReactEditText;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/views/textinput/ReactTextContentSizeWatcher;", "Lcom/facebook/react/views/textinput/ContentSizeWatcher;", "editText", "Lcom/facebook/react/views/textinput/ReactEditText;", "<init>", "(Lcom/facebook/react/views/textinput/ReactEditText;)V", "eventDispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "surfaceId", "", "previousContentWidth", "previousContentHeight", "onLayout", "", "ReactAndroid_debug"})
public final class ReactTextContentSizeWatcher
implements ContentSizeWatcher {
    @NotNull
    private final ReactEditText editText;
    @Nullable
    private final EventDispatcher eventDispatcher;
    private final int surfaceId;
    private int previousContentWidth;
    private int previousContentHeight;

    public ReactTextContentSizeWatcher(@NotNull ReactEditText editText) {
        Intrinsics.checkNotNullParameter((Object)((Object)editText), (String)"editText");
        this.editText = editText;
        ReactContext reactContext = UIManagerHelper.getReactContext((View)this.editText);
        this.eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag(reactContext, this.editText.getId());
        this.surfaceId = UIManagerHelper.getSurfaceId((Context)reactContext);
    }

    @Override
    public void onLayout() {
        block2: {
            int contentWidth = this.editText.getWidth();
            int contentHeight = this.editText.getHeight();
            if (this.editText.getLayout() != null) {
                contentWidth = this.editText.getCompoundPaddingLeft() + this.editText.getLayout().getWidth() + this.editText.getCompoundPaddingRight();
                contentHeight = this.editText.getCompoundPaddingTop() + this.editText.getLayout().getHeight() + this.editText.getCompoundPaddingBottom();
            }
            if (contentWidth == this.previousContentWidth && contentHeight == this.previousContentHeight) break block2;
            this.previousContentHeight = contentHeight;
            this.previousContentWidth = contentWidth;
            EventDispatcher eventDispatcher = this.eventDispatcher;
            if (eventDispatcher != null) {
                eventDispatcher.dispatchEvent(new ReactContentSizeChangedEvent(this.surfaceId, this.editText.getId(), PixelUtil.toDIPFromPixel(contentWidth), PixelUtil.toDIPFromPixel(contentHeight)));
            }
        }
    }
}

