/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import com.facebook.common.logging.FLog;
import com.facebook.react.common.annotations.UnstableReactNativeAPI;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.BorderStyle;
import com.facebook.react.uimanager.style.LogicalEdge;
import com.facebook.react.views.text.DefaultStyleValuesUtil;
import com.facebook.react.views.text.ReactBaseTextShadowNode;
import com.facebook.react.views.text.ReactTextView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UnstableReactNativeAPI
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b(\b'\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\fJ\u001d\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0001\u00a2\u0006\u0002\b\u0010J\u001f\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0001\u00a2\u0006\u0002\b\u0014J\u001d\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\u0017J\u001d\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b\u001bJ\u001d\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b\u001eJ\u001f\u0010\u001f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0013H\u0001\u00a2\u0006\u0002\b!J\u001d\u0010\"\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b$J!\u0010%\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\b\u0010&\u001a\u0004\u0018\u00010\u000fH\u0001\u00a2\u0006\u0004\b'\u0010(J\u001f\u0010)\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010\u0013H\u0001\u00a2\u0006\u0002\b+J%\u0010,\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b/J\u001f\u00100\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\b\u00101\u001a\u0004\u0018\u00010\u0013H\u0001\u00a2\u0006\u0002\b2J%\u00103\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b5J)\u00106\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u000f2\b\u0010&\u001a\u0004\u0018\u00010\u000fH\u0001\u00a2\u0006\u0004\b7\u00108J\u001d\u00109\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b;J\u001d\u0010<\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b>J\u001f\u0010?\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\b\u0010@\u001a\u0004\u0018\u00010\u0013H\u0001\u00a2\u0006\u0002\bA\u00a8\u0006B"}, d2={"Lcom/facebook/react/views/text/ReactTextAnchorViewManager;", "C", "Lcom/facebook/react/views/text/ReactBaseTextShadowNode;", "Lcom/facebook/react/uimanager/BaseViewManager;", "Lcom/facebook/react/views/text/ReactTextView;", "<init>", "()V", "setAccessible", "", "view", "accessible", "", "setAccessible$ReactAndroid_debug", "setNumberOfLines", "numberOfLines", "", "setNumberOfLines$ReactAndroid_debug", "setEllipsizeMode", "ellipsizeMode", "", "setEllipsizeMode$ReactAndroid_debug", "setAdjustFontSizeToFit", "adjustsFontSizeToFit", "setAdjustFontSizeToFit$ReactAndroid_debug", "setFontSize", "fontSize", "", "setFontSize$ReactAndroid_debug", "setLetterSpacing", "letterSpacing", "setLetterSpacing$ReactAndroid_debug", "setTextAlignVertical", "textAlignVertical", "setTextAlignVertical$ReactAndroid_debug", "setSelectable", "isSelectable", "setSelectable$ReactAndroid_debug", "setSelectionColor", "color", "setSelectionColor$ReactAndroid_debug", "(Lcom/facebook/react/views/text/ReactTextView;Ljava/lang/Integer;)V", "setAndroidHyphenationFrequency", "frequency", "setAndroidHyphenationFrequency$ReactAndroid_debug", "setBorderRadius", "index", "borderRadius", "setBorderRadius$ReactAndroid_debug", "setBorderStyle", "borderStyle", "setBorderStyle$ReactAndroid_debug", "setBorderWidth", "width", "setBorderWidth$ReactAndroid_debug", "setBorderColor", "setBorderColor$ReactAndroid_debug", "(Lcom/facebook/react/views/text/ReactTextView;ILjava/lang/Integer;)V", "setIncludeFontPadding", "includepad", "setIncludeFontPadding$ReactAndroid_debug", "setDisabled", "disabled", "setDisabled$ReactAndroid_debug", "setDataDetectorType", "type", "setDataDetectorType$ReactAndroid_debug", "ReactAndroid_debug"})
public abstract class ReactTextAnchorViewManager<C extends ReactBaseTextShadowNode>
extends BaseViewManager<ReactTextView, C> {
    @ReactProp(name="accessible")
    public final void setAccessible$ReactAndroid_debug(@NotNull ReactTextView view, boolean accessible) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setFocusable(accessible);
    }

    @ReactProp(name="numberOfLines", defaultInt=0x7FFFFFFF)
    public final void setNumberOfLines$ReactAndroid_debug(@NotNull ReactTextView view, int numberOfLines) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setNumberOfLines(numberOfLines);
    }

    /*
     * Unable to fully structure code
     */
    @ReactProp(name="ellipsizeMode")
    public final void setEllipsizeMode$ReactAndroid_debug(@NotNull ReactTextView view, @Nullable String ellipsizeMode) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        var3_3 = ellipsizeMode;
        if (var3_3 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var3_3.hashCode()) {
            case 3198432: {
                if (var3_3.equals("head")) {
                    tmp = 1;
                }
                break;
            }
            case -1074341483: {
                if (var3_3.equals("middle")) {
                    tmp = 2;
                }
                break;
            }
            case 3552336: {
                if (var3_3.equals("tail")) {
                    tmp = 3;
                }
                break;
            }
            case 3056464: {
                if (var3_3.equals("clip")) {
                    tmp = 4;
                }
                break;
            }
        }
        switch (tmp) {
            case 3: lbl-1000:
            // 2 sources

            {
                view.setEllipsizeLocation(TextUtils.TruncateAt.END);
                break;
            }
            case 1: {
                view.setEllipsizeLocation(TextUtils.TruncateAt.START);
                break;
            }
            case 2: {
                view.setEllipsizeLocation(TextUtils.TruncateAt.MIDDLE);
                break;
            }
            case 4: {
                view.setEllipsizeLocation(null);
                break;
            }
            default: {
                FLog.w((String)"ReactNative", (String)("Invalid ellipsizeMode: " + ellipsizeMode));
                view.setEllipsizeLocation(TextUtils.TruncateAt.END);
            }
        }
    }

    @ReactProp(name="adjustsFontSizeToFit")
    public final void setAdjustFontSizeToFit$ReactAndroid_debug(@NotNull ReactTextView view, boolean adjustsFontSizeToFit) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setAdjustFontSizeToFit(adjustsFontSizeToFit);
    }

    @ReactProp(name="fontSize")
    public final void setFontSize$ReactAndroid_debug(@NotNull ReactTextView view, float fontSize) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setFontSize(fontSize);
    }

    @ReactProp(name="letterSpacing", defaultFloat=0.0f)
    public final void setLetterSpacing$ReactAndroid_debug(@NotNull ReactTextView view, float letterSpacing) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setLetterSpacing(letterSpacing);
    }

    /*
     * Unable to fully structure code
     */
    @ReactProp(name="textAlignVertical")
    public final void setTextAlignVertical$ReactAndroid_debug(@NotNull ReactTextView view, @Nullable String textAlignVertical) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        var3_3 = textAlignVertical;
        if (var3_3 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var3_3.hashCode()) {
            case 3005871: {
                if (var3_3.equals("auto")) {
                    tmp = 1;
                }
                break;
            }
            case 115029: {
                if (var3_3.equals("top")) {
                    tmp = 2;
                }
                break;
            }
            case -1383228885: {
                if (var3_3.equals("bottom")) {
                    tmp = 3;
                }
                break;
            }
            case -1364013995: {
                if (var3_3.equals("center")) {
                    tmp = 4;
                }
                break;
            }
        }
        switch (tmp) {
            case 1: lbl-1000:
            // 2 sources

            {
                view.setGravityVertical(0);
                break;
            }
            case 2: {
                view.setGravityVertical(48);
                break;
            }
            case 3: {
                view.setGravityVertical(80);
                break;
            }
            case 4: {
                view.setGravityVertical(16);
                break;
            }
            default: {
                FLog.w((String)"ReactNative", (String)("Invalid textAlignVertical: " + textAlignVertical));
                view.setGravityVertical(0);
            }
        }
    }

    @ReactProp(name="selectable")
    public final void setSelectable$ReactAndroid_debug(@NotNull ReactTextView view, boolean isSelectable) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setTextIsSelectable(isSelectable);
    }

    @ReactProp(name="selectionColor", customType="Color")
    public final void setSelectionColor$ReactAndroid_debug(@NotNull ReactTextView view, @Nullable Integer color) {
        int n;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Integer n2 = color;
        if (n2 != null) {
            n = n2;
        } else {
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            n = DefaultStyleValuesUtil.getDefaultTextColorHighlight(context);
        }
        view.setHighlightColor(n);
    }

    /*
     * Unable to fully structure code
     */
    @ReactProp(name="android_hyphenationFrequency")
    public final void setAndroidHyphenationFrequency$ReactAndroid_debug(@NotNull ReactTextView view, @Nullable String frequency) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        var3_3 = frequency;
        if (var3_3 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var3_3.hashCode()) {
            case -1039745817: {
                if (var3_3.equals("normal")) {
                    tmp = 1;
                }
                break;
            }
            case 3387192: {
                if (var3_3.equals("none")) {
                    tmp = 2;
                }
                break;
            }
            case 3154575: {
                if (var3_3.equals("full")) {
                    tmp = 3;
                }
                break;
            }
        }
        switch (tmp) {
            case 2: lbl-1000:
            // 2 sources

            {
                view.setHyphenationFrequency(0);
                break;
            }
            case 3: {
                view.setHyphenationFrequency(2);
                break;
            }
            case 1: {
                view.setHyphenationFrequency(1);
                break;
            }
            default: {
                FLog.w((String)"ReactNative", (String)("Invalid android_hyphenationFrequency: " + frequency));
                view.setHyphenationFrequency(0);
            }
        }
    }

    @ReactPropGroup(names={"borderRadius", "borderTopLeftRadius", "borderTopRightRadius", "borderBottomRightRadius", "borderBottomLeftRadius"}, defaultFloat=NaNf)
    public final void setBorderRadius$ReactAndroid_debug(@NotNull ReactTextView view, int index, float borderRadius) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        LengthPercentage radius = Float.isNaN(borderRadius) ? null : new LengthPercentage(borderRadius, LengthPercentageType.POINT);
        BackgroundStyleApplicator.setBorderRadius((View)view, BorderRadiusProp.values()[index], radius);
    }

    @ReactProp(name="borderStyle")
    public final void setBorderStyle$ReactAndroid_debug(@NotNull ReactTextView view, @Nullable String borderStyle) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        String string2 = borderStyle;
        BorderStyle parsedBorderStyle = string2 == null ? null : BorderStyle.Companion.fromString(string2);
        BackgroundStyleApplicator.setBorderStyle((View)view, parsedBorderStyle);
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth", "borderStartWidth", "borderEndWidth"}, defaultFloat=NaNf)
    public final void setBorderWidth$ReactAndroid_debug(@NotNull ReactTextView view, int index, float width) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        BackgroundStyleApplicator.setBorderWidth((View)view, LogicalEdge.values()[index], Float.valueOf(width));
    }

    @ReactPropGroup(names={"borderColor", "borderLeftColor", "borderRightColor", "borderTopColor", "borderBottomColor"}, customType="Color")
    public final void setBorderColor$ReactAndroid_debug(@NotNull ReactTextView view, int index, @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        BackgroundStyleApplicator.setBorderColor((View)view, LogicalEdge.values()[index], color);
    }

    @ReactProp(name="includeFontPadding", defaultBoolean=true)
    public final void setIncludeFontPadding$ReactAndroid_debug(@NotNull ReactTextView view, boolean includepad) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setIncludeFontPadding(includepad);
    }

    @ReactProp(name="disabled", defaultBoolean=false)
    public final void setDisabled$ReactAndroid_debug(@NotNull ReactTextView view, boolean disabled) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setEnabled(!disabled);
    }

    @ReactProp(name="dataDetectorType")
    public final void setDataDetectorType$ReactAndroid_debug(@NotNull ReactTextView view, @Nullable String type) {
        block16: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            String string2 = type;
            if (string2 == null) break block16;
            int n = -1;
            switch (string2.hashCode()) {
                case 96673: {
                    if (string2.equals("all")) {
                        n = 1;
                    }
                    break;
                }
                case -1192969641: {
                    if (string2.equals("phoneNumber")) {
                        n = 2;
                    }
                    break;
                }
                case 3321850: {
                    if (string2.equals("link")) {
                        n = 3;
                    }
                    break;
                }
                case 96619420: {
                    if (string2.equals("email")) {
                        n = 4;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    view.setLinkifyMask(4);
                    return;
                }
                case 3: {
                    view.setLinkifyMask(1);
                    return;
                }
                case 4: {
                    view.setLinkifyMask(2);
                    return;
                }
                case 1: {
                    view.setLinkifyMask(15);
                    return;
                }
            }
        }
        view.setLinkifyMask(0);
    }
}

