/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.swiperefresh;

import android.content.Context;
import android.view.View;
import com.facebook.react.bridge.ColorPropConverter;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManagerDelegate;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.viewmanagers.AndroidSwipeRefreshLayoutManagerDelegate;
import com.facebook.react.viewmanagers.AndroidSwipeRefreshLayoutManagerInterface;
import com.facebook.react.views.swiperefresh.ReactSwipeRefreshLayout;
import com.facebook.react.views.swiperefresh.RefreshEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="AndroidSwipeRefreshLayout")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0011\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001)B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001a\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J\u001f\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0017\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0017J\u001a\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0011H\u0017J\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!H\u0017J\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0011H\u0016J\u0018\u0010#\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0014\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020&0%H\u0016J\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020&0%H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0014R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/facebook/react/views/swiperefresh/SwipeRefreshLayoutManager;", "Lcom/facebook/react/uimanager/ViewGroupManager;", "Lcom/facebook/react/views/swiperefresh/ReactSwipeRefreshLayout;", "Lcom/facebook/react/viewmanagers/AndroidSwipeRefreshLayoutManagerInterface;", "<init>", "()V", "delegate", "Lcom/facebook/react/uimanager/ViewManagerDelegate;", "createViewInstance", "reactContext", "Lcom/facebook/react/uimanager/ThemedReactContext;", "getName", "", "setEnabled", "", "view", "enabled", "", "setColors", "colors", "Lcom/facebook/react/bridge/ReadableArray;", "setProgressBackgroundColor", "color", "", "(Lcom/facebook/react/views/swiperefresh/ReactSwipeRefreshLayout;Ljava/lang/Integer;)V", "setSize", "value", "size", "Lcom/facebook/react/bridge/Dynamic;", "setRefreshing", "refreshing", "setProgressViewOffset", "offset", "", "setNativeRefreshing", "addEventEmitters", "getExportedViewConstants", "", "", "getExportedCustomDirectEventTypeConstants", "getDelegate", "Companion", "ReactAndroid_debug"})
public class SwipeRefreshLayoutManager
extends ViewGroupManager<ReactSwipeRefreshLayout>
implements AndroidSwipeRefreshLayoutManagerInterface<ReactSwipeRefreshLayout> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewManagerDelegate<ReactSwipeRefreshLayout> delegate = new AndroidSwipeRefreshLayoutManagerDelegate(this);
    @NotNull
    public static final String REACT_CLASS = "AndroidSwipeRefreshLayout";

    public SwipeRefreshLayoutManager() {
        super(null, 1, null);
    }

    @Override
    @NotNull
    protected ReactSwipeRefreshLayout createViewInstance(@NotNull ThemedReactContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        return new ReactSwipeRefreshLayout(reactContext);
    }

    @Override
    @NotNull
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    @ReactProp(name="enabled", defaultBoolean=true)
    public void setEnabled(@NotNull ReactSwipeRefreshLayout view, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setEnabled(enabled);
    }

    @Override
    @ReactProp(name="colors", customType="ColorArray")
    public void setColors(@NotNull ReactSwipeRefreshLayout view, @Nullable ReadableArray colors) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (colors != null) {
            int[] colorValues = new int[colors.size()];
            int n = colors.size();
            for (int i = 0; i < n; ++i) {
                if (colors.getType(i) == ReadableType.Map) {
                    ReadableMap readableMap = colors.getMap(i);
                    Context context = view.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                    colorValues[i] = ColorPropConverter.getColor(readableMap, context, 0);
                    continue;
                }
                colorValues[i] = colors.getInt(i);
            }
            view.setColorSchemeColors(Arrays.copyOf(colorValues, colorValues.length));
        } else {
            view.setColorSchemeColors(new int[0]);
        }
    }

    @Override
    @ReactProp(name="progressBackgroundColor", customType="Color")
    public void setProgressBackgroundColor(@NotNull ReactSwipeRefreshLayout view, @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Integer n = color;
        view.setProgressBackgroundColorSchemeColor(n != null ? n : 0);
    }

    public final void setSize(@NotNull ReactSwipeRefreshLayout view, int value) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setSize(value);
    }

    @Override
    public void setSize(@NotNull ReactSwipeRefreshLayout view, @Nullable String size) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (size == null || size.equals("default")) {
            view.setSize(1);
        } else if (size.equals("large")) {
            view.setSize(0);
        } else {
            throw new IllegalArgumentException("Size must be 'default' or 'large', received: " + size);
        }
    }

    @ReactProp(name="size")
    public final void setSize(@NotNull ReactSwipeRefreshLayout view, @NotNull Dynamic size) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        if (size.isNull()) {
            view.setSize(1);
        } else if (size.getType() == ReadableType.Number) {
            view.setSize(size.asInt());
        } else if (size.getType() == ReadableType.String) {
            this.setSize(view, size.asString());
        } else {
            throw new IllegalArgumentException("Size must be 'default' or 'large'");
        }
    }

    @Override
    @ReactProp(name="refreshing")
    public void setRefreshing(@NotNull ReactSwipeRefreshLayout view, boolean refreshing) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setRefreshing(refreshing);
    }

    @Override
    @ReactProp(name="progressViewOffset", defaultFloat=0.0f)
    public void setProgressViewOffset(@NotNull ReactSwipeRefreshLayout view, float offset) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setProgressViewOffset(offset);
    }

    @Override
    public void setNativeRefreshing(@NotNull ReactSwipeRefreshLayout view, boolean value) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        this.setRefreshing(view, value);
    }

    @Override
    protected void addEventEmitters(@NotNull ThemedReactContext reactContext, @NotNull ReactSwipeRefreshLayout view) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setOnRefreshListener(() -> SwipeRefreshLayoutManager.addEventEmitters$lambda$0(reactContext, view));
    }

    @Override
    @NotNull
    public Map<String, Object> getExportedViewConstants() {
        Pair[] pairArray = new Pair[1];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"DEFAULT", (Object)1), TuplesKt.to((Object)"LARGE", (Object)0)};
        pairArray[0] = TuplesKt.to((Object)"SIZE", (Object)MapsKt.mutableMapOf((Pair[])pairArray2));
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        Map baseEventTypeConstants = super.getExportedCustomDirectEventTypeConstants();
        Map map = baseEventTypeConstants;
        if (map == null) {
            map = new HashMap();
        }
        Map eventTypeConstants = map;
        Pair[] pairArray = new Pair[1];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"registrationName", (Object)"onRefresh")};
        pairArray[0] = TuplesKt.to((Object)"topRefresh", (Object)MapsKt.mutableMapOf((Pair[])pairArray2));
        eventTypeConstants.putAll(MapsKt.mutableMapOf((Pair[])pairArray));
        return eventTypeConstants;
    }

    @Override
    @NotNull
    protected ViewManagerDelegate<ReactSwipeRefreshLayout> getDelegate() {
        return this.delegate;
    }

    private static final void addEventEmitters$lambda$0(ThemedReactContext $reactContext, ReactSwipeRefreshLayout $view) {
        block0: {
            EventDispatcher eventDispatcher;
            EventDispatcher eventDispatcher2 = eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag($reactContext, $view.getId());
            if (eventDispatcher2 == null) break block0;
            eventDispatcher2.dispatchEvent(new RefreshEvent(UIManagerHelper.getSurfaceId((View)$view), $view.getId()));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/views/swiperefresh/SwipeRefreshLayoutManager$Companion;", "", "<init>", "()V", "REACT_CLASS", "", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

