/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UIManagerListener;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.views.scroll.ReactScrollViewHelper;
import com.facebook.react.views.view.ReactViewGroup;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\b\u0000\u0018\u0000*\u0010\b\u0000\u0010\u0001*\u0004\u0018\u00010\u0002*\u0004\u0018\u00010\u00032\u00020\u0004:\u0001+B\u0017\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\u0006\u0010\"\u001a\u00020 J\b\u0010#\u001a\u00020 H\u0002J\b\u0010$\u001a\u00020 H\u0002J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u001cH\u0016J\u0010\u0010'\u001a\u00020 2\u0006\u0010&\u001a\u00020\u001cH\u0016J\u0010\u0010(\u001a\u00020 2\u0006\u0010&\u001a\u00020\u001cH\u0016J\u0010\u0010)\u001a\u00020 2\u0006\u0010&\u001a\u00020\u001cH\u0016J\u0010\u0010*\u001a\u00020 2\u0006\u0010&\u001a\u00020\u001cH\u0016R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006,"}, d2={"Lcom/facebook/react/views/scroll/MaintainVisibleScrollPositionHelper;", "ScrollViewT", "Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasSmoothScroll;", "Landroid/view/ViewGroup;", "Lcom/facebook/react/bridge/UIManagerListener;", "scrollView", "horizontal", "", "<init>", "(Landroid/view/ViewGroup;Z)V", "Landroid/view/ViewGroup;", "config", "Lcom/facebook/react/views/scroll/MaintainVisibleScrollPositionHelper$Config;", "getConfig", "()Lcom/facebook/react/views/scroll/MaintainVisibleScrollPositionHelper$Config;", "setConfig", "(Lcom/facebook/react/views/scroll/MaintainVisibleScrollPositionHelper$Config;)V", "firstVisibleViewRef", "Ljava/lang/ref/WeakReference;", "Landroid/view/View;", "prevFirstVisibleFrame", "Landroid/graphics/Rect;", "isListening", "contentView", "Lcom/facebook/react/views/view/ReactViewGroup;", "getContentView", "()Lcom/facebook/react/views/view/ReactViewGroup;", "uIManager", "Lcom/facebook/react/bridge/UIManager;", "getUIManager", "()Lcom/facebook/react/bridge/UIManager;", "start", "", "stop", "updateScrollPosition", "updateScrollPositionInternal", "computeTargetView", "willDispatchViewUpdates", "uiManager", "willMountItems", "didMountItems", "didDispatchMountItems", "didScheduleMountItems", "Config", "ReactAndroid_debug"})
public final class MaintainVisibleScrollPositionHelper<ScrollViewT extends ViewGroup>
implements UIManagerListener {
    private final ScrollViewT scrollView;
    private final boolean horizontal;
    @Nullable
    private Config config;
    @Nullable
    private WeakReference<View> firstVisibleViewRef;
    @Nullable
    private Rect prevFirstVisibleFrame;
    private boolean isListening;

    public MaintainVisibleScrollPositionHelper(ScrollViewT scrollView, boolean horizontal) {
        this.scrollView = scrollView;
        this.horizontal = horizontal;
    }

    @Nullable
    public final Config getConfig() {
        return this.config;
    }

    public final void setConfig(@Nullable Config config) {
        this.config = config;
    }

    private final ReactViewGroup getContentView() {
        ScrollViewT ScrollViewT = this.scrollView;
        return (ReactViewGroup)(ScrollViewT != null ? ScrollViewT.getChildAt(0) : null);
    }

    private final UIManager getUIManager() {
        ScrollViewT ScrollViewT = this.scrollView;
        ReactContext reactContext = (ReactContext)((Object)(ScrollViewT != null ? ((View)ScrollViewT).getContext() : null));
        if (reactContext == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        ScrollViewT ScrollViewT2 = this.scrollView;
        UIManager uIManager = UIManagerHelper.getUIManager(reactContext, ViewUtil.getUIManagerType(ScrollViewT2 != null ? ((View)ScrollViewT2).getId() : 0));
        if (uIManager == null) {
            String string3 = "Required value was null.";
            throw new IllegalStateException(string3.toString());
        }
        return uIManager;
    }

    public final void start() {
        if (this.isListening) {
            return;
        }
        this.isListening = true;
        this.getUIManager().addUIManagerEventListener(this);
    }

    public final void stop() {
        if (!this.isListening) {
            return;
        }
        this.isListening = false;
        this.getUIManager().removeUIManagerEventListener(this);
    }

    public final void updateScrollPosition() {
        if (this.scrollView == null || ViewUtil.getUIManagerType(((View)this.scrollView).getId()) == 2) {
            return;
        }
        this.updateScrollPositionInternal();
    }

    private final void updateScrollPositionInternal() {
        Config config = this.config;
        if (config == null) {
            return;
        }
        Config config2 = config;
        WeakReference<View> weakReference = this.firstVisibleViewRef;
        if (weakReference == null) {
            return;
        }
        WeakReference<View> firstVisibleViewRef = weakReference;
        Rect rect = this.prevFirstVisibleFrame;
        if (rect == null) {
            return;
        }
        Rect prevFirstVisibleFrame = rect;
        View view = (View)firstVisibleViewRef.get();
        if (view == null) {
            return;
        }
        View firstVisibleView = view;
        ScrollViewT ScrollViewT = this.scrollView;
        if (ScrollViewT == null) {
            return;
        }
        ScrollViewT scrollView = ScrollViewT;
        Rect newFrame = new Rect();
        firstVisibleView.getHitRect(newFrame);
        if (this.horizontal) {
            int deltaX = newFrame.left - prevFirstVisibleFrame.left;
            if (deltaX != 0) {
                int scrollX = ((View)scrollView).getScrollX();
                ((ReactScrollViewHelper.HasSmoothScroll)scrollView).scrollToPreservingMomentum(scrollX + deltaX, ((View)scrollView).getScrollY());
                this.prevFirstVisibleFrame = newFrame;
                if (config2.getAutoScrollToTopThreshold() != null && scrollX <= config2.getAutoScrollToTopThreshold()) {
                    ((ReactScrollViewHelper.HasSmoothScroll)scrollView).reactSmoothScrollTo(0, ((View)scrollView).getScrollY());
                }
            }
        } else {
            int deltaY = newFrame.top - prevFirstVisibleFrame.top;
            if (deltaY != 0) {
                int scrollY = ((View)scrollView).getScrollY();
                ((ReactScrollViewHelper.HasSmoothScroll)scrollView).scrollToPreservingMomentum(((View)scrollView).getScrollX(), scrollY + deltaY);
                this.prevFirstVisibleFrame = newFrame;
                if (config2.getAutoScrollToTopThreshold() != null && scrollY <= config2.getAutoScrollToTopThreshold()) {
                    ((ReactScrollViewHelper.HasSmoothScroll)scrollView).reactSmoothScrollTo(((View)scrollView).getScrollX(), 0);
                }
            }
        }
    }

    private final void computeTargetView() {
        Config config = this.config;
        if (config == null) {
            return;
        }
        Config config2 = config;
        ScrollViewT ScrollViewT = this.scrollView;
        if (ScrollViewT == null) {
            return;
        }
        ScrollViewT scrollView = ScrollViewT;
        ReactViewGroup reactViewGroup = this.getContentView();
        if (reactViewGroup == null) {
            return;
        }
        ReactViewGroup contentView = reactViewGroup;
        int currentScroll = this.horizontal ? ((View)scrollView).getScrollX() : ((View)scrollView).getScrollY();
        int n = contentView.getChildCount();
        for (int i = config2.getMinIndexForVisible(); i < n; ++i) {
            float position;
            View child = contentView.getChildAt(i);
            float f = position = this.horizontal ? child.getX() + (float)child.getWidth() : child.getY() + (float)child.getHeight();
            if (!(position > (float)currentScroll) && i != contentView.getChildCount() - 1) continue;
            this.firstVisibleViewRef = new WeakReference<View>(child);
            Rect frame = new Rect();
            child.getHitRect(frame);
            this.prevFirstVisibleFrame = frame;
            break;
        }
    }

    @Override
    public void willDispatchViewUpdates(@NotNull UIManager uiManager) {
        Intrinsics.checkNotNullParameter((Object)uiManager, (String)"uiManager");
        UiThreadUtil.runOnUiThread(() -> MaintainVisibleScrollPositionHelper.willDispatchViewUpdates$lambda$0(this));
    }

    @Override
    public void willMountItems(@NotNull UIManager uiManager) {
        Intrinsics.checkNotNullParameter((Object)uiManager, (String)"uiManager");
        this.computeTargetView();
    }

    @Override
    public void didMountItems(@NotNull UIManager uiManager) {
        Intrinsics.checkNotNullParameter((Object)uiManager, (String)"uiManager");
        this.updateScrollPositionInternal();
    }

    @Override
    public void didDispatchMountItems(@NotNull UIManager uiManager) {
        Intrinsics.checkNotNullParameter((Object)uiManager, (String)"uiManager");
    }

    @Override
    public void didScheduleMountItems(@NotNull UIManager uiManager) {
        Intrinsics.checkNotNullParameter((Object)uiManager, (String)"uiManager");
    }

    private static final void willDispatchViewUpdates$lambda$0(MaintainVisibleScrollPositionHelper this$0) {
        this$0.computeTargetView();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u001b\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/facebook/react/views/scroll/MaintainVisibleScrollPositionHelper$Config;", "", "minIndexForVisible", "", "autoScrollToTopThreshold", "<init>", "(ILjava/lang/Integer;)V", "getMinIndexForVisible", "()I", "getAutoScrollToTopThreshold", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "Companion", "ReactAndroid_debug"})
    public static final class Config {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int minIndexForVisible;
        @Nullable
        private final Integer autoScrollToTopThreshold;

        public Config(int minIndexForVisible, @Nullable Integer autoScrollToTopThreshold) {
            this.minIndexForVisible = minIndexForVisible;
            this.autoScrollToTopThreshold = autoScrollToTopThreshold;
        }

        public final int getMinIndexForVisible() {
            return this.minIndexForVisible;
        }

        @Nullable
        public final Integer getAutoScrollToTopThreshold() {
            return this.autoScrollToTopThreshold;
        }

        @JvmStatic
        @NotNull
        public static final Config fromReadableMap(@NotNull ReadableMap value) {
            return Companion.fromReadableMap(value);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/react/views/scroll/MaintainVisibleScrollPositionHelper$Config$Companion;", "", "<init>", "()V", "fromReadableMap", "Lcom/facebook/react/views/scroll/MaintainVisibleScrollPositionHelper$Config;", "value", "Lcom/facebook/react/bridge/ReadableMap;", "ReactAndroid_debug"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Config fromReadableMap(@NotNull ReadableMap value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                int minIndexForVisible = value.getInt("minIndexForVisible");
                Integer autoScrollToTopThreshold = value.hasKey("autoscrollToTopThreshold") ? Integer.valueOf(value.getInt("autoscrollToTopThreshold")) : null;
                return new Config(minIndexForVisible, autoScrollToTopThreshold);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

