/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.view.MotionEvent;
import androidx.core.util.Pools;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.TouchTargetHelper;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.PointerEventHelper;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.RCTModernEventEmitter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002-.B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\b\u0010\"\u001a\u00020\u0010H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0018\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u0013H\u0002J\u0010\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0010\u0010)\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0002J\b\u0010*\u001a\u00020\tH\u0016J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020,H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u001b\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006/"}, d2={"Lcom/facebook/react/uimanager/events/PointerEvent;", "Lcom/facebook/react/uimanager/events/Event;", "<init>", "()V", "motionEvent", "Landroid/view/MotionEvent;", "_eventName", "", "coalescingKey", "", "pointersEventData", "", "Lcom/facebook/react/bridge/WritableMap;", "eventState", "Lcom/facebook/react/uimanager/events/PointerEvent$PointerEventState;", "init", "", "eventName", "targetTag", "", "motionEventToCopy", "getEventName", "isClickEvent", "", "()Z", "dispatch", "rctEventEmitter", "Lcom/facebook/react/uimanager/events/RCTEventEmitter;", "eventAnimationDriverMatchSpec", "Lcom/facebook/react/uimanager/events/Event$EventAnimationDriverMatchSpec;", "getEventAnimationDriverMatchSpec", "()Lcom/facebook/react/uimanager/events/Event$EventAnimationDriverMatchSpec;", "eventAnimationDriverMatchSpec$delegate", "Lkotlin/Lazy;", "onDispose", "createW3CPointerEvents", "addModifierKeyData", "pointerEvent", "modifierKeyMask", "createW3CPointerEvent", "index", "createPointersEventData", "getCoalescingKey", "dispatchModern", "Lcom/facebook/react/uimanager/events/RCTModernEventEmitter;", "PointerEventState", "Companion", "ReactAndroid_debug"})
public final class PointerEvent
extends Event<PointerEvent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private MotionEvent motionEvent;
    private String _eventName;
    private short coalescingKey = (short)-1;
    @Nullable
    private List<? extends WritableMap> pointersEventData;
    private PointerEventState eventState;
    @NotNull
    private final Lazy eventAnimationDriverMatchSpec$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> PointerEvent.eventAnimationDriverMatchSpec_delegate$lambda$1(this));
    @NotNull
    private static final String TAG;
    private static final int POINTER_EVENTS_POOL_SIZE = 6;
    @NotNull
    private static final Pools.SynchronizedPool<PointerEvent> EVENTS_POOL;
    private static final short UNSET_COALESCING_KEY = -1;

    private PointerEvent() {
    }

    private final void init(String eventName, int targetTag, PointerEventState eventState, MotionEvent motionEventToCopy, short coalescingKey) {
        super.init(eventState.getSurfaceId(), targetTag, motionEventToCopy.getEventTime());
        this._eventName = eventName;
        this.motionEvent = MotionEvent.obtain((MotionEvent)motionEventToCopy);
        this.coalescingKey = coalescingKey;
        this.eventState = eventState;
    }

    @Override
    @NotNull
    public String getEventName() {
        String string2 = this._eventName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_eventName");
            string2 = null;
        }
        return string2;
    }

    private final boolean isClickEvent() {
        String string2 = this._eventName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_eventName");
            string2 = null;
        }
        return Intrinsics.areEqual((Object)string2, (Object)"topClick");
    }

    @Override
    @Deprecated(message="Prefer to override getEventData instead")
    public void dispatch(@NotNull RCTEventEmitter rctEventEmitter) {
        Intrinsics.checkNotNullParameter((Object)rctEventEmitter, (String)"rctEventEmitter");
        if (this.motionEvent == null) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Cannot dispatch a Pointer that has no MotionEvent; the PointerEvent has been recycled"));
            return;
        }
        if (this.pointersEventData == null) {
            this.pointersEventData = this.createPointersEventData();
        }
        List<? extends WritableMap> list = this.pointersEventData;
        if (list == null) {
            return;
        }
        List<? extends WritableMap> data = list;
        boolean shouldCopy = data.size() > 1;
        for (WritableMap writableMap : data) {
            WritableMap eventData = shouldCopy ? writableMap.copy() : writableMap;
            int n = this.getViewTag();
            String string2 = this._eventName;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"_eventName");
                string2 = null;
            }
            rctEventEmitter.receiveEvent(n, string2, eventData);
        }
    }

    @Override
    @NotNull
    public Event.EventAnimationDriverMatchSpec getEventAnimationDriverMatchSpec() {
        Lazy lazy = this.eventAnimationDriverMatchSpec$delegate;
        return (Event.EventAnimationDriverMatchSpec)lazy.getValue();
    }

    @Override
    public void onDispose() {
        this.pointersEventData = null;
        MotionEvent motionEvent = this.motionEvent;
        this.motionEvent = null;
        MotionEvent motionEvent2 = motionEvent;
        if (motionEvent2 != null) {
            motionEvent2.recycle();
        }
        try {
            EVENTS_POOL.release((Object)this);
        }
        catch (IllegalStateException e) {
            ReactSoftExceptionLogger.logSoftException(TAG, e);
        }
    }

    private final List<WritableMap> createW3CPointerEvents() {
        ArrayList<WritableMap> w3cPointerEvents = new ArrayList<WritableMap>();
        MotionEvent motionEvent = this.motionEvent;
        if (motionEvent == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        int n = motionEvent.getPointerCount();
        for (int index = 0; index < n; ++index) {
            w3cPointerEvents.add(this.createW3CPointerEvent(index));
        }
        return w3cPointerEvents;
    }

    private final void addModifierKeyData(WritableMap pointerEvent, int modifierKeyMask) {
        pointerEvent.putBoolean("ctrlKey", (modifierKeyMask & 0x1000) != 0);
        pointerEvent.putBoolean("shiftKey", (modifierKeyMask & 1) != 0);
        pointerEvent.putBoolean("altKey", (modifierKeyMask & 2) != 0);
        pointerEvent.putBoolean("metaKey", (modifierKeyMask & 0x10000) != 0);
    }

    /*
     * Unable to fully structure code
     */
    private final WritableMap createW3CPointerEvent(int index) {
        v0 = Arguments.createMap();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"createMap(...)");
        pointerEvent = v0;
        v1 = this.motionEvent;
        if (v1 == null) {
            var5_3 = "Required value was null.";
            throw new IllegalStateException(var5_3.toString());
        }
        motionEvent = v1;
        pointerId = motionEvent.getPointerId(index);
        pointerEvent.putDouble("pointerId", pointerId);
        pointerType = PointerEventHelper.getW3CPointerType(motionEvent.getToolType(index));
        pointerEvent.putString("pointerType", pointerType);
        if (this.isClickEvent()) ** GOTO lbl-1000
        v2 = this.eventState;
        if (v2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventState");
            v2 = null;
        }
        if (v2.supportsHover(pointerId)) ** GOTO lbl-1000
        v3 = this.eventState;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventState");
            v3 = null;
        }
        if (pointerId == v3.getPrimaryPointerId()) lbl-1000:
        // 2 sources

        {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        isPrimary = v4;
        pointerEvent.putBoolean("isPrimary", isPrimary);
        v5 = this.eventState;
        if (v5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventState");
            v5 = null;
        }
        v6 = v5.getEventCoordinatesByPointerId().get(pointerId);
        if (v6 == null) {
            var9_8 = "Required value was null.";
            throw new IllegalStateException(var9_8.toString());
        }
        eventCoords = v6;
        clientX = PixelUtil.toDIPFromPixel(eventCoords[0]);
        clientY = PixelUtil.toDIPFromPixel(eventCoords[1]);
        pointerEvent.putDouble("clientX", clientX);
        pointerEvent.putDouble("clientY", clientY);
        v7 = this.eventState;
        if (v7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventState");
            v7 = null;
        }
        v8 = v7.getScreenCoordinatesByPointerId().get(pointerId);
        if (v8 == null) {
            var14_12 = "Required value was null.";
            throw new IllegalStateException(var14_12.toString());
        }
        screenCoords = v8;
        screenX = PixelUtil.toDIPFromPixel(screenCoords[0]);
        screenY = PixelUtil.toDIPFromPixel(screenCoords[1]);
        pointerEvent.putDouble("screenX", screenX);
        pointerEvent.putDouble("screenY", screenY);
        pointerEvent.putDouble("x", clientX);
        pointerEvent.putDouble("y", clientY);
        pointerEvent.putDouble("pageX", clientX);
        pointerEvent.putDouble("pageY", clientY);
        v9 = this.eventState;
        if (v9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventState");
            v9 = null;
        }
        v10 = v9.getOffsetByPointerId().get(pointerId);
        if (v10 == null) {
            var19_16 = "Required value was null.";
            throw new IllegalStateException(var19_16.toString());
        }
        offsetCoords = v10;
        pointerEvent.putDouble("offsetX", PixelUtil.toDIPFromPixel(offsetCoords[0]));
        pointerEvent.putDouble("offsetY", PixelUtil.toDIPFromPixel(offsetCoords[1]));
        pointerEvent.putInt("target", this.getViewTag());
        pointerEvent.putDouble("timestamp", this.getTimestampMs());
        pointerEvent.putInt("detail", 0);
        pointerEvent.putDouble("tiltX", 0.0);
        pointerEvent.putDouble("tiltY", 0.0);
        pointerEvent.putInt("twist", 0);
        if (Intrinsics.areEqual((Object)pointerType, (Object)"mouse") || this.isClickEvent()) {
            pointerEvent.putDouble("width", 1.0);
            pointerEvent.putDouble("height", 1.0);
        } else {
            majorAxis = PixelUtil.toDIPFromPixel(motionEvent.getTouchMajor(index));
            pointerEvent.putDouble("width", majorAxis);
            pointerEvent.putDouble("height", majorAxis);
        }
        buttonState = motionEvent.getButtonState();
        v11 = this.eventState;
        if (v11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventState");
            v11 = null;
        }
        pointerEvent.putInt("button", PointerEventHelper.getButtonChange(pointerType, v11.getLastButtonState(), buttonState));
        v12 = this._eventName;
        if (v12 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_eventName");
            v12 = null;
        }
        pointerEvent.putInt("buttons", PointerEventHelper.getButtons(v12, pointerType, buttonState));
        if (this.isClickEvent()) {
            v13 = 0.0;
        } else {
            v14 = pointerEvent.getInt("buttons");
            v15 = this._eventName;
            if (v15 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"_eventName");
                v15 = null;
            }
            v13 = PointerEventHelper.getPressure(v14, v15);
        }
        pressure = v13;
        pointerEvent.putDouble("pressure", pressure);
        pointerEvent.putDouble("tangentialPressure", 0.0);
        this.addModifierKeyData(pointerEvent, motionEvent.getMetaState());
        return pointerEvent;
    }

    private final List<WritableMap> createPointersEventData() {
        MotionEvent motionEvent = this.motionEvent;
        if (motionEvent == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        int activePointerIndex = motionEvent.getActionIndex();
        List pointersEventData = null;
        String string3 = this._eventName;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_eventName");
            string3 = null;
        }
        switch (string3) {
            case "topPointerCancel": 
            case "topPointerMove": {
                pointersEventData = this.createW3CPointerEvents();
                break;
            }
            case "topPointerEnter": 
            case "topPointerOut": 
            case "topPointerDown": 
            case "topPointerUp": 
            case "topPointerLeave": 
            case "topPointerOver": 
            case "topClick": {
                pointersEventData = CollectionsKt.listOf((Object)this.createW3CPointerEvent(activePointerIndex));
            }
        }
        return pointersEventData;
    }

    @Override
    public short getCoalescingKey() {
        return this.coalescingKey;
    }

    @Override
    public void dispatchModern(@NotNull RCTModernEventEmitter rctEventEmitter) {
        Intrinsics.checkNotNullParameter((Object)rctEventEmitter, (String)"rctEventEmitter");
        if (this.motionEvent == null) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Cannot dispatch a Pointer that has no MotionEvent; the PointerEvent has been recycled"));
            return;
        }
        if (this.pointersEventData == null) {
            this.pointersEventData = this.createPointersEventData();
        }
        if (this.pointersEventData == null) {
            return;
        }
        List<? extends WritableMap> list = this.pointersEventData;
        if (list == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        List<? extends WritableMap> pointersEventData = list;
        boolean shouldCopy = pointersEventData.size() > 1;
        for (WritableMap writableMap : pointersEventData) {
            WritableMap eventData = shouldCopy ? writableMap.copy() : writableMap;
            int n = this.getSurfaceId();
            int n2 = this.getViewTag();
            String string2 = this._eventName;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"_eventName");
                string2 = null;
            }
            boolean bl = this.coalescingKey != -1;
            String string3 = this._eventName;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"_eventName");
                string3 = null;
            }
            rctEventEmitter.receiveEvent(n, n2, string2, bl, this.coalescingKey, eventData, PointerEventHelper.getEventCategory(string3));
        }
    }

    private static final boolean eventAnimationDriverMatchSpec_delegate$lambda$1$lambda$0(PointerEvent this$0, int viewTag, String eventName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        String string2 = this$0._eventName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_eventName");
            string2 = null;
        }
        if (!Intrinsics.areEqual((Object)eventName, (Object)string2)) {
            return false;
        }
        if (PointerEventHelper.isBubblingEvent(eventName)) {
            PointerEventState pointerEventState = this$0.eventState;
            if (pointerEventState == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"eventState");
                pointerEventState = null;
            }
            for (TouchTargetHelper.ViewTarget viewTarget : pointerEventState.getHitPathForActivePointer()) {
                if (viewTarget.getViewId() != viewTag) continue;
                return true;
            }
            bl = false;
        } else {
            bl = this$0.getViewTag() == viewTag;
        }
        return bl;
    }

    private static final Event.EventAnimationDriverMatchSpec eventAnimationDriverMatchSpec_delegate$lambda$1(PointerEvent this$0) {
        return (arg_0, arg_1) -> PointerEvent.eventAnimationDriverMatchSpec_delegate$lambda$1$lambda$0(this$0, arg_0, arg_1);
    }

    @JvmStatic
    @NotNull
    public static final PointerEvent obtain(@NotNull String eventName, int targetTag, @NotNull PointerEventState eventState, @Nullable MotionEvent motionEventToCopy) {
        return Companion.obtain(eventName, targetTag, eventState, motionEventToCopy);
    }

    @JvmStatic
    @NotNull
    public static final PointerEvent obtain(@NotNull String eventName, int targetTag, @NotNull PointerEventState eventState, @Nullable MotionEvent motionEventToCopy, short coalescingKey) {
        return Companion.obtain(eventName, targetTag, eventState, motionEventToCopy, coalescingKey);
    }

    public /* synthetic */ PointerEvent(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        String string2 = PointerEvent.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
        TAG = string2;
        EVENTS_POOL = new Pools.SynchronizedPool(6);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J2\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/react/uimanager/events/PointerEvent$Companion;", "", "<init>", "()V", "TAG", "", "POINTER_EVENTS_POOL_SIZE", "", "EVENTS_POOL", "Landroidx/core/util/Pools$SynchronizedPool;", "Lcom/facebook/react/uimanager/events/PointerEvent;", "UNSET_COALESCING_KEY", "", "obtain", "eventName", "targetTag", "eventState", "Lcom/facebook/react/uimanager/events/PointerEvent$PointerEventState;", "motionEventToCopy", "Landroid/view/MotionEvent;", "coalescingKey", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PointerEvent obtain(@NotNull String eventName, int targetTag, @NotNull PointerEventState eventState, @Nullable MotionEvent motionEventToCopy) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            Intrinsics.checkNotNullParameter((Object)eventState, (String)"eventState");
            PointerEvent event = (PointerEvent)EVENTS_POOL.acquire();
            if (event == null) {
                event = new PointerEvent(null);
            }
            Object object = Assertions.assertNotNull((Object)motionEventToCopy);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assertNotNull(...)");
            event.init(eventName, targetTag, eventState, (MotionEvent)object, (short)0);
            return event;
        }

        @JvmStatic
        @NotNull
        public final PointerEvent obtain(@NotNull String eventName, int targetTag, @NotNull PointerEventState eventState, @Nullable MotionEvent motionEventToCopy, short coalescingKey) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            Intrinsics.checkNotNullParameter((Object)eventState, (String)"eventState");
            PointerEvent event = (PointerEvent)EVENTS_POOL.acquire();
            if (event == null) {
                event = new PointerEvent(null);
            }
            Object object = Assertions.assertNotNull((Object)motionEventToCopy);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assertNotNull(...)");
            event.init(eventName, targetTag, eventState, (MotionEvent)object, coalescingKey);
            return event;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u008b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\b\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0006\u0010\u001e\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R#\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lcom/facebook/react/uimanager/events/PointerEvent$PointerEventState;", "", "primaryPointerId", "", "activePointerId", "lastButtonState", "surfaceId", "offsetByPointerId", "", "", "hitPathByPointerId", "", "Lcom/facebook/react/uimanager/TouchTargetHelper$ViewTarget;", "eventCoordinatesByPointerId", "screenCoordinatesByPointerId", "hoveringPointerIds", "", "<init>", "(IIIILjava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Set;)V", "getPrimaryPointerId", "()I", "getActivePointerId", "getLastButtonState", "getOffsetByPointerId", "()Ljava/util/Map;", "getHitPathByPointerId", "getEventCoordinatesByPointerId", "getScreenCoordinatesByPointerId", "getHoveringPointerIds", "()Ljava/util/Set;", "getSurfaceId", "supportsHover", "", "pointerId", "hitPathForActivePointer", "getHitPathForActivePointer", "()Ljava/util/List;", "ReactAndroid_debug"})
    public static final class PointerEventState {
        private final int primaryPointerId;
        private final int activePointerId;
        private final int lastButtonState;
        private final int surfaceId;
        @NotNull
        private final Map<Integer, float[]> offsetByPointerId;
        @NotNull
        private final Map<Integer, List<TouchTargetHelper.ViewTarget>> hitPathByPointerId;
        @NotNull
        private final Map<Integer, float[]> eventCoordinatesByPointerId;
        @NotNull
        private final Map<Integer, float[]> screenCoordinatesByPointerId;
        @NotNull
        private final Set<Integer> hoveringPointerIds;

        public PointerEventState(int primaryPointerId, int activePointerId, int lastButtonState, int surfaceId, @NotNull Map<Integer, float[]> offsetByPointerId, @NotNull Map<Integer, ? extends List<TouchTargetHelper.ViewTarget>> hitPathByPointerId, @NotNull Map<Integer, float[]> eventCoordinatesByPointerId, @NotNull Map<Integer, float[]> screenCoordinatesByPointerId, @NotNull Set<Integer> hoveringPointerIds) {
            Intrinsics.checkNotNullParameter(offsetByPointerId, (String)"offsetByPointerId");
            Intrinsics.checkNotNullParameter(hitPathByPointerId, (String)"hitPathByPointerId");
            Intrinsics.checkNotNullParameter(eventCoordinatesByPointerId, (String)"eventCoordinatesByPointerId");
            Intrinsics.checkNotNullParameter(screenCoordinatesByPointerId, (String)"screenCoordinatesByPointerId");
            Intrinsics.checkNotNullParameter(hoveringPointerIds, (String)"hoveringPointerIds");
            this.primaryPointerId = primaryPointerId;
            this.activePointerId = activePointerId;
            this.lastButtonState = lastButtonState;
            this.surfaceId = surfaceId;
            this.offsetByPointerId = offsetByPointerId;
            this.hitPathByPointerId = hitPathByPointerId;
            this.eventCoordinatesByPointerId = eventCoordinatesByPointerId;
            this.screenCoordinatesByPointerId = screenCoordinatesByPointerId;
            this.hoveringPointerIds = new HashSet(hoveringPointerIds);
        }

        public final int getPrimaryPointerId() {
            return this.primaryPointerId;
        }

        public final int getActivePointerId() {
            return this.activePointerId;
        }

        public final int getLastButtonState() {
            return this.lastButtonState;
        }

        @NotNull
        public final Map<Integer, float[]> getOffsetByPointerId() {
            return this.offsetByPointerId;
        }

        @NotNull
        public final Map<Integer, List<TouchTargetHelper.ViewTarget>> getHitPathByPointerId() {
            return this.hitPathByPointerId;
        }

        @NotNull
        public final Map<Integer, float[]> getEventCoordinatesByPointerId() {
            return this.eventCoordinatesByPointerId;
        }

        @NotNull
        public final Map<Integer, float[]> getScreenCoordinatesByPointerId() {
            return this.screenCoordinatesByPointerId;
        }

        @NotNull
        public final Set<Integer> getHoveringPointerIds() {
            return this.hoveringPointerIds;
        }

        public final int getSurfaceId() {
            return this.surfaceId;
        }

        public final boolean supportsHover(int pointerId) {
            return this.hoveringPointerIds.contains(pointerId);
        }

        @NotNull
        public final List<TouchTargetHelper.ViewTarget> getHitPathForActivePointer() {
            List<TouchTargetHelper.ViewTarget> list = this.hitPathByPointerId.get(this.activePointerId);
            if (list == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            return list;
        }
    }
}

