/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import android.view.ViewGroup;
import com.facebook.common.logging.FLog;
import com.facebook.react.uimanager.ViewGroupManager;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007J\u0006\u0010\u0014\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/react/uimanager/ViewGroupDrawingOrderHelper;", "", "viewGroup", "Landroid/view/ViewGroup;", "<init>", "(Landroid/view/ViewGroup;)V", "numberOfChildrenWithZIndex", "", "drawingOrderIndices", "", "handleAddView", "", "view", "Landroid/view/View;", "handleRemoveView", "shouldEnableCustomDrawingOrder", "", "getChildDrawingOrder", "childCount", "index", "update", "ReactAndroid_debug"})
public final class ViewGroupDrawingOrderHelper {
    @NotNull
    private final ViewGroup viewGroup;
    private int numberOfChildrenWithZIndex;
    @Nullable
    private int[] drawingOrderIndices;

    public ViewGroupDrawingOrderHelper(@NotNull ViewGroup viewGroup) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        this.viewGroup = viewGroup;
    }

    public final void handleAddView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (ViewGroupManager.Companion.getViewZIndex(view) != null) {
            int n = this.numberOfChildrenWithZIndex;
            this.numberOfChildrenWithZIndex = n + 1;
        }
        this.drawingOrderIndices = null;
    }

    public final void handleRemoveView(@Nullable View view) {
        if (ViewGroupManager.Companion.getViewZIndex(view) != null) {
            int n = this.numberOfChildrenWithZIndex;
            this.numberOfChildrenWithZIndex = n + -1;
        }
        this.drawingOrderIndices = null;
    }

    public final boolean shouldEnableCustomDrawingOrder() {
        return this.numberOfChildrenWithZIndex > 0;
    }

    public final int getChildDrawingOrder(int childCount, int index) {
        int[] currentDrawingOrderIndices = this.drawingOrderIndices;
        if (currentDrawingOrderIndices != null && (index >= currentDrawingOrderIndices.length || currentDrawingOrderIndices[index] >= childCount)) {
            Object[] objectArray = new Object[]{childCount, index};
            FLog.w((String)"ReactNative", (String)"getChildDrawingOrder index out of bounds! Please check any custom view manipulations you may have done. childCount = %d, index = %d", (Object[])objectArray);
            this.update();
        }
        if (currentDrawingOrderIndices == null) {
            int i;
            ArrayList<View> viewsToSort = new ArrayList<View>();
            for (i = 0; i < childCount; ++i) {
                viewsToSort.add(this.viewGroup.getChildAt(i));
            }
            CollectionsKt.sortWith((List)viewsToSort, (arg_0, arg_1) -> ViewGroupDrawingOrderHelper.getChildDrawingOrder$lambda$1(ViewGroupDrawingOrderHelper::getChildDrawingOrder$lambda$0, arg_0, arg_1));
            currentDrawingOrderIndices = new int[childCount];
            for (i = 0; i < childCount; ++i) {
                Object e = viewsToSort.get(i);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                View child = (View)e;
                currentDrawingOrderIndices[i] = this.viewGroup.indexOfChild(child);
            }
            this.drawingOrderIndices = currentDrawingOrderIndices;
        }
        return currentDrawingOrderIndices[index];
    }

    public final void update() {
        this.numberOfChildrenWithZIndex = 0;
        int n = this.viewGroup.getChildCount();
        for (int i = 0; i < n; ++i) {
            View child = this.viewGroup.getChildAt(i);
            if (ViewGroupManager.Companion.getViewZIndex(child) == null) continue;
            int n2 = this.numberOfChildrenWithZIndex;
            this.numberOfChildrenWithZIndex = n2 + 1;
        }
        this.drawingOrderIndices = null;
    }

    private static final int getChildDrawingOrder$lambda$0(View view1, View view2) {
        Integer n = ViewGroupManager.Companion.getViewZIndex(view1);
        int view1ZIndex = n != null ? n : 0;
        Integer n2 = ViewGroupManager.Companion.getViewZIndex(view2);
        int view2ZIndex = n2 != null ? n2 : 0;
        return view1ZIndex - view2ZIndex;
    }

    private static final int getChildDrawingOrder$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

