/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.uimanager.TouchTargetHelper;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.TouchEvent;
import com.facebook.react.uimanager.events.TouchEventCoalescingKeyHelper;
import com.facebook.react.uimanager.events.TouchEventType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\"\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\"\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/facebook/react/uimanager/JSTouchDispatcher;", "", "viewGroup", "Landroid/view/ViewGroup;", "<init>", "(Landroid/view/ViewGroup;)V", "targetTag", "", "targetCoordinates", "", "childIsHandlingNativeGesture", "", "gestureStartTime", "", "touchEventCoalescingKeyHelper", "Lcom/facebook/react/uimanager/events/TouchEventCoalescingKeyHelper;", "onChildStartedNativeGesture", "", "androidEvent", "Landroid/view/MotionEvent;", "eventDispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "onChildEndedNativeGesture", "handleTouchEvent", "ev", "reactContext", "Lcom/facebook/react/bridge/ReactContext;", "markActiveTouchForTag", "surfaceId", "reactTag", "sweepActiveTouchForTag", "findTargetTagAndSetCoordinates", "dispatchCancelEvent", "ReactAndroid_debug"})
public final class JSTouchDispatcher {
    @NotNull
    private final ViewGroup viewGroup;
    private int targetTag;
    @NotNull
    private final float[] targetCoordinates;
    private boolean childIsHandlingNativeGesture;
    private long gestureStartTime;
    @NotNull
    private final TouchEventCoalescingKeyHelper touchEventCoalescingKeyHelper;

    public JSTouchDispatcher(@NotNull ViewGroup viewGroup) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        this.viewGroup = viewGroup;
        this.targetTag = -1;
        this.targetCoordinates = new float[2];
        this.gestureStartTime = Long.MIN_VALUE;
        this.touchEventCoalescingKeyHelper = new TouchEventCoalescingKeyHelper();
    }

    public final void onChildStartedNativeGesture(@NotNull MotionEvent androidEvent, @NotNull EventDispatcher eventDispatcher) {
        Intrinsics.checkNotNullParameter((Object)androidEvent, (String)"androidEvent");
        Intrinsics.checkNotNullParameter((Object)eventDispatcher, (String)"eventDispatcher");
        if (this.childIsHandlingNativeGesture) {
            return;
        }
        this.dispatchCancelEvent(androidEvent, eventDispatcher);
        this.childIsHandlingNativeGesture = true;
        this.targetTag = -1;
    }

    public final void onChildEndedNativeGesture(@NotNull MotionEvent androidEvent, @NotNull EventDispatcher eventDispatcher) {
        Intrinsics.checkNotNullParameter((Object)androidEvent, (String)"androidEvent");
        Intrinsics.checkNotNullParameter((Object)eventDispatcher, (String)"eventDispatcher");
        this.childIsHandlingNativeGesture = false;
    }

    public final void handleTouchEvent(@NotNull MotionEvent ev, @NotNull EventDispatcher eventDispatcher) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        Intrinsics.checkNotNullParameter((Object)eventDispatcher, (String)"eventDispatcher");
        this.handleTouchEvent(ev, eventDispatcher, null);
    }

    public final void handleTouchEvent(@NotNull MotionEvent ev, @NotNull EventDispatcher eventDispatcher, @Nullable ReactContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        Intrinsics.checkNotNullParameter((Object)eventDispatcher, (String)"eventDispatcher");
        int action = ev.getAction() & 0xFF;
        if (action == 0) {
            if (this.targetTag != -1) {
                FLog.e((String)"ReactNative", (String)"Got DOWN touch before receiving UP or CANCEL from last gesture");
            }
            this.childIsHandlingNativeGesture = false;
            this.gestureStartTime = ev.getEventTime();
            this.targetTag = this.findTargetTagAndSetCoordinates(ev);
            int surfaceId = UIManagerHelper.getSurfaceId((View)this.viewGroup);
            this.markActiveTouchForTag(surfaceId, this.targetTag, reactContext);
            eventDispatcher.dispatchEvent(TouchEvent.Companion.obtain(UIManagerHelper.getSurfaceId((View)this.viewGroup), this.targetTag, TouchEventType.START, ev, this.gestureStartTime, this.targetCoordinates[0], this.targetCoordinates[1], this.touchEventCoalescingKeyHelper));
        } else {
            if (this.childIsHandlingNativeGesture) {
                return;
            }
            if (this.targetTag == -1) {
                FLog.e((String)"ReactNative", (String)"Unexpected state: received touch event but didn't get starting ACTION_DOWN for this gesture before");
            } else if (action == 1) {
                this.findTargetTagAndSetCoordinates(ev);
                int surfaceId = UIManagerHelper.getSurfaceId((View)this.viewGroup);
                eventDispatcher.dispatchEvent(TouchEvent.Companion.obtain(surfaceId, this.targetTag, TouchEventType.END, ev, this.gestureStartTime, this.targetCoordinates[0], this.targetCoordinates[1], this.touchEventCoalescingKeyHelper));
                this.sweepActiveTouchForTag(surfaceId, this.targetTag, reactContext);
                this.targetTag = -1;
                this.gestureStartTime = Long.MIN_VALUE;
            } else if (action == 2) {
                this.findTargetTagAndSetCoordinates(ev);
                eventDispatcher.dispatchEvent(TouchEvent.Companion.obtain(UIManagerHelper.getSurfaceId((View)this.viewGroup), this.targetTag, TouchEventType.MOVE, ev, this.gestureStartTime, this.targetCoordinates[0], this.targetCoordinates[1], this.touchEventCoalescingKeyHelper));
            } else if (action == 5) {
                eventDispatcher.dispatchEvent(TouchEvent.Companion.obtain(UIManagerHelper.getSurfaceId((View)this.viewGroup), this.targetTag, TouchEventType.START, ev, this.gestureStartTime, this.targetCoordinates[0], this.targetCoordinates[1], this.touchEventCoalescingKeyHelper));
            } else if (action == 6) {
                eventDispatcher.dispatchEvent(TouchEvent.Companion.obtain(UIManagerHelper.getSurfaceId((View)this.viewGroup), this.targetTag, TouchEventType.END, ev, this.gestureStartTime, this.targetCoordinates[0], this.targetCoordinates[1], this.touchEventCoalescingKeyHelper));
            } else if (action == 3) {
                if (this.touchEventCoalescingKeyHelper.hasCoalescingKey(ev.getDownTime())) {
                    this.dispatchCancelEvent(ev, eventDispatcher);
                } else {
                    FLog.e((String)"ReactNative", (String)"Received an ACTION_CANCEL touch event for which we have no corresponding ACTION_DOWN");
                }
                int surfaceId = UIManagerHelper.getSurfaceId((View)this.viewGroup);
                this.sweepActiveTouchForTag(surfaceId, this.targetTag, reactContext);
                this.targetTag = -1;
                this.gestureStartTime = Long.MIN_VALUE;
            } else {
                FLog.w((String)"ReactNative", (String)("Warning : touch event was ignored. Action=" + action + " Target=" + this.targetTag));
            }
        }
    }

    private final void markActiveTouchForTag(int surfaceId, int reactTag, ReactContext reactContext) {
        block1: {
            UIManager uiManager;
            if (reactContext == null) {
                return;
            }
            UIManager uIManager = uiManager = UIManagerHelper.getUIManager(reactContext, 2);
            if (uIManager == null) break block1;
            uIManager.markActiveTouchForTag(surfaceId, reactTag);
        }
    }

    private final void sweepActiveTouchForTag(int surfaceId, int reactTag, ReactContext reactContext) {
        block1: {
            UIManager uiManager;
            if (reactContext == null) {
                return;
            }
            UIManager uIManager = uiManager = UIManagerHelper.getUIManager(reactContext, 2);
            if (uIManager == null) break block1;
            uIManager.sweepActiveTouchForTag(surfaceId, reactTag);
        }
    }

    private final int findTargetTagAndSetCoordinates(MotionEvent ev) {
        return TouchTargetHelper.findTargetTagAndCoordinatesForTouch(ev.getX(), ev.getY(), this.viewGroup, this.targetCoordinates, null);
    }

    private final void dispatchCancelEvent(MotionEvent androidEvent, EventDispatcher eventDispatcher) {
        if (this.targetTag == -1) {
            FLog.w((String)"ReactNative", (String)"Can't cancel already finished gesture. Is a child View trying to start a gesture from an UP/CANCEL event?");
            return;
        }
        Assertions.assertCondition((!this.childIsHandlingNativeGesture ? 1 : 0) != 0, (String)"Expected to not have already sent a cancel for this gesture");
        ((EventDispatcher)Assertions.assertNotNull((Object)eventDispatcher)).dispatchEvent(TouchEvent.Companion.obtain(UIManagerHelper.getSurfaceId((View)this.viewGroup), this.targetTag, TouchEventType.CANCEL, androidEvent, this.gestureStartTime, this.targetCoordinates[0], this.targetCoordinates[1], this.touchEventCoalescingKeyHelper));
    }
}

