/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.facebook.common.logging.FLog;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.runtime.ReactHostImpl;
import com.facebook.react.runtime.ReactSurfaceImpl;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.JSPointerDispatcher;
import com.facebook.react.uimanager.JSTouchDispatcher;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.systrace.Systrace;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u00016B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014J0\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0014J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\rH\u0016J\u001a\u0010\u001f\u001a\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\rH\u0016J\b\u0010*\u001a\u00020\u000fH\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020#H\u0014J\u0018\u0010/\u001a\u00020\u00122\u0006\u0010.\u001a\u00020#2\u0006\u00100\u001a\u00020\rH\u0014J\b\u00101\u001a\u00020\rH\u0016J\b\u00102\u001a\u00020\rH\u0016J\n\u00103\u001a\u0004\u0018\u000104H\u0016J\b\u00105\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00067"}, d2={"Lcom/facebook/react/runtime/ReactSurfaceView;", "Lcom/facebook/react/ReactRootView;", "context", "Landroid/content/Context;", "surface", "Lcom/facebook/react/runtime/ReactSurfaceImpl;", "<init>", "(Landroid/content/Context;Lcom/facebook/react/runtime/ReactSurfaceImpl;)V", "jsTouchDispatcher", "Lcom/facebook/react/uimanager/JSTouchDispatcher;", "jsPointerDispatcher", "Lcom/facebook/react/uimanager/JSPointerDispatcher;", "wasMeasured", "", "widthMeasureSpec", "", "heightMeasureSpec", "onMeasure", "", "onLayout", "changed", "left", "top", "right", "bottom", "viewportOffset", "Landroid/graphics/Point;", "getViewportOffset", "()Landroid/graphics/Point;", "requestDisallowInterceptTouchEvent", "disallowIntercept", "onChildStartedNativeGesture", "childView", "Landroid/view/View;", "ev", "Landroid/view/MotionEvent;", "onChildEndedNativeGesture", "handleException", "t", "", "setIsFabric", "isFabric", "getUIManagerType", "getJSModuleName", "", "dispatchJSTouchEvent", "event", "dispatchJSPointerEvent", "isCapture", "hasActiveReactContext", "hasActiveReactInstance", "getCurrentReactContext", "Lcom/facebook/react/bridge/ReactContext;", "isViewAttachedToReactInstance", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nReactSurfaceView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactSurfaceView.kt\ncom/facebook/react/runtime/ReactSurfaceView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
public final class ReactSurfaceView
extends ReactRootView {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactSurfaceImpl surface;
    @NotNull
    private final JSTouchDispatcher jsTouchDispatcher;
    @Nullable
    private JSPointerDispatcher jsPointerDispatcher;
    private boolean wasMeasured;
    private int widthMeasureSpec;
    private int heightMeasureSpec;
    @NotNull
    private static final String TAG = "ReactSurfaceView";

    public ReactSurfaceView(@Nullable Context context, @NotNull ReactSurfaceImpl surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        super(context);
        this.surface = surface;
        this.jsTouchDispatcher = new JSTouchDispatcher((ViewGroup)this);
        if (ReactFeatureFlags.dispatchPointerEvents) {
            this.jsPointerDispatcher = new JSPointerDispatcher((ViewGroup)this);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Systrace.beginSection(0L, "ReactSurfaceView.onMeasure");
        int width = 0;
        int height = 0;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        switch (widthMode) {
            case -2147483648: 
            case 0: {
                int n = this.getChildCount();
                for (int i = 0; i < n; ++i) {
                    View child = this.getChildAt(i);
                    int childSize = child.getLeft() + child.getMeasuredWidth() + child.getPaddingLeft() + child.getPaddingRight();
                    width = Math.max(width, childSize);
                }
                break;
            }
            default: {
                width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            }
        }
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        switch (heightMode) {
            case -2147483648: 
            case 0: {
                int n = this.getChildCount();
                for (int i = 0; i < n; ++i) {
                    View child = this.getChildAt(i);
                    int childSize = child.getTop() + child.getMeasuredHeight() + child.getPaddingTop() + child.getPaddingBottom();
                    height = Math.max(height, childSize);
                }
                break;
            }
            default: {
                height = View.MeasureSpec.getSize((int)heightMeasureSpec);
            }
        }
        this.setMeasuredDimension(width, height);
        this.wasMeasured = true;
        this.widthMeasureSpec = widthMeasureSpec;
        this.heightMeasureSpec = heightMeasureSpec;
        Point viewportOffset = this.getViewportOffset();
        this.surface.updateLayoutSpecs$ReactAndroid_debug(widthMeasureSpec, heightMeasureSpec, viewportOffset.x, viewportOffset.y);
        Systrace.endSection(0L);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.wasMeasured && changed) {
            Point viewportOffset = this.getViewportOffset();
            this.surface.updateLayoutSpecs$ReactAndroid_debug(this.widthMeasureSpec, this.heightMeasureSpec, viewportOffset.x, viewportOffset.y);
        }
    }

    private final Point getViewportOffset() {
        int[] locationOnScreen = new int[2];
        this.getLocationOnScreen(locationOnScreen);
        Rect visibleWindowFrame = new Rect();
        this.getWindowVisibleDisplayFrame(visibleWindowFrame);
        locationOnScreen[0] = locationOnScreen[0] - visibleWindowFrame.left;
        locationOnScreen[1] = locationOnScreen[1] - visibleWindowFrame.top;
        return new Point(locationOnScreen[0], locationOnScreen[1]);
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        block0: {
            ViewParent viewParent = this.getParent();
            if (viewParent == null) break block0;
            viewParent.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    @Override
    public void onChildStartedNativeGesture(@Nullable View childView, @NotNull MotionEvent ev) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
            EventDispatcher eventDispatcher = this.surface.getEventDispatcher$ReactAndroid_debug();
            if (eventDispatcher == null) {
                return;
            }
            EventDispatcher eventDispatcher2 = eventDispatcher;
            this.jsTouchDispatcher.onChildStartedNativeGesture(ev, eventDispatcher2);
            View view = childView;
            if (view == null) break block2;
            View it = view;
            boolean bl = false;
            JSPointerDispatcher jSPointerDispatcher = this.jsPointerDispatcher;
            if (jSPointerDispatcher != null) {
                jSPointerDispatcher.onChildStartedNativeGesture(it, ev, eventDispatcher2);
            }
        }
    }

    @Override
    public void onChildEndedNativeGesture(@NotNull View childView, @NotNull MotionEvent ev) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)childView, (String)"childView");
            Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
            EventDispatcher eventDispatcher = this.surface.getEventDispatcher$ReactAndroid_debug();
            if (eventDispatcher == null) {
                return;
            }
            EventDispatcher eventDispatcher2 = eventDispatcher;
            this.jsTouchDispatcher.onChildEndedNativeGesture(ev, eventDispatcher2);
            JSPointerDispatcher jSPointerDispatcher = this.jsPointerDispatcher;
            if (jSPointerDispatcher == null) break block1;
            jSPointerDispatcher.onChildEndedNativeGesture();
        }
    }

    @Override
    public void handleException(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        String string2 = Objects.toString(t.getMessage(), "");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        IllegalViewOperationException e = new IllegalViewOperationException(string2, (View)this, t);
        ReactHostImpl reactHostImpl = this.surface.getReactHost$ReactAndroid_debug();
        if (reactHostImpl == null) {
            throw e;
        }
        reactHostImpl.handleHostException$ReactAndroid_debug(e);
    }

    @Override
    public void setIsFabric(boolean isFabric) {
        super.setIsFabric(true);
    }

    @Override
    public int getUIManagerType() {
        return 2;
    }

    @Override
    @NotNull
    public String getJSModuleName() {
        return this.surface.getModuleName();
    }

    @Override
    protected void dispatchJSTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        EventDispatcher eventDispatcher = this.surface.getEventDispatcher$ReactAndroid_debug();
        if (eventDispatcher != null) {
            ReactHostImpl reactHostImpl = this.surface.getReactHost$ReactAndroid_debug();
            this.jsTouchDispatcher.handleTouchEvent(event, eventDispatcher, reactHostImpl != null ? reactHostImpl.getCurrentReactContext() : null);
        } else {
            FLog.w((String)TAG, (String)"Unable to dispatch touch events to JS as the React instance has not been attached");
        }
    }

    @Override
    protected void dispatchJSPointerEvent(@NotNull MotionEvent event, boolean isCapture) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.jsPointerDispatcher == null) {
            if (!ReactFeatureFlags.dispatchPointerEvents) {
                return;
            }
            FLog.w((String)TAG, (String)"Unable to dispatch pointer events to JS before the dispatcher is available");
            return;
        }
        EventDispatcher eventDispatcher = this.surface.getEventDispatcher$ReactAndroid_debug();
        if (eventDispatcher != null) {
            JSPointerDispatcher jSPointerDispatcher = this.jsPointerDispatcher;
            if (jSPointerDispatcher != null) {
                jSPointerDispatcher.handleMotionEvent(event, eventDispatcher, isCapture);
            }
        } else {
            FLog.w((String)TAG, (String)"Unable to dispatch pointer events to JS as the React instance has not been attached");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasActiveReactContext() {
        if (!this.surface.isAttached$ReactAndroid_debug()) return false;
        ReactHostImpl reactHostImpl = this.surface.getReactHost$ReactAndroid_debug();
        if (reactHostImpl == null) return false;
        ReactContext reactContext = reactHostImpl.getCurrentReactContext();
        if (reactContext == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasActiveReactInstance() {
        if (!this.surface.isAttached$ReactAndroid_debug()) return false;
        ReactHostImpl reactHostImpl = this.surface.getReactHost$ReactAndroid_debug();
        if (reactHostImpl == null) return false;
        if (!reactHostImpl.isInstanceInitialized$ReactAndroid_debug()) return false;
        return true;
    }

    @Override
    @Nullable
    public ReactContext getCurrentReactContext() {
        ReactContext reactContext;
        if (this.surface.isAttached$ReactAndroid_debug()) {
            ReactHostImpl reactHostImpl = this.surface.getReactHost$ReactAndroid_debug();
            reactContext = reactHostImpl != null ? reactHostImpl.getCurrentReactContext() : null;
        } else {
            reactContext = null;
        }
        return reactContext;
    }

    @Override
    public boolean isViewAttachedToReactInstance() {
        return this.surface.isAttached$ReactAndroid_debug();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/runtime/ReactSurfaceView$Companion;", "", "<init>", "()V", "TAG", "", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

