/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import android.app.Activity;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.runtime.BridgelessReactStateTracker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u001c\u0010\u0011\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u001c\u0010\u0012\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u0012\u0010\u0013\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/facebook/react/runtime/ReactLifecycleStateManager;", "", "bridgelessReactStateTracker", "Lcom/facebook/react/runtime/BridgelessReactStateTracker;", "<init>", "(Lcom/facebook/react/runtime/BridgelessReactStateTracker;)V", "state", "Lcom/facebook/react/common/LifecycleState;", "lifecycleState", "getLifecycleState", "()Lcom/facebook/react/common/LifecycleState;", "resumeReactContextIfHostResumed", "", "currentContext", "Lcom/facebook/react/bridge/ReactContext;", "activity", "Landroid/app/Activity;", "moveToOnHostResume", "moveToOnHostPause", "moveToOnHostDestroy", "ReactAndroid_debug"})
public final class ReactLifecycleStateManager {
    @NotNull
    private final BridgelessReactStateTracker bridgelessReactStateTracker;
    @NotNull
    private LifecycleState state;

    public ReactLifecycleStateManager(@NotNull BridgelessReactStateTracker bridgelessReactStateTracker) {
        Intrinsics.checkNotNullParameter((Object)bridgelessReactStateTracker, (String)"bridgelessReactStateTracker");
        this.bridgelessReactStateTracker = bridgelessReactStateTracker;
        this.state = LifecycleState.BEFORE_CREATE;
    }

    @NotNull
    public final LifecycleState getLifecycleState() {
        return this.state;
    }

    @ThreadConfined(value="UI")
    public final void resumeReactContextIfHostResumed(@NotNull ReactContext currentContext, @Nullable Activity activity) {
        Intrinsics.checkNotNullParameter((Object)((Object)currentContext), (String)"currentContext");
        if (this.state == LifecycleState.RESUMED) {
            this.bridgelessReactStateTracker.enterState("ReactContext.onHostResume()");
            currentContext.onHostResume(activity);
        }
    }

    @ThreadConfined(value="UI")
    public final void moveToOnHostResume(@Nullable ReactContext currentContext, @Nullable Activity activity) {
        if (this.state == LifecycleState.RESUMED) {
            return;
        }
        ReactContext reactContext = currentContext;
        if (reactContext != null) {
            ReactContext context = reactContext;
            boolean bl = false;
            this.bridgelessReactStateTracker.enterState("ReactContext.onHostResume()");
            context.onHostResume(activity);
        }
        this.state = LifecycleState.RESUMED;
    }

    @ThreadConfined(value="UI")
    public final void moveToOnHostPause(@Nullable ReactContext currentContext, @Nullable Activity activity) {
        ReactContext reactContext = currentContext;
        if (reactContext != null) {
            ReactContext it = reactContext;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    this.bridgelessReactStateTracker.enterState("ReactContext.onHostResume()");
                    it.onHostResume(activity);
                    this.bridgelessReactStateTracker.enterState("ReactContext.onHostPause()");
                    it.onHostPause();
                    break;
                }
                case 2: {
                    this.bridgelessReactStateTracker.enterState("ReactContext.onHostPause()");
                    it.onHostPause();
                }
            }
        }
        this.state = LifecycleState.BEFORE_RESUME;
    }

    @ThreadConfined(value="UI")
    public final void moveToOnHostDestroy(@Nullable ReactContext currentContext) {
        ReactContext reactContext = currentContext;
        if (reactContext != null) {
            ReactContext it = reactContext;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 3: {
                    this.bridgelessReactStateTracker.enterState("ReactContext.onHostDestroy()");
                    it.onHostDestroy();
                    break;
                }
                case 2: {
                    this.bridgelessReactStateTracker.enterState("ReactContext.onHostPause()");
                    it.onHostPause();
                    this.bridgelessReactStateTracker.enterState("ReactContext.onHostDestroy()");
                    it.onHostDestroy();
                }
            }
        }
        this.state = LifecycleState.BEFORE_CREATE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LifecycleState.values().length];
            try {
                nArray[LifecycleState.BEFORE_CREATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LifecycleState.RESUMED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LifecycleState.BEFORE_RESUME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

