/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.systeminfo;

import android.annotation.SuppressLint;
import android.app.UiModeManager;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import com.facebook.fbreact.specs.NativePlatformConstantsAndroidSpec;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.systeminfo.AndroidInfoHelpers;
import com.facebook.react.modules.systeminfo.ReactNativeVersion;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ReactModule(name="PlatformConstants")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\n0\tH\u0014J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/facebook/react/modules/systeminfo/AndroidInfoModule;", "Lcom/facebook/fbreact/specs/NativePlatformConstantsAndroidSpec;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "uiMode", "", "getTypedExportedConstants", "", "", "getAndroidID", "invalidate", "", "isRunningScreenshotTest", "", "Companion", "ReactAndroid_debug"})
@SuppressLint(value={"HardwareIds"})
public final class AndroidInfoModule
extends NativePlatformConstantsAndroidSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "PlatformConstants";
    @NotNull
    private static final String IS_TESTING = "IS_TESTING";
    @NotNull
    private static final String IS_DISABLE_ANIMATIONS = "IS_DISABLE_ANIMATIONS";

    public AndroidInfoModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super(reactContext);
    }

    private final String uiMode() {
        Object object = this.getReactApplicationContext().getSystemService("uimode");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.UiModeManager");
        UiModeManager uiModeManager = (UiModeManager)object;
        return switch (uiModeManager.getCurrentModeType()) {
            case 4 -> "tv";
            case 3 -> "car";
            case 2 -> "desk";
            case 6 -> "watch";
            case 7 -> "vrheadset";
            case 1 -> "normal";
            default -> "unknown";
        };
    }

    @Override
    @NotNull
    protected Map<String, Object> getTypedExportedConstants() {
        Map constants = new LinkedHashMap();
        constants.put("Version", Build.VERSION.SDK_INT);
        constants.put("Release", Build.VERSION.RELEASE);
        constants.put("Serial", Build.SERIAL);
        constants.put("Fingerprint", Build.FINGERPRINT);
        constants.put("Model", Build.MODEL);
        constants.put("Manufacturer", Build.MANUFACTURER);
        constants.put("Brand", Build.BRAND);
        if (ReactBuildConfig.DEBUG) {
            Map map = constants;
            String string2 = "ServerHost";
            Context context = this.getReactApplicationContext().getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
            String string3 = AndroidInfoHelpers.getServerHost(context);
            map.put(string2, string3);
        }
        constants.put("isTesting", Intrinsics.areEqual((Object)"true", (Object)System.getProperty(IS_TESTING)) || this.isRunningScreenshotTest());
        String isDisableAnimations = System.getProperty(IS_DISABLE_ANIMATIONS);
        if (isDisableAnimations != null) {
            constants.put("isDisableAnimations", Intrinsics.areEqual((Object)"true", (Object)isDisableAnimations));
        }
        constants.put("reactNativeVersion", ReactNativeVersion.VERSION);
        constants.put("uiMode", this.uiMode());
        return constants;
    }

    @Override
    @NotNull
    public String getAndroidID() {
        String string2 = Settings.Secure.getString((ContentResolver)this.getReactApplicationContext().getContentResolver(), (String)"android_id");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return string2;
    }

    @Override
    public void invalidate() {
    }

    private final boolean isRunningScreenshotTest() {
        boolean bl;
        try {
            Class.forName("com.facebook.testing.react.screenshots.ReactAppScreenshotTestActivity");
            bl = true;
        }
        catch (ClassNotFoundException ignored) {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/react/modules/systeminfo/AndroidInfoModule$Companion;", "", "<init>", "()V", "NAME", "", "IS_TESTING", "IS_DISABLE_ANIMATIONS", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

