/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.fresco;

import android.util.Pair;
import com.facebook.imagepipeline.listener.BaseRequestListener;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.systrace.Systrace;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0016J.\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0011H\u0016J6\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0011H\u0016J.\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0011H\u0016J \u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0016J(\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010 \u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/facebook/react/modules/fresco/SystraceRequestListener;", "Lcom/facebook/imagepipeline/listener/BaseRequestListener;", "<init>", "()V", "currentId", "", "producerId", "", "", "Landroid/util/Pair;", "requestsId", "onProducerStart", "", "requestId", "producerName", "onProducerFinishWithSuccess", "extraMap", "", "onProducerFinishWithFailure", "t", "", "onProducerFinishWithCancellation", "onProducerEvent", "eventName", "onRequestStart", "request", "Lcom/facebook/imagepipeline/request/ImageRequest;", "callerContext", "", "isPrefetch", "", "onRequestSuccess", "onRequestFailure", "throwable", "onRequestCancellation", "requiresExtraMap", "ReactAndroid_debug"})
public final class SystraceRequestListener
extends BaseRequestListener {
    private int currentId;
    @NotNull
    private final Map<String, Pair<Integer, String>> producerId = new LinkedHashMap();
    @NotNull
    private final Map<String, Pair<Integer, String>> requestsId = new LinkedHashMap();

    public void onProducerStart(@NotNull String requestId, @NotNull String producerName) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)producerName, (String)"producerName");
        if (!Systrace.isTracing(0L)) {
            return;
        }
        StringBuilder entryName = new StringBuilder();
        entryName.append("FRESCO_PRODUCER_");
        entryName.append(StringsKt.replace$default((String)producerName, (char)':', (char)'_', (boolean)false, (int)4, null));
        Pair requestPair = Pair.create((Object)this.currentId, (Object)entryName.toString());
        Object object = requestPair.second;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
        Systrace.beginAsyncSection(0L, (String)object, this.currentId);
        this.producerId.put(requestId, (Pair<Integer, String>)requestPair);
        int n = this.currentId;
        this.currentId = n + 1;
    }

    public void onProducerFinishWithSuccess(@NotNull String requestId, @NotNull String producerName, @Nullable Map<String, String> extraMap) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)producerName, (String)"producerName");
        if (!Systrace.isTracing(0L)) {
            return;
        }
        Pair<Integer, String> entry = this.producerId.get(requestId);
        if (entry != null) {
            Object object = entry.second;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
            String string2 = (String)object;
            Object object2 = entry.first;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first");
            Systrace.endAsyncSection(0L, string2, ((Number)object2).intValue());
            this.producerId.remove(requestId);
        }
    }

    public void onProducerFinishWithFailure(@NotNull String requestId, @NotNull String producerName, @NotNull Throwable t, @Nullable Map<String, String> extraMap) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)producerName, (String)"producerName");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (!Systrace.isTracing(0L)) {
            return;
        }
        Pair<Integer, String> entry = this.producerId.get(requestId);
        if (entry != null) {
            Object object = entry.second;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
            String string2 = (String)object;
            Object object2 = entry.first;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first");
            Systrace.endAsyncSection(0L, string2, ((Number)object2).intValue());
            this.producerId.remove(requestId);
        }
    }

    public void onProducerFinishWithCancellation(@NotNull String requestId, @NotNull String producerName, @Nullable Map<String, String> extraMap) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)producerName, (String)"producerName");
        if (!Systrace.isTracing(0L)) {
            return;
        }
        Pair<Integer, String> entry = this.producerId.get(requestId);
        if (entry != null) {
            Object object = entry.second;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
            String string2 = (String)object;
            Object object2 = entry.first;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first");
            Systrace.endAsyncSection(0L, string2, ((Number)object2).intValue());
            this.producerId.remove(requestId);
        }
    }

    public void onProducerEvent(@NotNull String requestId, @NotNull String producerName, @NotNull String eventName) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)producerName, (String)"producerName");
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        if (!Systrace.isTracing(0L)) {
            return;
        }
        StringBuilder entryName = new StringBuilder();
        entryName.append("FRESCO_PRODUCER_EVENT_");
        entryName.append(StringsKt.replace$default((String)requestId, (char)':', (char)'_', (boolean)false, (int)4, null));
        entryName.append("_");
        entryName.append(StringsKt.replace$default((String)producerName, (char)':', (char)'_', (boolean)false, (int)4, null));
        entryName.append("_");
        entryName.append(StringsKt.replace$default((String)eventName, (char)':', (char)'_', (boolean)false, (int)4, null));
        Systrace.traceInstant(0L, entryName.toString(), Systrace.EventScope.THREAD);
    }

    public void onRequestStart(@NotNull ImageRequest request, @NotNull Object callerContext, @NotNull String requestId, boolean isPrefetch) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)callerContext, (String)"callerContext");
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        if (!Systrace.isTracing(0L)) {
            return;
        }
        StringBuilder entryName = new StringBuilder();
        entryName.append("FRESCO_REQUEST_");
        String string2 = request.getSourceUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        entryName.append(StringsKt.replace$default((String)string2, (char)':', (char)'_', (boolean)false, (int)4, null));
        Pair requestPair = Pair.create((Object)this.currentId, (Object)entryName.toString());
        Object object = requestPair.second;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
        Systrace.beginAsyncSection(0L, (String)object, this.currentId);
        this.requestsId.put(requestId, (Pair<Integer, String>)requestPair);
        int n = this.currentId;
        this.currentId = n + 1;
    }

    public void onRequestSuccess(@NotNull ImageRequest request, @NotNull String requestId, boolean isPrefetch) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        if (!Systrace.isTracing(0L)) {
            return;
        }
        Pair<Integer, String> entry = this.requestsId.get(requestId);
        if (entry != null) {
            Object object = entry.second;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
            String string2 = (String)object;
            Object object2 = entry.first;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first");
            Systrace.endAsyncSection(0L, string2, ((Number)object2).intValue());
            this.requestsId.remove(requestId);
        }
    }

    public void onRequestFailure(@NotNull ImageRequest request, @NotNull String requestId, @NotNull Throwable throwable, boolean isPrefetch) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (!Systrace.isTracing(0L)) {
            return;
        }
        Pair<Integer, String> entry = this.requestsId.get(requestId);
        if (entry != null) {
            Object object = entry.second;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
            String string2 = (String)object;
            Object object2 = entry.first;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first");
            Systrace.endAsyncSection(0L, string2, ((Number)object2).intValue());
            this.requestsId.remove(requestId);
        }
    }

    public void onRequestCancellation(@NotNull String requestId) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        if (!Systrace.isTracing(0L)) {
            return;
        }
        Pair<Integer, String> entry = this.requestsId.get(requestId);
        if (entry != null) {
            Object object = entry.second;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
            String string2 = (String)object;
            Object object2 = entry.first;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first");
            Systrace.endAsyncSection(0L, string2, ((Number)object2).intValue());
            this.requestsId.remove(requestId);
        }
    }

    public boolean requiresExtraMap(@NotNull String requestId) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        return false;
    }
}

