/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import android.util.SparseArray;
import android.view.Choreographer;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.common.SystemClock;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.jstasks.HeadlessJsTaskContext;
import com.facebook.react.jstasks.HeadlessJsTaskEventListener;
import com.facebook.react.modules.core.JavaScriptTimerExecutor;
import com.facebook.react.modules.core.ReactChoreographer;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u000b\b\u0016\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0005?@ABCB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020#H\u0016J\u0010\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010*\u001a\u00020#H\u0016J\b\u0010+\u001a\u00020#H\u0002J\b\u0010,\u001a\u00020#H\u0002J\b\u0010-\u001a\u00020#H\u0002J\b\u0010.\u001a\u00020#H\u0002J\b\u0010/\u001a\u00020#H\u0002J\b\u00100\u001a\u00020#H\u0002J \u00101\u001a\u00020#2\u0006\u00102\u001a\u00020(2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001dH\u0017J(\u00106\u001a\u00020#2\u0006\u00102\u001a\u00020(2\u0006\u00107\u001a\u00020(2\u0006\u00108\u001a\u0002092\u0006\u00105\u001a\u00020\u001dH\u0016J\u0010\u0010:\u001a\u00020#2\u0006\u00102\u001a\u00020(H\u0017J\u0010\u0010;\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u001dH\u0017J\u0015\u0010<\u001a\u00020\u001d2\u0006\u0010=\u001a\u000204H\u0000\u00a2\u0006\u0002\b>R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00060\u0019R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0018\u00010\u001bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/facebook/react/modules/core/JavaTimerManager;", "Lcom/facebook/react/bridge/LifecycleEventListener;", "Lcom/facebook/react/jstasks/HeadlessJsTaskEventListener;", "reactApplicationContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "javaScriptTimerExecutor", "Lcom/facebook/react/modules/core/JavaScriptTimerExecutor;", "reactChoreographer", "Lcom/facebook/react/modules/core/ReactChoreographer;", "devSupportManager", "Lcom/facebook/react/devsupport/interfaces/DevSupportManager;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;Lcom/facebook/react/modules/core/JavaScriptTimerExecutor;Lcom/facebook/react/modules/core/ReactChoreographer;Lcom/facebook/react/devsupport/interfaces/DevSupportManager;)V", "timerGuard", "", "idleCallbackGuard", "timerIdsToTimers", "Landroid/util/SparseArray;", "Lcom/facebook/react/modules/core/JavaTimerManager$Timer;", "isPaused", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isRunningTasks", "timerFrameCallback", "Lcom/facebook/react/modules/core/JavaTimerManager$TimerFrameCallback;", "idleFrameCallback", "Lcom/facebook/react/modules/core/JavaTimerManager$IdleFrameCallback;", "currentIdleCallbackRunnable", "Lcom/facebook/react/modules/core/JavaTimerManager$IdleCallbackRunnable;", "frameCallbackPosted", "", "frameIdleCallbackPosted", "sendIdleEvents", "timers", "Ljava/util/PriorityQueue;", "onHostPause", "", "onHostDestroy", "onHostResume", "onHeadlessJsTaskStart", "taskId", "", "onHeadlessJsTaskFinish", "onInstanceDestroy", "maybeSetChoreographerIdleCallback", "maybeIdleCallback", "setChoreographerCallback", "clearFrameCallback", "setChoreographerIdleCallback", "clearChoreographerIdleCallback", "createTimer", "timerId", "delay", "", "repeat", "createAndMaybeCallTimer", "duration", "jsSchedulingTime", "", "deleteTimer", "setSendIdleEvents", "hasActiveTimersInRange", "rangeMs", "hasActiveTimersInRange$ReactAndroid_debug", "Timer", "TimerFrameCallback", "IdleFrameCallback", "IdleCallbackRunnable", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nJavaTimerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaTimerManager.kt\ncom/facebook/react/modules/core/JavaTimerManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,366:1\n1#2:367\n*E\n"})
public class JavaTimerManager
implements LifecycleEventListener,
HeadlessJsTaskEventListener {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactApplicationContext reactApplicationContext;
    @NotNull
    private final JavaScriptTimerExecutor javaScriptTimerExecutor;
    @NotNull
    private final ReactChoreographer reactChoreographer;
    @NotNull
    private final DevSupportManager devSupportManager;
    @NotNull
    private final Object timerGuard;
    @NotNull
    private final Object idleCallbackGuard;
    @NotNull
    private final SparseArray<Timer> timerIdsToTimers;
    @NotNull
    private final AtomicBoolean isPaused;
    @NotNull
    private final AtomicBoolean isRunningTasks;
    @NotNull
    private final TimerFrameCallback timerFrameCallback;
    @NotNull
    private final IdleFrameCallback idleFrameCallback;
    @Nullable
    private IdleCallbackRunnable currentIdleCallbackRunnable;
    private boolean frameCallbackPosted;
    private boolean frameIdleCallbackPosted;
    private boolean sendIdleEvents;
    @NotNull
    private final PriorityQueue<Timer> timers;
    private static final float IDLE_CALLBACK_FRAME_DEADLINE_MS = 1.0f;
    private static final float FRAME_DURATION_MS = 16.666666f;
    private static final int TIMER_QUEUE_CAPACITY = 11;

    public JavaTimerManager(@NotNull ReactApplicationContext reactApplicationContext, @NotNull JavaScriptTimerExecutor javaScriptTimerExecutor, @NotNull ReactChoreographer reactChoreographer, @NotNull DevSupportManager devSupportManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactApplicationContext), (String)"reactApplicationContext");
        Intrinsics.checkNotNullParameter((Object)javaScriptTimerExecutor, (String)"javaScriptTimerExecutor");
        Intrinsics.checkNotNullParameter((Object)reactChoreographer, (String)"reactChoreographer");
        Intrinsics.checkNotNullParameter((Object)devSupportManager, (String)"devSupportManager");
        this.reactApplicationContext = reactApplicationContext;
        this.javaScriptTimerExecutor = javaScriptTimerExecutor;
        this.reactChoreographer = reactChoreographer;
        this.devSupportManager = devSupportManager;
        this.timerGuard = new Object();
        this.idleCallbackGuard = new Object();
        this.timerIdsToTimers = new SparseArray();
        this.isPaused = new AtomicBoolean(true);
        this.isRunningTasks = new AtomicBoolean(false);
        this.timerFrameCallback = new TimerFrameCallback();
        this.idleFrameCallback = new IdleFrameCallback();
        this.timers = new PriorityQueue(11, (arg_0, arg_1) -> JavaTimerManager.timers$lambda$1(JavaTimerManager::timers$lambda$0, arg_0, arg_1));
        this.reactApplicationContext.addLifecycleEventListener(this);
        HeadlessJsTaskContext.Companion.getInstance(this.reactApplicationContext).addTaskEventListener(this);
    }

    @Override
    public void onHostPause() {
        this.isPaused.set(true);
        this.clearFrameCallback();
        this.maybeIdleCallback();
    }

    @Override
    public void onHostDestroy() {
        this.clearFrameCallback();
        this.maybeIdleCallback();
    }

    @Override
    public void onHostResume() {
        this.isPaused.set(false);
        this.setChoreographerCallback();
        this.maybeSetChoreographerIdleCallback();
    }

    @Override
    public void onHeadlessJsTaskStart(int taskId) {
        if (!this.isRunningTasks.getAndSet(true)) {
            this.setChoreographerCallback();
            this.maybeSetChoreographerIdleCallback();
        }
    }

    @Override
    public void onHeadlessJsTaskFinish(int taskId) {
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.Companion.getInstance(this.reactApplicationContext);
        if (!headlessJsTaskContext.hasActiveTasks()) {
            this.isRunningTasks.set(false);
            this.clearFrameCallback();
            this.maybeIdleCallback();
        }
    }

    public void onInstanceDestroy() {
        HeadlessJsTaskContext.Companion.getInstance(this.reactApplicationContext).removeTaskEventListener(this);
        this.reactApplicationContext.removeLifecycleEventListener(this);
        this.clearFrameCallback();
        this.clearChoreographerIdleCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void maybeSetChoreographerIdleCallback() {
        Object object = this.idleCallbackGuard;
        synchronized (object) {
            boolean bl = false;
            if (this.sendIdleEvents) {
                this.setChoreographerIdleCallback();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void maybeIdleCallback() {
        if (this.isPaused.get() && !this.isRunningTasks.get()) {
            this.clearFrameCallback();
        }
    }

    private final void setChoreographerCallback() {
        if (!this.frameCallbackPosted) {
            this.reactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this.timerFrameCallback);
            this.frameCallbackPosted = true;
        }
    }

    private final void clearFrameCallback() {
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.Companion.getInstance(this.reactApplicationContext);
        if (this.frameCallbackPosted && this.isPaused.get() && !headlessJsTaskContext.hasActiveTasks()) {
            this.reactChoreographer.removeFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this.timerFrameCallback);
            this.frameCallbackPosted = false;
        }
    }

    private final void setChoreographerIdleCallback() {
        if (!this.frameIdleCallbackPosted) {
            this.reactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this.idleFrameCallback);
            this.frameIdleCallbackPosted = true;
        }
    }

    private final void clearChoreographerIdleCallback() {
        if (this.frameIdleCallbackPosted) {
            this.reactChoreographer.removeFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this.idleFrameCallback);
            this.frameIdleCallbackPosted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    public void createTimer(int timerId, long delay, boolean repeat) {
        long initialTargetTime = SystemClock.nanoTime() / (long)1000000 + delay;
        Timer timer = new Timer(timerId, initialTargetTime, (int)delay, repeat);
        Object object = this.timerGuard;
        synchronized (object) {
            boolean bl = false;
            this.timers.add(timer);
            this.timerIdsToTimers.put(timerId, (Object)timer);
            Unit unit = Unit.INSTANCE;
        }
    }

    public void createAndMaybeCallTimer(int timerId, int duration, double jsSchedulingTime, boolean repeat) {
        long driftTime;
        long deviceTime = SystemClock.currentTimeMillis();
        long remoteTime = (long)jsSchedulingTime;
        if (this.devSupportManager.getDevSupportEnabled() && (driftTime = Math.abs(remoteTime - deviceTime)) > 60000L) {
            this.javaScriptTimerExecutor.emitTimeDriftWarning("Debugger and device times have drifted by more than 60s. Please correct this by running adb shell \"date `date +%m%d%H%M%Y.%S`\" on your debugger machine.");
        }
        long adjustedDuration = Math.max(0L, remoteTime - deviceTime + (long)duration);
        if (duration == 0 && !repeat) {
            WritableArray writableArray = Arguments.createArray();
            Intrinsics.checkNotNullExpressionValue((Object)writableArray, (String)"createArray(...)");
            WritableArray timerToCall = writableArray;
            timerToCall.pushInt(timerId);
            this.javaScriptTimerExecutor.callTimers(timerToCall);
            return;
        }
        this.createTimer(timerId, adjustedDuration, repeat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    public void deleteTimer(int timerId) {
        Object object = this.timerGuard;
        synchronized (object) {
            boolean bl = false;
            Timer timer = (Timer)this.timerIdsToTimers.get(timerId);
            if (timer == null) {
                return;
            }
            Timer timer2 = timer;
            this.timerIdsToTimers.remove(timerId);
            boolean bl2 = this.timers.remove(timer2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    public void setSendIdleEvents(boolean sendIdleEvents) {
        Object object = this.idleCallbackGuard;
        synchronized (object) {
            boolean bl = false;
            this.sendIdleEvents = sendIdleEvents;
            Unit unit = Unit.INSTANCE;
        }
        UiThreadUtil.runOnUiThread(() -> JavaTimerManager.setSendIdleEvents$lambda$7(this, sendIdleEvents));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasActiveTimersInRange$ReactAndroid_debug(long rangeMs) {
        Object object = this.timerGuard;
        synchronized (object) {
            block8: {
                Timer timer;
                block7: {
                    boolean bl = false;
                    if (this.timers.peek() != null) break block7;
                    boolean bl2 = false;
                    return bl2;
                }
                Timer nextTimer = timer;
                if (!JavaTimerManager.Companion.isTimerInRange(nextTimer, rangeMs)) break block8;
                boolean bl = true;
                return bl;
            }
            Iterator<Timer> iterator2 = this.timers.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<Timer> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Timer timer = iterator3.next();
                Intrinsics.checkNotNull((Object)timer);
                if (!JavaTimerManager.Companion.isTimerInRange(timer, rangeMs)) continue;
                boolean bl = true;
                return bl;
            }
            Unit unit = Unit.INSTANCE;
        }
        return false;
    }

    private static final int timers$lambda$0(Timer lhs, Timer rhs) {
        return MathKt.getSign((long)(lhs.getTargetTime() - rhs.getTargetTime()));
    }

    private static final int timers$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void setSendIdleEvents$lambda$7(JavaTimerManager this$0, boolean $sendIdleEvents) {
        Object object = this$0.idleCallbackGuard;
        synchronized (object) {
            boolean bl = false;
            if ($sendIdleEvents) {
                this$0.setChoreographerIdleCallback();
            } else {
                this$0.clearChoreographerIdleCallback();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/react/modules/core/JavaTimerManager$Companion;", "", "<init>", "()V", "IDLE_CALLBACK_FRAME_DEADLINE_MS", "", "FRAME_DURATION_MS", "TIMER_QUEUE_CAPACITY", "", "isTimerInRange", "", "timer", "Lcom/facebook/react/modules/core/JavaTimerManager$Timer;", "rangeMs", "", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        private final boolean isTimerInRange(Timer timer, long rangeMs) {
            return !timer.getRepeat() && (long)timer.getInterval() < rangeMs;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/react/modules/core/JavaTimerManager$IdleCallbackRunnable;", "Ljava/lang/Runnable;", "frameStartTime", "", "<init>", "(Lcom/facebook/react/modules/core/JavaTimerManager;J)V", "isCancelled", "", "run", "", "cancel", "ReactAndroid_debug"})
    @SourceDebugExtension(value={"SMAP\nJavaTimerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaTimerManager.kt\ncom/facebook/react/modules/core/JavaTimerManager$IdleCallbackRunnable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,366:1\n1#2:367\n*E\n"})
    private final class IdleCallbackRunnable
    implements Runnable {
        private final long frameStartTime;
        private volatile boolean isCancelled;

        public IdleCallbackRunnable(long frameStartTime) {
            this.frameStartTime = frameStartTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.isCancelled) {
                return;
            }
            long frameTimeMillis = this.frameStartTime / (long)1000000;
            long timeSinceBoot = SystemClock.uptimeMillis();
            long frameTimeElapsed = timeSinceBoot - frameTimeMillis;
            long time = SystemClock.currentTimeMillis();
            long absoluteFrameStartTime = time - frameTimeElapsed;
            if (16.666666f - (float)frameTimeElapsed < 1.0f) {
                return;
            }
            boolean sendIdleEvents = false;
            Object object = JavaTimerManager.this.idleCallbackGuard;
            JavaTimerManager javaTimerManager = JavaTimerManager.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                sendIdleEvents = javaTimerManager.sendIdleEvents;
                Unit unit = Unit.INSTANCE;
            }
            if (sendIdleEvents) {
                JavaTimerManager.this.javaScriptTimerExecutor.callIdleCallbacks(absoluteFrameStartTime);
            }
            JavaTimerManager.this.currentIdleCallbackRunnable = null;
        }

        public final void cancel() {
            this.isCancelled = true;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/facebook/react/modules/core/JavaTimerManager$IdleFrameCallback;", "Landroid/view/Choreographer$FrameCallback;", "<init>", "(Lcom/facebook/react/modules/core/JavaTimerManager;)V", "doFrame", "", "frameTimeNanos", "", "ReactAndroid_debug"})
    private final class IdleFrameCallback
    implements Choreographer.FrameCallback {
        public void doFrame(long frameTimeNanos) {
            if (JavaTimerManager.this.isPaused.get() && !JavaTimerManager.this.isRunningTasks.get()) {
                return;
            }
            IdleCallbackRunnable idleCallbackRunnable = JavaTimerManager.this.currentIdleCallbackRunnable;
            if (idleCallbackRunnable != null) {
                idleCallbackRunnable.cancel();
            }
            JavaTimerManager.this.currentIdleCallbackRunnable = new IdleCallbackRunnable(frameTimeNanos);
            JavaTimerManager.this.reactApplicationContext.runOnJSQueueThread(JavaTimerManager.this.currentIdleCallbackRunnable);
            JavaTimerManager.this.reactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/facebook/react/modules/core/JavaTimerManager$Timer;", "", "timerId", "", "targetTime", "", "interval", "repeat", "", "<init>", "(IJIZ)V", "getTimerId", "()I", "getTargetTime", "()J", "setTargetTime", "(J)V", "getInterval", "getRepeat", "()Z", "ReactAndroid_debug"})
    private static final class Timer {
        private final int timerId;
        private long targetTime;
        private final int interval;
        private final boolean repeat;

        public Timer(int timerId, long targetTime, int interval, boolean repeat) {
            this.timerId = timerId;
            this.targetTime = targetTime;
            this.interval = interval;
            this.repeat = repeat;
        }

        public final int getTimerId() {
            return this.timerId;
        }

        public final long getTargetTime() {
            return this.targetTime;
        }

        public final void setTargetTime(long l) {
            this.targetTime = l;
        }

        public final int getInterval() {
            return this.interval;
        }

        public final boolean getRepeat() {
            return this.repeat;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/react/modules/core/JavaTimerManager$TimerFrameCallback;", "Landroid/view/Choreographer$FrameCallback;", "<init>", "(Lcom/facebook/react/modules/core/JavaTimerManager;)V", "timersToCall", "Lcom/facebook/react/bridge/WritableArray;", "doFrame", "", "frameTimeNanos", "", "ReactAndroid_debug"})
    private final class TimerFrameCallback
    implements Choreographer.FrameCallback {
        @Nullable
        private WritableArray timersToCall;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFrame(long frameTimeNanos) {
            if (JavaTimerManager.this.isPaused.get() && !JavaTimerManager.this.isRunningTasks.get()) {
                return;
            }
            long frameTimeMillis = frameTimeNanos / (long)1000000;
            Object object = JavaTimerManager.this.timerGuard;
            Object object2 = JavaTimerManager.this;
            Object object3 = object;
            synchronized (object3) {
                boolean $i$a$-synchronized-JavaTimerManager$TimerFrameCallback$doFrame$22 = false;
                while (!((JavaTimerManager)object2).timers.isEmpty()) {
                    Timer timer;
                    Object e = ((JavaTimerManager)object2).timers.peek();
                    Intrinsics.checkNotNull(e);
                    if (((Timer)e).getTargetTime() >= frameTimeMillis || (timer = (Timer)((JavaTimerManager)object2).timers.poll()) == null) break;
                    if (this.timersToCall == null) {
                        this.timersToCall = Arguments.createArray();
                    }
                    WritableArray writableArray = this.timersToCall;
                    if (writableArray != null) {
                        writableArray.pushInt(timer.getTimerId());
                    }
                    if (timer.getRepeat()) {
                        timer.setTargetTime(frameTimeMillis + (long)timer.getInterval());
                        ((JavaTimerManager)object2).timers.add(timer);
                        continue;
                    }
                    ((JavaTimerManager)object2).timerIdsToTimers.remove(timer.getTimerId());
                }
                Unit $i$a$-synchronized-JavaTimerManager$TimerFrameCallback$doFrame$22 = Unit.INSTANCE;
            }
            WritableArray writableArray = this.timersToCall;
            if (writableArray != null) {
                object2 = writableArray;
                object3 = JavaTimerManager.this;
                Object it = object2;
                boolean bl = false;
                ((JavaTimerManager)object3).javaScriptTimerExecutor.callTimers((WritableArray)it);
                this.timersToCall = null;
            }
            JavaTimerManager.this.reactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this);
        }
    }
}

