/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.blob;

import android.util.Base64;
import com.facebook.fbreact.specs.NativeFileReaderModuleSpec;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.blob.BlobModule;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ReactModule(name="FileReaderModule")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/facebook/react/modules/blob/FileReaderModule;", "Lcom/facebook/fbreact/specs/NativeFileReaderModuleSpec;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "getBlobModule", "Lcom/facebook/react/modules/blob/BlobModule;", "reason", "", "readAsText", "", "blob", "Lcom/facebook/react/bridge/ReadableMap;", "encoding", "promise", "Lcom/facebook/react/bridge/Promise;", "readAsDataURL", "Companion", "ReactAndroid_debug"})
public final class FileReaderModule
extends NativeFileReaderModuleSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NAME = "FileReaderModule";
    @NotNull
    private static final String ERROR_INVALID_BLOB = "ERROR_INVALID_BLOB";

    public FileReaderModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super(reactContext);
    }

    private final BlobModule getBlobModule(String reason) {
        ReactApplicationContext reactApplicationContext;
        ReactApplicationContext reactApplicationContext2 = reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
        return reactApplicationContext2 != null ? reactApplicationContext2.getNativeModule(BlobModule.class) : null;
    }

    @Override
    public void readAsText(@NotNull ReadableMap blob, @NotNull String encoding, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)blob, (String)"blob");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        BlobModule blobModule = this.getBlobModule("readAsText");
        if (blobModule == null) {
            promise.reject(new IllegalStateException("Could not get BlobModule from ReactApplicationContext"));
            return;
        }
        String blobId = blob.getString("blobId");
        if (blobId == null) {
            promise.reject(ERROR_INVALID_BLOB, "The specified blob does not contain a blobId");
            return;
        }
        byte[] bytes = blobModule.resolve(blobId, blob.getInt("offset"), blob.getInt("size"));
        if (bytes == null) {
            promise.reject(ERROR_INVALID_BLOB, "The specified blob is invalid");
            return;
        }
        try {
            Charset charset = Charset.forName(encoding);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            promise.resolve(new String(bytes, charset));
        }
        catch (Exception e) {
            promise.reject(e);
        }
    }

    @Override
    public void readAsDataURL(@NotNull ReadableMap blob, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)blob, (String)"blob");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        BlobModule blobModule = this.getBlobModule("readAsDataURL");
        if (blobModule == null) {
            promise.reject(new IllegalStateException("Could not get BlobModule from ReactApplicationContext"));
            return;
        }
        String blobId = blob.getString("blobId");
        if (blobId == null) {
            promise.reject(ERROR_INVALID_BLOB, "The specified blob does not contain a blobId");
            return;
        }
        byte[] bytes = blobModule.resolve(blobId, blob.getInt("offset"), blob.getInt("size"));
        if (bytes == null) {
            promise.reject(ERROR_INVALID_BLOB, "The specified blob is invalid");
            return;
        }
        try {
            CharSequence charSequence;
            StringBuilder sb = new StringBuilder();
            sb.append("data:");
            StringBuilder stringBuilder = blob.hasKey("type") && !((charSequence = (CharSequence)blob.getString("type")) == null || charSequence.length() == 0) ? sb.append(blob.getString("type")) : sb.append("application/octet-stream");
            sb.append(";base64,");
            sb.append(Base64.encodeToString((byte[])bytes, (int)2));
            promise.resolve(sb.toString());
        }
        catch (Exception e) {
            promise.reject(e);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/facebook/react/modules/blob/FileReaderModule$Companion;", "", "<init>", "()V", "NAME", "", "getNAME", "()Ljava/lang/String;", "ERROR_INVALID_BLOB", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

