/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting;

import android.os.SystemClock;
import androidx.annotation.UiThread;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.react.bridge.ReactIgnorableMountingException;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.RetryableMountingLayerException;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.SurfaceMountingManager;
import com.facebook.react.fabric.mounting.mountitems.DispatchCommandMountItem;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.systrace.Systrace;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0005\b\u0000\u0018\u0000 *2\u00020\u0001:\u0002)*B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fJ\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fJ\b\u0010\u001d\u001a\u00020\u0019H\u0007J\u0018\u0010\u001e\u001a\u00020\u00192\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\tH\u0007J\b\u0010\u001e\u001a\u00020\u0019H\u0003J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0011H\u0007J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\fH\u0002J\u0010\u0010%\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010&H\u0003J\u0010\u0010'\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010&H\u0003J\u0010\u0010(\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010&H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/facebook/react/fabric/mounting/MountItemDispatcher;", "", "mountingManager", "Lcom/facebook/react/fabric/mounting/MountingManager;", "itemDispatchListener", "Lcom/facebook/react/fabric/mounting/MountItemDispatcher$ItemDispatchListener;", "<init>", "(Lcom/facebook/react/fabric/mounting/MountingManager;Lcom/facebook/react/fabric/mounting/MountItemDispatcher$ItemDispatchListener;)V", "viewCommandMountItems", "Ljava/util/Queue;", "Lcom/facebook/react/fabric/mounting/mountitems/DispatchCommandMountItem;", "mountItems", "Lcom/facebook/react/fabric/mounting/mountitems/MountItem;", "preMountItems", "inDispatch", "", "value", "", "batchedExecutionTime", "getBatchedExecutionTime", "()J", "runStartTime", "getRunStartTime", "lastFrameTimeNanos", "addViewCommandMountItem", "", "mountItem", "addMountItem", "addPreAllocateMountItem", "tryDispatchMountItems", "dispatchMountItems", "dispatchPreMountItems", "frameTimeNanos", "dispatchPreMountItemsImpl", "deadline", "executeOrEnqueue", "item", "getAndResetViewCommandMountItems", "", "getAndResetMountItems", "getAndResetPreMountItems", "ItemDispatchListener", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nMountItemDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MountItemDispatcher.kt\ncom/facebook/react/fabric/mounting/MountItemDispatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,366:1\n1#2:367\n*E\n"})
public final class MountItemDispatcher {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final MountingManager mountingManager;
    @NotNull
    private final ItemDispatchListener itemDispatchListener;
    @NotNull
    private final Queue<DispatchCommandMountItem> viewCommandMountItems;
    @NotNull
    private final Queue<MountItem> mountItems;
    @NotNull
    private final Queue<MountItem> preMountItems;
    private boolean inDispatch;
    private long batchedExecutionTime;
    private long runStartTime;
    private long lastFrameTimeNanos;
    @NotNull
    private static final String TAG = "MountItemDispatcher";
    private static final long FRAME_TIME_NS = 16666666L;

    public MountItemDispatcher(@NotNull MountingManager mountingManager, @NotNull ItemDispatchListener itemDispatchListener) {
        Intrinsics.checkNotNullParameter((Object)mountingManager, (String)"mountingManager");
        Intrinsics.checkNotNullParameter((Object)itemDispatchListener, (String)"itemDispatchListener");
        this.mountingManager = mountingManager;
        this.itemDispatchListener = itemDispatchListener;
        this.viewCommandMountItems = new ConcurrentLinkedQueue();
        this.mountItems = new ConcurrentLinkedQueue();
        this.preMountItems = new ConcurrentLinkedQueue();
    }

    public final long getBatchedExecutionTime() {
        return this.batchedExecutionTime;
    }

    public final long getRunStartTime() {
        return this.runStartTime;
    }

    public final void addViewCommandMountItem(@NotNull DispatchCommandMountItem mountItem) {
        Intrinsics.checkNotNullParameter((Object)mountItem, (String)"mountItem");
        this.viewCommandMountItems.add(mountItem);
    }

    public final void addMountItem(@NotNull MountItem mountItem) {
        Intrinsics.checkNotNullParameter((Object)mountItem, (String)"mountItem");
        this.mountItems.add(mountItem);
    }

    public final void addPreAllocateMountItem(@NotNull MountItem mountItem) {
        Intrinsics.checkNotNullParameter((Object)mountItem, (String)"mountItem");
        if (!this.mountingManager.surfaceIsStopped(mountItem.getSurfaceId())) {
            this.preMountItems.add(mountItem);
        } else if (FabricUIManager.IS_DEVELOPMENT_ENVIRONMENT) {
            Object[] objectArray = new Object[]{mountItem.getSurfaceId(), mountItem.toString()};
            FLog.e((String)TAG, (String)"Not queueing PreAllocateMountItem: surfaceId stopped: [%d] - %s", (Object[])objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    @ThreadConfined(value="UI")
    public final void tryDispatchMountItems() {
        if (this.inDispatch) {
            return;
        }
        this.inDispatch = true;
        try {
            this.dispatchMountItems();
        }
        finally {
            this.inDispatch = false;
        }
        this.itemDispatchListener.didDispatchMountItems();
    }

    @UiThread
    @ThreadConfined(value="UI")
    public final void dispatchMountItems(@NotNull Queue<MountItem> mountItems) {
        Intrinsics.checkNotNullParameter(mountItems, (String)"mountItems");
        while (!mountItems.isEmpty()) {
            MountItem item;
            if (mountItems.poll() == null) {
                boolean $i$a$-requireNotNull-MountItemDispatcher$dispatchMountItems$item$22 = false;
                String $i$a$-requireNotNull-MountItemDispatcher$dispatchMountItems$item$22 = "MountItem should not be null";
                throw new IllegalArgumentException($i$a$-requireNotNull-MountItemDispatcher$dispatchMountItems$item$22.toString());
            }
            try {
                item.execute(this.mountingManager);
            }
            catch (RetryableMountingLayerException e) {
                if (item instanceof DispatchCommandMountItem) {
                    DispatchCommandMountItem mountItem = (DispatchCommandMountItem)item;
                    if (mountItem.getRetries() != 0) continue;
                    mountItem.incrementRetries();
                    this.addViewCommandMountItem(mountItem);
                    continue;
                }
                MountItemDispatcher.Companion.printMountItem(item, "dispatchExternalMountItems: mounting failed with " + e.getMessage());
            }
        }
    }

    @UiThread
    @ThreadConfined(value="UI")
    private final void dispatchMountItems() {
        this.batchedExecutionTime = 0L;
        this.runStartTime = SystemClock.uptimeMillis();
        List<DispatchCommandMountItem> viewCommandMountItemsToDispatch = this.getAndResetViewCommandMountItems();
        List<MountItem> mountItemsToDispatch = this.getAndResetMountItems();
        if (mountItemsToDispatch == null && viewCommandMountItemsToDispatch == null) {
            return;
        }
        this.itemDispatchListener.willMountItems(mountItemsToDispatch);
        List<DispatchCommandMountItem> list = viewCommandMountItemsToDispatch;
        if (list != null) {
            List<DispatchCommandMountItem> commands = list;
            boolean bl = false;
            Systrace.beginSection(0L, "MountItemDispatcher::mountViews viewCommandMountItems");
            for (DispatchCommandMountItem command : commands) {
                if (ReactNativeFeatureFlags.enableFabricLogs()) {
                    MountItemDispatcher.Companion.printMountItem(command, "dispatchMountItems: Executing viewCommandMountItem");
                }
                try {
                    this.executeOrEnqueue(command);
                }
                catch (RetryableMountingLayerException e) {
                    if (command.getRetries() == 0) {
                        command.incrementRetries();
                        this.addViewCommandMountItem(command);
                        continue;
                    }
                    ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Caught exception executing ViewCommand: " + command, e));
                }
                catch (Throwable e) {
                    ReactSoftExceptionLogger.logSoftException(TAG, new RuntimeException("Caught exception executing ViewCommand: " + command, e));
                }
            }
            Systrace.endSection(0L);
        }
        List<MountItem> list2 = this.getAndResetPreMountItems();
        if (list2 != null) {
            List<MountItem> preMountItems = list2;
            boolean bl = false;
            Systrace.beginSection(0L, "MountItemDispatcher::mountViews preMountItems");
            for (MountItem preMountItem : preMountItems) {
                if (ReactNativeFeatureFlags.enableFabricLogs()) {
                    MountItemDispatcher.Companion.printMountItem(preMountItem, "dispatchMountItems: Executing preMountItem");
                }
                this.executeOrEnqueue(preMountItem);
            }
            Systrace.endSection(0L);
        }
        List<MountItem> list3 = mountItemsToDispatch;
        if (list3 != null) {
            List<MountItem> items = list3;
            boolean bl = false;
            Systrace.beginSection(0L, "MountItemDispatcher::mountViews mountItems to execute");
            long batchedExecutionStartTime = SystemClock.uptimeMillis();
            for (MountItem mountItem : items) {
                if (ReactNativeFeatureFlags.enableFabricLogs()) {
                    MountItemDispatcher.Companion.printMountItem(mountItem, "dispatchMountItems: Executing mountItem");
                }
                try {
                    this.executeOrEnqueue(mountItem);
                }
                catch (Throwable e) {
                    FLog.e((String)TAG, (String)"dispatchMountItems: caught exception, displaying mount state", (Throwable)e);
                    for (MountItem m : items) {
                        if (m == mountItem) {
                            FLog.e((String)TAG, (String)"dispatchMountItems: mountItem: next mountItem triggered exception!");
                        }
                        MountItemDispatcher.Companion.printMountItem(m, "dispatchMountItems: mountItem");
                    }
                    if (mountItem.getSurfaceId() != -1) {
                        SurfaceMountingManager surfaceMountingManager = this.mountingManager.getSurfaceManager(mountItem.getSurfaceId());
                        if (surfaceMountingManager != null) {
                            surfaceMountingManager.printSurfaceState();
                        }
                    }
                    if (ReactIgnorableMountingException.Companion.isIgnorable(e)) {
                        ReactSoftExceptionLogger.logSoftException(TAG, e);
                        continue;
                    }
                    throw e;
                }
            }
            this.batchedExecutionTime += SystemClock.uptimeMillis() - batchedExecutionStartTime;
            Systrace.endSection(0L);
        }
        this.itemDispatchListener.didMountItems(mountItemsToDispatch);
    }

    @UiThread
    @ThreadConfined(value="UI")
    public final void dispatchPreMountItems(long frameTimeNanos) {
        this.lastFrameTimeNanos = frameTimeNanos;
        if (this.preMountItems.isEmpty()) {
            return;
        }
        long deadline = this.lastFrameTimeNanos + 8333333L;
        this.dispatchPreMountItemsImpl(deadline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dispatchPreMountItemsImpl(long deadline) {
        Systrace.beginSection(0L, "MountItemDispatcher::premountViews");
        this.inDispatch = true;
        try {
            while (System.nanoTime() <= deadline) {
                MountItem preMountItemToDispatch;
                if (this.preMountItems.poll() == null) {
                    break;
                }
                if (ReactNativeFeatureFlags.enableFabricLogs()) {
                    MountItemDispatcher.Companion.printMountItem(preMountItemToDispatch, "dispatchPreMountItems");
                }
                this.executeOrEnqueue(preMountItemToDispatch);
            }
        }
        finally {
            this.inDispatch = false;
        }
        Systrace.endSection(0L);
    }

    private final void executeOrEnqueue(MountItem item) {
        if (this.mountingManager.isWaitingForViewAttach(item.getSurfaceId())) {
            if (ReactNativeFeatureFlags.enableFabricLogs()) {
                Object[] objectArray = new Object[]{item.getSurfaceId()};
                FLog.e((String)TAG, (String)"executeOrEnqueue: Item execution delayed, surface %s is not ready yet", (Object[])objectArray);
            }
            SurfaceMountingManager surfaceMountingManager = this.mountingManager.getSurfaceManagerEnforced(item.getSurfaceId(), "MountItemDispatcher::executeOrEnqueue");
            surfaceMountingManager.scheduleMountItemOnViewAttach(item);
        } else {
            item.execute(this.mountingManager);
        }
    }

    @ThreadConfined(value="UI")
    @UiThread
    private final List<DispatchCommandMountItem> getAndResetViewCommandMountItems() {
        return MountItemDispatcher.Companion.drainConcurrentItemQueue(this.viewCommandMountItems);
    }

    @ThreadConfined(value="UI")
    @UiThread
    private final List<MountItem> getAndResetMountItems() {
        return MountItemDispatcher.Companion.drainConcurrentItemQueue(this.mountItems);
    }

    @ThreadConfined(value="UI")
    @UiThread
    private final List<MountItem> getAndResetPreMountItems() {
        return MountItemDispatcher.Companion.drainConcurrentItemQueue(this.preMountItems);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\n\u0018\u00010\t\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/fabric/mounting/MountItemDispatcher$Companion;", "", "<init>", "()V", "TAG", "", "FRAME_TIME_NS", "", "drainConcurrentItemQueue", "", "E", "queue", "Ljava/util/Queue;", "printMountItem", "", "mountItem", "Lcom/facebook/react/fabric/mounting/mountitems/MountItem;", "prefix", "ReactAndroid_debug"})
    @SourceDebugExtension(value={"SMAP\nMountItemDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MountItemDispatcher.kt\ncom/facebook/react/fabric/mounting/MountItemDispatcher$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,366:1\n1#2:367\n739#3,9:368\n*S KotlinDebug\n*F\n+ 1 MountItemDispatcher.kt\ncom/facebook/react/fabric/mounting/MountItemDispatcher$Companion\n*L\n358#1:368,9\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        private final <E> List<E> drainConcurrentItemQueue(Queue<E> queue) {
            List list;
            if (queue.isEmpty()) {
                return null;
            }
            List $this$drainConcurrentItemQueue_u24lambda_u241 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            do {
                if (queue.poll() != null) {
                    E it;
                    boolean bl2 = false;
                    $this$drainConcurrentItemQueue_u24lambda_u241.add(it);
                }
            } while (!((Collection)queue).isEmpty());
            List it = list = CollectionsKt.build((List)list);
            boolean bl3 = false;
            return !((Collection)it).isEmpty() ? list : null;
        }

        private final void printMountItem(MountItem mountItem, String prefix) {
            List list;
            String[] stringArray = new String[]{"\n"};
            List $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)mountItem.toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            List mountItemLines = list;
            for (String line : mountItemLines) {
                FLog.e((String)MountItemDispatcher.TAG, (String)(prefix + ": " + line));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H&J\u0018\u0010\u0007\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H&J\b\u0010\b\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/fabric/mounting/MountItemDispatcher$ItemDispatchListener;", "", "willMountItems", "", "mountItems", "", "Lcom/facebook/react/fabric/mounting/mountitems/MountItem;", "didMountItems", "didDispatchMountItems", "ReactAndroid_debug"})
    public static interface ItemDispatchListener {
        public void willMountItems(@Nullable List<? extends MountItem> var1);

        public void didMountItems(@Nullable List<? extends MountItem> var1);

        public void didDispatchMountItems();
    }
}

