/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Sink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J8\u0010\u0016\u001a\u00020\u00132\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/facebook/react/devsupport/MultipartStreamReader;", "", "source", "Lokio/BufferedSource;", "boundary", "", "<init>", "(Lokio/BufferedSource;Ljava/lang/String;)V", "lastProgressEvent", "", "readAllParts", "", "listener", "Lcom/facebook/react/devsupport/MultipartStreamReader$ChunkListener;", "parseHeaders", "", "data", "Lokio/Buffer;", "emitChunk", "", "chunk", "done", "emitProgress", "headers", "contentLength", "isFinal", "ChunkListener", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nMultipartStreamReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipartStreamReader.kt\ncom/facebook/react/devsupport/MultipartStreamReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,168:1\n739#2,9:169\n37#3:178\n36#3,3:179\n108#4:182\n80#4,22:183\n108#4:205\n80#4,22:206\n*S KotlinDebug\n*F\n+ 1 MultipartStreamReader.kt\ncom/facebook/react/devsupport/MultipartStreamReader\n*L\n116#1:169,9\n116#1:178\n116#1:179,3\n122#1:182\n122#1:183,22\n123#1:205\n123#1:206,22\n*E\n"})
public final class MultipartStreamReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final String boundary;
    private long lastProgressEvent;
    @NotNull
    private static final String CRLF = "\r\n";

    public MultipartStreamReader(@NotNull BufferedSource source2, @NotNull String boundary) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
        this.source = source2;
        this.boundary = boundary;
    }

    public final boolean readAllParts(@NotNull ChunkListener listener) throws IOException {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ByteString delimiter = ByteString.Companion.-deprecated_encodeUtf8("\r\n--" + this.boundary + CRLF);
        ByteString closeDelimiter = ByteString.Companion.-deprecated_encodeUtf8("\r\n--" + this.boundary + "--\r\n");
        ByteString headersDelimiter = ByteString.Companion.-deprecated_encodeUtf8("\r\n\r\n");
        int bufferLen = 4096;
        long chunkStart = 0L;
        long bytesSeen = 0L;
        Buffer content = new Buffer();
        Map<String, String> currentHeaders = null;
        long currentHeadersLength = 0L;
        while (true) {
            boolean isCloseDelimiter = false;
            long searchStart = (long)Math.max((double)(bytesSeen - (long)closeDelimiter.-deprecated_size()), (double)chunkStart);
            long indexOfDelimiter = content.indexOf(delimiter, searchStart);
            if (indexOfDelimiter == -1L) {
                isCloseDelimiter = true;
                indexOfDelimiter = content.indexOf(closeDelimiter, searchStart);
            }
            if (indexOfDelimiter == -1L) {
                long bytesRead;
                bytesSeen = content.-deprecated_size();
                if (currentHeaders == null) {
                    long indexOfHeaders = content.indexOf(headersDelimiter, searchStart);
                    if (indexOfHeaders >= 0L) {
                        this.source.read(content, indexOfHeaders);
                        Buffer headers = new Buffer();
                        content.copyTo(headers, searchStart, indexOfHeaders - searchStart);
                        currentHeadersLength = headers.-deprecated_size() + (long)headersDelimiter.-deprecated_size();
                        currentHeaders = this.parseHeaders(headers);
                    }
                } else {
                    this.emitProgress(currentHeaders, content.-deprecated_size() - currentHeadersLength, false, listener);
                }
                if ((bytesRead = this.source.read(content, (long)bufferLen)) > 0L) continue;
                return false;
            }
            long chunkEnd = indexOfDelimiter;
            long length = chunkEnd - chunkStart;
            if (chunkStart > 0L) {
                Buffer chunk = new Buffer();
                content.skip(chunkStart);
                content.read(chunk, length);
                this.emitProgress(currentHeaders, chunk.-deprecated_size() - currentHeadersLength, true, listener);
                this.emitChunk(chunk, isCloseDelimiter, listener);
                currentHeaders = null;
                currentHeadersLength = 0L;
            } else {
                content.skip(chunkEnd);
            }
            if (isCloseDelimiter) {
                return true;
            }
            bytesSeen = chunkStart = (long)delimiter.-deprecated_size();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> parseHeaders(Buffer data) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Map headers = new LinkedHashMap();
        String text = data.readUtf8();
        Object object = text;
        Regex regex = new Regex(CRLF);
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        for (String line : thisCollection$iv.toArray(new String[0])) {
            void $this$trim$iv;
            void $this$trim$iv2;
            int indexOfSeparator = StringsKt.indexOf$default((CharSequence)line, (String)":", (int)0, (boolean)false, (int)6, null);
            if (indexOfSeparator == -1) continue;
            Intrinsics.checkNotNullExpressionValue((Object)line.substring(0, indexOfSeparator), (String)"substring(...)");
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv2;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String key = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)line.substring(indexOfSeparator + 1), (String)"substring(...)");
            boolean $i$f$trim3 = false;
            CharSequence $this$trim$iv$iv2 = (CharSequence)$this$trim$iv;
            boolean $i$f$trim4 = false;
            int startIndex$iv$iv2 = 0;
            int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
            boolean startFound$iv$iv2 = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv2;
            }
            String value = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
            headers.put(key, value);
        }
        return headers;
    }

    private final void emitChunk(Buffer chunk, boolean done, ChunkListener listener) throws IOException {
        ByteString marker = ByteString.Companion.-deprecated_encodeUtf8("\r\n\r\n");
        long indexOfMarker = chunk.indexOf(marker);
        if (indexOfMarker == -1L) {
            listener.onChunkComplete(MapsKt.emptyMap(), chunk, done);
        } else {
            Buffer headers = new Buffer();
            Buffer body = new Buffer();
            chunk.read(headers, indexOfMarker);
            chunk.skip((long)marker.-deprecated_size());
            chunk.readAll((Sink)body);
            listener.onChunkComplete(this.parseHeaders(headers), body, done);
        }
    }

    private final void emitProgress(Map<String, String> headers, long contentLength, boolean isFinal, ChunkListener listener) throws IOException {
        if (listener == null || headers == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastProgressEvent > 16L || isFinal) {
            this.lastProgressEvent = currentTime;
            long headersContentLength = Long.parseLong(headers.getOrDefault("Content-Length", "0"));
            listener.onChunkProgress(headers, contentLength, headersContentLength);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J,\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J,\u0010\u000b\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/devsupport/MultipartStreamReader$ChunkListener;", "", "onChunkComplete", "", "headers", "", "", "body", "Lokio/Buffer;", "isLastChunk", "", "onChunkProgress", "loaded", "", "total", "ReactAndroid_debug"})
    public static interface ChunkListener {
        public void onChunkComplete(@NotNull Map<String, String> var1, @NotNull Buffer var2, boolean var3) throws IOException;

        public void onChunkProgress(@NotNull Map<String, String> var1, long var2, long var4) throws IOException;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/devsupport/MultipartStreamReader$Companion;", "", "<init>", "()V", "CRLF", "", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

