/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.modules.debug.FpsDebugFrameCallback;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0014J0\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/facebook/react/devsupport/FpsView;", "Landroid/widget/FrameLayout;", "reactContext", "Lcom/facebook/react/bridge/ReactContext;", "<init>", "(Lcom/facebook/react/bridge/ReactContext;)V", "textView", "Landroid/widget/TextView;", "frameCallback", "Lcom/facebook/react/modules/debug/FpsDebugFrameCallback;", "fpsMonitorRunnable", "Lcom/facebook/react/devsupport/FpsView$FPSMonitorRunnable;", "onAttachedToWindow", "", "onDetachedFromWindow", "setCurrentFPS", "currentFPS", "", "currentJSFPS", "droppedUIFrames", "", "total4PlusFrameStutters", "runningOnFabric", "", "FPSMonitorRunnable", "Companion", "ReactAndroid_debug"})
public final class FpsView
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextView textView;
    @NotNull
    private final FpsDebugFrameCallback frameCallback;
    @NotNull
    private final FPSMonitorRunnable fpsMonitorRunnable;
    private static final int UPDATE_INTERVAL_MS = 500;

    public FpsView(@Nullable ReactContext reactContext) {
        ReactContext reactContext2 = reactContext;
        Intrinsics.checkNotNull((Object)((Object)reactContext2));
        super((Context)reactContext2);
        FrameLayout.inflate((Context)((Context)reactContext), (int)R.layout.fps_view, (ViewGroup)((ViewGroup)this));
        View view = this.findViewById(R.id.fps_text);
        Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.TextView");
        this.textView = (TextView)view;
        this.frameCallback = new FpsDebugFrameCallback(reactContext);
        this.fpsMonitorRunnable = new FPSMonitorRunnable();
        this.setCurrentFPS(0.0, 0.0, 0, 0, this.frameCallback.isRunningOnFabric());
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.frameCallback.reset();
        FpsDebugFrameCallback.start$default(this.frameCallback, 0.0, 1, null);
        this.fpsMonitorRunnable.start();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.frameCallback.stop();
        this.fpsMonitorRunnable.stop();
    }

    private final void setCurrentFPS(double currentFPS, double currentJSFPS, int droppedUIFrames, int total4PlusFrameStutters, boolean runningOnFabric) {
        Locale locale = Locale.US;
        String string2 = "UI: %.1f fps\n%d dropped so far\n%d stutters (4+) so far";
        Object[] objectArray = new Object[]{currentFPS, droppedUIFrames, total4PlusFrameStutters};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        Object fpsString = string3;
        if (!runningOnFabric) {
            locale = Locale.US;
            string2 = "\nJS: %.1f fps";
            objectArray = new Object[]{currentJSFPS};
            String string4 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            fpsString = (String)fpsString + string4;
        }
        this.textView.setText((CharSequence)fpsString);
        FLog.d((String)"ReactNative", (String)fpsString);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/devsupport/FpsView$Companion;", "", "<init>", "()V", "UPDATE_INTERVAL_MS", "", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/react/devsupport/FpsView$FPSMonitorRunnable;", "Ljava/lang/Runnable;", "<init>", "(Lcom/facebook/react/devsupport/FpsView;)V", "shouldStop", "", "totalFramesDropped", "", "total4PlusFrameStutters", "run", "", "start", "stop", "ReactAndroid_debug"})
    private final class FPSMonitorRunnable
    implements Runnable {
        private boolean shouldStop;
        private int totalFramesDropped;
        private int total4PlusFrameStutters;

        @Override
        public void run() {
            if (this.shouldStop) {
                return;
            }
            this.totalFramesDropped += FpsView.this.frameCallback.getExpectedNumFrames() - FpsView.this.frameCallback.getNumFrames();
            this.total4PlusFrameStutters += FpsView.this.frameCallback.get4PlusFrameStutters();
            FpsView.this.setCurrentFPS(FpsView.this.frameCallback.getFps(), FpsView.this.frameCallback.getJsFPS(), this.totalFramesDropped, this.total4PlusFrameStutters, FpsView.this.frameCallback.isRunningOnFabric());
            FpsView.this.frameCallback.reset();
            FpsView.this.postDelayed(this, 500L);
        }

        public final void start() {
            this.shouldStop = false;
            FpsView.this.post(this);
        }

        public final void stop() {
            this.shouldStop = true;
        }
    }
}

