/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.common.DebugServerException;
import com.facebook.react.devsupport.MultipartStreamReader;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.-DeprecatedUpgrade;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0002 !B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J6\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J:\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002JB\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/facebook/react/devsupport/BundleDownloader;", "", "client", "Lokhttp3/OkHttpClient;", "<init>", "(Lokhttp3/OkHttpClient;)V", "downloadBundleFromURLCall", "Lokhttp3/Call;", "downloadBundleFromURL", "", "callback", "Lcom/facebook/react/devsupport/interfaces/DevBundleDownloadListener;", "outputFile", "Ljava/io/File;", "bundleURL", "", "bundleInfo", "Lcom/facebook/react/devsupport/BundleDownloader$BundleInfo;", "requestBuilder", "Lokhttp3/Request$Builder;", "processMultipartResponse", "url", "response", "Lokhttp3/Response;", "boundary", "processBundleResult", "statusCode", "", "headers", "Lokhttp3/Headers;", "body", "Lokio/BufferedSource;", "BundleInfo", "Companion", "ReactAndroid_debug"})
public final class BundleDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpClient client;
    @Nullable
    private Call downloadBundleFromURLCall;
    @NotNull
    private static final String TAG = "BundleDownloader";
    private static final int FILES_CHANGED_COUNT_NOT_BUILT_BY_BUNDLER = -2;

    public BundleDownloader(@NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
    }

    @JvmOverloads
    public final void downloadBundleFromURL(@NotNull DevBundleDownloadListener callback, @NotNull File outputFile, @Nullable String bundleURL, @Nullable BundleInfo bundleInfo, @NotNull Request.Builder requestBuilder) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)requestBuilder, (String)"requestBuilder");
        if (bundleURL == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        Request request = requestBuilder.url(bundleURL).addHeader("Accept", "multipart/mixed").build();
        Call call = this.downloadBundleFromURLCall = this.client.newCall(request);
        if (call == null) {
            String string3 = "Required value was null.";
            throw new IllegalStateException(string3.toString());
        }
        call.enqueue(new Callback(this, callback, outputFile, bundleInfo){
            final /* synthetic */ BundleDownloader this$0;
            final /* synthetic */ DevBundleDownloadListener $callback;
            final /* synthetic */ File $outputFile;
            final /* synthetic */ BundleInfo $bundleInfo;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
                this.$outputFile = $outputFile;
                this.$bundleInfo = $bundleInfo;
            }

            public void onFailure(Call call, IOException e) {
                block4: {
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (BundleDownloader.access$getDownloadBundleFromURLCall$p(this.this$0) == null) break block3;
                        Call call2 = BundleDownloader.access$getDownloadBundleFromURLCall$p(this.this$0);
                        boolean bl = call2 != null ? call2.isCanceled() : false;
                        if (!bl) break block4;
                    }
                    BundleDownloader.access$setDownloadBundleFromURLCall$p(this.this$0, null);
                    return;
                }
                BundleDownloader.access$setDownloadBundleFromURLCall$p(this.this$0, null);
                String url = call.request().-deprecated_url().toString();
                this.$callback.onFailure(DebugServerException.Companion.makeGeneric(url, "Could not connect to development server.", "URL: " + url, e));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Closeable closeable = (Closeable)response;
                BundleDownloader bundleDownloader = this.this$0;
                File file = this.$outputFile;
                BundleInfo bundleInfo = this.$bundleInfo;
                DevBundleDownloadListener devBundleDownloadListener = this.$callback;
                Throwable throwable = null;
                try {
                    Response resp;
                    block22: {
                        block21: {
                            resp = (Response)closeable;
                            boolean bl = false;
                            if (BundleDownloader.access$getDownloadBundleFromURLCall$p(bundleDownloader) == null) break block21;
                            Call call2 = BundleDownloader.access$getDownloadBundleFromURLCall$p(bundleDownloader);
                            boolean bl2 = call2 != null ? call2.isCanceled() : false;
                            if (!bl2) break block22;
                        }
                        BundleDownloader.access$setDownloadBundleFromURLCall$p(bundleDownloader, null);
                        return;
                    }
                    BundleDownloader.access$setDownloadBundleFromURLCall$p(bundleDownloader, null);
                    String url = resp.-deprecated_request().-deprecated_url().toString();
                    String contentType = Response.header$default((Response)resp, (String)"content-type", null, (int)2, null);
                    if (contentType == null) {
                        contentType = "";
                    }
                    Pattern regex = Pattern.compile("multipart/mixed;.*boundary=\"([^\"]+)\"");
                    Matcher match = regex.matcher(contentType);
                    if (((CharSequence)contentType).length() > 0 && match.find()) {
                        String boundary = (String)Assertions.assertNotNull((Object)match.group(1));
                        Intrinsics.checkNotNull((Object)boundary);
                        BundleDownloader.access$processMultipartResponse(bundleDownloader, url, resp, boundary, file, bundleInfo, devBundleDownloadListener);
                    } else {
                        Closeable closeable2 = (Closeable)resp.-deprecated_body();
                        Throwable throwable2 = null;
                        try {
                            ResponseBody body = (ResponseBody)closeable2;
                            boolean bl = false;
                            if (body != null) {
                                BundleDownloader.access$processBundleResult(bundleDownloader, url, resp.-deprecated_code(), resp.-deprecated_headers(), body.source(), file, bundleInfo, devBundleDownloadListener);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        });
    }

    public static /* synthetic */ void downloadBundleFromURL$default(BundleDownloader bundleDownloader, DevBundleDownloadListener devBundleDownloadListener, File file, String string2, BundleInfo bundleInfo, Request.Builder builder, int n, Object object) {
        if ((n & 0x10) != 0) {
            builder = new Request.Builder();
        }
        bundleDownloader.downloadBundleFromURL(devBundleDownloadListener, file, string2, bundleInfo, builder);
    }

    private final void processMultipartResponse(String url, Response response, String boundary, File outputFile, BundleInfo bundleInfo, DevBundleDownloadListener callback) throws IOException {
        if (response.-deprecated_body() == null) {
            callback.onFailure(new DebugServerException(StringsKt.trimIndent((String)("\n                    Error while reading multipart response.\n                    \n                    Response body was empty: " + response.-deprecated_code() + "\n                    \n                    URL: " + url + "\n                    \n                    \n                    "))));
            return;
        }
        ResponseBody responseBody2 = response.-deprecated_body();
        Object object = responseBody2 != null ? responseBody2.source() : null;
        if (object == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        BufferedSource source2 = object;
        MultipartStreamReader bodyReader = new MultipartStreamReader(source2, boundary);
        boolean completed2 = bodyReader.readAllParts(new MultipartStreamReader.ChunkListener(response, this, url, outputFile, bundleInfo, callback){
            final /* synthetic */ Response $response;
            final /* synthetic */ BundleDownloader this$0;
            final /* synthetic */ String $url;
            final /* synthetic */ File $outputFile;
            final /* synthetic */ BundleInfo $bundleInfo;
            final /* synthetic */ DevBundleDownloadListener $callback;
            {
                this.$response = $response;
                this.this$0 = $receiver;
                this.$url = $url;
                this.$outputFile = $outputFile;
                this.$bundleInfo = $bundleInfo;
                this.$callback = $callback;
            }

            public void onChunkComplete(Map<String, String> headers, Buffer body, boolean isLastChunk) throws IOException {
                Intrinsics.checkNotNullParameter(headers, (String)"headers");
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                if (isLastChunk) {
                    int status = this.$response.-deprecated_code();
                    if (headers.containsKey("X-Http-Status")) {
                        status = Integer.parseInt(headers.getOrDefault("X-Http-Status", "0"));
                    }
                    BundleDownloader.access$processBundleResult(this.this$0, this.$url, status, Headers.Companion.-deprecated_of(headers), (BufferedSource)body, this.$outputFile, this.$bundleInfo, this.$callback);
                } else {
                    if (!headers.containsKey("Content-Type") || !Intrinsics.areEqual((Object)headers.get("Content-Type"), (Object)"application/json")) {
                        return;
                    }
                    try {
                        JSONObject progress = new JSONObject(body.readUtf8());
                        String status = progress.has("status") ? progress.getString("status") : "Bundling";
                        Integer done = null;
                        if (progress.has("done")) {
                            done = progress.getInt("done");
                        }
                        Integer total = null;
                        if (progress.has("total")) {
                            total = progress.getInt("total");
                        }
                        this.$callback.onProgress(status, done, total);
                    }
                    catch (JSONException e) {
                        FLog.e((String)"ReactNative", (String)("Error parsing progress JSON. " + e));
                    }
                }
            }

            public void onChunkProgress(Map<String, String> headers, long loaded, long total) {
                Intrinsics.checkNotNullParameter(headers, (String)"headers");
                if (Intrinsics.areEqual((Object)"application/javascript", (Object)headers.get("Content-Type"))) {
                    this.$callback.onProgress("Downloading", (int)(loaded / (long)1024), (int)(total / (long)1024));
                }
            }
        });
        if (!completed2) {
            callback.onFailure(new DebugServerException(StringsKt.trimIndent((String)("\n                    Error while reading multipart response.\n                    \n                    Response code: " + response.-deprecated_code() + "\n                    \n                    URL: " + url + "\n                    \n                    \n                    "))));
        }
    }

    private final void processBundleResult(String url, int statusCode, Headers headers, BufferedSource body, File outputFile, BundleInfo bundleInfo, DevBundleDownloadListener callback) throws IOException {
        File tmpFile;
        if (statusCode != 200) {
            String bodyString = body.readUtf8();
            DebugServerException debugServerException = DebugServerException.Companion.parse(url, bodyString);
            if (debugServerException != null) {
                callback.onFailure(debugServerException);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("The development server returned response error code: ").append(statusCode).append("\n\n").append("URL: ").append(url).append("\n\n").append("Body:\n").append(bodyString);
                String string2 = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                callback.onFailure(new DebugServerException(string2));
            }
            return;
        }
        if (bundleInfo != null) {
            BundleDownloader.Companion.populateBundleInfo(url, headers, bundleInfo);
        }
        if (BundleDownloader.Companion.storePlainJSInFile(body, tmpFile = new File(outputFile.getPath() + ".tmp")) && !tmpFile.renameTo(outputFile)) {
            throw new IOException("Couldn't rename " + tmpFile + " to " + outputFile);
        }
        callback.onSuccess();
    }

    @JvmOverloads
    public final void downloadBundleFromURL(@NotNull DevBundleDownloadListener callback, @NotNull File outputFile, @Nullable String bundleURL, @Nullable BundleInfo bundleInfo) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        BundleDownloader.downloadBundleFromURL$default(this, callback, outputFile, bundleURL, bundleInfo, null, 16, null);
    }

    public static final /* synthetic */ Call access$getDownloadBundleFromURLCall$p(BundleDownloader $this) {
        return $this.downloadBundleFromURLCall;
    }

    public static final /* synthetic */ void access$setDownloadBundleFromURLCall$p(BundleDownloader $this, Call call) {
        $this.downloadBundleFromURLCall = call;
    }

    public static final /* synthetic */ void access$processBundleResult(BundleDownloader $this, String url, int statusCode, Headers headers, BufferedSource body, File outputFile, BundleInfo bundleInfo, DevBundleDownloadListener callback) {
        $this.processBundleResult(url, statusCode, headers, body, outputFile, bundleInfo, callback);
    }

    public static final /* synthetic */ void access$processMultipartResponse(BundleDownloader $this, String url, Response response, String boundary, File outputFile, BundleInfo bundleInfo, DevBundleDownloadListener callback) {
        $this.processMultipartResponse(url, response, boundary, outputFile, bundleInfo, callback);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/facebook/react/devsupport/BundleDownloader$BundleInfo;", "", "<init>", "()V", "_url", "", "get_url$ReactAndroid_debug", "()Ljava/lang/String;", "set_url$ReactAndroid_debug", "(Ljava/lang/String;)V", "url", "getUrl", "value", "", "filesChangedCount", "getFilesChangedCount", "()I", "setFilesChangedCount$ReactAndroid_debug", "(I)V", "toJSONString", "Companion", "ReactAndroid_debug"})
    public static final class BundleInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private String _url;
        private int filesChangedCount;

        @Nullable
        public final String get_url$ReactAndroid_debug() {
            return this._url;
        }

        public final void set_url$ReactAndroid_debug(@Nullable String string2) {
            this._url = string2;
        }

        @NotNull
        public final String getUrl() {
            String string2 = this._url;
            if (string2 == null) {
                string2 = "unknown";
            }
            return string2;
        }

        public final int getFilesChangedCount() {
            return this.filesChangedCount;
        }

        public final void setFilesChangedCount$ReactAndroid_debug(int n) {
            this.filesChangedCount = n;
        }

        @Nullable
        public final String toJSONString() {
            Object object;
            try {
                JSONObject $this$toJSONString_u24lambda_u240 = object = new JSONObject();
                boolean bl = false;
                $this$toJSONString_u24lambda_u240.put("url", (Object)this._url);
                $this$toJSONString_u24lambda_u240.put("filesChangedCount", this.filesChangedCount);
                object = object.toString();
            }
            catch (JSONException e) {
                FLog.e((String)BundleDownloader.TAG, (String)"Can't serialize bundle info: ", (Throwable)e);
                object = null;
            }
            return object;
        }

        @JvmStatic
        @Nullable
        public static final BundleInfo fromJSONString(@Nullable String jsonStr) {
            return Companion.fromJSONString(jsonStr);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/react/devsupport/BundleDownloader$BundleInfo$Companion;", "", "<init>", "()V", "fromJSONString", "Lcom/facebook/react/devsupport/BundleDownloader$BundleInfo;", "jsonStr", "", "ReactAndroid_debug"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @Nullable
            public final BundleInfo fromJSONString(@Nullable String jsonStr) {
                BundleInfo bundleInfo;
                if (jsonStr == null) {
                    return null;
                }
                try {
                    BundleInfo bundleInfo2;
                    JSONObject obj = new JSONObject(jsonStr);
                    BundleInfo $this$fromJSONString_u24lambda_u240 = bundleInfo2 = new BundleInfo();
                    boolean bl = false;
                    $this$fromJSONString_u24lambda_u240.set_url$ReactAndroid_debug(obj.getString("url"));
                    $this$fromJSONString_u24lambda_u240.setFilesChangedCount$ReactAndroid_debug(obj.getInt("filesChangedCount"));
                    bundleInfo = bundleInfo2;
                }
                catch (JSONException e) {
                    FLog.e((String)BundleDownloader.TAG, (String)"Invalid bundle info: ", (Throwable)e);
                    bundleInfo = null;
                }
                return bundleInfo;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/react/devsupport/BundleDownloader$Companion;", "", "<init>", "()V", "TAG", "", "FILES_CHANGED_COUNT_NOT_BUILT_BY_BUNDLER", "", "storePlainJSInFile", "", "body", "Lokio/BufferedSource;", "outputFile", "Ljava/io/File;", "populateBundleInfo", "", "url", "headers", "Lokhttp3/Headers;", "bundleInfo", "Lcom/facebook/react/devsupport/BundleDownloader$BundleInfo;", "ReactAndroid_debug"})
    @SourceDebugExtension(value={"SMAP\nBundleDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundleDownloader.kt\ncom/facebook/react/devsupport/BundleDownloader$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,324:1\n1#2:325\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean storePlainJSInFile(BufferedSource body, File outputFile) throws IOException {
            Closeable closeable = (Closeable)-DeprecatedUpgrade.getOkio().sink(outputFile);
            Throwable throwable = null;
            try {
                Sink it = (Sink)closeable;
                boolean bl = false;
                long l = body.readAll(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return true;
        }

        private final void populateBundleInfo(String url, Headers headers, BundleInfo bundleInfo) {
            bundleInfo.set_url$ReactAndroid_debug(url);
            String filesChangedCountStr = headers.get("X-Metro-Files-Changed-Count");
            if (filesChangedCountStr != null) {
                try {
                    bundleInfo.setFilesChangedCount$ReactAndroid_debug(Integer.parseInt(filesChangedCountStr));
                }
                catch (NumberFormatException e) {
                    bundleInfo.setFilesChangedCount$ReactAndroid_debug(-2);
                    FLog.e((String)BundleDownloader.TAG, (String)"Can't populate bundle info: ", (Throwable)e);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

