/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.common.build.ReactBuildConfig;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\b\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006\u00a2\u0006\u0002\u0010\rR\"\u0010\u0004\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/facebook/react/bridge/JavaScriptModuleRegistry;", "", "<init>", "()V", "moduleInstances", "", "Ljava/lang/Class;", "Lcom/facebook/react/bridge/JavaScriptModule;", "getJavaScriptModule", "T", "instance", "Lcom/facebook/react/bridge/CatalystInstance;", "moduleInterface", "(Lcom/facebook/react/bridge/CatalystInstance;Ljava/lang/Class;)Lcom/facebook/react/bridge/JavaScriptModule;", "JavaScriptModuleInvocationHandler", "Companion", "ReactAndroid_debug"})
public final class JavaScriptModuleRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Class<? extends JavaScriptModule>, JavaScriptModule> moduleInstances = new HashMap();

    @NotNull
    public final synchronized <T extends JavaScriptModule> T getJavaScriptModule(@NotNull CatalystInstance instance, @NotNull Class<T> moduleInterface) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter(moduleInterface, (String)"moduleInterface");
        JavaScriptModule module = this.moduleInstances.get(moduleInterface);
        if (module != null) {
            return (T)module;
        }
        Class[] classArray = new Class[]{moduleInterface};
        Object object = Proxy.newProxyInstance(moduleInterface.getClassLoader(), classArray, (InvocationHandler)new JavaScriptModuleInvocationHandler(instance, moduleInterface));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.facebook.react.bridge.JavaScriptModule");
        JavaScriptModule proxy = (JavaScriptModule)object;
        this.moduleInstances.put(moduleInterface, proxy);
        return (T)proxy;
    }

    @JvmStatic
    @NotNull
    public static final String getJSModuleName(@NotNull Class<? extends JavaScriptModule> jsModuleInterface) {
        return Companion.getJSModuleName(jsModuleInterface);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0007\u00a8\u0006\t"}, d2={"Lcom/facebook/react/bridge/JavaScriptModuleRegistry$Companion;", "", "<init>", "()V", "getJSModuleName", "", "jsModuleInterface", "Ljava/lang/Class;", "Lcom/facebook/react/bridge/JavaScriptModule;", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getJSModuleName(@NotNull Class<? extends JavaScriptModule> jsModuleInterface) {
            String name;
            Intrinsics.checkNotNullParameter(jsModuleInterface, (String)"jsModuleInterface");
            String string2 = name = jsModuleInterface.getSimpleName();
            Intrinsics.checkNotNull((Object)string2);
            int dollarSignIndex = StringsKt.lastIndexOf$default((CharSequence)string2, (char)'$', (int)0, (boolean)false, (int)6, null);
            if (dollarSignIndex != -1) {
                string2 = name;
                Intrinsics.checkNotNull((Object)string2);
                int n = dollarSignIndex + 1;
                String string3 = string2.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                name = string3;
            }
            string2 = name;
            Intrinsics.checkNotNull((Object)string2);
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\nH\u0002J2\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u0012H\u0096\u0002\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/react/bridge/JavaScriptModuleRegistry$JavaScriptModuleInvocationHandler;", "Ljava/lang/reflect/InvocationHandler;", "catalystInstance", "Lcom/facebook/react/bridge/CatalystInstance;", "moduleInterface", "Ljava/lang/Class;", "Lcom/facebook/react/bridge/JavaScriptModule;", "<init>", "(Lcom/facebook/react/bridge/CatalystInstance;Ljava/lang/Class;)V", "name", "", "getJSModuleName", "invoke", "", "proxy", "method", "Ljava/lang/reflect/Method;", "args", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "ReactAndroid_debug"})
    @SourceDebugExtension(value={"SMAP\nJavaScriptModuleRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaScriptModuleRegistry.kt\ncom/facebook/react/bridge/JavaScriptModuleRegistry$JavaScriptModuleInvocationHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
    private static final class JavaScriptModuleInvocationHandler
    implements InvocationHandler {
        @NotNull
        private final CatalystInstance catalystInstance;
        @NotNull
        private final Class<? extends JavaScriptModule> moduleInterface;
        @Nullable
        private String name;

        public JavaScriptModuleInvocationHandler(@NotNull CatalystInstance catalystInstance, @NotNull Class<? extends JavaScriptModule> moduleInterface) {
            Intrinsics.checkNotNullParameter((Object)catalystInstance, (String)"catalystInstance");
            Intrinsics.checkNotNullParameter(moduleInterface, (String)"moduleInterface");
            this.catalystInstance = catalystInstance;
            this.moduleInterface = moduleInterface;
            if (ReactBuildConfig.DEBUG) {
                Set methodNames = new LinkedHashSet();
                Iterator iterator2 = ArrayIteratorKt.iterator((Object[])this.moduleInterface.getDeclaredMethods());
                while (iterator2.hasNext()) {
                    Method method = (Method)iterator2.next();
                    String string2 = method.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    if (!methodNames.add(string2)) {
                        throw new AssertionError((Object)("Method overloading is unsupported: " + this.moduleInterface.getName() + "#" + method.getName()));
                    }
                }
            }
        }

        private final String getJSModuleName() {
            String string2 = this.name;
            if (string2 == null) {
                String string3;
                String it = string3 = Companion.getJSModuleName(this.moduleInterface);
                boolean bl = false;
                this.name = it;
                string2 = string3;
            }
            return string2;
        }

        @Override
        @Nullable
        public Object invoke(@NotNull Object proxy, @NotNull Method method, @Nullable Object[] args) {
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            WritableNativeArray writableNativeArray = args != null ? Arguments.fromJavaArgs(args) : new WritableNativeArray();
            Intrinsics.checkNotNull((Object)writableNativeArray);
            WritableNativeArray jsArgs = writableNativeArray;
            String string2 = this.getJSModuleName();
            String string3 = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            this.catalystInstance.callFunction(string2, string3, jsArgs);
            return null;
        }
    }
}

