/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.BaseJavaModule;
import com.facebook.react.bridge.JSInstance;
import com.facebook.react.bridge.JavaMethodWrapper;
import com.facebook.react.bridge.ModuleHolder;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 '2\u00020\u0001:\u0003%&'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0003J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\r0\tj\b\u0012\u0004\u0012\u00020\r`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u00198G\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8G\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006("}, d2={"Lcom/facebook/react/bridge/JavaModuleWrapper;", "", "jsInstance", "Lcom/facebook/react/bridge/JSInstance;", "moduleHolder", "Lcom/facebook/react/bridge/ModuleHolder;", "<init>", "(Lcom/facebook/react/bridge/JSInstance;Lcom/facebook/react/bridge/ModuleHolder;)V", "methods", "Ljava/util/ArrayList;", "Lcom/facebook/react/bridge/JavaModuleWrapper$NativeMethod;", "Lkotlin/collections/ArrayList;", "descs", "Lcom/facebook/react/bridge/JavaModuleWrapper$MethodDescriptor;", "module", "Lcom/facebook/react/bridge/BaseJavaModule;", "getModule", "()Lcom/facebook/react/bridge/BaseJavaModule;", "name", "", "getName", "()Ljava/lang/String;", "findMethods", "", "methodDescriptors", "", "getMethodDescriptors", "()Ljava/util/List;", "constants", "Lcom/facebook/react/bridge/NativeMap;", "getConstants", "()Lcom/facebook/react/bridge/NativeMap;", "invoke", "methodId", "", "parameters", "Lcom/facebook/react/bridge/ReadableNativeArray;", "NativeMethod", "MethodDescriptor", "Companion", "ReactAndroid_debug"})
@DoNotStrip
public final class JavaModuleWrapper {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final JSInstance jsInstance;
    @NotNull
    private final ModuleHolder moduleHolder;
    @NotNull
    private final ArrayList<NativeMethod> methods;
    @NotNull
    private final ArrayList<MethodDescriptor> descs;

    public JavaModuleWrapper(@NotNull JSInstance jsInstance, @NotNull ModuleHolder moduleHolder) {
        Intrinsics.checkNotNullParameter((Object)jsInstance, (String)"jsInstance");
        Intrinsics.checkNotNullParameter((Object)moduleHolder, (String)"moduleHolder");
        this.jsInstance = jsInstance;
        this.moduleHolder = moduleHolder;
        this.methods = new ArrayList();
        this.descs = new ArrayList();
    }

    @DoNotStrip
    @NotNull
    public final BaseJavaModule getModule() {
        NativeModule nativeModule = this.moduleHolder.getModule();
        Intrinsics.checkNotNull((Object)nativeModule, (String)"null cannot be cast to non-null type com.facebook.react.bridge.BaseJavaModule");
        return (BaseJavaModule)nativeModule;
    }

    @DoNotStrip
    @NotNull
    public final String getName() {
        return this.moduleHolder.getName();
    }

    @DoNotStrip
    private final void findMethods() {
        Systrace.beginSection(0L, "findMethods");
        Class<?> classForMethods = this.moduleHolder.getModule().getClass();
        Class<?> superClass = classForMethods.getSuperclass();
        if (superClass != null && TurboModule.class.isAssignableFrom(superClass)) {
            classForMethods = superClass;
        }
        Object[] targetMethods = classForMethods.getDeclaredMethods();
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])targetMethods);
        while (iterator2.hasNext()) {
            ReactMethod annotation;
            Method targetMethod = (Method)iterator2.next();
            if (targetMethod.getAnnotation(ReactMethod.class) == null) continue;
            boolean bl = false;
            String methodName = targetMethod.getName();
            MethodDescriptor md = new MethodDescriptor();
            Intrinsics.checkNotNull((Object)targetMethod);
            JavaMethodWrapper method = new JavaMethodWrapper(this, targetMethod, annotation.isBlockingSynchronousMethod());
            md.setName(methodName);
            md.setType(method.getType());
            if (Intrinsics.areEqual((Object)"sync", (Object)md.getType())) {
                md.setSignature(method.getSignature());
                md.setMethod(targetMethod);
            }
            this.methods.add(method);
            this.descs.add(md);
        }
        Systrace.endSection(0L);
    }

    @DoNotStrip
    @NotNull
    public final List<MethodDescriptor> getMethodDescriptors() {
        if (this.descs.isEmpty()) {
            this.findMethods();
        }
        return this.descs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    @NotNull
    public final NativeMap getConstants() {
        String moduleName = this.getName();
        SystraceMessage.beginSection(0L, "JavaModuleWrapper.getConstants").arg("moduleName", moduleName).flush();
        ReactMarker.logMarker(ReactMarkerConstants.GET_CONSTANTS_START, moduleName);
        BaseJavaModule baseJavaModule = this.getModule();
        Systrace.beginSection(0L, "module.getConstants");
        Map<String, Object> map = baseJavaModule.getConstants();
        Systrace.endSection(0L);
        Systrace.beginSection(0L, "create WritableNativeMap");
        ReactMarker.logMarker(ReactMarkerConstants.CONVERT_CONSTANTS_START, moduleName);
        try {
            WritableNativeMap writableNativeMap = Arguments.makeNativeMap(map);
            Intrinsics.checkNotNullExpressionValue((Object)writableNativeMap, (String)"makeNativeMap(...)");
            NativeMap nativeMap = writableNativeMap;
            return nativeMap;
        }
        finally {
            ReactMarker.logMarker(ReactMarkerConstants.CONVERT_CONSTANTS_END, moduleName);
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.GET_CONSTANTS_END, moduleName);
            SystraceMessage.endSection(0L).flush();
        }
    }

    @DoNotStrip
    public final void invoke(int methodId, @NotNull ReadableNativeArray parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        if (methodId >= this.methods.size()) {
            return;
        }
        this.methods.get(methodId).invoke(this.jsInstance, parameters);
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("JavaModuleWrapper", LegacyArchitectureLogLevel.WARNING);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/facebook/react/bridge/JavaModuleWrapper$Companion;", "", "<init>", "()V", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR \u0010\u0013\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/bridge/JavaModuleWrapper$MethodDescriptor;", "", "<init>", "()V", "method", "Ljava/lang/reflect/Method;", "getMethod", "()Ljava/lang/reflect/Method;", "setMethod", "(Ljava/lang/reflect/Method;)V", "signature", "", "getSignature", "()Ljava/lang/String;", "setSignature", "(Ljava/lang/String;)V", "name", "getName", "setName", "type", "getType", "setType", "ReactAndroid_debug"})
    @DoNotStrip
    public static final class MethodDescriptor {
        @DoNotStrip
        @Nullable
        private Method method;
        @DoNotStrip
        @Nullable
        private String signature;
        @DoNotStrip
        @Nullable
        private String name;
        @DoNotStrip
        @Nullable
        private String type;

        @Nullable
        public final Method getMethod() {
            return this.method;
        }

        public final void setMethod(@Nullable Method method) {
            this.method = method;
        }

        @Nullable
        public final String getSignature() {
            return this.signature;
        }

        public final void setSignature(@Nullable String string2) {
            this.signature = string2;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string2) {
            this.name = string2;
        }

        @Nullable
        public final String getType() {
            return this.type;
        }

        public final void setType(@Nullable String string2) {
            this.type = string2;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/bridge/JavaModuleWrapper$NativeMethod;", "", "invoke", "", "jsInstance", "Lcom/facebook/react/bridge/JSInstance;", "parameters", "Lcom/facebook/react/bridge/ReadableArray;", "type", "", "getType", "()Ljava/lang/String;", "ReactAndroid_debug"})
    public static interface NativeMethod {
        public void invoke(@NotNull JSInstance var1, @NotNull ReadableArray var2);

        @NotNull
        public String getType();
    }
}

