/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.debug.holder.PrinterHolder;
import com.facebook.debug.tags.ReactDebugOverlayTags;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.CallbackImpl;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.DynamicFromArray;
import com.facebook.react.bridge.JSInstance;
import com.facebook.react.bridge.JavaModuleWrapper;
import com.facebook.react.bridge.NativeArgumentsParseException;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.PromiseImpl;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UnexpectedNativeTypeException;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import com.facebook.systrace.SystraceMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 32\u00020\u0001:\u000223B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010!\u001a\u00020\"H\u0002J/\u0010%\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0010\u0010&\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010'J)\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\r2\u0010\u0010&\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rH\u0002\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020\u0011H\u0002J\u0018\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0011H\u0002J\u0018\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u000e\u0010 \u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010#\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0015\u00a8\u00064"}, d2={"Lcom/facebook/react/bridge/JavaMethodWrapper;", "Lcom/facebook/react/bridge/JavaModuleWrapper$NativeMethod;", "moduleWrapper", "Lcom/facebook/react/bridge/JavaModuleWrapper;", "method", "Ljava/lang/reflect/Method;", "isSync", "", "<init>", "(Lcom/facebook/react/bridge/JavaModuleWrapper;Ljava/lang/reflect/Method;Z)V", "getMethod", "()Ljava/lang/reflect/Method;", "parameterTypes", "", "Ljava/lang/Class;", "[Ljava/lang/Class;", "paramLength", "", "type", "", "getType", "()Ljava/lang/String;", "setType", "(Ljava/lang/String;)V", "argumentsProcessed", "argumentExtractors", "Lcom/facebook/react/bridge/JavaMethodWrapper$ArgumentExtractor;", "[Lcom/facebook/react/bridge/JavaMethodWrapper$ArgumentExtractor;", "internalSignature", "arguments", "", "[Ljava/lang/Object;", "jsArgumentsNeeded", "processArguments", "", "signature", "getSignature", "buildSignature", "paramTypes", "(Ljava/lang/reflect/Method;[Ljava/lang/Class;Z)Ljava/lang/String;", "buildArgumentExtractors", "([Ljava/lang/Class;)[Lcom/facebook/react/bridge/JavaMethodWrapper$ArgumentExtractor;", "calculateJSArgumentsNeeded", "getAffectedRange", "startIndex", "invoke", "jsInstance", "Lcom/facebook/react/bridge/JSInstance;", "parameters", "Lcom/facebook/react/bridge/ReadableArray;", "ArgumentExtractor", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nJavaMethodWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaMethodWrapper.kt\ncom/facebook/react/bridge/JavaMethodWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,400:1\n1#2:401\n*E\n"})
public final class JavaMethodWrapper
implements JavaModuleWrapper.NativeMethod {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JavaModuleWrapper moduleWrapper;
    @NotNull
    private final Method method;
    @NotNull
    private final Class<?>[] parameterTypes;
    private final int paramLength;
    @NotNull
    private String type;
    private boolean argumentsProcessed;
    @Nullable
    private ArgumentExtractor<?>[] argumentExtractors;
    @Nullable
    private String internalSignature;
    @Nullable
    private Object[] arguments;
    private int jsArgumentsNeeded;
    @NotNull
    private static final ArgumentExtractor<Boolean> ARGUMENT_EXTRACTOR_BOOLEAN;
    @NotNull
    private static final ArgumentExtractor<Double> ARGUMENT_EXTRACTOR_DOUBLE;
    @NotNull
    private static final ArgumentExtractor<Float> ARGUMENT_EXTRACTOR_FLOAT;
    @NotNull
    private static final ArgumentExtractor<Integer> ARGUMENT_EXTRACTOR_INTEGER;
    @NotNull
    private static final ArgumentExtractor<String> ARGUMENT_EXTRACTOR_STRING;
    @NotNull
    private static final ArgumentExtractor<ReadableArray> ARGUMENT_EXTRACTOR_ARRAY;
    @NotNull
    private static final ArgumentExtractor<Dynamic> ARGUMENT_EXTRACTOR_DYNAMIC;
    @NotNull
    private static final ArgumentExtractor<ReadableMap> ARGUMENT_EXTRACTOR_MAP;
    @NotNull
    private static final ArgumentExtractor<Callback> ARGUMENT_EXTRACTOR_CALLBACK;
    @NotNull
    private static final ArgumentExtractor<Promise> ARGUMENT_EXTRACTOR_PROMISE;
    private static final boolean DEBUG;

    public JavaMethodWrapper(@NotNull JavaModuleWrapper moduleWrapper, @NotNull Method method, boolean isSync) {
        Intrinsics.checkNotNullParameter((Object)moduleWrapper, (String)"moduleWrapper");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.moduleWrapper = moduleWrapper;
        this.method = method;
        this.type = "async";
        this.method.setAccessible(true);
        Class<?>[] classArray = this.method.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
        this.parameterTypes = classArray;
        this.paramLength = this.parameterTypes.length;
        if (isSync) {
            this.setType("sync");
        } else if (this.paramLength > 0 && Intrinsics.areEqual(this.parameterTypes[this.paramLength - 1], Promise.class)) {
            this.setType("promise");
        }
    }

    @NotNull
    public final Method getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    public void setType(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.type = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processArguments() {
        if (this.argumentsProcessed) {
            return;
        }
        SystraceMessage.beginSection(0L, "processArguments").arg("method", this.moduleWrapper.getName() + "." + this.method.getName()).flush();
        try {
            this.argumentsProcessed = true;
            this.argumentExtractors = this.buildArgumentExtractors(this.parameterTypes);
            this.internalSignature = this.buildSignature(this.method, this.parameterTypes, Intrinsics.areEqual((Object)this.getType(), (Object)"sync"));
            this.arguments = new Object[this.parameterTypes.length];
            this.jsArgumentsNeeded = this.calculateJSArgumentsNeeded();
        }
        finally {
            SystraceMessage.endSection(0L).flush();
        }
    }

    @Nullable
    public final String getSignature() {
        if (!this.argumentsProcessed) {
            this.processArguments();
        }
        String string2 = this.internalSignature;
        if (string2 == null) {
            String string3 = "Required value was null.";
            throw new IllegalStateException(string3.toString());
        }
        return string2;
    }

    private final String buildSignature(Method method, Class<?>[] paramTypes, boolean isSync) {
        StringBuilder stringBuilder;
        int n = paramTypes.length + 2;
        StringBuilder $this$buildSignature_u24lambda_u241 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        if (isSync) {
            Class<?> clazz = method.getReturnType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getReturnType(...)");
            $this$buildSignature_u24lambda_u241.append(JavaMethodWrapper.Companion.returnTypeToChar(clazz));
            v1 = $this$buildSignature_u24lambda_u241.append('.');
        } else {
            v1 = $this$buildSignature_u24lambda_u241.append("v.");
        }
        int n2 = paramTypes.length;
        for (int i = 0; i < n2; ++i) {
            Class<?> paramClass = paramTypes[i];
            if (Intrinsics.areEqual(paramClass, Promise.class) && !(i == paramTypes.length - 1)) {
                boolean bl2 = false;
                String string2 = "Promise must be used as last parameter only";
                throw new IllegalStateException(string2.toString());
            }
            $this$buildSignature_u24lambda_u241.append(JavaMethodWrapper.Companion.paramTypeToChar(paramClass));
        }
        return stringBuilder.toString();
    }

    private final ArgumentExtractor<?>[] buildArgumentExtractors(Class<?>[] paramTypes) {
        ArgumentExtractor<Boolean> extractor;
        Object[] argumentExtractors = new ArgumentExtractor[paramTypes.length];
        for (int i = 0; i < paramTypes.length; i += extractor.getJSArgumentsNeeded()) {
            ArgumentExtractor<Object> argumentExtractor;
            Class<?> argumentClass = paramTypes[i];
            Class<?> clazz = argumentClass;
            if (Intrinsics.areEqual(clazz, Boolean.class) || Intrinsics.areEqual(clazz, Boolean.TYPE)) {
                argumentExtractor = ARGUMENT_EXTRACTOR_BOOLEAN;
            } else if (Intrinsics.areEqual(clazz, Integer.class) || Intrinsics.areEqual(clazz, Integer.TYPE)) {
                argumentExtractor = ARGUMENT_EXTRACTOR_INTEGER;
            } else if (Intrinsics.areEqual(clazz, Double.class) || Intrinsics.areEqual(clazz, Double.TYPE)) {
                argumentExtractor = ARGUMENT_EXTRACTOR_DOUBLE;
            } else if (Intrinsics.areEqual(clazz, Float.class) || Intrinsics.areEqual(clazz, Float.TYPE)) {
                argumentExtractor = ARGUMENT_EXTRACTOR_FLOAT;
            } else if (Intrinsics.areEqual(clazz, String.class)) {
                argumentExtractor = ARGUMENT_EXTRACTOR_STRING;
            } else if (Intrinsics.areEqual(clazz, Callback.class)) {
                argumentExtractor = ARGUMENT_EXTRACTOR_CALLBACK;
            } else if (Intrinsics.areEqual(clazz, Promise.class)) {
                if (!(i == paramTypes.length - 1)) {
                    boolean bl = false;
                    String string2 = "Promise must be used as last parameter only";
                    throw new IllegalStateException(string2.toString());
                }
                argumentExtractor = ARGUMENT_EXTRACTOR_PROMISE;
            } else if (Intrinsics.areEqual(clazz, ReadableMap.class)) {
                argumentExtractor = ARGUMENT_EXTRACTOR_MAP;
            } else if (Intrinsics.areEqual(clazz, ReadableArray.class)) {
                argumentExtractor = ARGUMENT_EXTRACTOR_ARRAY;
            } else if (Intrinsics.areEqual(clazz, Dynamic.class)) {
                argumentExtractor = ARGUMENT_EXTRACTOR_DYNAMIC;
            } else {
                throw new RuntimeException("Got unknown argument class: " + argumentClass.getSimpleName());
            }
            argumentExtractors[i] = extractor = argumentExtractor;
        }
        return (ArgumentExtractor[])ArraysKt.requireNoNulls((Object[])argumentExtractors);
    }

    private final int calculateJSArgumentsNeeded() {
        int n = 0;
        if (this.argumentExtractors == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        for (ArgumentExtractor<?> extractor : this.argumentExtractors) {
            n += extractor.getJSArgumentsNeeded();
        }
        return n;
    }

    private final String getAffectedRange(int startIndex, int jsArgumentsNeeded) {
        return jsArgumentsNeeded > 1 ? startIndex + "-" + (startIndex + jsArgumentsNeeded - 1) : String.valueOf(startIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(@NotNull JSInstance jsInstance, @NotNull ReadableArray parameters) {
        Intrinsics.checkNotNullParameter((Object)jsInstance, (String)"jsInstance");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String traceName = this.moduleWrapper.getName() + "." + this.method.getName();
        SystraceMessage.beginSection(0L, "callJavaModuleMethod").arg("method", traceName).flush();
        if (DEBUG) {
            Object[] objectArray = new Object[]{this.moduleWrapper.getName(), this.method.getName()};
            PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.BRIDGE_CALLS, "JS->Java: %s.%s()", objectArray);
        }
        try {
            int i;
            if (!this.argumentsProcessed) {
                this.processArguments();
            }
            if (this.arguments == null) {
                boolean $i$a$-requireNotNull-JavaMethodWrapper$invoke$validatedArguments$22 = false;
                String $i$a$-requireNotNull-JavaMethodWrapper$invoke$validatedArguments$22 = "processArguments failed: 'arguments' is null.";
                throw new IllegalArgumentException($i$a$-requireNotNull-JavaMethodWrapper$invoke$validatedArguments$22.toString());
            }
            Object[] validatedArguments = this.arguments;
            if (this.argumentExtractors == null) {
                boolean $i$a$-requireNotNull-JavaMethodWrapper$invoke$validatedArgumentExtractors$22 = false;
                String $i$a$-requireNotNull-JavaMethodWrapper$invoke$validatedArgumentExtractors$22 = "processArguments failed: 'argumentExtractors' is null.";
                throw new IllegalArgumentException($i$a$-requireNotNull-JavaMethodWrapper$invoke$validatedArgumentExtractors$22.toString());
            }
            ArgumentExtractor<?>[] validatedArgumentExtractors = this.argumentExtractors;
            if (this.jsArgumentsNeeded != parameters.size()) {
                throw new NativeArgumentsParseException(traceName + " got " + parameters.size() + " arguments, expected " + this.jsArgumentsNeeded);
            }
            int jsArgumentsConsumed = 0;
            try {
                for (i = 0; i < validatedArgumentExtractors.length; ++i) {
                    validatedArguments[i] = validatedArgumentExtractors[i].extractArgument(jsInstance, parameters, jsArgumentsConsumed);
                    jsArgumentsConsumed += validatedArgumentExtractors[i].getJSArgumentsNeeded();
                }
            }
            catch (UnexpectedNativeTypeException e) {
                throw new NativeArgumentsParseException(e.getMessage() + " (constructing arguments for " + traceName + " at argument index " + this.getAffectedRange(jsArgumentsConsumed, validatedArgumentExtractors[i].getJSArgumentsNeeded()) + ")", e);
            }
            catch (NullPointerException e) {
                throw new NativeArgumentsParseException(e.getMessage() + " (constructing arguments for " + traceName + " at argument index " + this.getAffectedRange(jsArgumentsConsumed, validatedArgumentExtractors[i].getJSArgumentsNeeded()) + ")", e);
            }
            try {
                Object object = this.method.invoke((Object)this.moduleWrapper.getModule(), Arrays.copyOf(validatedArguments, validatedArguments.length));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(JavaMethodWrapper.Companion.createInvokeExceptionMessage(traceName), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(JavaMethodWrapper.Companion.createInvokeExceptionMessage(traceName), e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    Throwable throwable = e.getCause();
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.RuntimeException");
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException(JavaMethodWrapper.Companion.createInvokeExceptionMessage(traceName), e);
            }
        }
        finally {
            SystraceMessage.endSection(0L).flush();
        }
    }

    public static final /* synthetic */ ArgumentExtractor access$getARGUMENT_EXTRACTOR_CALLBACK$cp() {
        return ARGUMENT_EXTRACTOR_CALLBACK;
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("JavaMethodWrapper", LegacyArchitectureLogLevel.ERROR);
        ARGUMENT_EXTRACTOR_BOOLEAN = new ArgumentExtractor<Boolean>(){

            public Boolean extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                Intrinsics.checkNotNullParameter((Object)jsInstance, (String)"jsInstance");
                Intrinsics.checkNotNullParameter((Object)jsArguments, (String)"jsArguments");
                return jsArguments.getBoolean(atIndex);
            }
        };
        ARGUMENT_EXTRACTOR_DOUBLE = new ArgumentExtractor<Double>(){

            public Double extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                Intrinsics.checkNotNullParameter((Object)jsInstance, (String)"jsInstance");
                Intrinsics.checkNotNullParameter((Object)jsArguments, (String)"jsArguments");
                return jsArguments.getDouble(atIndex);
            }
        };
        ARGUMENT_EXTRACTOR_FLOAT = new ArgumentExtractor<Float>(){

            public Float extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                Intrinsics.checkNotNullParameter((Object)jsInstance, (String)"jsInstance");
                Intrinsics.checkNotNullParameter((Object)jsArguments, (String)"jsArguments");
                return Float.valueOf((float)jsArguments.getDouble(atIndex));
            }
        };
        ARGUMENT_EXTRACTOR_INTEGER = new ArgumentExtractor<Integer>(){

            public Integer extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                Intrinsics.checkNotNullParameter((Object)jsInstance, (String)"jsInstance");
                Intrinsics.checkNotNullParameter((Object)jsArguments, (String)"jsArguments");
                return (int)jsArguments.getDouble(atIndex);
            }
        };
        ARGUMENT_EXTRACTOR_STRING = new ArgumentExtractor<String>(){

            public String extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                Intrinsics.checkNotNullParameter((Object)jsInstance, (String)"jsInstance");
                Intrinsics.checkNotNullParameter((Object)jsArguments, (String)"jsArguments");
                return jsArguments.getString(atIndex);
            }
        };
        ARGUMENT_EXTRACTOR_ARRAY = new ArgumentExtractor<ReadableArray>(){

            public ReadableArray extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                Intrinsics.checkNotNullParameter((Object)jsInstance, (String)"jsInstance");
                Intrinsics.checkNotNullParameter((Object)jsArguments, (String)"jsArguments");
                return jsArguments.getArray(atIndex);
            }
        };
        ARGUMENT_EXTRACTOR_DYNAMIC = new ArgumentExtractor<Dynamic>(){

            public Dynamic extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                Intrinsics.checkNotNullParameter((Object)jsInstance, (String)"jsInstance");
                Intrinsics.checkNotNullParameter((Object)jsArguments, (String)"jsArguments");
                return DynamicFromArray.Companion.create(jsArguments, atIndex);
            }
        };
        ARGUMENT_EXTRACTOR_MAP = new ArgumentExtractor<ReadableMap>(){

            public ReadableMap extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                Intrinsics.checkNotNullParameter((Object)jsInstance, (String)"jsInstance");
                Intrinsics.checkNotNullParameter((Object)jsArguments, (String)"jsArguments");
                return jsArguments.getMap(atIndex);
            }
        };
        ARGUMENT_EXTRACTOR_CALLBACK = new ArgumentExtractor<Callback>(){

            public Callback extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                Callback callback;
                Intrinsics.checkNotNullParameter((Object)jsInstance, (String)"jsInstance");
                Intrinsics.checkNotNullParameter((Object)jsArguments, (String)"jsArguments");
                if (jsArguments.isNull(atIndex)) {
                    callback = null;
                } else {
                    int id2 = (int)jsArguments.getDouble(atIndex);
                    callback = new CallbackImpl(jsInstance, id2);
                }
                return callback;
            }
        };
        ARGUMENT_EXTRACTOR_PROMISE = new ArgumentExtractor<Promise>(){

            public int getJSArgumentsNeeded() {
                return 2;
            }

            public Promise extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                Intrinsics.checkNotNullParameter((Object)jsInstance, (String)"jsInstance");
                Intrinsics.checkNotNullParameter((Object)jsArguments, (String)"jsArguments");
                Callback resolve = (Callback)JavaMethodWrapper.access$getARGUMENT_EXTRACTOR_CALLBACK$cp().extractArgument(jsInstance, jsArguments, atIndex);
                Callback reject = (Callback)JavaMethodWrapper.access$getARGUMENT_EXTRACTOR_CALLBACK$cp().extractArgument(jsInstance, jsArguments, atIndex + 1);
                return new PromiseImpl(resolve, reject);
            }
        };
        DEBUG = PrinterHolder.getPrinter().shouldDisplayLogMessage(ReactDebugOverlayTags.BRIDGE_CALLS);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J'\u0010\u0007\u001a\u0004\u0018\u00018\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H&\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/bridge/JavaMethodWrapper$ArgumentExtractor;", "T", "", "<init>", "()V", "getJSArgumentsNeeded", "", "extractArgument", "jsInstance", "Lcom/facebook/react/bridge/JSInstance;", "jsArguments", "Lcom/facebook/react/bridge/ReadableArray;", "atIndex", "(Lcom/facebook/react/bridge/JSInstance;Lcom/facebook/react/bridge/ReadableArray;I)Ljava/lang/Object;", "ReactAndroid_debug"})
    private static abstract class ArgumentExtractor<T> {
        public int getJSArgumentsNeeded() {
            return 1;
        }

        @Nullable
        public abstract T extractArgument(@NotNull JSInstance var1, @NotNull ReadableArray var2, int var3);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u0014\u0010\u001e\u001a\u00020\u001b2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u0014\u0010 \u001a\u00020\u001b2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000eH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/facebook/react/bridge/JavaMethodWrapper$Companion;", "", "<init>", "()V", "ARGUMENT_EXTRACTOR_BOOLEAN", "Lcom/facebook/react/bridge/JavaMethodWrapper$ArgumentExtractor;", "", "ARGUMENT_EXTRACTOR_DOUBLE", "", "ARGUMENT_EXTRACTOR_FLOAT", "", "ARGUMENT_EXTRACTOR_INTEGER", "", "ARGUMENT_EXTRACTOR_STRING", "", "ARGUMENT_EXTRACTOR_ARRAY", "Lcom/facebook/react/bridge/ReadableArray;", "ARGUMENT_EXTRACTOR_DYNAMIC", "Lcom/facebook/react/bridge/Dynamic;", "ARGUMENT_EXTRACTOR_MAP", "Lcom/facebook/react/bridge/ReadableMap;", "ARGUMENT_EXTRACTOR_CALLBACK", "Lcom/facebook/react/bridge/Callback;", "ARGUMENT_EXTRACTOR_PROMISE", "Lcom/facebook/react/bridge/Promise;", "DEBUG", "paramTypeToChar", "", "paramClass", "Ljava/lang/Class;", "returnTypeToChar", "returnClass", "commonTypeToChar", "typeClass", "createInvokeExceptionMessage", "traceName", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        private final char paramTypeToChar(Class<?> paramClass) {
            int n;
            char tryCommon = this.commonTypeToChar(paramClass);
            if (tryCommon != '\u0000') {
                return tryCommon;
            }
            Class<?> clazz = paramClass;
            if (Intrinsics.areEqual(clazz, Callback.class)) {
                n = 88;
            } else if (Intrinsics.areEqual(clazz, Promise.class)) {
                n = 80;
            } else if (Intrinsics.areEqual(clazz, ReadableMap.class)) {
                n = 77;
            } else if (Intrinsics.areEqual(clazz, ReadableArray.class)) {
                n = 65;
            } else if (Intrinsics.areEqual(clazz, Dynamic.class)) {
                n = 89;
            } else {
                throw new RuntimeException("Got unknown param class: " + paramClass.getSimpleName());
            }
            return (char)n;
        }

        private final char returnTypeToChar(Class<?> returnClass) {
            int n;
            char tryCommon = this.commonTypeToChar(returnClass);
            if (tryCommon != '\u0000') {
                return tryCommon;
            }
            Class<?> clazz = returnClass;
            if (Intrinsics.areEqual(clazz, Void.TYPE)) {
                n = 118;
            } else if (Intrinsics.areEqual(clazz, WritableMap.class)) {
                n = 77;
            } else if (Intrinsics.areEqual(clazz, WritableArray.class)) {
                n = 65;
            } else {
                throw new RuntimeException("Got unknown return class: " + returnClass.getSimpleName());
            }
            return (char)n;
        }

        private final char commonTypeToChar(Class<?> typeClass) {
            Class<?> clazz = typeClass;
            return (char)(Intrinsics.areEqual(clazz, Boolean.TYPE) ? 122 : (Intrinsics.areEqual(clazz, Boolean.class) ? 90 : (Intrinsics.areEqual(clazz, Integer.TYPE) ? 105 : (Intrinsics.areEqual(clazz, Integer.class) ? 73 : (Intrinsics.areEqual(clazz, Double.TYPE) ? 100 : (Intrinsics.areEqual(clazz, Double.class) ? 68 : (Intrinsics.areEqual(clazz, Float.TYPE) ? 102 : (Intrinsics.areEqual(clazz, Float.class) ? 70 : (Intrinsics.areEqual(clazz, String.class) ? 83 : 0)))))))));
        }

        private final String createInvokeExceptionMessage(String traceName) {
            return "Could not invoke " + traceName;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

