/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableArrayBuilder;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapBuilder;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nH\u0007\u00a8\u0006\u0011"}, d2={"Lcom/facebook/react/bridge/JSONArguments;", "", "<init>", "()V", "fromJSONObject", "Lcom/facebook/react/bridge/ReadableMap;", "obj", "Lorg/json/JSONObject;", "fromJSONObjectString", "objStr", "", "fromJSONArray", "Lcom/facebook/react/bridge/ReadableArray;", "arr", "Lorg/json/JSONArray;", "fromJSONArrayString", "arrStr", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nJSONArguments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONArguments.kt\ncom/facebook/react/bridge/JSONArguments\n+ 2 ReadableMapBuilder.kt\ncom/facebook/react/bridge/ReadableMapBuilderKt\n+ 3 ReadableArrayBuilder.kt\ncom/facebook/react/bridge/ReadableArrayBuilderKt\n*L\n1#1,116:1\n30#2,3:117\n24#3,3:120\n*S KotlinDebug\n*F\n+ 1 JSONArguments.kt\ncom/facebook/react/bridge/JSONArguments\n*L\n36#1:117,3\n81#1:120,3\n*E\n"})
public final class JSONArguments {
    @NotNull
    public static final JSONArguments INSTANCE = new JSONArguments();

    private JSONArguments() {
    }

    @JvmStatic
    @NotNull
    public static final ReadableMap fromJSONObject(@NotNull JSONObject obj) throws JSONException {
        ReadableMapBuilder readableMapBuilder;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Iterator keys = obj.keys();
        boolean $i$f$buildReadableMap = false;
        WritableMap writableMap = Arguments.createMap();
        Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
        WritableMap map$iv = writableMap;
        ReadableMapBuilder $this$fromJSONObject_u24lambda_u240 = readableMapBuilder = new ReadableMapBuilder(map$iv);
        boolean bl = false;
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = obj.get(key);
            if (value instanceof JSONObject) {
                Intrinsics.checkNotNull((Object)key);
                $this$fromJSONObject_u24lambda_u240.put(key, JSONArguments.fromJSONObject((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                Intrinsics.checkNotNull((Object)key);
                $this$fromJSONObject_u24lambda_u240.put(key, JSONArguments.fromJSONArray((JSONArray)value));
                continue;
            }
            if (value instanceof String) {
                Intrinsics.checkNotNull((Object)key);
                $this$fromJSONObject_u24lambda_u240.put(key, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                Intrinsics.checkNotNull((Object)key);
                $this$fromJSONObject_u24lambda_u240.put(key, (Boolean)value);
                continue;
            }
            if (value instanceof Integer) {
                Intrinsics.checkNotNull((Object)key);
                $this$fromJSONObject_u24lambda_u240.put(key, ((Number)value).intValue());
                continue;
            }
            if (value instanceof Double) {
                Intrinsics.checkNotNull((Object)key);
                $this$fromJSONObject_u24lambda_u240.put(key, ((Number)value).doubleValue());
                continue;
            }
            if (value instanceof Long) {
                Intrinsics.checkNotNull((Object)key);
                $this$fromJSONObject_u24lambda_u240.put(key, (int)((Number)value).longValue());
                continue;
            }
            if (obj.isNull(key)) {
                Intrinsics.checkNotNull((Object)key);
                $this$fromJSONObject_u24lambda_u240.putNull(key);
                continue;
            }
            throw new JSONException("Unexpected value when parsing JSON object. key: " + key);
        }
        ReadableMap result = map$iv;
        return result;
    }

    @JvmStatic
    @NotNull
    public static final ReadableMap fromJSONObjectString(@NotNull String objStr) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)objStr, (String)"objStr");
        return JSONArguments.fromJSONObject(new JSONObject(objStr));
    }

    @JvmStatic
    @NotNull
    public static final ReadableArray fromJSONArray(@NotNull JSONArray arr) throws JSONException {
        ReadableArrayBuilder readableArrayBuilder;
        Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
        boolean $i$f$buildReadableArray = false;
        WritableArray writableArray = Arguments.createArray();
        Intrinsics.checkNotNullExpressionValue((Object)writableArray, (String)"createArray(...)");
        WritableArray array$iv = writableArray;
        ReadableArrayBuilder $this$fromJSONArray_u24lambda_u242 = readableArrayBuilder = new ReadableArrayBuilder(array$iv);
        boolean bl = false;
        int n = arr.length();
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl2 = false;
            Object value = arr.get(it);
            if (value instanceof JSONObject) {
                $this$fromJSONArray_u24lambda_u242.add(JSONArguments.fromJSONObject((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                $this$fromJSONArray_u24lambda_u242.add(JSONArguments.fromJSONArray((JSONArray)value));
                continue;
            }
            if (value instanceof String) {
                $this$fromJSONArray_u24lambda_u242.add((String)value);
                continue;
            }
            if (value instanceof Boolean) {
                $this$fromJSONArray_u24lambda_u242.add((Boolean)value);
                continue;
            }
            if (value instanceof Integer) {
                $this$fromJSONArray_u24lambda_u242.add(((Number)value).intValue());
                continue;
            }
            if (value instanceof Double) {
                $this$fromJSONArray_u24lambda_u242.add(((Number)value).doubleValue());
                continue;
            }
            if (value instanceof Long) {
                $this$fromJSONArray_u24lambda_u242.add((int)((Number)value).longValue());
                continue;
            }
            if (arr.isNull(it)) {
                $this$fromJSONArray_u24lambda_u242.addNull();
                continue;
            }
            throw new JSONException("Unexpected value when parsing JSON array. index: " + it);
        }
        ReadableArray result = array$iv;
        return result;
    }

    @JvmStatic
    @NotNull
    public static final ReadableArray fromJSONArrayString(@NotNull String arrStr) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)arrStr, (String)"arrStr");
        return JSONArguments.fromJSONArray(new JSONArray(arrStr));
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("JSONArguments", LegacyArchitectureLogLevel.ERROR);
    }
}

