/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.ColorSpace;
import android.os.Build;
import android.util.TypedValue;
import androidx.core.content.res.ResourcesCompat;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.JSApplicationCausedNativeException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J!\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J!\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u00a2\u0006\u0002\u0010\u0013J\"\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u000fH\u0007J!\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u0007H\u0007\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0007H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/facebook/react/bridge/ColorPropConverter;", "", "<init>", "()V", "supportWideGamut", "", "JSON_KEY", "", "PREFIX_RESOURCE", "PREFIX_ATTR", "PACKAGE_DELIMITER", "PATH_DELIMITER", "ATTR", "ATTR_SEGMENT", "getColorInteger", "", "value", "context", "Landroid/content/Context;", "(Ljava/lang/Object;Landroid/content/Context;)Ljava/lang/Integer;", "getColorInstance", "Landroid/graphics/Color;", "getColor", "defaultInt", "resolveResourcePath", "resourcePath", "(Landroid/content/Context;Ljava/lang/String;)Ljava/lang/Integer;", "resolveResource", "resolveThemeAttribute", "ReactAndroid_debug"})
public final class ColorPropConverter {
    @NotNull
    public static final ColorPropConverter INSTANCE = new ColorPropConverter();
    @NotNull
    private static final String JSON_KEY = "resource_paths";
    @NotNull
    private static final String PREFIX_RESOURCE = "@";
    @NotNull
    private static final String PREFIX_ATTR = "?";
    @NotNull
    private static final String PACKAGE_DELIMITER = ":";
    @NotNull
    private static final String PATH_DELIMITER = "/";
    @NotNull
    private static final String ATTR = "attr";
    @NotNull
    private static final String ATTR_SEGMENT = "attr/";

    private ColorPropConverter() {
    }

    private final boolean supportWideGamut() {
        return Build.VERSION.SDK_INT >= 26;
    }

    private final Integer getColorInteger(Object value, Context context) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (int)((Number)value).doubleValue();
        }
        if (context == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        if (value instanceof ReadableMap) {
            if (((ReadableMap)value).hasKey("space")) {
                int r = (int)((float)((ReadableMap)value).getDouble("r") * (float)255);
                int g = (int)((float)((ReadableMap)value).getDouble("g") * (float)255);
                int b = (int)((float)((ReadableMap)value).getDouble("b") * (float)255);
                int a = (int)((float)((ReadableMap)value).getDouble("a") * (float)255);
                return Color.argb((int)a, (int)r, (int)g, (int)b);
            }
            ReadableArray readableArray = ((ReadableMap)value).getArray(JSON_KEY);
            if (readableArray == null) {
                throw new JSApplicationCausedNativeException("ColorValue: The `resource_paths` must be an array of color resource path strings.");
            }
            ReadableArray resourcePaths = readableArray;
            int n = resourcePaths.size();
            for (int i = 0; i < n; ++i) {
                Integer result = ColorPropConverter.resolveResourcePath(context, resourcePaths.getString(i));
                if (result == null) continue;
                return result;
            }
            throw new JSApplicationCausedNativeException("ColorValue: None of the paths in the `resource_paths` array resolved to a color resource.");
        }
        throw new JSApplicationCausedNativeException("ColorValue: the value must be a number or Object.");
    }

    @JvmStatic
    @Nullable
    public static final Color getColorInstance(@Nullable Object value, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (value == null) {
            return null;
        }
        if (INSTANCE.supportWideGamut() && value instanceof Double) {
            return Color.valueOf((int)((int)((Number)value).doubleValue()));
        }
        if (value instanceof ReadableMap) {
            if (INSTANCE.supportWideGamut() && ((ReadableMap)value).hasKey("space")) {
                String rawColorSpace = ((ReadableMap)value).getString("space");
                boolean isDisplayP3 = Intrinsics.areEqual((Object)rawColorSpace, (Object)"display-p3");
                ColorSpace colorSpace = ColorSpace.get((ColorSpace.Named)(isDisplayP3 ? ColorSpace.Named.DISPLAY_P3 : ColorSpace.Named.SRGB));
                Intrinsics.checkNotNullExpressionValue((Object)colorSpace, (String)"get(...)");
                ColorSpace space = colorSpace;
                float r = (float)((ReadableMap)value).getDouble("r");
                float g = (float)((ReadableMap)value).getDouble("g");
                float b = (float)((ReadableMap)value).getDouble("b");
                float a = (float)((ReadableMap)value).getDouble("a");
                long color = Color.pack((float)r, (float)g, (float)b, (float)a, (ColorSpace)space);
                return Color.valueOf((long)color);
            }
            ReadableArray readableArray = ((ReadableMap)value).getArray(JSON_KEY);
            if (readableArray == null) {
                throw new JSApplicationCausedNativeException("ColorValue: The `resource_paths` must be an array of color resource path strings.");
            }
            ReadableArray resourcePaths = readableArray;
            int n = resourcePaths.size();
            for (int i = 0; i < n; ++i) {
                Integer result = ColorPropConverter.resolveResourcePath(context, resourcePaths.getString(i));
                if (!INSTANCE.supportWideGamut() || result == null) continue;
                return Color.valueOf((int)result);
            }
            throw new JSApplicationCausedNativeException("ColorValue: None of the paths in the `resource_paths` array resolved to a color resource.");
        }
        throw new JSApplicationCausedNativeException("ColorValue: the value must be a number or Object.");
    }

    @JvmStatic
    @Nullable
    public static final Integer getColor(@Nullable Object value, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            if (INSTANCE.supportWideGamut()) {
                Color color = ColorPropConverter.getColorInstance(value, context);
                if (color != null) {
                    return color.toArgb();
                }
            }
        }
        catch (JSApplicationCausedNativeException ex) {
            FLog.w((String)"ReactNative", (Throwable)ex, (String)"Error extracting color from WideGamut", (Object[])new Object[0]);
        }
        return INSTANCE.getColorInteger(value, context);
    }

    @JvmStatic
    public static final int getColor(@Nullable Object value, @NotNull Context context, int defaultInt) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            Integer n2 = ColorPropConverter.getColor(value, context);
            n = n2 != null ? n2 : defaultInt;
        }
        catch (JSApplicationCausedNativeException e) {
            FLog.w((String)"ReactNative", (Throwable)e, (String)"Error converting ColorValue", (Object[])new Object[0]);
            n = defaultInt;
        }
        return n;
    }

    @JvmStatic
    @Nullable
    public static final Integer resolveResourcePath(@NotNull Context context, @Nullable String resourcePath) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = resourcePath;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        boolean isResource = StringsKt.startsWith$default((String)resourcePath, (String)PREFIX_RESOURCE, (boolean)false, (int)2, null);
        boolean isThemeAttribute = StringsKt.startsWith$default((String)resourcePath, (String)PREFIX_ATTR, (boolean)false, (int)2, null);
        String string2 = resourcePath.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String path = string2;
        try {
            n = isResource ? Integer.valueOf(INSTANCE.resolveResource(context, path)) : (isThemeAttribute ? Integer.valueOf(INSTANCE.resolveThemeAttribute(context, path)) : null);
        }
        catch (Resources.NotFoundException e) {
            n = null;
        }
        return n;
    }

    private final int resolveResource(Context context, String resourcePath) {
        String[] stringArray = new String[]{PACKAGE_DELIMITER};
        List pathTokens = StringsKt.split$default((CharSequence)resourcePath, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String packageName = context.getPackageName();
        String resource = resourcePath;
        if (pathTokens.size() > 1) {
            packageName = (String)pathTokens.get(0);
            resource = (String)pathTokens.get(1);
        }
        String[] stringArray2 = new String[]{PATH_DELIMITER};
        List resourceTokens = StringsKt.split$default((CharSequence)resource, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        String resourceType = (String)resourceTokens.get(0);
        String resourceName = (String)resourceTokens.get(1);
        int resourceId = context.getResources().getIdentifier(resourceName, resourceType, packageName);
        return ResourcesCompat.getColor((Resources)context.getResources(), (int)resourceId, (Resources.Theme)context.getTheme());
    }

    private final int resolveThemeAttribute(Context context, String resourcePath) {
        int resourceId;
        String path = StringsKt.replace$default((String)resourcePath, (String)ATTR_SEGMENT, (String)"", (boolean)false, (int)4, null);
        String[] stringArray = new String[]{PACKAGE_DELIMITER};
        List pathTokens = StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String packageName = context.getPackageName();
        String resourceName = path;
        if (pathTokens.size() > 1) {
            packageName = (String)pathTokens.get(0);
            resourceName = (String)pathTokens.get(1);
        }
        if ((resourceId = context.getResources().getIdentifier(resourceName, ATTR, packageName)) == 0) {
            resourceId = context.getResources().getIdentifier(resourceName, ATTR, "android");
        }
        TypedValue outValue = new TypedValue();
        Resources.Theme theme = context.getTheme();
        if (theme.resolveAttribute(resourceId, outValue, true)) {
            return outValue.data;
        }
        throw new Resources.NotFoundException();
    }
}

