/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.JSInstance;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\n\u001a\u00020\u000b2\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e0\r\"\u0004\u0018\u00010\u000eH\u0096\u0002\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/react/bridge/CallbackImpl;", "Lcom/facebook/react/bridge/Callback;", "jsInstance", "Lcom/facebook/react/bridge/JSInstance;", "callbackId", "", "<init>", "(Lcom/facebook/react/bridge/JSInstance;I)V", "invoked", "", "invoke", "", "args", "", "", "([Ljava/lang/Object;)V", "Companion", "ReactAndroid_debug"})
public final class CallbackImpl
implements Callback {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final JSInstance jsInstance;
    private final int callbackId;
    private boolean invoked;

    public CallbackImpl(@NotNull JSInstance jsInstance, int callbackId) {
        Intrinsics.checkNotNullParameter((Object)jsInstance, (String)"jsInstance");
        this.jsInstance = jsInstance;
        this.callbackId = callbackId;
    }

    @Override
    public void invoke(Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (this.invoked) {
            throw new RuntimeException("Illegal callback invocation from native module. This callback type only permits a single invocation from native code.");
        }
        WritableNativeArray writableNativeArray = Arguments.fromJavaArgs(args);
        Intrinsics.checkNotNullExpressionValue((Object)writableNativeArray, (String)"fromJavaArgs(...)");
        this.jsInstance.invokeCallback(this.callbackId, writableNativeArray);
        this.invoked = true;
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("CallbackImpl", LegacyArchitectureLogLevel.ERROR);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/facebook/react/bridge/CallbackImpl$Companion;", "", "<init>", "()V", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

