/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.view.KeyEvent;
import android.view.View;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\tJ$\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/ReactAndroidHWInputDeviceHelper;", "", "reactRootView", "Lcom/facebook/react/ReactRootView;", "<init>", "(Lcom/facebook/react/ReactRootView;)V", "lastFocusedViewId", "", "handleKeyEvent", "", "ev", "Landroid/view/KeyEvent;", "onFocusChanged", "newFocusedView", "Landroid/view/View;", "clearFocus", "dispatchEvent", "eventType", "", "targetViewId", "eventKeyAction", "Companion", "ReactAndroid_debug"})
public final class ReactAndroidHWInputDeviceHelper {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactRootView reactRootView;
    private int lastFocusedViewId;
    @NotNull
    private static final Map<Integer, String> KEY_EVENTS_ACTIONS;

    public ReactAndroidHWInputDeviceHelper(@NotNull ReactRootView reactRootView) {
        Intrinsics.checkNotNullParameter((Object)reactRootView, (String)"reactRootView");
        this.reactRootView = reactRootView;
        this.lastFocusedViewId = -1;
    }

    public final void handleKeyEvent(@NotNull KeyEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        int eventKeyCode = ev.getKeyCode();
        int eventKeyAction = ev.getAction();
        if ((eventKeyAction == 1 || eventKeyAction == 0) && KEY_EVENTS_ACTIONS.containsKey(eventKeyCode)) {
            this.dispatchEvent(KEY_EVENTS_ACTIONS.get(eventKeyCode), this.lastFocusedViewId, eventKeyAction);
        }
    }

    public final void onFocusChanged(@NotNull View newFocusedView) {
        Intrinsics.checkNotNullParameter((Object)newFocusedView, (String)"newFocusedView");
        if (this.lastFocusedViewId == newFocusedView.getId()) {
            return;
        }
        if (this.lastFocusedViewId != -1) {
            ReactAndroidHWInputDeviceHelper.dispatchEvent$default(this, "blur", this.lastFocusedViewId, 0, 4, null);
        }
        this.lastFocusedViewId = newFocusedView.getId();
        ReactAndroidHWInputDeviceHelper.dispatchEvent$default(this, "focus", newFocusedView.getId(), 0, 4, null);
    }

    public final void clearFocus() {
        if (this.lastFocusedViewId != -1) {
            ReactAndroidHWInputDeviceHelper.dispatchEvent$default(this, "blur", this.lastFocusedViewId, 0, 4, null);
        }
        this.lastFocusedViewId = -1;
    }

    private final void dispatchEvent(String eventType, int targetViewId, int eventKeyAction) {
        WritableNativeMap writableNativeMap;
        WritableNativeMap $this$dispatchEvent_u24lambda_u240 = writableNativeMap = new WritableNativeMap();
        boolean bl = false;
        $this$dispatchEvent_u24lambda_u240.putString("eventType", eventType);
        $this$dispatchEvent_u24lambda_u240.putInt("eventKeyAction", eventKeyAction);
        if (targetViewId != -1) {
            $this$dispatchEvent_u24lambda_u240.putInt("tag", targetViewId);
        }
        WritableMap event = writableNativeMap;
        this.reactRootView.sendEvent("onHWKeyEvent", event);
    }

    static /* synthetic */ void dispatchEvent$default(ReactAndroidHWInputDeviceHelper reactAndroidHWInputDeviceHelper, String string2, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        reactAndroidHWInputDeviceHelper.dispatchEvent(string2, n, n2);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)23, (Object)"select"), TuplesKt.to((Object)66, (Object)"select"), TuplesKt.to((Object)62, (Object)"select"), TuplesKt.to((Object)85, (Object)"playPause"), TuplesKt.to((Object)89, (Object)"rewind"), TuplesKt.to((Object)90, (Object)"fastForward"), TuplesKt.to((Object)86, (Object)"stop"), TuplesKt.to((Object)87, (Object)"next"), TuplesKt.to((Object)88, (Object)"previous"), TuplesKt.to((Object)19, (Object)"up"), TuplesKt.to((Object)22, (Object)"right"), TuplesKt.to((Object)20, (Object)"down"), TuplesKt.to((Object)21, (Object)"left"), TuplesKt.to((Object)165, (Object)"info"), TuplesKt.to((Object)82, (Object)"menu")};
        KEY_EVENTS_ACTIONS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/react/ReactAndroidHWInputDeviceHelper$Companion;", "", "<init>", "()V", "KEY_EVENTS_ACTIONS", "", "", "", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

