/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.filter;

import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0007J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J8\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J@\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/facebook/imagepipeline/filter/IterativeBoxBlurFilter;", "", "()V", "TAG", "", "bound", "", "x", "l", "h", "boxBlurBitmapInPlace", "", "bitmap", "Landroid/graphics/Bitmap;", "iterations", "radius", "fastBoxBlur", "internalHorizontalBlur", "pixels", "", "outRow", "w", "row", "diameter", "div", "internalVerticalBlur", "outCol", "col", "imagepipeline_release"})
public final class IterativeBoxBlurFilter {
    @NotNull
    public static final IterativeBoxBlurFilter INSTANCE = new IterativeBoxBlurFilter();
    @NotNull
    private static final String TAG = "IterativeBoxBlurFilter";

    private IterativeBoxBlurFilter() {
    }

    @JvmStatic
    public static final void boxBlurBitmapInPlace(@NotNull Bitmap bitmap, int iterations, int radius) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Preconditions.checkArgument((Boolean)bitmap.isMutable());
        Preconditions.checkArgument((Boolean)((float)bitmap.getHeight() <= 2048.0f ? 1 : 0));
        Preconditions.checkArgument((Boolean)((float)bitmap.getWidth() <= 2048.0f ? 1 : 0));
        Preconditions.checkArgument((Boolean)(radius > 0 && radius <= 25 ? 1 : 0));
        Preconditions.checkArgument((Boolean)(iterations > 0 ? 1 : 0));
        try {
            INSTANCE.fastBoxBlur(bitmap, iterations, radius);
        }
        catch (OutOfMemoryError oom) {
            Locale locale = null;
            String string = "OOM: %d iterations on %dx%d with %d radius";
            Object[] objectArray = new Object[]{iterations, bitmap.getWidth(), bitmap.getHeight(), radius};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
            FLog.e((String)TAG, (String)string2);
            throw oom;
        }
    }

    private final void fastBoxBlur(Bitmap bitmap, int iterations, int radius) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int[] pixels = new int[w * h];
        bitmap.getPixels(pixels, 0, w, 0, 0, w, h);
        int diameter = radius + 1 + radius;
        int[] div = new int[256 * diameter];
        int ptr = radius + 1;
        for (int b = 1; b < 256; ++b) {
            for (int d = 0; d < diameter; ++d) {
                div[ptr] = b;
                ++ptr;
            }
        }
        int[] tempRowOrColumn = new int[Math.max(w, h)];
        for (int i = 0; i < iterations; ++i) {
            for (int row = 0; row < h; ++row) {
                this.internalHorizontalBlur(pixels, tempRowOrColumn, w, row, diameter, div);
                System.arraycopy(tempRowOrColumn, 0, pixels, row * w, w);
            }
            for (int col = 0; col < w; ++col) {
                this.internalVerticalBlur(pixels, tempRowOrColumn, w, h, col, diameter, div);
                int pos = col;
                for (int row = 0; row < h; ++row) {
                    pixels[pos] = tempRowOrColumn[row];
                    pos += w;
                }
            }
        }
        bitmap.setPixels(pixels, 0, w, 0, 0, w, h);
    }

    private final void internalHorizontalBlur(int[] pixels, int[] outRow, int w, int row, int diameter, int[] div) {
        int firstInByte = w * row;
        int lastInByte = w * (row + 1) - 1;
        int radius = diameter >> 1;
        int a = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int pixel = 0;
        int n = w + radius;
        for (int i = -radius; i < n; ++i) {
            int ii = this.bound(firstInByte + i, firstInByte, lastInByte);
            pixel = pixels[ii];
            r += pixel >> 16 & 0xFF;
            g += pixel >> 8 & 0xFF;
            b += pixel & 0xFF;
            a += pixel >>> 24;
            if (i < radius) continue;
            int outOffset = i - radius;
            outRow[outOffset] = div[a] << 24 | div[r] << 16 | div[g] << 8 | div[b];
            int j = i - (diameter - 1);
            int jj = this.bound(firstInByte + j, firstInByte, lastInByte);
            pixel = pixels[jj];
            r -= pixel >> 16 & 0xFF;
            g -= pixel >> 8 & 0xFF;
            b -= pixel & 0xFF;
            a -= pixel >>> 24;
        }
    }

    private final void internalVerticalBlur(int[] pixels, int[] outCol, int w, int h, int col, int diameter, int[] div) {
        int lastInByte = w * (h - 1) + col;
        int radiusTimesW = (diameter >> 1) * w;
        int diameterMinusOneTimesW = (diameter - 1) * w;
        int a = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int pixel = 0;
        int outColPos = 0;
        for (int i = col - radiusTimesW; i <= lastInByte + radiusTimesW; i += w) {
            int ii = this.bound(i, col, lastInByte);
            pixel = pixels[ii];
            r += pixel >> 16 & 0xFF;
            g += pixel >> 8 & 0xFF;
            b += pixel & 0xFF;
            a += pixel >>> 24;
            int outPos = i - radiusTimesW;
            if (outPos < col) continue;
            outCol[outColPos] = div[a] << 24 | div[r] << 16 | div[g] << 8 | div[b];
            ++outColPos;
            int j = i - diameterMinusOneTimesW;
            int jj = this.bound(j, col, lastInByte);
            pixel = pixels[jj];
            r -= pixel >> 16 & 0xFF;
            g -= pixel >> 8 & 0xFF;
            b -= pixel & 0xFF;
            a -= pixel >>> 24;
        }
    }

    private final int bound(int x, int l, int h) {
        return x < l ? l : (x > h ? h : x);
    }
}

