/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.datasource;

import com.facebook.common.internal.Supplier;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.datasource.SimpleDataSource;
import com.facebook.datasource.SuccessfulVoidDataSource;
import com.facebook.infer.annotation.Nullsafe;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class DataSources {
    private DataSources() {
    }

    public static <T> DataSource<T> immediateFailedDataSource(Throwable failure) {
        SimpleDataSource simpleDataSource = SimpleDataSource.create();
        simpleDataSource.setFailure(failure);
        return simpleDataSource;
    }

    public static <T> DataSource<T> immediateDataSource(T result) {
        SimpleDataSource<T> simpleDataSource = SimpleDataSource.create();
        simpleDataSource.setResult(result);
        return simpleDataSource;
    }

    public static DataSource<Void> immediateSuccessfulDataSource() {
        return SuccessfulVoidDataSource.INSTANCE;
    }

    public static <T> Supplier<DataSource<T>> getFailedDataSourceSupplier(final Throwable failure) {
        return new Supplier<DataSource<T>>(){

            @Override
            public DataSource<T> get() {
                return DataSources.immediateFailedDataSource(failure);
            }
        };
    }

    @Nullable
    public static <T> T waitForFinalResult(DataSource<T> dataSource) throws Throwable {
        final CountDownLatch latch = new CountDownLatch(1);
        final ValueHolder resultHolder = new ValueHolder();
        final ValueHolder pendingException = new ValueHolder();
        dataSource.subscribe(new DataSubscriber<T>(){

            @Override
            public void onNewResult(DataSource<T> dataSource) {
                if (!dataSource.isFinished()) {
                    return;
                }
                try {
                    resultHolder.value = dataSource.getResult();
                }
                finally {
                    latch.countDown();
                }
            }

            @Override
            public void onFailure(DataSource<T> dataSource) {
                try {
                    pendingException.value = dataSource.getFailureCause();
                }
                finally {
                    latch.countDown();
                }
            }

            @Override
            public void onCancellation(DataSource<T> dataSource) {
                latch.countDown();
            }

            @Override
            public void onProgressUpdate(DataSource<T> dataSource) {
            }
        }, new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        });
        latch.await();
        if (pendingException.value != null) {
            throw (Throwable)pendingException.value;
        }
        return resultHolder.value;
    }

    private static class ValueHolder<T> {
        @Nullable
        public T value = null;

        private ValueHolder() {
        }
    }
}

