/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.streams;

import com.facebook.infer.annotation.Nullsafe;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class TailAppendingInputStream
extends FilterInputStream {
    private final byte[] mTail;
    private int mTailOffset;
    private int mMarkedTailOffset;

    public TailAppendingInputStream(InputStream inputStream, byte[] tail) {
        super(inputStream);
        if (inputStream == null) {
            throw new NullPointerException();
        }
        if (tail == null) {
            throw new NullPointerException();
        }
        this.mTail = tail;
    }

    @Override
    public int read() throws IOException {
        int readResult = this.in.read();
        if (readResult != -1) {
            return readResult;
        }
        return this.readNextTailByte();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws IOException {
        int nextByte;
        int bytesRead;
        int readResult = this.in.read(buffer, offset, count);
        if (readResult != -1) {
            return readResult;
        }
        if (count == 0) {
            return 0;
        }
        for (bytesRead = 0; bytesRead < count && (nextByte = this.readNextTailByte()) != -1; ++bytesRead) {
            buffer[offset + bytesRead] = (byte)nextByte;
        }
        return bytesRead > 0 ? bytesRead : -1;
    }

    @Override
    public void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("mark is not supported");
        }
        this.in.reset();
        this.mTailOffset = this.mMarkedTailOffset;
    }

    @Override
    public void mark(int readLimit) {
        if (this.in.markSupported()) {
            super.mark(readLimit);
            this.mMarkedTailOffset = this.mTailOffset;
        }
    }

    private int readNextTailByte() {
        if (this.mTailOffset >= this.mTail.length) {
            return -1;
        }
        return this.mTail[this.mTailOffset++] & 0xFF;
    }
}

