/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.references;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.common.references.SharedReference;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class DefaultCloseableReference<T>
extends CloseableReference<T> {
    private static final String TAG = "DefaultCloseableReference";

    private DefaultCloseableReference(SharedReference<T> sharedReference, @Nullable CloseableReference.LeakHandler leakHandler, @Nullable Throwable stacktrace) {
        super(sharedReference, leakHandler, stacktrace);
    }

    DefaultCloseableReference(T t, ResourceReleaser<T> resourceReleaser, CloseableReference.LeakHandler leakHandler, @Nullable Throwable stacktrace) {
        super(t, resourceReleaser, leakHandler, stacktrace, true);
    }

    @Override
    public CloseableReference<T> clone() {
        Preconditions.checkState(this.isValid());
        return new DefaultCloseableReference<T>(this.mSharedReference, this.mLeakHandler, this.mStacktrace != null ? new Throwable() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            DefaultCloseableReference defaultCloseableReference = this;
            synchronized (defaultCloseableReference) {
                if (this.mIsClosed) {
                    return;
                }
            }
            Object ref = this.mSharedReference.get();
            FLog.w(TAG, "Finalized without closing: %x %x (type = %s)", System.identityHashCode(this), System.identityHashCode(this.mSharedReference), ref == null ? null : ref.getClass().getName());
            if (this.mLeakHandler != null) {
                this.mLeakHandler.reportLeak(this.mSharedReference, this.mStacktrace);
            }
            this.close();
            return;
        }
        finally {
            super.finalize();
        }
    }
}

