/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.memory;

import androidx.annotation.Nullable;
import androidx.core.util.Pools;
import com.facebook.infer.annotation.Nullsafe;
import java.nio.ByteBuffer;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class DecodeBufferHelper
implements Pools.Pool<ByteBuffer> {
    public static final DecodeBufferHelper INSTANCE = new DecodeBufferHelper();
    private static final int DEFAULT_DECODE_BUFFER_SIZE = 16384;
    private static int sRecommendedDecodeBufferSize = 16384;
    private static final ThreadLocal<ByteBuffer> sBuffer = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocate(sRecommendedDecodeBufferSize);
        }
    };

    public static int getRecommendedDecodeBufferSize() {
        return sRecommendedDecodeBufferSize;
    }

    public static void setRecommendedDecodeBufferSize(int recommendedDecodeBufferSize) {
        sRecommendedDecodeBufferSize = recommendedDecodeBufferSize;
    }

    @Nullable
    public ByteBuffer acquire() {
        return sBuffer.get();
    }

    public boolean release(ByteBuffer instance) {
        return true;
    }
}

