/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.internal;

import com.facebook.common.internal.ByteStreams;
import com.facebook.infer.annotation.Nullsafe;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class Files {
    private Files() {
    }

    static byte[] readFile(InputStream in, long expectedSize) throws IOException {
        if (expectedSize > Integer.MAX_VALUE) {
            throw new OutOfMemoryError("file is too large to fit in a byte array: " + expectedSize + " bytes");
        }
        return expectedSize == 0L ? ByteStreams.toByteArray(in) : ByteStreams.toByteArray(in, (int)expectedSize);
    }

    public static byte[] toByteArray(File file) throws IOException {
        try (FileInputStream in = null;){
            in = new FileInputStream(file);
            byte[] byArray = Files.readFile(in, in.getChannel().size());
            return byArray;
        }
    }
}

