/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.executors;

import com.facebook.infer.annotation.Nullsafe;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public abstract class StatefulRunnable<T>
implements Runnable {
    protected static final int STATE_CREATED = 0;
    protected static final int STATE_STARTED = 1;
    protected static final int STATE_CANCELLED = 2;
    protected static final int STATE_FINISHED = 3;
    protected static final int STATE_FAILED = 4;
    protected final AtomicInteger mState = new AtomicInteger(0);

    @Override
    public final void run() {
        T result;
        if (!this.mState.compareAndSet(0, 1)) {
            return;
        }
        try {
            result = this.getResult();
        }
        catch (Exception e) {
            this.mState.set(4);
            this.onFailure(e);
            return;
        }
        this.mState.set(3);
        try {
            this.onSuccess(result);
        }
        finally {
            this.disposeResult(result);
        }
    }

    public void cancel() {
        if (this.mState.compareAndSet(0, 2)) {
            this.onCancellation();
        }
    }

    protected void onSuccess(@Nullable T result) {
    }

    protected void onFailure(Exception e) {
    }

    protected void onCancellation() {
    }

    protected void disposeResult(@Nullable T result) {
    }

    @Nullable
    protected abstract T getResult() throws Exception;
}

